/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.baison.service.E3OrderService;
import com.wmeimob.fastboot.baison.utils.BaisonOrderUtil;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.OrderGift;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.entity.selfMention.SelfMentionRefundSecondRequestVO;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OperationTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PriceSystem;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.event.RefundEvent;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.mapper.RetryInfoRecordMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.bizvane.service.SendOrderMsgRecordService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.open.enums.AuditStatusEnum;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.exception.WepayException;
import me.hao0.wepay.model.enums.RefundAccount;
import me.hao0.wepay.model.refund.RefundApplyRequest;
import me.hao0.wepay.model.refund.RefundApplyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class RefundOrderServiceImpl
implements RefundOrderService {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderServiceImpl.class);
    @Autowired
    private RefundOrderMapper refundOrderMapper;
    @Autowired
    private OrderItemsMapper orderItemsMapper;
    @Autowired
    private OrderGiftMapper orderGiftMapper;
    @Resource
    private OrdersService ordersService;
    @Resource
    private WechatService wechatService;
    @Resource
    private WechatProperties wechatProperties;
    @Resource
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersServiceImpl;
    @Resource
    private GoodsSkuDetailService goodsSkuDetailService;
    @Resource
    private WechatMchNewMapper wechatMchNewMapper;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private GoodsMapper goodsMapper;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Autowired
    private E3OrderService e3OrderService;
    @Autowired
    private RetryInfoRecordMapper retryInfoRecordMapper;
    @Autowired
    private BaisonOrderUtil baisonOrderUtil;
    @Autowired
    private SendOrderMsgRecordService sendOrderMsgRecordService;

    public List<RefundOrder> findByCondition(RefundOrder condition) {
        return this.refundOrderMapper.findList(condition);
    }

    public PageInfo<RefundOrder> findByConditionSX(RefundOrder refundOrder) {
        log.info("findByConditionSX :{}", JSON.toJSON((Object)refundOrder));
        PageHelper.startPage((int)refundOrder.getPageNum(), (int)refundOrder.getPageSize());
        List list = this.refundOrderMapper.selectRefundOrderListSX(refundOrder);
        return new PageInfo(list);
    }

    @Transactional(rollbackFor={Exception.class})
    public int update(RefundOrder refundOrder) {
        Date date = new Date();
        refundOrder.setAuditAt(date);
        RefundOrder refundOrderDetail = (RefundOrder)this.refundOrderMapper.selectByPrimaryKey((Object)refundOrder.getId());
        if (refundOrder.getAuditStatus() == 1) {
            Orders orders = (Orders)this.ordersService.findById(refundOrderDetail.getOrderNo());
            refundOrder.setMerchantId(orders.getMerchantId());
            Orders commonOrders = (Orders)this.commonOrdersServiceImpl.findById(orders.getId());
            List customSkuInfo = this.convertToSkuInfo(commonOrders.getItems());
            customSkuInfo.forEach(o -> o.setStock(Integer.valueOf(-o.getStock().intValue())));
            this.goodsSkuDetailService.inventoryReduction(customSkuInfo);
            OrderGift orderGift = new OrderGift();
            Example example = new Example(OrderGift.class);
            example.createCriteria().andEqualTo("orderItemId", (Object)refundOrderDetail.getItemId());
            orderGift.setHasRefund(Boolean.valueOf(refundOrderDetail.getIsGift() == null));
            this.orderGiftMapper.updateByExampleSelective((Object)orderGift, (Object)example);
            OrderItems orderItems = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)refundOrderDetail.getItemId());
            if (refundOrderDetail.getRefundAmount().compareTo(orderItems.getWepayAmount()) == 1) {
                throw new CustomException("\u9000\u6b3e\u91d1\u989d\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getWepayAmount());
            }
            if (!StringUtils.isEmpty((Object)refundOrder.getNickName())) {
                refundOrder.setAuditor(refundOrder.getNickName());
            }
            if (refundOrderDetail.getRefundIntegral() == null) {
                refundOrderDetail.setRefundIntegral(Integer.valueOf(0));
            } else {
                if (orders.getPriceSystem().equals(0) && refundOrderDetail.getRefundIntegral() > orderItems.getDeductionIntegral()) {
                    throw new CustomException("\u9000\u6b3e\u79ef\u5206\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getDeductionIntegral());
                }
                if (!orders.getPriceSystem().equals(0) && (long)refundOrderDetail.getRefundIntegral().intValue() > orderItems.getPoints()) {
                    throw new CustomException("\u9000\u6b3e\u79ef\u5206\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getPoints());
                }
            }
            if (refundOrderDetail.getRefundBalance() == null) {
                refundOrderDetail.setRefundBalance(BigDecimal.ZERO);
            } else if (orders.getPriceSystem().equals(0) && refundOrderDetail.getRefundBalance().compareTo(orderItems.getDeductionBalance()) == 1) {
                throw new CustomException("\u9000\u6b3e\u4f59\u989d\u9519\u8bef\uff0c\u5e94\u4e3a\uff1a" + orderItems.getDeductionBalance());
            }
        } else if (refundOrder.getAuditStatus() == 2) {
            log.info("\u4f5c\u5e9f\u9000\u6b3e\u5355");
            refundOrder.setValid(Integer.valueOf(0));
            OrderItems items = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)refundOrderDetail.getItemId());
            items.setRefundStatus(RefundStatus.NONE);
            items.setGmtModified(new Date());
            this.orderItemsMapper.updateByPrimaryKeySelective((Object)items);
        }
        RefundOrder refundOrderSend = this.refundOrderMapper.selectRefundOrderById(refundOrder.getId());
        try {
            this.sendOrderMsgRecordService.addRefundOrderMsgRecord(refundOrder.getMerchantId(), refundOrderSend.getRefundNo(), refundOrderSend);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355:{}\u4fdd\u5b58t_send_order_msg_record\u8868\u5931\u8d25:{}", (Object)refundOrderSend.getOrderNo(), (Object)e);
        }
        refundOrder.setGmtModified(new Date());
        return this.refundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
    }

    public RefundOrder findById(Integer id) {
        RefundOrder refundOrder = this.refundOrderMapper.selectRefundOrderDetailById(id);
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("orderNo", (Object)refundOrder.getOrderNo());
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)example);
        if (orders == null) {
            return refundOrder;
        }
        refundOrder.setShippingFee(orders.getShippingFee());
        refundOrder.setShippingDeduction(orders.getShippingDeduction());
        refundOrder.setBuyerPhone(orders.getMobile());
        refundOrder.setPayAmount(String.valueOf(orders.getPayAmount()));
        refundOrder.setActiveDeduction(String.valueOf(orders.getActiveDeduction()));
        log.info("refundOrder:{}", (Object)refundOrder);
        return refundOrder;
    }

    @Transactional
    public ResponseData updateRefundStatusReject(SelfMentionRefundSecondRequestVO vo) {
        Integer pushFlag;
        log.info("RefundOrderServiceImpl updateRefundStatusReject:{}", JSON.toJSON((Object)vo));
        RefundOrder refundOrder = (RefundOrder)this.refundOrderMapper.selectByPrimaryKey((Object)vo.getId());
        if (StringUtils.isEmpty((Object)refundOrder.getAuditor())) {
            refundOrder.setAuditor(vo.getAuditor());
        }
        if (StringUtils.isEmpty((Object)refundOrder.getAuditor())) {
            log.info("\u672a\u4f20\u64cd\u4f5c\u4eba");
            return ResponseUtil.getFailedMsg((String)"\u672a\u4f20\u64cd\u4f5c\u4eba");
        }
        if (refundOrder.getValid().equals(0)) {
            throw new CustomException("\u6b64\u9000\u6b3e\u5355\u5df2\u88ab\u4f5c\u5e9f");
        }
        Integer merchantId = refundOrder.getMerchantId();
        if (refundOrder.getMerchantId() == null) {
            throw new CustomException("\u6b64\u8ba2\u5355\u5546\u6237id\u4e0d\u5b58\u5728");
        }
        OrderItems orderItems = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)refundOrder.getItemId());
        log.info("RefundOrderServiceImpl#updateRefundStatusReject orderItems:{}", (Object)orderItems);
        Orders orders = (Orders)this.ordersService.findById(refundOrder.getOrderNo());
        log.info("RefundOrderServiceImpl#updateRefundStatusReject orders:{}", (Object)JSON.toJSONString((Object)orders));
        Integer n = pushFlag = refundOrder.getRefundType().equals(1) ? PushFlagEnum.REFUND.getPushFlag() : PushFlagEnum.REFUND_GOODS.getPushFlag();
        if (orders.getPriceSystem().equals(2)) {
            RefundEvent refundEvent = new RefundEvent((Object)this.applicationContext, refundOrder, pushFlag);
            try {
                this.applicationContext.publishEvent((ApplicationEvent)refundEvent);
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
        orderItems.setRefundStatus(RefundStatus.NONE);
        int result = this.orderItemsMapper.updateByPrimaryKeySelective((Object)orderItems);
        if (orders.getPriceSystem().equals(0)) {
            OrderItems odi = new OrderItems();
            odi.setOrderNo(orders.getOrderNo());
            List select = this.orderItemsMapper.select((Object)odi);
            if (!CollectionUtils.isEmpty((Collection)select)) {
                long count = select.stream().filter(e -> !e.getRefundStatus().equals((Object)RefundStatus.NONE)).count();
                log.info("orderItems\u4e2d\u8fd8\u6709:[{}]\u6761\u8bb0\u5f55\u4e0d\u662fsuccess,\u4e3a0\u624d\u4f1a\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u4e3afail", (Object)count);
                if (count < 1L) {
                    log.info("\u5168\u90e8\u8ba2\u5355\u64cd\u4f5c\u5b8c\u6210");
                }
            }
        }
        RefundOrder newRefund = new RefundOrder();
        newRefund.setId(refundOrder.getId());
        newRefund.setAuditStatus(AuditStatusEnum.REJECT.status());
        newRefund.setAuditReback(vo.getAuditReback());
        newRefund.setAuditor(refundOrder.getAuditor());
        log.info("updateRefundStatusReject#rejectPO:{}", JSON.toJSON((Object)newRefund));
        this.refundOrderMapper.updateByPrimaryKeySelective((Object)newRefund);
        return ResponseUtil.getSuccessData(null);
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateRefundStatus(RefundOrder vo) {
        Integer pushFlag;
        Integer num;
        BigDecimal banlance;
        Integer redundIntegral;
        RefundOrder refundOrder = (RefundOrder)this.refundOrderMapper.selectByPrimaryKey((Object)vo.getId());
        log.info("RefundOrderServiceImpl#updateRefundStatus refundOrder:{}", (Object)JSON.toJSONString((Object)refundOrder));
        RefundOrder updateAuditor = new RefundOrder();
        updateAuditor.setId(refundOrder.getId());
        updateAuditor.setAuditor(vo.getAuditor());
        updateAuditor.setAuditorId(vo.getAuditorId());
        updateAuditor.setAuditAt(new Date());
        if (StringUtils.isEmpty((Object)updateAuditor.getAuditor())) {
            log.info("\u672a\u4f20\u64cd\u4f5c\u4eba");
            throw new CustomException("\u672a\u4f20\u64cd\u4f5c\u4eba");
        }
        if (refundOrder.getValid().equals(0)) {
            throw new CustomException("\u6b64\u9000\u6b3e\u5355\u5df2\u88ab\u4f5c\u5e9f");
        }
        Integer merchantId = refundOrder.getMerchantId();
        if (refundOrder.getMerchantId() == null) {
            throw new CustomException("\u6b64\u8ba2\u5355\u5546\u6237id\u4e0d\u5b58\u5728");
        }
        OrderItems orderItems = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)refundOrder.getItemId());
        log.info("RefundOrderServiceImpl#updateRefundStatus orderItems:{}", (Object)JSON.toJSONString((Object)orderItems));
        Orders orders = (Orders)this.ordersService.findById(refundOrder.getOrderNo());
        log.info("RefundOrderServiceImpl#updateRefundStatus orders:{}", (Object)JSON.toJSONString((Object)orders));
        if (orders == null) {
            throw new CustomException("\u76f8\u5173\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        BigDecimal refundAmount = refundOrder.getRefundAmount();
        BigDecimal ordersShippingFee = orders.getShippingFee();
        BigDecimal payMoney = refundAmount.add(ordersShippingFee);
        if (!PriceSystem.INTEGRAL.getCode().equals(orders.getPriceSystem()) && payMoney.compareTo(BigDecimal.ZERO) > 0) {
            Example example = new Example(WechatMchNew.class);
            example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
            WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
            if (mchNew == null) {
                throw new CustomException("\u54c1\u724cID:" + merchantId + ",\u672a\u64cd\u4f5c\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
            }
            WechatMp wechatMp = new WechatMp();
            wechatMp.setAppid(mchNew.getAppId());
            WechatMch wechatMch = new WechatMch();
            wechatMch.setMchKey(mchNew.getMchKey());
            wechatMch.setMchNo(mchNew.getMchNo());
            wechatMch.setP12(mchNew.getP12());
            Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
            log.info("RefundOrderServiceImpl#updateRefundStatus wepay:{}", (Object)JSON.toJSONString((Object)wepay));
            RefundApplyRequest refundApplyRequest = new RefundApplyRequest();
            refundApplyRequest.setOutTradeNo(refundOrder.getOrderNo());
            refundApplyRequest.setOutRefundNo(refundOrder.getRefundNo());
            refundApplyRequest.setRefundFee(Integer.valueOf(refundAmount.multiply(new BigDecimal("100")).intValue()));
            refundApplyRequest.setOpUserId(vo.getAuditor());
            refundApplyRequest.setRefundDesc(refundOrder.getRefundReason());
            refundApplyRequest.setNotifyUrl((String)this.wechatProperties.getUrls().get("refund-notify"));
            refundApplyRequest.setRefundAccount(RefundAccount.REFUND_SOURCE_UNSETTLED_FUNDS);
            refundApplyRequest.setTotalFee(Integer.valueOf(orders.getPayAmount().multiply(new BigDecimal("100")).intValue()));
            BigDecimal shippingFee = orders.getShippingFee().subtract(orders.getShippingDeduction());
            Example orderItemsExample = new Example(OrderItems.class);
            Example.Criteria criteria = orderItemsExample.createCriteria();
            criteria.andEqualTo("orderNo", (Object)refundOrder.getOrderNo());
            int orderItemsCount = this.orderItemsMapper.selectCountByExample((Object)orderItemsExample);
            log.info("RefundOrderServiceImpl#updateRefundStatus orderItemsCount:{}", (Object)orderItemsCount);
            criteria.andEqualTo("refundStatus", (Object)RefundStatus.SUCCESS);
            int orderItemsAlreadyRefundCount = this.orderItemsMapper.selectCountByExample((Object)orderItemsExample);
            log.info("RefundOrderServiceImpl#updateRefundStatus orderItemsAlreadyRefundCount:{}", (Object)orderItemsAlreadyRefundCount);
            if (orderItemsCount - orderItemsAlreadyRefundCount == 1 && LogisticsStatusEnum.UN_SEND.equals((Object)orders.getLogisticsStatus())) {
                BigDecimal lastRefundAmount = refundAmount.add(shippingFee);
                log.info("\u8bbe\u7f6e\u9000\u6b3e\u91d1\u989d\u4e3a\u652f\u4ed8\u91d1\u989d,\u9000\u6b3e\u5355\u53f7:{} , \u9000\u6b3e\u5355\u91d1\u989d:{} , \u90ae\u8d39:{} , \u6700\u540e\u4e00\u4ef6\u9000\u6b3e\u91d1\u989d:{}", new Object[]{refundOrder.getRefundNo(), refundAmount, shippingFee, lastRefundAmount});
                refundApplyRequest.setRefundFee(Integer.valueOf(lastRefundAmount.multiply(new BigDecimal("100")).intValue()));
            }
            log.info("\u5fae\u4fe1\u9000\u6b3e\u8bf7\u6c42\u4f53===>{}", (Object)JSONObject.toJSONString((Object)refundApplyRequest));
            try {
                RefundApplyResponse refundApplyResponse = wepay.refund().apply(refundApplyRequest);
                log.info("wexin pay refund result => {}", (Object)JSONObject.toJSONString((Object)refundApplyResponse));
            }
            catch (WepayException e2) {
                throw new CustomException(e2.getMessage());
            }
            catch (Exception e3) {
                log.error(e3.getMessage(), (Throwable)e3);
                throw new CustomException(e3.getMessage());
            }
        }
        if ((redundIntegral = refundOrder.getRefundIntegral()) != null && redundIntegral > 0) {
            if (orders.getPriceSystem().equals(0) && redundIntegral > orderItems.getDeductionIntegral()) {
                redundIntegral = orderItems.getDeductionIntegral();
            } else if (!orders.getPriceSystem().equals(0) && (long)redundIntegral.intValue() > orderItems.getPoints()) {
                redundIntegral = Integer.parseInt(orderItems.getPoints() + "");
            }
            RestResult restResult = this.bizvaneInterface.operationIntegral(refundOrder.getUserNo(), redundIntegral, OperationTypeEnum.ADD.getCode(), refundOrder.getRefundNo());
            log.info("RefundOrderServiceImpl#updateRefundStatus restResultIntegral:{}", (Object)restResult);
            if (restResult.getCode() != 0) {
                return -1;
            }
        }
        if ((banlance = refundOrder.getRefundBalance()) != null && BigDecimal.ZERO.compareTo(banlance) < 0) {
            if (banlance.compareTo(orderItems.getDeductionBalance()) == 1) {
                banlance = orderItems.getDeductionBalance();
            }
            RestResult restResult = this.bizvaneInterface.operationBalance(refundOrder.getUserNo(), banlance, OperationTypeEnum.ADD.getCode(), refundOrder.getRefundNo());
            log.info("RefundOrderServiceImpl#updateRefundStatus restResultBanlance:{}", (Object)restResult);
            if (restResult.getCode() != 0) {
                return -1;
            }
        }
        Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)orderItems.getGoodsId());
        log.info("RefundOrderServiceImpl#updateRefundStatus goods:{}", (Object)goods);
        if (orders.getOrdersActivityType().equals("2") && (num = goods.getAssembleNum()) >= orderItems.getSaleQuantity()) {
            goods.setAssembleNum(Integer.valueOf(num - orderItems.getSaleQuantity()));
            this.goodsMapper.updateByPrimaryKeySelective((Object)goods);
        }
        orderItems.setGoodsNo(goods.getGoodsNo());
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        goodsSkuDetail.setGoodsId(goods.getId());
        goodsSkuDetail.setSkuNo(orderItems.getGoodsSkuNo());
        goodsSkuDetail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)goodsSkuDetail);
        log.info("\u9700\u8981\u9000\u6b3e\u7684goodsSkuDetail:{}", (Object)JSON.toJSONString((Object)goodsSkuDetail));
        String specIds = null;
        if (goodsSkuDetail == null) {
            if (orderItems.getSkuId() == null) {
                throw new MallAdminException("\u8fd9\u4e2a\u8ba2\u5355\u660e\u7ec6sku\u4e0d\u5b58\u5728\u4e14\u662f\u8001\u8ba2\u5355\uff0c\u6ca1\u6709\u5197\u4f59skuId\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
            }
            GoodsSkuDetailPO goodsSkuDetailPO = this.goodsSkuDetailPOMapper.selectByPrimaryKey(orderItems.getSkuId());
            specIds = goodsSkuDetailPO.getSpecIds();
        } else {
            specIds = goodsSkuDetail.getSpecIds();
        }
        orderItems.setSpecIds(specIds);
        ArrayList<OrderItems> list = new ArrayList<OrderItems>();
        list.add(orderItems);
        refundOrder.setItems(list);
        refundOrder.setGoodsName(orderItems.getGoodsName());
        Integer n = pushFlag = refundOrder.getRefundType().equals(1) ? PushFlagEnum.REFUND.getPushFlag() : PushFlagEnum.REFUND_GOODS.getPushFlag();
        if (orders.getPriceSystem().equals(2)) {
            orders.setOrderStatus(OrdersStatusEnum.FAIL);
            orders.setClosedAt(new Date());
            orders.setClosedReason("\u7533\u8bf7\u552e\u540e");
            this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
            RefundEvent refundEvent = new RefundEvent((Object)this.applicationContext, refundOrder, pushFlag);
            try {
                this.applicationContext.publishEvent((ApplicationEvent)refundEvent);
            }
            catch (Exception e4) {
                log.error(e4.getMessage(), (Throwable)e4);
            }
        }
        orderItems.setRefundStatus(RefundStatus.SUCCESS);
        int result = this.orderItemsMapper.updateByPrimaryKeySelective((Object)orderItems);
        if (orders.getPriceSystem().equals(0) && refundAmount.compareTo(BigDecimal.ZERO) == 0) {
            OrderItems odi = new OrderItems();
            odi.setOrderNo(orders.getOrderNo());
            List select = this.orderItemsMapper.select((Object)odi);
            RefundEvent refundEvent = new RefundEvent((Object)this.applicationContext, refundOrder, pushFlag);
            try {
                this.applicationContext.publishEvent((ApplicationEvent)refundEvent);
            }
            catch (Exception e5) {
                log.error(e5.getMessage(), (Throwable)e5);
            }
            if (!CollectionUtils.isEmpty((Collection)select)) {
                long count = select.stream().filter(e -> !e.getRefundStatus().equals((Object)RefundStatus.SUCCESS)).count();
                log.info("orderItems\u4e2d\u8fd8\u6709:[{}]\u6761\u8bb0\u5f55\u4e0d\u662fsuccess,\u4e3a0\u624d\u4f1a\u4fee\u6539\u8ba2\u5355\u72b6\u6001\u4e3afail", (Object)count);
                if (count < 1L) {
                    Orders od = new Orders();
                    od.setId(orders.getId());
                    od.setOrderStatus(OrdersStatusEnum.FAIL);
                    od.setClosedAt(new Date());
                    od.setClosedReason("\u7533\u8bf7\u552e\u540e");
                    this.ordersMapper.updateByPrimaryKeySelective((Object)od);
                }
            }
        }
        log.info("\u9000\u5355\u64cd\u4f5c\u4eba\uff1a{}", (Object)updateAuditor.getAuditor());
        this.refundOrderMapper.updateByPrimaryKeySelective((Object)updateAuditor);
        try {
            this.sendOrderMsgRecordService.updateRefundOrderBegin(refundOrder.getRefundNo());
        }
        catch (Exception e6) {
            log.error("\u9000\u5355:{}\u66f4\u65b0\u786e\u8ba4\u9000\u6b3e\u72b6\u6001\u5931\u8d25", (Object)refundOrder.getRefundNo(), (Object)e6);
        }
        return result;
    }

    private RefundOrder buildForOffLine(RefundOrder refundOrder, Orders orders) {
        ArrayList temp = new ArrayList();
        refundOrder.setItems(temp);
        refundOrder.setGoodsName(((OrderItems)orders.getItems().get(0)).getGoodsName());
        return refundOrder;
    }

    private List<GoodsSkuDetail> convertToSkuInfo(List<OrderItems> orderItems) {
        ArrayList<GoodsSkuDetail> skuInfoList = new ArrayList<GoodsSkuDetail>();
        for (OrderItems item : orderItems) {
            GoodsSkuDetail skuInfo = new GoodsSkuDetail();
            skuInfo.setGoodsId(item.getGoodsId());
            skuInfo.setSkuNo(item.getGoodsSkuNo());
            skuInfo.setGoodsName(item.getGoodsName());
            skuInfo.setStock(item.getSaleQuantity());
            skuInfoList.add(skuInfo);
        }
        return skuInfoList;
    }
}

