/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.dto.StatisticalDTO;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.MallLogs;
import com.wmeimob.fastboot.bizvane.entity.OrderDeliveryDetail;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.MarketOrderStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderQueryStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.enums.PushToWhereEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.enums.ShippingModeEnum;
import com.wmeimob.fastboot.bizvane.event.OrderEvent;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderDeliveryDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrderItemsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersCommissionPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.RefundOrderPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.WechatMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.ConfigPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationDetailPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.OrderItemsPOExample;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.WechatMchPO;
import com.wmeimob.fastboot.bizvane.po.WechatMchPOExample;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.MallLogsService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.utils.ConvertDateUtils;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.vo.PayOrderDetailVo;
import com.wmeimob.fastboot.bizvane.vo.admin.AutoConfirmOrderVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.fastboot.util.DateUtil;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import com.wmeimob.fastboot.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.exception.WepayException;
import me.hao0.wepay.model.enums.RefundAccount;
import me.hao0.wepay.model.refund.RefundApplyRequest;
import me.hao0.wepay.model.refund.RefundApplyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class OrdersServiceImpl
implements OrdersService {
    private static final Logger log = LoggerFactory.getLogger(OrdersServiceImpl.class);
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private OrderItemsMapper orderItemsMapper;
    @Resource
    private RefundOrderMapper refundOrderMapper;
    @Autowired
    private OrdersPOMapper ordersPOMapper;
    @Autowired
    private OrderItemsPOMapper orderItemsPOMapper;
    @Autowired
    private WechatMchPOMapper wechatMchPOMapper;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private WechatProperties wechatProperties;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersService;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private MarketActivityOrdersPOMapper marketActivityOrdersPOMapper;
    private static final ScheduledThreadPoolExecutor SCHEDULE = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("wechat-loreal-global-pool-%d").build());
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private MallLogsService mallLogsService;
    @Autowired
    private OrderDeliveryDetailMapper orderDeliveryDetailMapper;
    @Autowired
    private OrdersCommissionPOMapper ordersCommissionPOMapper;
    @Autowired
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private LoginUtil loginUtil;
    @Resource
    private RefundOrderPOMapper refundOrderPOMapper;
    @Resource
    private CustomizationDetailPOMapper customizationDetailPOMapper;
    public static String REDIS_FREEZE_STOCK_KEY = "wx_reducePrice_freeze_stock_";
    private static final String ORDER_CLOSE_KEY = "market_orders:%s:close_handler";

    public List<Orders> findByCondition(Orders orders) {
        return this.ordersMapper.selectOrderList(orders);
    }

    public PageInfo findByConditionPage(Orders order, Boolean pageJudge) {
        log.info("OrdersServiceImpl#findByConditionPage param:{}", (Object)order);
        List orders = null;
        PageInfo pageInfo = new PageInfo();
        if (pageJudge.booleanValue()) {
            PageHelper.startPage((int)order.getPageIndex(), (int)order.getPageSize());
            orders = this.ordersMapper.selectOrderList(order);
            log.info("findByConditionPage Orders:{}", JSON.toJSON((Object)orders));
            pageInfo = new PageInfo(orders);
        } else {
            orders = this.ordersMapper.selectOrderList(order);
            log.info("findByConditionPage Orders:{}", JSON.toJSON((Object)orders));
            pageInfo.setList(orders);
        }
        if (CollectionUtils.isEmpty((Collection)orders)) {
            return pageInfo;
        }
        ArrayList<Byte> auditStatus = new ArrayList<Byte>();
        auditStatus.add((byte)0);
        auditStatus.add((byte)1);
        for (Orders check : orders) {
            check = this.checkRefund(check, order);
        }
        return pageInfo;
    }

    public int update(Orders orders) {
        log.info("\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5165\u53c2:[{}]", JSON.toJSON((Object)orders));
        Date date = new Date();
        orders.setGmtModified(date);
        Orders param = new Orders();
        param.setOrderNo(orders.getOrderNo());
        param.setId(orders.getId());
        Orders od = this.ordersMapper.selectOrdersDetailById((Object)orders);
        log.info("order_checkFullTeam\uff1a{}", (Object)JSON.toJSONString((Object)od));
        String ordersActivityType = od.getOrdersActivityType();
        if (StringUtils.isEmpty((Object)ordersActivityType)) {
            throw new MallAdminException("\u8be5\u8ba2\u5355\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (OrderActivityTypeEnum.PIT.getCode().equals(Integer.valueOf(ordersActivityType))) {
            MarketActivityOrdersPOExample marketActivityOrdersPOExample = new MarketActivityOrdersPOExample();
            marketActivityOrdersPOExample.createCriteria().andOrdersNoEqualTo(od.getOrderNo()).andValidEqualTo(Integer.valueOf(1));
            List marketActivityOrdersPOS = this.marketActivityOrdersPOMapper.selectByExample(marketActivityOrdersPOExample);
            log.info("marketActivityOrdersPOS_checkFullTeam:{}", (Object)JSON.toJSONString((Object)marketActivityOrdersPOS));
            if (CollectionUtils.isEmpty((Collection)marketActivityOrdersPOS)) {
                throw new MallAdminException("\u62fc\u56e2\u8ba2\u5355\u6ca1\u6709\u6d3b\u52a8\u8ba2\u5355\u4fe1\u606f");
            }
            if (((MarketActivityOrdersPO)marketActivityOrdersPOS.get(0)).getOrdersStatus().equals(MarketOrderStatusEnum.GOING.getCode())) {
                throw new MallAdminException("\u62fc\u56e2\u5f85\u6210\u56e2");
            }
        }
        if (orders.getLogisticsStatus() != null && orders.getLogisticsStatus().equals((Object)LogisticsStatusEnum.SEND)) {
            int result;
            if (Integer.valueOf(ShippingModeEnum.SELF_MENTION.getCode()).equals(orders.getShippingMode())) {
                orders.setShippingAt(date);
                orders.setLogisticsStatus(LogisticsStatusEnum.RECEIVED);
                orders.setOrderStatus(OrdersStatusEnum.SUCCESS);
                orders.setReceiptAt(date);
                orders.setGmtModified(date);
                orders.setPickErpGuideName("Mall-" + this.loginUtil.getLoginUser(this.request).getNickName());
                log.info("\u786e\u8ba4\u6536\u8d27\u65e5\u5fd7:{}", JSON.toJSON((Object)orders));
                result = this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
            } else {
                if (StringUtils.isEmpty((Object)orders.getShippingNo())) {
                    if (StringUtils.isEmpty((Object)orders.getDeliverPersonName()) || StringUtils.isEmpty((Object)orders.getDeliverPhone())) {
                        throw new MallAdminException("\u95e8\u5e97\u914d\u9001\u9700\u8981\u63d0\u4f9b\u914d\u9001\u5458\u4fe1\u606f");
                    }
                    orders.setShippingVendor("ZYPS");
                    OrderDeliveryDetail odd = new OrderDeliveryDetail();
                    odd.setOrderId(orders.getId());
                    odd.setDeliverName(orders.getDeliverPersonName());
                    odd.setDeliverPhone(orders.getDeliverPhone());
                    this.orderDeliveryDetailMapper.insertSelective((Object)odd);
                } else {
                    InputValidator.checkLengthRange((Object)orders.getShippingNo(), (int)0, (int)20, (String)"\u5feb\u9012\u5355\u53f7");
                    if (!Pattern.matches("^[a-zA-Z0-9\\-]+$", orders.getShippingNo())) {
                        throw new MallAdminException("\u5feb\u9012\u5355\u53f7\u53c2\u6570\u5f02\u5e38");
                    }
                }
                orders.setShippingAt(date);
                result = this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
                if (result > 0) {
                    Config sysConfig = this.configService.findSysConfig(orders.getMerchantId());
                    Orders queryOrders = (Orders)this.ordersMapper.selectByPrimaryKey((Object)orders.getId());
                    orders.setUserId(queryOrders.getUserId());
                    orders.setId(queryOrders.getId());
                    SCHEDULE.schedule(() -> this.commonOrdersService.confirm(orders), (long)sysConfig.getAwaitOrderConfirm().intValue(), TimeUnit.DAYS);
                }
            }
            if (result < 1) {
                throw new MallAdminException("\u53d1\u8d27\u5931\u8d25");
            }
            od.getItems().forEach(e -> {
                GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
                goodsSkuDetail.setGoodsId(e.getGoodsId());
                goodsSkuDetail.setSkuNo(e.getGoodsSkuNo());
                goodsSkuDetail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)goodsSkuDetail);
                if (goodsSkuDetail != null) {
                    e.setSpecIds(goodsSkuDetail.getSpecIds());
                    Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)goodsSkuDetail.getGoodsId());
                    e.setGoodsNo(goods.getGoodsNo());
                }
            });
            OrderEvent orderDeliveryEvent = new OrderEvent((Object)this.applicationContext, od, PushFlagEnum.SEND_ORDER.getPushFlag(), PushToWhereEnum.TO_All.getPushToWhere(), null);
            try {
                this.applicationContext.publishEvent((ApplicationEvent)orderDeliveryEvent);
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
            return result;
        }
        log.info("\u6700\u7ec8\u4fee\u6539\u8ba2\u5355\u4fe1\u606f:{}", JSON.toJSON((Object)orders));
        return this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
    }

    public Orders findById(String orderNo) {
        log.info("OrdersServiceImpl#findById:{}", (Object)orderNo);
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)example);
        if (orders != null) {
            orders = this.checkRefund(orders, new Orders());
            return orders;
        }
        return null;
    }

    public PageInfo<StatisticalDTO> commissionStatisticalList(Orders orders, Boolean pageJudge) {
        PageInfo pageInfo = new PageInfo();
        List statisticalDTOS = new ArrayList();
        if (Boolean.TRUE.equals(pageJudge)) {
            PageHelper.startPage((int)orders.getPageIndex(), (int)orders.getPageSize());
            statisticalDTOS = this.ordersMapper.commissionStatisticalList(orders);
            pageInfo = new PageInfo(statisticalDTOS);
        } else {
            statisticalDTOS = this.ordersMapper.commissionStatisticalList(orders);
            pageInfo.setList(statisticalDTOS);
        }
        if (pageInfo.getList().size() > 0) {
            StatisticalDTO statisticalDTO = new StatisticalDTO();
            statisticalDTO.setPrice(new BigDecimal("0"));
            statisticalDTO.setRefundPrice(new BigDecimal("0"));
            statisticalDTO.setCommission(new BigDecimal("0"));
            statisticalDTO.setCountOrder(Integer.valueOf(0));
            statisticalDTO.setCountRefundOrder(Integer.valueOf(0));
            statisticalDTO.setQuantity(Integer.valueOf(0));
            statisticalDTO.setRefundQuantity(Integer.valueOf(0));
            statisticalDTO.setCreateTime("\u603b\u8ba1");
            for (StatisticalDTO s : pageInfo.getList()) {
                statisticalDTO.setPrice(statisticalDTO.getPrice().add(s.getPrice() == null ? new BigDecimal("0") : s.getPrice()));
                statisticalDTO.setRefundPrice(statisticalDTO.getRefundPrice().add(s.getRefundPrice() == null ? new BigDecimal("0") : s.getRefundPrice()));
                statisticalDTO.setCommission(statisticalDTO.getCommission().add(s.getCommission() == null ? new BigDecimal("0") : s.getCommission()));
                statisticalDTO.setCountOrder(Integer.valueOf(statisticalDTO.getCountOrder() + (s.getCountOrder() == null ? 0 : s.getCountOrder())));
                statisticalDTO.setCountRefundOrder(Integer.valueOf(statisticalDTO.getCountRefundOrder() + (s.getCountRefundOrder() == null ? 0 : s.getCountRefundOrder())));
                statisticalDTO.setQuantity(Integer.valueOf(statisticalDTO.getQuantity() + (s.getQuantity() == null ? 0 : s.getQuantity())));
                statisticalDTO.setRefundQuantity(Integer.valueOf(statisticalDTO.getRefundQuantity() + (s.getRefundQuantity() == null ? 0 : s.getRefundQuantity())));
            }
            pageInfo.getList().add(0, statisticalDTO);
        }
        return pageInfo;
    }

    public PageInfo<StatisticalDTO> orderStatisticalList(Orders orders, Boolean pageJudge) {
        PageInfo pageInfo = new PageInfo();
        List statisticalDTOS = new ArrayList();
        if (Boolean.TRUE.equals(pageJudge)) {
            PageHelper.startPage((int)orders.getPageIndex(), (int)orders.getPageSize());
            statisticalDTOS = this.ordersMapper.orderStatisticalList(orders);
            pageInfo = new PageInfo(statisticalDTOS);
        } else {
            statisticalDTOS = this.ordersMapper.orderStatisticalList(orders);
            pageInfo.setList(statisticalDTOS);
        }
        if (pageInfo.getList().size() > 0) {
            StatisticalDTO statisticalDTO = new StatisticalDTO();
            statisticalDTO.setAvgPrice(new BigDecimal("0"));
            statisticalDTO.setAvgQuantity(Integer.valueOf(0));
            statisticalDTO.setCountCollect(Integer.valueOf(0));
            statisticalDTO.setCountOrder(Integer.valueOf(0));
            statisticalDTO.setCountRefundOrder(Integer.valueOf(0));
            statisticalDTO.setCountPayOrder(Integer.valueOf(0));
            statisticalDTO.setPayAmount(new BigDecimal("0"));
            statisticalDTO.setPayQuantity(Integer.valueOf(0));
            statisticalDTO.setPrice(new BigDecimal("0"));
            statisticalDTO.setQuantity(Integer.valueOf(0));
            statisticalDTO.setRefundPrice(new BigDecimal("0"));
            statisticalDTO.setRefundQuantity(Integer.valueOf(0));
            statisticalDTO.setCreateTime("\u603b\u8ba1");
            BigDecimal zero = new BigDecimal(0);
            for (StatisticalDTO s : pageInfo.getList()) {
                BigDecimal countPayOrder = new BigDecimal(s.getCountPayOrder() == null ? 0 : s.getCountPayOrder());
                BigDecimal avgDayPrice = s.getPayAmount() == null ? new BigDecimal("0") : s.getPayAmount();
                BigDecimal avgDayPayCount = new BigDecimal(s.getPayQuantity() == null ? 0 : s.getPayQuantity());
                statisticalDTO.setAvgPrice(statisticalDTO.getAvgPrice().add(s.getAvgPrice() == null ? new BigDecimal("0") : s.getAvgPrice()));
                statisticalDTO.setPayAmount(statisticalDTO.getPayAmount().add(s.getPayAmount() == null ? new BigDecimal("0") : s.getPayAmount()));
                statisticalDTO.setPrice(statisticalDTO.getPrice().add(s.getPrice() == null ? new BigDecimal("0") : s.getPrice()));
                statisticalDTO.setRefundPrice(statisticalDTO.getRefundPrice().add(s.getRefundPrice() == null ? new BigDecimal("0") : s.getRefundPrice()));
                statisticalDTO.setAvgQuantity(Integer.valueOf(statisticalDTO.getAvgQuantity() + (s.getAvgQuantity() == null ? 0 : s.getAvgQuantity())));
                statisticalDTO.setCountCollect(Integer.valueOf(statisticalDTO.getCountCollect() + (s.getCountCollect() == null ? 0 : s.getCountCollect())));
                statisticalDTO.setCountPayOrder(Integer.valueOf(statisticalDTO.getCountPayOrder() + (s.getCountPayOrder() == null ? 0 : s.getCountPayOrder())));
                statisticalDTO.setCountOrder(Integer.valueOf(statisticalDTO.getCountOrder() + (s.getCountOrder() == null ? 0 : s.getCountOrder())));
                statisticalDTO.setCountRefundOrder(Integer.valueOf(statisticalDTO.getCountRefundOrder() + (s.getCountRefundOrder() == null ? 0 : s.getCountRefundOrder())));
                statisticalDTO.setPayQuantity(Integer.valueOf(statisticalDTO.getPayQuantity() + (s.getPayQuantity() == null ? 0 : s.getPayQuantity())));
                statisticalDTO.setQuantity(Integer.valueOf(statisticalDTO.getQuantity() + (s.getQuantity() == null ? 0 : s.getQuantity())));
                statisticalDTO.setRefundQuantity(Integer.valueOf(statisticalDTO.getRefundQuantity() + (s.getRefundQuantity() == null ? 0 : s.getRefundQuantity())));
                if (zero.equals(countPayOrder)) {
                    s.setAvgQuantityBigDecimal(zero);
                    s.setAvgPrice(zero);
                    continue;
                }
                s.setAvgQuantityBigDecimal(avgDayPayCount.divide(countPayOrder, 1, RoundingMode.HALF_DOWN));
                s.setAvgPrice(avgDayPrice.divide(countPayOrder, 2, RoundingMode.HALF_DOWN));
            }
            BigDecimal dtoLength = new BigDecimal(statisticalDTO.getCountPayOrder());
            if (zero.equals(dtoLength)) {
                statisticalDTO.setAvgPrice(zero);
                statisticalDTO.setAvgQuantityBigDecimal(zero);
            } else {
                statisticalDTO.setAvgPrice(statisticalDTO.getPayAmount().divide(dtoLength, 4, RoundingMode.HALF_DOWN));
                BigDecimal sumQuantity = BigDecimal.valueOf(statisticalDTO.getPayQuantity().intValue());
                statisticalDTO.setAvgQuantityBigDecimal(sumQuantity.divide(dtoLength, 1, 5));
            }
            pageInfo.getList().add(0, statisticalDTO);
        }
        return pageInfo;
    }

    public List<Orders> findByConditionNew(Orders orders) {
        return this.ordersMapper.selectOrderListNew(orders);
    }

    private void timeConvert(Orders orders) {
        Date endDate;
        Date end;
        Date beginDate = orders.getBeginDate();
        Date convertDate = ConvertDateUtils.getConvertDate((Date)beginDate, (String)" 00:00:00");
        if (convertDate != null) {
            orders.setBeginDate(convertDate);
        }
        if ((end = ConvertDateUtils.getConvertDate((Date)(endDate = orders.getEndDate()), (String)" 23:59:59")) != null) {
            orders.setEndDate(end);
        }
    }

    public Map judgeSend(Integer id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Orders orders = (Orders)this.ordersMapper.selectByPrimaryKey((Object)id);
        if (orders == null) {
            map.put("code", -1);
            map.put("msg", "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        String ordersNo = orders.getOrderNo();
        Example example = new Example(OrderItems.class);
        example.createCriteria().andEqualTo("orderNo", (Object)ordersNo);
        List itemsList = this.orderItemsMapper.selectByExample((Object)example);
        Example reExample = new Example(RefundOrder.class);
        reExample.createCriteria().andEqualTo("orderNo", (Object)ordersNo).andEqualTo("valid", (Object)1).andNotEqualTo("auditStatus", (Object)2);
        List refundOrders = this.refundOrderMapper.selectByExample((Object)reExample);
        if (refundOrders.size() > 0) {
            if (refundOrders.size() == itemsList.size()) {
                map.put("code", -1);
                map.put("msg", "\u60a8\u8ba2\u5355\u4e0b\u5546\u54c1\u90fd\u5904\u4e8e\u9000\u8d27\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u53d1\u8d27\u3002");
                int i = 0;
                for (OrderItems orderItems : itemsList) {
                    if (!RefundStatus.SUCCESS.equals((Object)orderItems.getRefundStatus())) continue;
                    ++i;
                }
                if (i == itemsList.size()) {
                    orders.setOrderStatus(OrdersStatusEnum.FAIL);
                    this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
                }
            } else {
                StringBuffer sb = new StringBuffer();
                for (OrderItems items : itemsList) {
                    for (RefundOrder refundOrder : refundOrders) {
                        if (!refundOrder.getItemId().equals(items.getId())) continue;
                        sb.append("\u5546\u54c1\u540d\u79f0\uff1a[" + items.getGoodsName() + "]\u65e0\u6cd5\u53d1\u8d27");
                    }
                }
                map.put("code", 1);
                map.put("msg", sb.toString());
            }
        } else if (refundOrders.size() == 0) {
            map.put("code", 0);
        }
        log.info("OrderSendJudgeSend:{}", JSON.toJSON(map));
        return map;
    }

    public void pushToOffline(String orderNo) {
        MallLogs mallLogs = new MallLogs();
        mallLogs.setOrderNo(orderNo);
        List select = this.mallLogsService.select(mallLogs);
        if (!CollectionUtils.isEmpty((Collection)select)) {
            log.info("\u624b\u52a8\u63a8\u9001\u7ebf\u4e0b\u7684size:[]", (Object)select.size());
            MallLogs record = (MallLogs)select.get(0);
            log.info("\u624b\u52a8\u63a8\u9001\u7ebf\u4e0b\u8ba2\u5355\u8868\u8bb0\u5f55:[{}]", (Object)record.getLogContent());
            Orders orders = (Orders)JSONObject.parseObject((String)record.getLogContent(), Orders.class);
            Orders temp = (Orders)this.ordersMapper.selectByPrimaryKey((Object)orders.getId());
            if (temp != null && temp.getSynOfflineState() != 1) {
                String s = null;
                Orders od = new Orders();
                MallLogs param = new MallLogs();
                param.setId(record.getId());
                param.setRecordNumber(Integer.valueOf(record.getRecordNumber() + 1));
                param.setUpdateTime(new Date());
                try {
                    s = this.bizvaneInterface.notifyPaidOrderInfoOffLine(orders);
                }
                catch (Exception e) {
                    log.error("\u624b\u52a8_\u65b0\u589e\u8ba2\u5355\u91cd\u63a8\u7ebf\u4e0b\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                    param.setReason(e.getMessage());
                    int n = this.mallLogsService.updateByPrimaryKeySelective(param);
                }
                od.setId(orders.getId());
                if (!StringUtils.isEmpty((Object)s)) {
                    Integer result = "success".equals(s) ? 1 : 2;
                    od.setSynOfflineState(result);
                    if (od.getSynOfflineState() != null && od.getSynOfflineState().equals(2)) {
                        param.setReason("\u8c03\u7528\u8fde\u63a5\u5668\u63a5\u53e3\u5931\u8d25");
                        this.mallLogsService.updateByPrimaryKeySelective(param);
                    }
                }
                if (od.getSynOfflineState() == 1) {
                    this.ordersMapper.updateByPrimaryKeySelective((Object)od);
                    log.info("\u624b\u52a8_\u65b0\u589e\u8ba2\u5355\u91cd\u63a8\u7ebf\u4e0b\u6210\u529f");
                } else {
                    log.info("\u624b\u52a8_\u91cd\u63a8\u6570\u636e\u5931\u8d25");
                }
            } else {
                log.info("\u624b\u52a8_\u91cd\u63a8\u8ba2\u5355\u6570\u636e\u672a\u627e\u5230\uff0c\u6216\u8005\u8ba2\u5355\u540c\u6b65\u72b6\u6001\u4e3a\u6210\u529f");
            }
        }
    }

    @Async
    public void autoConfirmOrder(ConfigPO configPO, int interval) {
        log.info("OrdersServiceImpl#autoConfirmOrder config:{}", (Object)JSON.toJSONString((Object)configPO));
        Date startDate = com.wmeimob.fastboot.bizvane.utils.DateUtil.addDay((Date)new Date(), (int)(-(configPO.getAwaitOrderConfirm() + interval)));
        Date endDate = com.wmeimob.fastboot.bizvane.utils.DateUtil.addDay((Date)new Date(), (int)(-configPO.getAwaitOrderConfirm().intValue()));
        OrdersPOExample ordersPOExample = new OrdersPOExample();
        ordersPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(configPO.getMerchantId()).andShippingAtBetween(startDate, endDate);
        OrdersPO ordersPO = new OrdersPO();
        ordersPO.setLogisticsStatus(LogisticsStatusEnum.RECEIVED.name());
        ordersPO.setOrderStatus(OrdersStatusEnum.SUCCESS.name());
        ordersPO.setReceiptAt(new Date());
        ordersPO.setGmtModified(new Date());
        this.ordersPOMapper.updateByExampleSelective(ordersPO, ordersPOExample);
        AutoConfirmOrderVO autoConfirmOrderVO = new AutoConfirmOrderVO();
        autoConfirmOrderVO.setMerchantId(configPO.getMerchantId());
        autoConfirmOrderVO.setStartDate(com.wmeimob.fastboot.bizvane.utils.DateUtil.format((Date)startDate, (String)com.wmeimob.fastboot.bizvane.utils.DateUtil.ymdhms));
        autoConfirmOrderVO.setEndDate(com.wmeimob.fastboot.bizvane.utils.DateUtil.format((Date)endDate, (String)com.wmeimob.fastboot.bizvane.utils.DateUtil.ymdhms));
        this.ordersCommissionPOMapper.insertAutoConfirmOrderCommission(autoConfirmOrderVO);
    }

    @Async
    public void autoCancelAssembleOrder(MarketActivityOrdersPO marketActivityOrdersPO) {
        OrderItemsPOExample orderItemsPOExample = new OrderItemsPOExample();
        orderItemsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andOrderNoEqualTo(marketActivityOrdersPO.getOrdersNo());
        List orderItemsList = this.orderItemsPOMapper.selectByExample(orderItemsPOExample);
        log.info("OrdersServiceImpl#autoCancelAssembleOrder orderItemsList:{}", (Object)JSONObject.toJSONString((Object)orderItemsList));
        orderItemsList.forEach(orderItems -> {
            WechatMchPOExample wechatMchPOExample = new WechatMchPOExample();
            wechatMchPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(orderItems.getMerchantId());
            List wechatMchPOS = this.wechatMchPOMapper.selectByExampleWithBLOBs(wechatMchPOExample);
            log.info("OrdersServiceImpl#autoCancelAssembleOrder wechatMchPOS:{}", (Object)JSON.toJSONString((Object)wechatMchPOS));
            if (CollectionUtils.isEmpty((Collection)wechatMchPOS)) {
                throw new MallAdminException("\u54c1\u724cID:" + orderItems.getMerchantId() + ",\u672a\u64cd\u4f5c\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
            }
            WechatMchPO mchNew = (WechatMchPO)wechatMchPOS.get(0);
            WechatMp wechatMp = new WechatMp();
            wechatMp.setAppid(mchNew.getAppId());
            WechatMch wechatMch = new WechatMch();
            wechatMch.setMchKey(mchNew.getMchKey());
            wechatMch.setMchNo(mchNew.getMchNo());
            wechatMch.setP12(mchNew.getP12());
            Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
            log.info("OrdersServiceImpl#autoCancelAssembleOrder wepay:{}", (Object)JSONObject.toJSONString((Object)wepay));
            RefundApplyRequest refundApplyRequest = new RefundApplyRequest();
            refundApplyRequest.setOutTradeNo(orderItems.getOrderNo());
            refundApplyRequest.setOutRefundNo(marketActivityOrdersPO.getId().toString());
            refundApplyRequest.setRefundFee(Integer.valueOf(orderItems.getItemsPayAmount().multiply(new BigDecimal("100")).intValue()));
            refundApplyRequest.setOpUserId("admin");
            refundApplyRequest.setRefundDesc("\u62fc\u56e2\u6709\u6548\u671f\u8fc7\u671f,\u7533\u8bf7\u9000\u6b3e");
            refundApplyRequest.setNotifyUrl((String)this.wechatProperties.getUrls().get("activity-refund-notify"));
            refundApplyRequest.setRefundAccount(RefundAccount.REFUND_SOURCE_UNSETTLED_FUNDS);
            OrdersPO orders = this.ordersPOMapper.selectByPrimaryKey(orderItems.getOrderId());
            refundApplyRequest.setTotalFee(Integer.valueOf(orders.getPayAmount().multiply(new BigDecimal("100")).intValue()));
            try {
                log.info("OrdersServiceImpl#autoCancelAssembleOrder refundApplyRequest:{}", (Object)JSONObject.toJSONString((Object)refundApplyRequest));
                RefundApplyResponse refundApplyResponse = wepay.refund().apply(refundApplyRequest);
                this.updateActivityRefund(marketActivityOrdersPO, marketActivityOrdersPO.getOrdersNo());
                log.info("OrdersServiceImpl#autoCancelAssembleOrder refundApplyResponse:{}", (Object)JSONObject.toJSONString((Object)refundApplyResponse));
            }
            catch (WepayException e) {
                log.warn(e.getMessage(), (Throwable)e);
                throw new MallAdminException(e.getMessage());
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        });
    }

    @Async
    public void autoCancelReduceOrder(MarketActivityOrdersPO marketActivityOrdersPO) {
        log.info("OrdersServiceImpl#autoCancelReduceOrder mao:{}", (Object)JSON.toJSONString((Object)marketActivityOrdersPO));
        MarketActivityOrdersPO mao = new MarketActivityOrdersPO();
        mao.setId(marketActivityOrdersPO.getId());
        mao.setTradeStatus("0");
        mao.setOrdersStatus("2");
        mao.setGmtModified(new Date());
        this.marketActivityOrdersPOMapper.updateByPrimaryKeySelective(mao);
        log.info("\u780d\u4ef7\u53d6\u6d88\u8425\u9500\u8ba2\u5355\u63a5\u53e3\u8fdb\u5165\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        String key = String.format(ORDER_CLOSE_KEY, marketActivityOrdersPO.getActivityOrdersNo());
        ValueOperations ops = this.stringRedisTemplate.opsForValue();
        if (!ops.setIfAbsent((Object)key, (Object)"").booleanValue()) {
            log.warn("\u53d6\u6d88\u8425\u9500\u8ba2\u5355{},\u91cd\u590d\u7684\u8bf7\u6c42", (Object)marketActivityOrdersPO.getActivityOrdersNo());
            return;
        }
        this.stringRedisTemplate.expire((Object)key, 7L, TimeUnit.DAYS);
        String freezeStock = REDIS_FREEZE_STOCK_KEY + marketActivityOrdersPO.getGoodsId() + "-" + marketActivityOrdersPO.getGoodsSkuNo();
        if (this.stringRedisTemplate.opsForValue().getOperations().hasKey((Object)freezeStock).booleanValue()) {
            String s = (String)this.stringRedisTemplate.opsForValue().get((Object)freezeStock);
            if (Integer.parseInt(s) <= 0) {
                throw new MallAdminException("\u51bb\u7ed3\u5e93\u5b58\u4e0d\u8db3:goodsId" + marketActivityOrdersPO.getGoodsId() + ",goodsSkuNo:" + marketActivityOrdersPO.getGoodsSkuNo());
            }
            ops.increment((Object)freezeStock, -1L);
        }
    }

    public Long countByConditionSelfPick(Orders orders) {
        log.info("OrdersServiceImpl findByConditionSelfPick :{}", JSON.toJSON((Object)orders));
        orders.setShippingMode(Integer.valueOf(ShippingModeEnum.SELF_MENTION.getCode()));
        PageHelper.startPage((int)1, (int)1);
        List ordersSearch = this.ordersMapper.selectOrderList(orders);
        PageInfo ordersPageInfo = new PageInfo(ordersSearch);
        log.info("ordersPageInfo:{}", (Object)ordersPageInfo);
        return ordersPageInfo.getTotal();
    }

    public PageInfo payOrderDetailList(PayOrderDetailVo payOrderDetailVo) {
        PageHelper.startPage((int)payOrderDetailVo.getPageIndex(), (int)payOrderDetailVo.getPageSize());
        List payOrderDetailVoList = new ArrayList();
        if (PushFlagEnum.PAID_ORDERS.getPushFlag().equals(payOrderDetailVo.getStatus())) {
            payOrderDetailVoList = this.ordersPOMapper.getPayOrderDetailList(payOrderDetailVo);
        }
        if (PushFlagEnum.REFUND.getPushFlag().equals(payOrderDetailVo.getStatus())) {
            payOrderDetailVoList = this.refundOrderPOMapper.getRefundOrderDetailList(payOrderDetailVo);
        }
        PageInfo payOrderDetailVoPageInfo = new PageInfo(payOrderDetailVoList);
        log.info("ordersPageInfo:{}", (Object)payOrderDetailVoPageInfo);
        return payOrderDetailVoPageInfo;
    }

    private void updateActivityRefund(MarketActivityOrdersPO marketActivityOrdersPO, String ordersNo) {
        Example ordersExample = new Example(Orders.class);
        ordersExample.createCriteria().andEqualTo("orderNo", (Object)ordersNo);
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)ordersExample);
        if (orders.getOrdersActivityType().equals("2")) {
            Example orderItemCondif = new Example(OrderItems.class);
            orderItemCondif.createCriteria().andEqualTo("orderNo", (Object)ordersNo);
            List orderItemsList = this.orderItemsMapper.selectByExample((Object)orderItemCondif);
            if (orderItemsList.size() > 0) {
                OrderItems orderItems = (OrderItems)orderItemsList.get(0);
                Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)orderItems.getGoodsId());
                Integer num = goods.getAssembleNum();
                log.info("\u8fd4\u8fd8\u524d\u7684\u5df2\u62fc\u6570\u91cf{}", (Object)num);
                if (num >= orderItems.getSaleQuantity()) {
                    goods.setAssembleNum(Integer.valueOf(num - orderItems.getSaleQuantity()));
                    this.goodsMapper.updateByPrimaryKeySelective((Object)goods);
                }
                Example example = new Example(GoodsSkuDetail.class);
                example.createCriteria().andEqualTo("skuNo", (Object)orderItems.getGoodsSkuNo()).andEqualTo("goodsId", (Object)orderItems.getGoodsId());
                GoodsSkuDetail skuDetail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOneByExample((Object)example);
                if (skuDetail != null) {
                    Integer stock = skuDetail.getStock() + orderItems.getSaleQuantity();
                    log.info("\u8fd4\u8fd8\u540e\u7684\u5e93\u5b58\u4e3a{}", (Object)stock);
                    skuDetail.setStock(stock);
                    this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)skuDetail);
                }
                orderItems.setRefundStatus(RefundStatus.REFUND);
                orderItems.setGmtModified(new Date());
                this.orderItemsMapper.updateByPrimaryKeySelective((Object)orderItems);
                RefundOrder refundOrder = new RefundOrder();
                refundOrder.setOrderNo(orders.getOrderNo());
                List refundList = this.refundOrderMapper.select((Object)refundOrder);
                if (CollectionUtils.isEmpty((Collection)refundList)) {
                    this.generateRefundOrder(orders, orderItems);
                }
            }
        }
        marketActivityOrdersPO.setOrdersStatus("2");
        marketActivityOrdersPO.setGmtModified(new Date());
        this.marketActivityOrdersPOMapper.updateByPrimaryKeySelective(marketActivityOrdersPO);
    }

    private void generateRefundOrder(Orders orders, OrderItems orderItems) {
        RefundOrder refundOrder = new RefundOrder();
        Date date = new Date();
        refundOrder.setOrderNo(orders.getOrderNo());
        refundOrder.setMerchantId(orders.getMerchantId());
        refundOrder.setUserId(orders.getUserId());
        refundOrder.setUserName(orders.getUserName());
        refundOrder.setUserNo(orders.getUserNo());
        refundOrder.setItemId(orderItems.getId());
        refundOrder.setRefundAt(date);
        refundOrder.setGmtCreate(date);
        refundOrder.setGmtModified(date);
        refundOrder.setAuditStatus(new Byte("1"));
        refundOrder.setAuditAt(new Date());
        refundOrder.setAuditor("\u62fc\u56e2\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
        refundOrder.setRefundQuantity(orderItems.getSaleQuantity());
        refundOrder.setRefundNo(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)10));
        refundOrder.setItemAmout(orderItems.getItemsPayAmount());
        refundOrder.setRefundIntegral(Integer.valueOf(0));
        refundOrder.setRefundBalance(BigDecimal.ZERO);
        log.info("\u8ba2\u5355\u9000\u6b3e\u7684\u91d1\u989d\uff1a{}", (Object)orderItems.getWepayAmount());
        refundOrder.setRefundAmount(orderItems.getWepayAmount());
        this.refundOrderMapper.insertSelective((Object)refundOrder);
        orderItems.setRefundStatus(RefundStatus.REFUND);
        this.orderItemsMapper.updateByPrimaryKeySelective((Object)orderItems);
        Orders param = new Orders();
        param.setId(orders.getId());
        param.setOrderStatus(OrdersStatusEnum.REFUND);
        this.ordersMapper.updateByPrimaryKeySelective((Object)param);
    }

    public Orders checkRefund(Orders check, Orders vo) {
        OrderItemsPOExample checkRefundItem = new OrderItemsPOExample();
        checkRefundItem.createCriteria().andValidEqualTo(Boolean.TRUE).andOrderIdEqualTo(check.getId());
        List orderItemsPOS = check.getItems();
        log.info("findByConditionPage:{}", JSON.toJSON((Object)orderItemsPOS));
        if (!CollectionUtils.isEmpty((Collection)orderItemsPOS)) {
            Boolean refundJudge = Boolean.TRUE;
            for (OrderItems items : orderItemsPOS) {
                if (items.getCustomizationDetailId() != null) {
                    CustomizationDetailPO customizationDetailPO = this.customizationDetailPOMapper.selectByPrimaryKey(items.getCustomizationDetailId());
                    log.info("\u5b9a\u5236\u670d\u52a1\u6837\u5f0f\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)customizationDetailPO));
                    if (customizationDetailPO != null) {
                        items.setCustomizationDetailImgPath(customizationDetailPO.getCustomizationDetailImgPath());
                    }
                }
                if (!RefundStatus.NONE.equals((Object)items.getRefundStatus())) continue;
                log.info("\u8ba2\u5355:{}\u6709\u975e\u552e\u540e\u7269\u54c1\uff1a{}", (Object)check.getOrderNo(), (Object)items.getGoodsName());
                refundJudge = Boolean.FALSE;
                break;
            }
            if (OrdersStatusEnum.FAIL.equals((Object)check.getOrderStatus())) {
                refundJudge = Boolean.FALSE;
            }
            if (OrderQueryStatusEnum.ORDER_REFUND.getCode().equals(vo.getQueryStatus())) {
                refundJudge = Boolean.TRUE;
            } else if (vo.getQueryStatus() != null && !OrderQueryStatusEnum.ORDER_REFUND.getCode().equals(vo.getQueryStatus())) {
                refundJudge = Boolean.FALSE;
            }
            if (refundJudge.booleanValue()) {
                check.setOrderStatus(OrdersStatusEnum.REFUND);
            }
        }
        return check;
    }
}

