/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.GoodsQueryDTO;
import com.wmeimob.fastboot.bizvane.dto.GoodsStatisticalDTO;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleCombination;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassifyCustom;
import com.wmeimob.fastboot.bizvane.entity.GoodsCopyVO;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropValueCustom;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpecRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsTagCustom;
import com.wmeimob.fastboot.bizvane.entity.UpdateSalesEntity;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.enums.GoodsIsGift;
import com.wmeimob.fastboot.bizvane.enums.GoodsStatusEnum;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleCombinationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropHeadCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropValueCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsTagCustomMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityCombinationGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsClassifyCustomPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsGroupPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsGroupRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsServiceDescPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsServiceDescRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuLogPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsTagCustomPOMapper;
import com.wmeimob.fastboot.bizvane.po.ActivityCombinationGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityPO;
import com.wmeimob.fastboot.bizvane.po.ActivityPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsClassifyCustomPO;
import com.wmeimob.fastboot.bizvane.po.GoodsClassifyCustomPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsGroupPO;
import com.wmeimob.fastboot.bizvane.po.GoodsGroupRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsGroupRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsServiceDescPO;
import com.wmeimob.fastboot.bizvane.po.GoodsServiceDescRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsServiceDescRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuLogPO;
import com.wmeimob.fastboot.bizvane.po.GoodsTagCustomPO;
import com.wmeimob.fastboot.bizvane.po.GoodsTagCustomPOExample;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.fix.Fix20200416;
import com.wmeimob.fastboot.bizvane.service.qdqm.GoodsSyncChildService;
import com.wmeimob.fastboot.bizvane.service.qdqm.ImportTaskService;
import com.wmeimob.fastboot.bizvane.utils.jobutils.XxlJobUtil;
import com.wmeimob.fastboot.bizvane.vo.GoodsClassificationVO;
import com.wmeimob.fastboot.bizvane.vo.GoodsExpressTemplateVO;
import com.wmeimob.fastboot.bizvane.vo.GoodsGroudVO;
import com.wmeimob.fastboot.bizvane.vo.GoodsTagVO;
import com.wmeimob.fastboot.bizvane.vo.goodsclassify.SelectGoodsClassifyRequestVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class GoodsServiceImpl
implements GoodsService {
    private static final Logger log = LoggerFactory.getLogger(GoodsServiceImpl.class);
    @Autowired
    private ActivityGoodsMapper activityGoodsMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsTagCustomMapper goodsTagCustomMapper;
    @Autowired
    private GoodsClassifyCustomMapper goodsClassifyCustomMapper;
    @Autowired
    private GoodsPropValueCustomMapper goodsPropValueCustomMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private GoodsSpecRelationMapper goodsSpecRelationMapper;
    @Autowired
    private GoodsPropHeadCustomMapper goodsPropHeadCustomMapper;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityRuleCombinationMapper activityRuleCombinationMapper;
    @Resource
    private GoodsClassifyMapper goodsClassifyMapper;
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private ActivityPOMapper activityPOMapper;
    @Autowired
    private ActivityCombinationGoodsPOMapper activityCombinationGoodsPOMapper;
    @Autowired
    private GoodsSkuLogPOMapper goodsSkuLogPOMapper;
    @Autowired
    private GoodsSyncChildService goodsSyncChildService;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;
    @Autowired
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Autowired
    private Fix20200416 fix20200416;
    @Resource
    private GoodsGroupPOMapper goodsGroupPOMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Resource
    private GoodsGroupRelationPOMapper goodsGroupRelationPOMapper;
    @Resource
    private GoodsTagCustomPOMapper goodsTagCustomPOMapper;
    @Resource
    private GoodsClassifyCustomPOMapper goodsClassifyCustomPOMapper;
    @Resource
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;
    @Resource
    private GoodsServiceDescRelationPOMapper goodsServiceDescRelationPOMapper;
    @Autowired
    private XxlJobUtil xxlJobUtil;
    @Value(value="${spring.application.name}")
    private String appName;
    @Autowired
    private GoodsServiceDescPOMapper goodsServiceDescPOMapper;
    @Autowired
    private ImportTaskService importTaskService;

    @Transactional
    public Goods add(Goods goods) {
        List goodsServiceDescRelationPOList;
        Integer sysBrandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(goods.getMerchantId());
        List guessGroupPOList = goods.getGuessGroupPOS();
        goods.setSysBrandId(sysBrandId);
        log.info("\u65b0\u589e\u5546\u54c1\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)goods));
        InputValidator.checkEmpty((Object)goods.getCoverImg(), (String)"\u5217\u8868\u9875\u5c55\u793a\u56fe");
        InputValidator.checkEmpty((Object)goods.getBannerImgPaths(), (String)"\u8be6\u60c5\u9875\u5546\u54c1\u56fe");
        log.info("\u65b0\u589e\u5546\u54c1\u4e1a\u52a1\u5c42\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)goods));
        if (goods.getLimitation() != null) {
            InputValidator.checkNaturalNumber((Integer)goods.getLimitation(), (String)"\u9650\u8d2d\u6570\u91cf");
        }
        if (!StringUtils.isEmpty((Object)goods.getVideoPaths())) {
            InputValidator.checkEmpty((Object)goods.getVideoImg(), (String)"\u89c6\u9891\u5c01\u9762\u56fe");
        }
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)goods.getGoodsNo()).andEqualTo("merchantId", (Object)goods.getMerchantId()).andEqualTo("isDel", (Object)false);
        List goodsList = this.goodsMapper.selectByExample((Object)example);
        if (goodsList.size() > 0) {
            throw new MallAdminException("\u5546\u54c1\u7f16\u53f7\u91cd\u590d");
        }
        Date data = new Date();
        goods.setGmtCreate(data);
        if (CollectionUtils.isNotEmpty((Collection)guessGroupPOList)) {
            String guessGroudId = JSONArray.toJSONString((Object)guessGroupPOList.stream().map(GoodsGroupPO::getId).toArray());
            goods.setGuessGroupIds(guessGroudId);
        }
        this.goodsMapper.insertSelective((Object)goods);
        this.goodsSyncChildService.modifyChildMerchantStatus(goods);
        List goodsGroupPOList = goods.getGoodsGroupPOS();
        if (CollectionUtils.isNotEmpty((Collection)goodsGroupPOList)) {
            goodsGroupPOList.stream().forEach(e -> {
                GoodsGroupRelationPO goodsGroupRelationPO = new GoodsGroupRelationPO();
                GoodsGroupPO goodsGroupPO = this.goodsGroupPOMapper.selectByPrimaryKey(e.getId());
                goodsGroupRelationPO.setGoodsId(goods.getId());
                goodsGroupRelationPO.setGmtCreate(data);
                goodsGroupRelationPO.setGmtModified(data);
                goodsGroupRelationPO.setGoodsGroupId(e.getId());
                goodsGroupRelationPO.setGroupName(goodsGroupPO.getGoodsGroupName());
                goodsGroupRelationPO.setValid(Boolean.valueOf(true));
                goodsGroupRelationPO.setMerchantId(goods.getMerchantId());
                this.goodsGroupRelationPOMapper.insert(goodsGroupRelationPO);
            });
        }
        if ((goodsServiceDescRelationPOList = goods.getGoodsServiceDescPOList()).size() > 5) {
            throw new MallAdminException("\u5546\u54c1\u670d\u52a1\u4e0d\u80fd\u591a\u4e8e5\u4e2a\uff01");
        }
        if (CollectionUtils.isNotEmpty((Collection)goodsServiceDescRelationPOList)) {
            goodsServiceDescRelationPOList.stream().forEach(e -> {
                GoodsServiceDescRelationPO goodsServiceDescRelationPO = new GoodsServiceDescRelationPO();
                goodsServiceDescRelationPO.setGmtCreate(data);
                goodsServiceDescRelationPO.setGoodsServiceDescId(e.getId());
                goodsServiceDescRelationPO.setGoodsServiceName(e.getGoodsServiceName());
                goodsServiceDescRelationPO.setMerchantId(e.getMerchantId());
                goodsServiceDescRelationPO.setGoodsId(goods.getId());
                goodsServiceDescRelationPO.setValid(Boolean.valueOf(true));
                this.goodsServiceDescRelationPOMapper.insert(goodsServiceDescRelationPO);
            });
        }
        for (GoodsPropValueCustom gpvc : goods.getGoodsPropValueCustomList()) {
            gpvc.setGmtCreate(data);
            gpvc.setGoodsId(goods.getId());
        }
        for (GoodsClassifyCustom gcc : goods.getGoodsClassifyCustomList()) {
            gcc.setGmtCreate(data);
            gcc.setGoodsId(goods.getId());
        }
        for (GoodsTagCustom gtc : goods.getGoodsTagCustomList()) {
            gtc.setGmtCreate(data);
            gtc.setGoodsId(goods.getId());
        }
        if (goods.getGoodsPropValueCustomList().size() > 0) {
            this.goodsPropValueCustomMapper.insertList(goods.getGoodsPropValueCustomList());
        }
        if (goods.getGoodsClassifyCustomList().size() > 0) {
            this.goodsClassifyCustomMapper.insertList(goods.getGoodsClassifyCustomList());
        }
        if (goods.getGoodsTagCustomList().size() > 0) {
            this.goodsTagCustomMapper.insertList(goods.getGoodsTagCustomList());
        }
        if (goods.getIsPreSale().booleanValue()) {
            log.info("\u521b\u5efa\u9884\u552e\u5b9a\u65f6\u5668");
            this.createGoodsUnShelfJod(goods);
        }
        return goods;
    }

    private void createGoodsUnShelfJod(Goods goods) {
        Date jobTime = goods.getPreSaleTime();
        String jobDesc = "Goods_Sale_";
        String param = String.valueOf(goods.getId());
        String author = "mall_admin";
        String jobHandler = "goodsUnSale";
        int businessType = GoodsStatusEnum.UN_SALE_JOB.getType();
        String bizCode = goods.getId() + "_UnSaleJob";
        String appName = this.appName;
        this.xxlJobUtil.removeByBiz(businessType, bizCode);
        this.xxlJobUtil.addJob(jobTime, jobDesc, param, author, jobHandler, businessType, bizCode, appName);
    }

    private void createGoodsShelfJod(Goods goods) {
        Date jobTime = goods.getShelfTime();
        String jobDesc = "Goods_Shelf_";
        String param = String.valueOf(goods.getId());
        String author = "mall_admin";
        String jobHandler = "goodsShelf";
        int businessType = GoodsStatusEnum.PRE_SHELF_JOB.getType();
        String bizCode = goods.getId() + "_ShelfJob";
        String appName = this.appName;
        this.xxlJobUtil.removeByBiz(businessType, bizCode);
        this.xxlJobUtil.addJob(jobTime, jobDesc, param, author, jobHandler, businessType, bizCode, appName);
    }

    public int update(Goods goods) {
        int i;
        Example example;
        List goodsIds;
        GoodsPO oldGoods;
        Integer sysBrandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(goods.getMerchantId());
        goods.setSysBrandId(sysBrandId);
        log.info("GoodsServiceImpl#update goods:{}", (Object)JSON.toJSONString((Object)goods));
        if (goods.getLimitation() != null) {
            InputValidator.checkNaturalNumber((Integer)goods.getLimitation(), (String)"\u9650\u8d2d\u6570\u91cf");
        }
        Example goodsNoExample = new Example(Goods.class);
        goodsNoExample.createCriteria().andEqualTo("goodsNo", (Object)goods.getGoodsNo()).andEqualTo("merchantId", (Object)goods.getMerchantId()).andEqualTo("isDel", (Object)false);
        List goodsList = this.goodsMapper.selectByExample((Object)goodsNoExample);
        if (CollectionUtils.isNotEmpty((Collection)goodsList) && !goods.getId().equals(((Goods)goodsList.get(0)).getId())) {
            throw new MallAdminException("\u5546\u54c1\u7f16\u53f7\u91cd\u590d");
        }
        Date date = new Date();
        goods.setGmtModified(date);
        if (goods.getVideoDelete() != null && goods.getVideoDelete().booleanValue()) {
            goods.setVideoImg("");
            goods.setVideoPaths("");
        }
        if (!((oldGoods = this.goodsPOMapper.selectByPrimaryKey(goods.getId())).getIsPreSale().equals(goods.getIsPreSale()) && oldGoods.getLimitation().equals(goods.getLimitation()) && oldGoods.getShippingMode().equals(goods.getShippingMode()))) {
            this.validaGoods(goods);
        }
        if (goods.getIsPreSale().booleanValue() && (goodsIds = this.activityGoodsMapper.selectActivityGoodsIds(goods.getMerchantId())).contains(goods.getId())) {
            throw new MallAdminException("\u8be5\u5546\u54c1\u53c2\u52a0\u4e86\u4fc3\u9500\u6d3b\u52a8\uff0c\u4e0d\u53ef\u8bbe\u7f6e\u4e3a\u9884\u552e\u5546\u54c1\uff01");
        }
        this.scheduledThreadPoolExecutor.execute(() -> {
            String bizCode;
            if (goods.getIsPreSale().booleanValue()) {
                this.createGoodsUnShelfJod(goods);
            } else {
                bizCode = goods.getId() + "_UnSaleJob";
                this.xxlJobUtil.removeByBiz(GoodsStatusEnum.UN_SALE_JOB.getType().intValue(), bizCode);
            }
            log.info("\u5904\u7406\u5b9a\u65f6\u4e0a\u67b6\u5b9a\u65f6\u5668");
            if (goods.getIsPreShelf().booleanValue()) {
                this.createGoodsShelfJod(goods);
            } else {
                bizCode = goods.getId() + "_ShelfJob";
                this.xxlJobUtil.removeByBiz(GoodsStatusEnum.PRE_SHELF_JOB.getType().intValue(), bizCode);
            }
        });
        GoodsGroupRelationPOExample goodsGroupRelationPOExample = new GoodsGroupRelationPOExample();
        GoodsGroupRelationPOExample.Criteria criteria = goodsGroupRelationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(goods.getMerchantId()).andGoodsIdEqualTo(goods.getId());
        GoodsGroupRelationPO groupRelationPO = new GoodsGroupRelationPO();
        groupRelationPO.setValid(Boolean.valueOf(false));
        groupRelationPO.setGmtModified(date);
        this.goodsGroupRelationPOMapper.updateByExampleSelective(groupRelationPO, goodsGroupRelationPOExample);
        if (CollectionUtils.isNotEmpty((Collection)goods.getGoodsGroupPOS())) {
            goods.getGoodsGroupPOS().stream().forEach(goodsGroupPO -> {
                GoodsGroupRelationPO goodsGroupRelationPO = new GoodsGroupRelationPO();
                goodsGroupRelationPO.setGroupName(goodsGroupPO.getGoodsGroupName());
                goodsGroupRelationPO.setGoodsId(goods.getId());
                goodsGroupRelationPO.setValid(Boolean.valueOf(true));
                goodsGroupRelationPO.setGoodsGroupId(goodsGroupPO.getId());
                goodsGroupRelationPO.setGmtCreate(date);
                goodsGroupRelationPO.setMerchantId(goods.getMerchantId());
                this.goodsGroupRelationPOMapper.insert(goodsGroupRelationPO);
            });
        }
        GoodsServiceDescRelationPOExample goodsService = new GoodsServiceDescRelationPOExample();
        goodsService.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(goods.getMerchantId()).andGoodsIdEqualTo(goods.getId());
        GoodsServiceDescRelationPO goodsServiceDescRelationPO = new GoodsServiceDescRelationPO();
        goodsServiceDescRelationPO.setValid(Boolean.valueOf(false));
        goodsServiceDescRelationPO.setGmtModified(date);
        this.goodsServiceDescRelationPOMapper.updateByExampleSelective(goodsServiceDescRelationPO, goodsService);
        List goodsServiceDescPOList = goods.getGoodsServiceDescPOList();
        if (CollectionUtils.isNotEmpty((Collection)goodsServiceDescPOList)) {
            goodsServiceDescPOList.stream().forEach(e -> {
                GoodsServiceDescRelationPO goodsServiceDescRelation = new GoodsServiceDescRelationPO();
                GoodsServiceDescPO goodsServiceDescPO = this.goodsServiceDescPOMapper.selectByPrimaryKey(e.getId());
                goodsServiceDescRelation.setValid(Boolean.valueOf(true));
                goodsServiceDescRelation.setGoodsServiceDescId(e.getId());
                goodsServiceDescRelation.setGoodsServiceDesc(goodsServiceDescPO.getGoodsServiceDesc());
                goodsServiceDescRelation.setMerchantId(goods.getMerchantId());
                goodsServiceDescRelation.setGoodsServiceName(goodsServiceDescPO.getGoodsServiceName());
                goodsServiceDescRelation.setGmtCreate(date);
                goodsServiceDescRelation.setGoodsId(goods.getId());
                this.goodsServiceDescRelationPOMapper.insert(goodsServiceDescRelation);
            });
        }
        if (goods.getGoodsPropValueCustomList() != null) {
            for (GoodsPropValueCustom gpvc : goods.getGoodsPropValueCustomList()) {
                if (gpvc.getId() == null) {
                    gpvc.setGmtCreate(date);
                    gpvc.setGoodsId(goods.getId());
                    this.goodsPropValueCustomMapper.insertSelective((Object)gpvc);
                }
                if (gpvc.getIsDelete() == null || !gpvc.getIsDelete().booleanValue()) continue;
                this.goodsPropValueCustomMapper.deleteByPrimaryKey((Object)gpvc);
            }
        }
        if (goods.getGoodsClassifyCustomList() != null) {
            for (GoodsClassifyCustom gcc : goods.getGoodsClassifyCustomList()) {
                if (gcc.getId() == null) {
                    gcc.setGmtCreate(date);
                    gcc.setGoodsId(goods.getId());
                    this.goodsClassifyCustomMapper.insertSelective((Object)gcc);
                }
                if (gcc.getIsDelete() == null || !gcc.getIsDelete().booleanValue()) continue;
                Integer count = this.goodsClassifyCustomMapper.countclassByid(goods.getId(), gcc.getId());
                if (count == 0) {
                    Integer pid = this.goodsClassifyCustomMapper.selectPidById(gcc.getId());
                    Example example2 = new Example(GoodsClassifyCustom.class);
                    example2.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("classifyId", (Object)pid);
                    this.goodsClassifyCustomMapper.deleteByExample((Object)example2);
                }
                this.goodsClassifyCustomMapper.deleteByPrimaryKey((Object)gcc);
            }
        }
        if (goods.getGoodsTagCustomList() != null) {
            for (GoodsTagCustom gtc : goods.getGoodsTagCustomList()) {
                if (gtc.getId() == null) {
                    gtc.setGmtCreate(date);
                    gtc.setGoodsId(goods.getId());
                    this.goodsTagCustomMapper.insertSelective((Object)gtc);
                }
                if (gtc.getIsDelete() == null || !gtc.getIsDelete().booleanValue()) continue;
                this.goodsTagCustomMapper.deleteByPrimaryKey((Object)gtc);
            }
        }
        if (goods.getIsUniform() != null) {
            if (goods.getIsUniform().booleanValue()) {
                long goodsSkuDetailPOCount;
                GoodsSkuDetail goodsSkuDetail = (GoodsSkuDetail)goods.getGoodsSkuDetailList().get(0);
                goodsSkuDetail.setSysBrandId(goods.getSysBrandId());
                goodsSkuDetail.setMerchantId(goods.getMerchantId());
                if (goods.getIsGift() == 0) {
                    if (goodsSkuDetail.getSalesPrice().compareTo(new BigDecimal("0")) < 1) {
                        throw new MallAdminException("\u552e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0");
                    }
                    if (goodsSkuDetail.getMarketPrice().compareTo(new BigDecimal("0")) < 1) {
                        throw new MallAdminException("\u540a\u724c\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0");
                    }
                    if (goodsSkuDetail.getMarketPrice().compareTo(goodsSkuDetail.getSalesPrice()) < 0) {
                        throw new MallAdminException("\u540a\u724c\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u9500\u552e\u4ef7");
                    }
                    if (!goods.getPriceSystem().equals(0) && goodsSkuDetail.getIntegralPoints().compareTo(0L) < 1) {
                        throw new MallAdminException("\u79ef\u5206\u4e0d\u80fd\u4e3a0");
                    }
                }
                GoodsSkuDetailPOExample goodsSkuDetailPOExample = new GoodsSkuDetailPOExample();
                GoodsSkuDetailPOExample.Criteria goodsSkuDetailPOExampleCriteria = goodsSkuDetailPOExample.createCriteria();
                goodsSkuDetailPOExampleCriteria.andValidEqualTo(Boolean.TRUE).andSysBrandIdEqualTo(goods.getSysBrandId()).andMerchantIdEqualTo(goods.getMerchantId()).andSkuNoEqualTo(goodsSkuDetail.getSkuNo()).andIsDelEqualTo(Boolean.FALSE);
                if (null != goodsSkuDetail.getId()) {
                    goodsSkuDetailPOExampleCriteria.andIdNotEqualTo(goodsSkuDetail.getId());
                }
                if ((goodsSkuDetailPOCount = this.goodsSkuDetailPOMapper.countByExample(goodsSkuDetailPOExample)) > 0L) {
                    throw new MallAdminException("sku\u7f16\u7801\u6709\u91cd\u590d");
                }
                if (goodsSkuDetail.getId() == null) {
                    goodsSkuDetail.setGoodsId(goods.getId());
                    goodsSkuDetail.setGmtCreate(date);
                    goodsSkuDetail.setIsUniform(Boolean.valueOf(true));
                    goodsSkuDetail.setStock(goodsSkuDetail.getStockChange());
                    this.goodsSkuDetailMapper.insertSelective((Object)goodsSkuDetail);
                } else {
                    goodsSkuDetail.setNoId(goodsSkuDetail.getId());
                    goodsSkuDetail.setGmtModified(date);
                    log.info("\u66f4\u65b0\u5546\u54c1\u7684sku\u7b49\u4fe1\u606f\uff1a{},skuNO{}", (Object)JSONObject.toJSONString((Object)goodsSkuDetail), (Object)JSONObject.toJSONString((Object)goodsSkuDetail.getSkuNo()));
                    if (goodsSkuDetail.getStockChange() != null) {
                        goodsSkuDetail.setStock(Integer.valueOf(goodsSkuDetail.getStock() + goodsSkuDetail.getStockChange()));
                    }
                    this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)goodsSkuDetail);
                    this.scheduledThreadPoolExecutor.execute(() -> {
                        Goods goods1 = this.goodsMapper.selectById(goods.getId());
                        log.info("GoodsServiceImpl#update goods1:{}", (Object)JSON.toJSONString((Object)goods1));
                        GoodsSkuLogPO goodsSkuLogPO = new GoodsSkuLogPO();
                        goodsSkuLogPO.setGmtCreate(new Date());
                        goodsSkuLogPO.setGoodsId(goods.getId());
                        goodsSkuLogPO.setGoodsSkuDetailId(goodsSkuDetail.getId());
                        goodsSkuLogPO.setGoodsNo(goods1.getGoodsNo());
                        goodsSkuLogPO.setSkuNo(goodsSkuDetail.getSkuNo());
                        goodsSkuLogPO.setNewMarketPrice(goodsSkuDetail.getMarketPrice());
                        goodsSkuLogPO.setNewSalesPrice(goodsSkuDetail.getSalesPrice());
                        goodsSkuLogPO.setNewStock(goodsSkuDetail.getStock());
                        goodsSkuLogPO.setUserCreate(goods.getNickName());
                        goodsSkuLogPO.setUserAccount(goods.getAccountCode());
                        goodsSkuLogPO.setMerchantId(goods.getMerchantId());
                        log.info("GoodsServiceImpl#update#scheduledThreadPoolExecutor goodsSkuLogPO:{}", (Object)JSON.toJSONString((Object)goodsSkuLogPO));
                        this.goodsSkuLogPOMapper.insertSelective(goodsSkuLogPO);
                    });
                }
                goods.setSalePrice(goodsSkuDetail.getSalesPrice());
                goods.setMarketPrice(goodsSkuDetail.getMarketPrice());
                goods.setIntegralPoints(((GoodsSkuDetail)goods.getGoodsSkuDetailList().get(0)).getIntegralPoints());
            } else {
                List goodsSkuDetailList = goods.getGoodsSkuDetailList();
                this.fix20200416.checkGoodsSkuDetailRepeat(goodsSkuDetailList, goods.getMerchantId());
                if (goodsSkuDetailList.size() > 0) {
                    example = new Example(GoodsSkuDetail.class);
                    example.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
                    List goodsSkuDetails = this.goodsSkuDetailMapper.selectByExample((Object)example);
                    ArrayList ids = new ArrayList();
                    goodsSkuDetailList.forEach(e -> ids.add(e.getId()));
                    for (GoodsSkuDetail g : goodsSkuDetails) {
                        if (ids.contains(g.getId())) continue;
                        g.setIsDel(Boolean.valueOf(true));
                        g.setSysBrandId(goods.getSysBrandId());
                        g.setMerchantId(goods.getMerchantId());
                        this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)g);
                    }
                    BigDecimal minSalePrice = ((GoodsSkuDetail)goodsSkuDetailList.get(0)).getSalesPrice();
                    BigDecimal minMarketPrice = ((GoodsSkuDetail)goodsSkuDetailList.get(0)).getMarketPrice();
                    Long minIntegralPoints = ((GoodsSkuDetail)goodsSkuDetailList.get(0)).getIntegralPoints();
                    for (GoodsSkuDetail g : goodsSkuDetailList) {
                        g.setSysBrandId(goods.getSysBrandId());
                        g.setMerchantId(goods.getMerchantId());
                        if (g.getIsEnabled().booleanValue()) {
                            long goodsSkuDetailPOCount;
                            if (g.getSalesPrice().compareTo(new BigDecimal("0")) < 1) {
                                throw new MallAdminException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
                            }
                            if (g.getMarketPrice().compareTo(new BigDecimal("0")) < 1) {
                                throw new MallAdminException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
                            }
                            if (g.getMarketPrice().compareTo(g.getSalesPrice()) < 0) {
                                throw new MallAdminException("\u540a\u724c\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u9500\u552e\u4ef7");
                            }
                            if (!goods.getPriceSystem().equals(0) && g.getIntegralPoints().compareTo(0L) < 1) {
                                throw new MallAdminException("\u79ef\u5206\u4e0d\u80fd\u4e3a0");
                            }
                            if (g.getSalesPrice().compareTo(minSalePrice) < 0) {
                                minSalePrice = g.getSalesPrice();
                            }
                            if (g.getMarketPrice().compareTo(minMarketPrice) < 0) {
                                minMarketPrice = g.getMarketPrice();
                            }
                            if (!goods.getPriceSystem().equals(0) && g.getIntegralPoints().compareTo(minIntegralPoints) < 0) {
                                minIntegralPoints = g.getIntegralPoints();
                            }
                            GoodsSkuDetailPOExample goodsSkuDetailPOExample = new GoodsSkuDetailPOExample();
                            GoodsSkuDetailPOExample.Criteria goodsSkuDetailPOExampleCriteria = goodsSkuDetailPOExample.createCriteria();
                            goodsSkuDetailPOExampleCriteria.andValidEqualTo(Boolean.TRUE).andSysBrandIdEqualTo(goods.getSysBrandId()).andMerchantIdEqualTo(goods.getMerchantId()).andSkuNoEqualTo(g.getSkuNo()).andIsDelEqualTo(Boolean.FALSE);
                            if (null != g.getId()) {
                                goodsSkuDetailPOExampleCriteria.andIdNotEqualTo(g.getId());
                            }
                            if ((goodsSkuDetailPOCount = this.goodsSkuDetailPOMapper.countByExample(goodsSkuDetailPOExample)) > 0L) {
                                throw new MallAdminException("sku\u7f16\u7801\u6709\u91cd\u590d");
                            }
                        }
                        if (g.getId() == null) {
                            g.setSysBrandId(goods.getSysBrandId());
                            g.setGoodsId(goods.getId());
                            g.setGmtCreate(date);
                            g.setIsUniform(Boolean.valueOf(false));
                            g.setStock(g.getStockChange());
                            this.goodsSkuDetailMapper.insertSelective((Object)g);
                            continue;
                        }
                        g.setSysBrandId(goods.getSysBrandId());
                        g.setNoId(g.getId());
                        g.setGmtModified(date);
                        if (g.getStockChange() != null) {
                            if (g.getStock() != null) {
                                g.setStock(Integer.valueOf(g.getStock() + g.getStockChange()));
                            } else {
                                throw new MallAdminException("\u5f53\u524d\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a\u503c\uff01");
                            }
                        }
                        this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)g);
                        this.scheduledThreadPoolExecutor.execute(() -> {
                            Goods goods1 = this.goodsMapper.selectById(goods.getId());
                            log.info("GoodsServiceImpl#update goods1:{}", (Object)JSON.toJSONString((Object)goods1));
                            GoodsSkuLogPO goodsSkuLogPO = new GoodsSkuLogPO();
                            goodsSkuLogPO.setGmtCreate(new Date());
                            goodsSkuLogPO.setUserCreate(goods.getNickName());
                            goodsSkuLogPO.setUserAccount(goods.getAccountCode());
                            goodsSkuLogPO.setGoodsId(goods.getId());
                            goodsSkuLogPO.setGoodsSkuDetailId(g.getId());
                            goodsSkuLogPO.setGoodsNo(goods1.getGoodsNo());
                            goodsSkuLogPO.setSkuNo(g.getSkuNo());
                            goodsSkuLogPO.setNewMarketPrice(g.getMarketPrice());
                            goodsSkuLogPO.setNewSalesPrice(g.getSalesPrice());
                            goodsSkuLogPO.setNewStock(g.getStock());
                            goodsSkuLogPO.setMerchantId(goods.getMerchantId());
                            log.info("GoodsServiceImpl#update#scheduledThreadPoolExecutor goodsSkuLogPO:{}", (Object)JSON.toJSONString((Object)goodsSkuLogPO));
                            this.goodsSkuLogPOMapper.insertSelective(goodsSkuLogPO);
                        });
                    }
                    goods.setSalePrice(minSalePrice);
                    goods.setMarketPrice(minMarketPrice);
                    goods.setIntegralPoints(minIntegralPoints);
                    if (goods.getGoodsSpecRelationList().size() > 0) {
                        Example example4 = new Example(GoodsSpecRelation.class);
                        example4.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
                        this.goodsSpecRelationMapper.deleteByExample((Object)example4);
                        this.goodsSpecRelationMapper.insertList(goods.getGoodsSpecRelationList());
                    }
                }
            }
        }
        if ((i = this.goodsMapper.updateByPrimaryKeySelective((Object)goods)) > 0) {
            example = new Example(ActivityRuleCombination.class);
            example.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
            List combinations = this.activityRuleCombinationMapper.selectByExample((Object)example);
            combinations.forEach(c -> {
                c.setGoodsName(goods.getGoodsName());
                c.setGoodsNo(goods.getGoodsNo());
                this.activityRuleCombinationMapper.updateByPrimaryKeySelective(c);
            });
        }
        return i;
    }

    private void validaGoods(Goods goods) {
        Integer merchantId = goods.getMerchantId();
        ActivityPOExample activityPOExample = new ActivityPOExample();
        activityPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andActivityStatusValueIsNotNull().andActivityStatusValueNotEqualTo(Integer.valueOf(2));
        List activityPOList = this.activityPOMapper.selectByExample(activityPOExample);
        if (CollectionUtils.isNotEmpty((Collection)activityPOList)) {
            List activityIds = activityPOList.stream().map(ActivityPO::getId).collect(Collectors.toList());
            ActivityCombinationGoodsPOExample activityCombinationGoodsPOExample = new ActivityCombinationGoodsPOExample();
            activityCombinationGoodsPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE).andActivityIdIn(activityIds);
            List activityCombinationGoodsPOList = this.activityCombinationGoodsPOMapper.selectByExample(activityCombinationGoodsPOExample);
            if (CollectionUtils.isNotEmpty((Collection)activityCombinationGoodsPOList)) {
                throw new MallCommonException("\u8be5\u5546\u54c1\u5df2\u53c2\u52a0\u7ec4\u5408\u4ef7\u6d3b\u52a8\uff0c\u4e0d\u53ef\u66f4\u6539\u914d\u9001\u65b9\u5f0f,\u9884\u552e\uff0c\u9650\u8d2d\uff01");
            }
        }
    }

    public Goods findById(Integer id) {
        Goods goods = this.goodsMapper.selectById(id);
        log.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)goods));
        ArrayList<GoodsSkuDetail> list2 = new ArrayList<GoodsSkuDetail>();
        for (GoodsSkuDetail skuDetail : goods.getGoodsSkuDetailList()) {
            if (StringUtils.isEmpty((Object)skuDetail.getSkuImg())) {
                skuDetail.setSkuImg(goods.getCoverImg());
            }
            list2.add(skuDetail);
            log.info("sku:{}", (Object)JSON.toJSONString(list2));
        }
        goods.setGoodsSkuDetailList(list2);
        List goodsGroupRelationPOList = this.goodsGroupRelationPOMapper.selectByGoodsId(id);
        if (CollectionUtils.isNotEmpty((Collection)goodsGroupRelationPOList)) {
            ArrayList goodsGroupPOList = new ArrayList();
            goodsGroupRelationPOList.stream().forEach(e -> {
                GoodsGroupPO goodsGroupPO = new GoodsGroupPO();
                goodsGroupPO.setId(e.getGoodsGroupId());
                goodsGroupPO.setGoodsGroupName(e.getGroupName());
                goodsGroupPOList.add(goodsGroupPO);
            });
            goods.setGoodsGroupPOS(goodsGroupPOList);
        }
        if (!StringUtils.isEmpty((Object)goods.getGuessGroupIds())) {
            ArrayList guessGroupPOList = new ArrayList();
            List guessGroupIds = JSONArray.parseArray((String)goods.getGuessGroupIds(), Integer.class);
            guessGroupIds.stream().forEach(e -> {
                GoodsGroupPO goodsGroupPO = new GoodsGroupPO();
                goodsGroupPO.setId(e);
                goodsGroupPO.setGoodsGroupName(this.goodsGroupPOMapper.selectByPrimaryKey(e).getGoodsGroupName());
                guessGroupPOList.add(goodsGroupPO);
            });
            goods.setGuessGroupPOS(guessGroupPOList);
        }
        GoodsServiceDescRelationPOExample goodsServiceDescRelationPOExample = new GoodsServiceDescRelationPOExample();
        goodsServiceDescRelationPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andGoodsIdEqualTo(id).andMerchantIdEqualTo(goods.getMerchantId());
        List goodsServiceDescRelationPOList = this.goodsServiceDescRelationPOMapper.selectByExample(goodsServiceDescRelationPOExample);
        if (CollectionUtils.isNotEmpty((Collection)goodsServiceDescRelationPOList)) {
            ArrayList goodsServiceDescPOList = new ArrayList();
            goodsServiceDescRelationPOList.stream().forEach(e -> {
                GoodsServiceDescPO goodsServiceDescPO = new GoodsServiceDescPO();
                goodsServiceDescPO.setGoodsServiceName(e.getGoodsServiceName());
                goodsServiceDescPO.setId(e.getGoodsServiceDescId());
                goodsServiceDescPOList.add(goodsServiceDescPO);
            });
            goods.setGoodsServiceDescPOList(goodsServiceDescPOList);
        }
        log.info("\u6700\u540e\u8fd4\u56de\u7684\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)goods));
        return goods;
    }

    public List<Goods> findByConditionForActivity(Goods goods) {
        return this.goodsMapper.goodsListForActivity(goods);
    }

    public List<Goods> findByCondition(Goods goods) {
        return this.goodsMapper.goodsList(goods);
    }

    public int updateShelved(List<Goods> goodsList, Integer checked) {
        if (checked == 1) {
            for (Goods g : goodsList) {
                Example example = new Example(GoodsSkuDetail.class);
                example.createCriteria().andEqualTo("goodsId", (Object)g.getId()).andEqualTo("isDel", (Object)false);
                List list = this.goodsSkuDetailMapper.selectByExample((Object)example);
                if (list.size() >= 1) continue;
                throw new MallAdminException("\u7f16\u53f7" + g.getGoodsNo() + "\u5546\u54c1\u6ca1\u6709\u8bbe\u7f6e\u89c4\u683c");
            }
        }
        return this.goodsMapper.updateShelved(goodsList, checked);
    }

    public int delete(Integer id) {
        Goods goods1 = (Goods)this.goodsMapper.selectByPrimaryKey((Object)id);
        if (goods1.getIsShelved().booleanValue()) {
            throw new MallAdminException("\u5546\u54c1\u9700\u8981\u5148\u4e0b\u67b6\u624d\u80fd\u5220\u9664");
        }
        Goods goods = new Goods();
        goods.setId(id);
        goods.setIsDel(Boolean.valueOf(true));
        int result = this.goodsMapper.updateByPrimaryKeySelective((Object)goods);
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        goodsSkuDetail.setIsDel(Boolean.valueOf(true));
        Example example = new Example(GoodsSkuDetail.class);
        example.createCriteria().andEqualTo("goodsId", (Object)goods1.getId());
        int skuResult = this.goodsSkuDetailMapper.updateByExampleSelective((Object)goodsSkuDetail, (Object)example);
        log.info("\u66f4\u65b0\u4e86goodsId:[{}]\u4e0b\u7684sku:[{}]\u6761", (Object)id, (Object)skuResult);
        if (result > 0) {
            this.activityService.deleteActivityGoods(id);
        }
        return result;
    }

    public List<Goods> goodsStock(Goods goods) {
        return this.goodsMapper.goodsStock(goods);
    }

    public Goods findGiftByNo(Integer merchantId, String goodsNo) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)goodsNo).andEqualTo("merchantId", (Object)merchantId).andEqualTo("isGift", (Object)true).andEqualTo("isDel", (Object)false);
        List list = this.goodsMapper.selectByExample((Object)example);
        if (list.size() > 0) {
            return (Goods)list.get(0);
        }
        throw new MallAdminException("\u6ca1\u6709\u6b64\u7f16\u53f7\u7684\u8d60\u54c1");
    }

    public PageInfo<GoodsStatisticalDTO> goodsStatisticalList(Goods goods, Boolean pageJudge) {
        PageInfo pageInfo = new PageInfo();
        List statisticalDTOS = new ArrayList();
        if (Boolean.TRUE.equals(pageJudge)) {
            PageHelper.startPage((int)goods.getPageIndex(), (int)goods.getPageSize());
            statisticalDTOS = this.goodsMapper.goodsStatisticalList(goods);
            pageInfo = new PageInfo(statisticalDTOS);
        } else {
            statisticalDTOS = this.goodsMapper.goodsStatisticalList(goods);
            pageInfo.setList(statisticalDTOS);
        }
        if (pageInfo.getList().size() > 0) {
            GoodsStatisticalDTO goodsStatisticalDTO = new GoodsStatisticalDTO();
            goodsStatisticalDTO.setGoodsNo("\u603b\u8ba1");
            goodsStatisticalDTO.setAmount(new BigDecimal("0"));
            goodsStatisticalDTO.setAvgPrice(new BigDecimal("0"));
            goodsStatisticalDTO.setCountCar(Integer.valueOf(0));
            goodsStatisticalDTO.setCountCollect(Integer.valueOf(0));
            goodsStatisticalDTO.setQuantity(Integer.valueOf(0));
            for (GoodsStatisticalDTO g : pageInfo.getList()) {
                goodsStatisticalDTO.setAmount(goodsStatisticalDTO.getAmount().add(g.getAmount() == null ? new BigDecimal("0") : g.getAmount()));
                goodsStatisticalDTO.setAvgPrice(goodsStatisticalDTO.getAvgPrice().add(g.getAvgPrice() == null ? new BigDecimal("0") : g.getAvgPrice()));
                goodsStatisticalDTO.setCountCar(Integer.valueOf(goodsStatisticalDTO.getCountCar() + (g.getCountCar() == null ? 0 : g.getCountCar())));
                goodsStatisticalDTO.setCountCollect(Integer.valueOf(goodsStatisticalDTO.getCountCollect() + (g.getCountCollect() == null ? 0 : g.getCountCollect())));
                goodsStatisticalDTO.setQuantity(Integer.valueOf(goodsStatisticalDTO.getQuantity() + (g.getQuantity() == null ? 0 : g.getQuantity())));
                goodsStatisticalDTO.setAvgPrice(goodsStatisticalDTO.getAvgPrice().setScale(2, 4));
                g.setAvgPrice(g.getAvgPrice().setScale(2, 4));
            }
            pageInfo.getList().add(0, goodsStatisticalDTO);
        }
        return pageInfo;
    }

    public Goods selectByGoodsNo(Goods goods) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)goods.getGoodsNo()).andEqualTo("isGift", (Object)false).andEqualTo("merchantId", (Object)goods.getMerchantId()).andEqualTo("isDel", (Object)0);
        return (Goods)this.goodsMapper.selectOneByExample((Object)example);
    }

    public Integer selectCountGoodsByExpressId(Integer id) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("expressTemplateId", (Object)id).andEqualTo("isDel", (Object)false);
        List goods = this.goodsMapper.selectByExample((Object)example);
        return goods.size();
    }

    public PageInfo<Goods> selectGoodsList(Goods goods) {
        log.info("GoodsServiceImpl#selectGoodsList goods:{}", (Object)JSON.toJSONString((Object)goods));
        PageHelper.startPage((int)goods.getPageIndex(), (int)goods.getPageSize(), (boolean)true);
        List goods1 = this.goodsMapper.selectGoodsList(goods);
        log.info("selectGoodsList\u67e5\u8be2\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)goods1));
        PageInfo pageInfo = new PageInfo(goods1);
        List goodsList = pageInfo.getList();
        if (!CollectionUtils.isEmpty((Collection)goodsList)) {
            List goodsPackage = this.addCategoryName(goodsList);
            goodsPackage.stream().forEach(e -> {
                ArrayList goodsGroupPOList = new ArrayList();
                List goodsGroupRelationPOList = this.goodsGroupRelationPOMapper.selectByGoodsId(e.getId());
                if (CollectionUtils.isNotEmpty((Collection)goodsGroupRelationPOList)) {
                    goodsGroupRelationPOList.stream().forEach(goodsGroupRelationPO -> {
                        GoodsGroupPO goodsGroupPO = new GoodsGroupPO();
                        goodsGroupPO.setGoodsGroupName(goodsGroupRelationPO.getGroupName());
                        goodsGroupPO.setId(goodsGroupRelationPO.getGoodsGroupId());
                        goodsGroupPOList.add(goodsGroupPO);
                    });
                    e.setGoodsGroupPOS(goodsGroupPOList);
                }
            });
            pageInfo.setList(goodsPackage);
        }
        return pageInfo;
    }

    public PageInfo<Goods> getGoodListByClassifyName(Object condition) {
        GoodsQueryDTO goodsQueryDTO = (GoodsQueryDTO)condition;
        goodsQueryDTO.setActivityType(ActivitySanEnum.FULL_REDUCTION.getCode());
        log.info("\u67e5\u8be2\u6709\u6548\u6d3b\u52a8\u5546\u54c1\u6761\u4ef6:{}", (Object)goodsQueryDTO);
        List goodsIds = this.activityGoodsMapper.selectGoodIdsInActivity(goodsQueryDTO);
        log.info("\u67e5\u8be2\u51fa\u7684\u6709\u6548\u6d3b\u52a8\u5546\u54c1:{}", (Object)goodsIds);
        goodsQueryDTO.setGoodsInActivity(goodsIds);
        PageHelper.startPage((int)goodsQueryDTO.getPageIndex(), (int)goodsQueryDTO.getPageSize());
        List goods = this.activityGoodsMapper.selectGoodsNotInActivity(goodsQueryDTO);
        PageInfo result = new PageInfo(goods);
        result = this.goodsAddClassifyName(result);
        log.info("\u7b26\u5408\u5546\u54c1\u7684\u7ed3\u679c\uff1a{}", (Object)goods);
        return result;
    }

    @Transactional
    public RestResult updateSalePrice(List<Goods> goods) {
        ArrayList<UpdateSalesEntity> failed = new ArrayList<UpdateSalesEntity>();
        for (Goods good : goods) {
            log.info("GoodsServiceImpl#updateSalePrice good:{}", (Object)JSON.toJSONString((Object)good));
            Goods good1 = this.goodsMapper.selectById(good.getId());
            if (good.getId() == null || good.getSalePrice() == null) {
                log.info("\u53c2\u6570\u4e3a\u7a7a");
                failed.add(this.transGood2Update(good1, "\u53c2\u6570\u4e3a\u7a7a"));
                continue;
            }
            if (good1 == null) {
                log.info("\u6ca1\u6709\u5546\u54c1\u6570\u636e");
                failed.add(this.transGood2Update(good1, "\u6ca1\u6709\u5546\u54c1\u6570\u636e"));
                continue;
            }
            if (GoodsIsGift.GIFT.getCode().equals(good1.getIsGift())) {
                log.info("\u8be5\u5546\u54c1\u662f\u793c\u54c1");
                failed.add(this.transGood2Update(good1, "\u8be5\u5546\u54c1\u662f\u793c\u54c1"));
                continue;
            }
            if (Boolean.TRUE.equals(good1.getIsDel())) {
                log.info("\u8be5\u5546\u54c1\u5df2\u7ecf\u88ab\u5220\u9664");
                failed.add(this.transGood2Update(good1, "\u8be5\u5546\u54c1\u5df2\u7ecf\u88ab\u5220\u9664"));
                continue;
            }
            GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
            goodsSkuDetail.setGoodsId(good1.getId());
            goodsSkuDetail.setSalesPrice(good.getSalePrice());
            goodsSkuDetail.setGmtModified(new Date());
            List goodsSkuDetails = this.goodsSkuDetailMapper.selectSkuSalesGTMarketPrice(goodsSkuDetail);
            log.info("GoodsServiceImpl#updateSalePrice goodsSkuDetails:{}", (Object)JSON.toJSONString((Object)goodsSkuDetails));
            if (goodsSkuDetails.size() > 0) {
                log.info("\u8be5\u5546\u54c1\u89c4\u683c\u552e\u4ef7\u5927\u4e8e\u540a\u724c\u4ef7");
                failed.add(this.transGood2Update(good1, "\u8be5\u5546\u54c1\u89c4\u683c\u552e\u4ef7\u5927\u4e8e\u540a\u724c\u4ef7"));
                continue;
            }
            Goods goodChange = new Goods();
            goodChange.setId(good1.getId());
            goodChange.setSalePrice(good.getSalePrice());
            int j = this.goodsMapper.updateSalesByGoodSelective(goodChange);
            if (j == 0 && !good1.getSalePrice().setScale(0, 4).equals(good.getSalePrice().setScale(0, 4))) {
                log.info("\u8be5\u5546\u54c1\u552e\u4ef7\u9ad8\u4e8e\u540a\u724c\u4ef7");
                failed.add(this.transGood2Update(good1, "\u8be5\u5546\u54c1\u552e\u4ef7\u9ad8\u4e8e\u540a\u724c\u4ef7"));
                continue;
            }
            int i = this.goodsSkuDetailMapper.updateByGoodsIdSelective(goodsSkuDetail);
            List goodsSkuDetailsUpdated = this.goodsSkuDetailMapper.selectByGoodsId(good.getId());
            log.info("GoodsServiceImpl#updateSalePrice#scheduledThreadPoolExecutor goodsSkuDetailsUpdated:{}", (Object)JSON.toJSONString((Object)goodsSkuDetailsUpdated));
            for (GoodsSkuDetail goodsSkuDetail1 : goodsSkuDetailsUpdated) {
                this.scheduledThreadPoolExecutor.execute(() -> {
                    log.info("GoodsServiceImpl#updateSalePrice#scheduledThreadPoolExecutor goodsSkuDetail1:{}", (Object)JSON.toJSONString((Object)goodsSkuDetail1));
                    Goods goods1 = this.goodsMapper.selectById(good.getId());
                    GoodsSkuLogPO goodsSkuLogPO = new GoodsSkuLogPO();
                    goodsSkuLogPO.setGmtCreate(new Date());
                    goodsSkuLogPO.setUserCreate(good.getNickName());
                    goodsSkuLogPO.setUserAccount(good.getAccountCode());
                    goodsSkuLogPO.setGoodsId(good.getId());
                    goodsSkuLogPO.setGoodsSkuDetailId(goodsSkuDetail1.getId());
                    goodsSkuLogPO.setGoodsNo(goods1.getGoodsNo());
                    goodsSkuLogPO.setSkuNo(goodsSkuDetail1.getSkuNo());
                    goodsSkuLogPO.setNewMarketPrice(good.getMarketPrice());
                    goodsSkuLogPO.setNewSalesPrice(good.getSalePrice());
                    goodsSkuLogPO.setMerchantId(good.getMerchantId());
                    this.goodsSkuLogPOMapper.insertSelective(goodsSkuLogPO);
                });
            }
        }
        HashMap<String, ArrayList<UpdateSalesEntity>> resultMap = new HashMap<String, ArrayList<UpdateSalesEntity>>();
        resultMap.put("failed", failed);
        return RestResult.success(resultMap);
    }

    public UpdateSalesEntity transGood2Update(Goods good, String msg) {
        UpdateSalesEntity faildMsg = new UpdateSalesEntity();
        if (good != null) {
            faildMsg.setId(good.getId());
            faildMsg.setGoodsName(good.getGoodsName());
        }
        faildMsg.setFailedMsg(msg);
        return faildMsg;
    }

    public List<Goods> addCategoryName(List<Goods> list) {
        for (Goods goods : list) {
            HashMap groud = new HashMap();
            List goodsClassifies = this.goodsClassifyMapper.selectByGoodsId(goods.getId());
            for (GoodsClassify gc : goodsClassifies) {
                if (gc.getPid() != 0) {
                    goods.setSecondCategoryName(gc.getName());
                    continue;
                }
                goods.setFirstCategoryName(gc.getName());
            }
        }
        return list;
    }

    public PageInfo<GoodsCopyVO> selectGoodsListByChildSync(GoodsCopyVO goods) throws Exception {
        Integer merchantId = goods.getMerchantId();
        Integer mainMallMerchantIdByMerchantId = this.companyBrandRelationService.getMainMallMerchantIdByMerchantId(merchantId);
        if (mainMallMerchantIdByMerchantId == null) {
            throw new Exception("\u5f53\u524d\u5546\u6237\u6ca1\u6709\u4e3b\u5546\u57ce\u4fe1\u606f!");
        }
        goods.setChildMerchantId(merchantId);
        goods.setMerchantId(mainMallMerchantIdByMerchantId);
        PageHelper.startPage((int)goods.getPageIndex(), (int)goods.getPageSize());
        List goods1 = this.goodsMapper.selectGoodsListByChildSync(goods);
        PageInfo pageInfo = new PageInfo(goods1);
        List list = pageInfo.getList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List goodsPackage = this.addCategoryNameNew(list);
            pageInfo.setList(goodsPackage);
        }
        return pageInfo;
    }

    public void batchUpdateGroud(GoodsGroudVO goodsGroudVos, Integer merchantId) {
        log.info("GoodsServiceImpl_batchUpdateGroud" + JSONArray.toJSONString((Object)goodsGroudVos));
        Date data = new Date();
        List goodsIds = goodsGroudVos.getGoodsIds();
        List groudIds = goodsGroudVos.getGroudIds();
        if (CollectionUtils.isEmpty((Collection)goodsIds) || StringUtils.isEmpty((Object)groudIds)) {
            throw new MallCommonException("\u5546\u54c1ID\u6216\u8005\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        GoodsGroupRelationPOExample goodsGroupRelationPOExample = new GoodsGroupRelationPOExample();
        GoodsGroupRelationPOExample.Criteria criteria = goodsGroupRelationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andGoodsIdIn(goodsIds);
        GoodsGroupRelationPO groupRelationPO = new GoodsGroupRelationPO();
        groupRelationPO.setValid(Boolean.valueOf(false));
        groupRelationPO.setGmtModified(new Date());
        this.goodsGroupRelationPOMapper.updateByExampleSelective(groupRelationPO, goodsGroupRelationPOExample);
        goodsIds.stream().forEach(e -> groudIds.stream().forEach(groudId -> {
            GoodsGroupRelationPO goodsGroupRelationPO = new GoodsGroupRelationPO();
            goodsGroupRelationPO.setGroupName(this.goodsGroupPOMapper.selectByPrimaryKey(groudId).getGoodsGroupName());
            goodsGroupRelationPO.setGoodsId(e);
            goodsGroupRelationPO.setValid(Boolean.valueOf(true));
            goodsGroupRelationPO.setGoodsGroupId(groudId);
            goodsGroupRelationPO.setGmtCreate(data);
            goodsGroupRelationPO.setMerchantId(merchantId);
            this.goodsGroupRelationPOMapper.insert(goodsGroupRelationPO);
        }));
        log.info("\u6279\u91cf\u63d2\u5165\u6210\u529f\uff01{}" + JSONArray.toJSONString((Object)goodsGroudVos));
    }

    public void batchUpdateClassification(GoodsClassificationVO goodsClassificationVO, Integer merchantId) {
        List goodsIds = goodsClassificationVO.getGoodsIds();
        List classificationIds = goodsClassificationVO.getClassificationIds();
        if (CollectionUtils.isEmpty((Collection)goodsIds) || CollectionUtils.isEmpty((Collection)classificationIds)) {
            throw new MallCommonException("\u5546\u54c1ID\u6216\u8005\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        GoodsClassifyCustomPOExample goodsClassifyCustomPOExample = new GoodsClassifyCustomPOExample();
        GoodsClassifyCustomPOExample.Criteria criteria = goodsClassifyCustomPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andGoodsIdIn(goodsIds);
        GoodsClassifyCustomPO goodsClassifyCustomPO = new GoodsClassifyCustomPO();
        goodsClassifyCustomPO.setValid(Boolean.valueOf(false));
        goodsClassifyCustomPO.setGmtModified(new Date());
        this.goodsClassifyCustomPOMapper.updateByExampleSelective(goodsClassifyCustomPO, goodsClassifyCustomPOExample);
        goodsIds.stream().forEach(e -> classificationIds.stream().forEach(id -> {
            GoodsClassifyCustomPO goodsClassifyCustom = new GoodsClassifyCustomPO();
            goodsClassifyCustom.setGoodsId(e);
            goodsClassifyCustom.setValid(Boolean.valueOf(true));
            goodsClassifyCustom.setClassifyId(id);
            goodsClassifyCustom.setGmtCreate(new Date());
            goodsClassifyCustom.setMerchantId(merchantId);
            goodsClassifyCustom.setGmtModified(new Date());
            this.goodsClassifyCustomPOMapper.insert(goodsClassifyCustom);
        }));
    }

    public void batchUpdateTag(GoodsTagVO goodsTagVO, Integer merchantId) {
        log.info("GoodsServiceImpl_batchUpdateTag" + JSONArray.toJSONString((Object)goodsTagVO));
        List goodsIds = goodsTagVO.getGoodsIds();
        List tagIds = goodsTagVO.getTagIds();
        if (CollectionUtils.isEmpty((Collection)goodsIds) || CollectionUtils.isEmpty((Collection)tagIds)) {
            throw new MallCommonException("\u5546\u54c1ID\u6216\u8005\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (tagIds.size() > 4) {
            throw new MallCommonException("\u6279\u91cf\u4fee\u6539\u6807\u7b7e\u4e0d\u53ef\u591a\u4e8e5\u4e2a\uff01");
        }
        GoodsTagCustomPOExample goodsTagCustomPOExample = new GoodsTagCustomPOExample();
        GoodsTagCustomPOExample.Criteria criteria = goodsTagCustomPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andGoodsIdIn(goodsIds);
        GoodsTagCustomPO goodsTagPO = new GoodsTagCustomPO();
        goodsTagPO.setValid(Boolean.valueOf(false));
        goodsTagPO.setGmtModified(new Date());
        this.goodsTagCustomPOMapper.updateByExampleSelective(goodsTagPO, goodsTagCustomPOExample);
        goodsIds.stream().forEach(e -> tagIds.stream().forEach(tagId -> {
            GoodsTagCustomPO goodsTagCustomPO = new GoodsTagCustomPO();
            goodsTagCustomPO.setGoodsId(e);
            goodsTagCustomPO.setValid(Boolean.valueOf(true));
            goodsTagCustomPO.setTagId(tagId);
            goodsTagCustomPO.setGmtCreate(new Date());
            goodsTagCustomPO.setMerchantId(merchantId);
            goodsTagCustomPO.setGmtModified(new Date());
            this.goodsTagCustomPOMapper.insert(goodsTagCustomPO);
        }));
    }

    public void batchUpdateExpressTemplate(GoodsExpressTemplateVO goodsExpressTemplateVO, Integer merchantId) {
        log.info("GoodsServiceImpl_batchUpdateTag" + JSONArray.toJSONString((Object)goodsExpressTemplateVO));
        List goodsIds = goodsExpressTemplateVO.getGoodsIds();
        Integer expressTemplateId = goodsExpressTemplateVO.getExpressTemplateId();
        if (CollectionUtils.isEmpty((Collection)goodsIds) || StringUtils.isEmpty((Object)expressTemplateId)) {
            throw new MallCommonException("\u5546\u54c1ID\u6216\u8005\u8fd0\u8d39\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        goodsIds.stream().forEach(e -> {
            GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(e);
            goodsPO.setMerchantId(merchantId);
            goodsPO.setExpressTemplateId(expressTemplateId);
            this.goodsPOMapper.updateByPrimaryKey(goodsPO);
        });
    }

    private List<GoodsCopyVO> addCategoryNameNew(List<GoodsCopyVO> list) {
        for (Goods goods : list) {
            List goodsClassifies = this.goodsClassifyMapper.selectByGoodsId(goods.getId());
            for (GoodsClassify gc : goodsClassifies) {
                if (gc.getPid() != 0) {
                    goods.setSecondCategoryName(gc.getName());
                    continue;
                }
                goods.setFirstCategoryName(gc.getName());
            }
        }
        return list;
    }

    public PageInfo<Goods> goodsAddClassifyName(PageInfo<Goods> goodsPage) {
        log.info("GoodsServiceImpl#goodsAddClassifyName:{}", (Object)JSON.toJSONString(goodsPage));
        List goodsList = goodsPage.getList();
        for (Goods goods : goodsList) {
            SelectGoodsClassifyRequestVO vo = new SelectGoodsClassifyRequestVO();
            vo.setGoodsId(goods.getId());
            vo.setPid(Integer.valueOf(0));
            List goodsClassifiesParents = this.goodsClassifyMapper.selectByGoodsIdAndPid(vo);
            if (CollectionUtils.isEmpty((Collection)goodsClassifiesParents)) {
                goods.setClassifyName("");
                continue;
            }
            goods.setFirstCategoryName(((GoodsClassify)goodsClassifiesParents.get(0)).getName());
            vo.setPid(((GoodsClassify)goodsClassifiesParents.get(0)).getId());
            List goodsClassifiesSecond = this.goodsClassifyMapper.selectByGoodsIdAndPid(vo);
            if (!CollectionUtils.isEmpty((Collection)goodsClassifiesSecond)) {
                goods.setSecondCategoryName("");
            }
            goods.setSecondCategoryName(((GoodsClassify)goodsClassifiesSecond.get(0)).getName());
        }
        return goodsPage;
    }

    private List<GoodsSkuDetail> checkEmptySkuDetail(List<GoodsSkuDetail> details) {
        log.info("checkEmptySkuDetail:{}", (Object)JSON.toJSONString(details));
        Iterator<GoodsSkuDetail> checkIterator = details.iterator();
        while (checkIterator.hasNext()) {
            GoodsSkuDetail detail = checkIterator.next();
            log.info("detail:{}", (Object)JSON.toJSONString((Object)detail));
            Boolean judge = Boolean.TRUE;
            if (detail.getActualSales() != null) {
                log.info("1");
                continue;
            }
            if (detail.getCustomStartSales() != null) {
                log.info("2");
                continue;
            }
            if (detail.getMarketPrice() != null) {
                log.info("3");
                continue;
            }
            if (detail.getId() != null) {
                log.info("4");
                continue;
            }
            if (!StringUtils.isEmpty((Object)detail.getSpecIds())) {
                log.info("5");
                continue;
            }
            if (!StringUtils.isEmpty((Object)detail.getSkuImg())) {
                log.info("6");
                continue;
            }
            if (!StringUtils.isEmpty((Object)detail.getSpecNames())) {
                log.info("7");
                continue;
            }
            if (detail.getStock() != null) {
                log.info("8");
                continue;
            }
            if (detail.getStockChange() != null) {
                log.info("9");
                continue;
            }
            if (detail.getVolume() != null) {
                log.info("10");
                continue;
            }
            if (detail.getWeight() != null) {
                log.info("11");
                continue;
            }
            if (!StringUtils.isEmpty((Object)detail.getSkuNo())) {
                log.info("12");
                continue;
            }
            checkIterator.remove();
        }
        log.info("checkEmptySkuDetail#result:{}", (Object)JSON.toJSONString(details));
        return details;
    }
}

