/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.BargainPlayers;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.mapper.BargainPlayersMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CutDownService {
    @Autowired
    private MarketActivityMapper marketActivityMapper;
    @Autowired
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private BargainPlayersMapper bargainPlayersMapper;

    public Map<String, Object> analysis(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MarketActivity marketActivity = (MarketActivity)this.marketActivityMapper.selectByPrimaryKey((Object)id);
        if (marketActivity == null) {
            throw new CustomException("\u6d3b\u52a8\u672a\u627e\u5230");
        }
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setActivityNo(marketActivity.getActivityNo());
        List select = this.marketActivityOrdersMapper.select((Object)mao);
        Date begin = marketActivity.getActivityBeginTime();
        Date end = marketActivity.getActivityEndTime();
        long jinxingzhong = 0L;
        long leijichegnjiaodan = 0L;
        long leijichegnjiaoe = 0L;
        long leijikanjiae = 0L;
        long faqikanjiarenshu = 0L;
        long canyukanjiarenshu = 0L;
        if (!CollectionUtils.isEmpty((Collection)select)) {
            faqikanjiarenshu = select.size();
            List timeSatisfiedOders = select.stream().filter(e -> e.getValid().equals(1)).filter(e -> e.getGmtCreate().after(begin) && e.getGmtCreate().before(end)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(timeSatisfiedOders)) {
                jinxingzhong = timeSatisfiedOders.stream().filter(e -> "0".equals(e.getOrdersStatus())).count();
                List collect = timeSatisfiedOders.stream().filter(e -> "1".equals(e.getTradeStatus()) && "1".equals(e.getOrdersStatus())).collect(Collectors.toList());
                leijichegnjiaodan = collect.size();
                leijichegnjiaoe = collect.stream().map(e -> ((MarketActivityGoods)this.marketActivityGoodsMapper.selectByPrimaryKey((Object)e.getMarketActivityGoodsId())).getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add).longValue();
                List cutDown = timeSatisfiedOders.stream().map(e -> {
                    BargainPlayers bp = new BargainPlayers();
                    bp.setActivityOrdersNo(e.getActivityOrdersNo());
                    List helps = this.bargainPlayersMapper.select((Object)bp);
                    return helps.stream();
                }).flatMap(e -> e).collect(Collectors.toList());
                leijikanjiae = cutDown.stream().map(f -> f.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add).longValue();
                canyukanjiarenshu = cutDown.size();
            }
        }
        result.put("jinxingzhong", jinxingzhong);
        result.put("leijichegnjiaodan", leijichegnjiaodan);
        result.put("leijichegnjiaoe", leijichegnjiaoe);
        result.put("leijikanjiae", leijikanjiae);
        result.put("faqikanjiarenshu", faqikanjiarenshu);
        result.put("canyukanjiarenshu", canyukanjiarenshu);
        result.put("marketActivity", marketActivity);
        return result;
    }
}

