/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.logistics;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.service.logistics.LogisticsService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.logistics.CourierCompanyInfoResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.LogisticsInfoDetailsResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.QueryLogisticsInfoDetailsRequestVO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"logistics"})
public class LogisticsInfoController {
    private static final Logger log = LoggerFactory.getLogger(LogisticsInfoController.class);
    @Autowired
    private LogisticsService logisticsService;

    @GetMapping(value={"queryCourierCompany"})
    public ResponseData<List<CourierCompanyInfoResponseVO>> queryCourierCompany() {
        log.info("LogisticsInfoController#queryCourierCompany");
        ResponseData data = new ResponseData();
        try {
            List courierCompanyInfoList = this.logisticsService.queryCourierCompany();
            data.setData((Object)courierCompanyInfoList);
            return data;
        }
        catch (Exception e) {
            log.warn("\u67e5\u8be2\u5feb\u9012\u516c\u53f8\u7f16\u53f7\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            data.setCode(SysResponseEnum.FAILED.getCode());
            data.setMessage(e.getMessage());
            return data;
        }
    }

    @PostMapping(value={"queryLogisticsInfoDetails"})
    public ResponseData<LogisticsInfoDetailsResponseVO> queryLogisticsInfoDetails(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody QueryLogisticsInfoDetailsRequestVO requestVo) {
        log.info("LogisticsInfoController#queryLogisticsInfoDetails\u5165\u53c2:[{}]_[{}]", (Object)merchantId, (Object)JSON.toJSONString((Object)requestVo));
        try {
            requestVo.setMerchantId(merchantId);
            LogisticsInfoDetailsResponseVO logisticsInfoDetailsResponseVo = this.logisticsService.queryLogisticsInfoDetailsBy100(requestVo);
            return new ResponseData((Object)logisticsInfoDetailsResponseVo);
        }
        catch (Exception e) {
            log.warn("\u901a\u8fc7\u5feb\u9012100\u516c\u5171API\u83b7\u53d6\u7269\u6d41\u8be6\u60c5\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return new ResponseData(100, e.getMessage(), null);
        }
    }
}

