/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.enums.MarketActivityEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.ConfigPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.service.order.OrderCancelService;
import com.wmeimob.fastboot.bizvane.vo.admin.OrderCancelVO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderCancelServiceImpl
implements OrderCancelService {
    private static final Logger log = LoggerFactory.getLogger(OrderCancelServiceImpl.class);
    private final String MARKET_ORDER_STATUS_DOING = "0";
    private final String MARKET_ORDER_STATUS_PERSON_NUMBER_MORE_THAN = "1";
    private final String MARKET_ORDER_STATUS_OVERDUE_FAILURE = "2";
    @Resource
    private MarketActivityOrdersPOMapper marketActivityOrdersPOMapper;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private final String MARKET_ACTIVITY_SEC_KILL_ORDER_KEY = "market_orders:sec_kill_close:%s:close_handler:marketActivityId";

    @Override
    public void cancelOrder() {
    }

    @Override
    public void cancelSecKillMarketActivityOrder(ConfigPO configPO) {
        Integer merchantId = configPO.getMerchantId();
        OrderCancelVO orderCancelVO = new OrderCancelVO();
        orderCancelVO.setActivityOrdersType(MarketActivityEnum.SEC_KILL.getType().toString());
        orderCancelVO.setMerchantId(merchantId);
        List marketActivityOrdersPOS = this.marketActivityOrdersPOMapper.selectCancelSecKIllOrders(orderCancelVO);
        String key = String.format("market_orders:sec_kill_close:%s:close_handler:marketActivityId", merchantId);
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (value != null) {
            log.info("merchantId:{}\u5f53\u524d\u6709\u4efb\u52a1\u6b63\u5728\u6267\u884c,orderIds:{}", (Object)merchantId, (Object)value);
            return;
        }
        List orderIds = marketActivityOrdersPOS.stream().map(marketActivityOrdersPO -> marketActivityOrdersPO.getOrderId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderIds)) {
            log.warn("merchantId:{}\u6ca1\u6709\u9700\u8981\u5173\u95ed\u7684\u5f85\u652f\u4ed8\u79d2\u6740\u8ba2\u5355!", (Object)merchantId);
            return;
        }
        OrdersPOExample ordersPOExample = new OrdersPOExample();
        ordersPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andPayStatusEqualTo(PayStatusEnum.UN_PAY.name()).andIdIn(orderIds).andOrdersActivityTypeEqualTo("4").andValidEqualTo(Boolean.TRUE);
        List ordersPOS = this.ordersPOMapper.selectByExample(ordersPOExample);
        if (CollectionUtils.isEmpty((Collection)ordersPOS)) {
            log.warn("merchantId:{}\u6ca1\u6709\u9700\u8981\u5173\u95ed\u7684\u5f85\u652f\u4ed8\u8ba2\u5355!", (Object)merchantId);
            return;
        }
        List executeOrderIds = ordersPOS.stream().map(ordersPO -> ordersPO.getId()).collect(Collectors.toList());
        List marketActivityOrderIds = ordersPOS.stream().map(ordersPO -> ordersPO.getMarketActivityOrdersId()).collect(Collectors.toList());
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSON.toJSONString(executeOrderIds));
        OrdersPO ordersPO2 = new OrdersPO();
        ordersPO2.setOrderStatus(OrdersStatusEnum.FAIL.name());
        ordersPO2.setGmtModified(new Date());
        ordersPO2.setClosedAt(new Date());
        ordersPO2.setClosedReason("\u652f\u4ed8\u8d85\u65f6\u81ea\u52a8\u5173\u95ed\u79d2\u6740\u8ba2\u5355");
        OrdersPOExample ordersPOExampleCondition = new OrdersPOExample();
        ordersPOExampleCondition.createCriteria().andIdIn(executeOrderIds);
        int i = this.ordersPOMapper.updateByExampleSelective(ordersPO2, ordersPOExampleCondition);
        log.info("merchantId:{}\u5173\u95ed\u652f\u4ed8\u8d85\u65f6\u79d2\u6740\u8ba2\u5355orderIds:{}", (Object)merchantId, (Object)JSON.toJSONString(orderIds));
        MarketActivityOrdersPO marketActivityOrdersPO2 = new MarketActivityOrdersPO();
        marketActivityOrdersPO2.setGmtModified(new Date());
        marketActivityOrdersPO2.setOrdersStatus("2");
        MarketActivityOrdersPOExample marketActivityOrdersPOExample1 = new MarketActivityOrdersPOExample();
        marketActivityOrdersPOExample1.createCriteria().andMerchantIdEqualTo(merchantId).andIdIn(marketActivityOrderIds).andValidEqualTo(Integer.valueOf(1));
        int i1 = this.marketActivityOrdersPOMapper.updateByExampleSelective(marketActivityOrdersPO2, marketActivityOrdersPOExample1);
        log.info("merchantId:{}\u5173\u95ed\u652f\u4ed8\u8d85\u65f6\u79d2\u6740\u8ba2\u5355marketActivityOrder\u6570\u91cf:{}", (Object)i1);
        this.stringRedisTemplate.delete((Object)key);
    }
}

