/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.seckill;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillMomentService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillSendWxSubscribeService;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillMomentDeleteRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillMomentSaveRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillMomentSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillMomentUpdateRequestVO;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"marketActivitySecKillMoment"})
public class MarketActivitySecKillMomentController {
    private static final Logger log = LoggerFactory.getLogger(MarketActivitySecKillMomentController.class);
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;
    @Autowired
    private MarketActivitySecKillMomentService momentService;
    @Autowired
    private LoginUtil loginUtil;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private MarketActivitySecKillSendWxSubscribeService secKillSendWxSubscribeService;

    @PostMapping(value={"saveSecKillMoment"})
    public ResponseData saveSecKillMoment(@Valid @RequestBody MarketActivitySecKillMomentSaveRequestVO vo, @RequestHeader(value="merchantId") Integer merchantId) {
        log.info("MarketActivitySecKillMomentController saveSecKillMoment vo:{} merchantId:{}", JSON.toJSON((Object)((Object)vo)), (Object)merchantId);
        LoginUser loginUser = this.loginUtil.getLoginUser(this.request);
        Integer sysBrandId = this.companyBrandRelationService.getBrandIdByMerchantId(merchantId);
        log.info("\u8ba4\u8bc1");
        ResponseData responseData = new ResponseData();
        if (vo.getMarketActivityMomentDate() == null) {
            return ResponseUtil.getFailedMsg((String)"\u573a\u6b21\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setAccountcode(loginUser.getAccountCode());
        vo.setSysBrandId(sysBrandId);
        vo.setMerchantId(merchantId);
        return this.momentService.saveSecKillMoment(vo);
    }

    @PostMapping(value={"deleteSecKillMoment"})
    public ResponseData deleteSecKillMoment(@RequestBody MarketActivitySecKillMomentDeleteRequestVO vo, @RequestHeader(value="merchantId") Integer merchantId) {
        log.info("MarketActivitySecKillMomentController deleteSecKillMoment vo:{} merchantId:{}", JSON.toJSON((Object)((Object)vo)), (Object)merchantId);
        if (vo.getMarketActivityMomentId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u573a\u6b21id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.momentService.checkInActivity(vo.getMarketActivityMomentId())) {
            return ResponseUtil.getFailedMsg((String)"\u573a\u6b21\u88ab\u4f7f\u7528\u4e0d\u80fd\u5220\u9664");
        }
        return this.momentService.deleteSecKillMoment(vo);
    }

    @PostMapping(value={"findSecKillMoment"})
    public ResponseData findSecKillMoment(@RequestHeader(value="merchantId") Integer merchantId) {
        log.info("MarketActivitySecKillMomentController findSecKillMoment merchantId:{}", (Object)merchantId);
        MarketActivitySecKillMomentSearchRequestVO vo = new MarketActivitySecKillMomentSearchRequestVO();
        vo.setMerchantId(merchantId);
        return this.momentService.findSecKillMoment(vo);
    }

    @PostMapping(value={"updateSecKillMoment"})
    public ResponseData updateSecKillMoment(@RequestBody MarketActivitySecKillMomentUpdateRequestVO vo, @RequestHeader(value="merchantId") Integer merchantId) {
        log.info("MarketActivitySecKillMomentController updateSecKillMoment vo:{} merchantId:{}", JSON.toJSON((Object)((Object)vo)), (Object)merchantId);
        vo.setMerchantId(merchantId);
        if (vo.getMarketActivityMomentDate() == null) {
            return ResponseUtil.getFailedMsg((String)"\u573a\u6b21\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.momentService.checkInActivity(vo.getMarketActivityMomentId())) {
            return ResponseUtil.getFailedMsg((String)"\u573a\u6b21\u88ab\u4f7f\u7528\u4e0d\u80fd\u4fee\u6539");
        }
        if (vo.getMarketActivityMomentId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u573a\u6b21id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.momentService.updateSecKillMoment(vo);
    }
}

