/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.api;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.api.vo.ApiGetGoodsRequestVO;
import com.wmeimob.fastboot.bizvane.api.vo.ApiPageVO;
import com.wmeimob.fastboot.bizvane.service.admin.ApiService;
import com.wmeimob.fastboot.bizvane.service.api.ApiGoodsService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"apiGoods"})
public class ApiGoodsController {
    private static final Logger log = LoggerFactory.getLogger(ApiGoodsController.class);
    @Autowired
    private ApiGoodsService apiGoodsService;
    @Resource
    private ApiService apiService;

    @PostMapping(value={"/get"})
    @ResponseBody
    public ResponseData<PageInfo> getGoods(@RequestBody ApiGetGoodsRequestVO requestVO) {
        log.info("ApiGoodsController_getGoods_param:{}", (Object)JSON.toJSONString((Object)requestVO));
        String shopCode = requestVO.getShopCode();
        String merchantId = this.apiService.checkStoreAuth(requestVO.getToken(), shopCode);
        requestVO.setMerchantId(merchantId);
        this.apiService.checkPage((ApiPageVO)requestVO);
        PageInfo goodsPageInfo = this.apiGoodsService.queryGoodsList(requestVO);
        return ResponseUtil.getSuccessData((Object)goodsPageInfo);
    }
}

