/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.AssembleNewMember;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"marketActivity"})
public class MarketActivityController {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityController.class);
    @Autowired
    private MarketActivityService marketActivityService;

    @PostMapping(value={"saveActivity"})
    public RestResult saveActivity(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody MarketActivity marketActivity) {
        log.info("\u4fdd\u5b58\u8425\u9500\u6d3b\u52a8\u5165\u53c2:[{}]", JSON.toJSON((Object)marketActivity));
        marketActivity.setMerchantId(merchantId);
        marketActivity.getMarketActivityGoods().stream().forEach(e -> {
            if (e.getGoodsId() == null) {
                throw new MallAdminException("goodsId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            e.setMerchantId(merchantId);
        });
        return this.marketActivityService.saveActivity(marketActivity);
    }

    @Page
    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, MarketActivity marketActivity) {
        log.info("\u8425\u9500\u6d3b\u52a8\u5206\u9875\u5217\u8868");
        marketActivity.setMerchantId(merchantId);
        List<MarketActivity> list = this.marketActivityService.getAllList(marketActivity);
        return new PageInfo(list);
    }

    @GetMapping(value={"{id}"})
    public MarketActivity getDetail(@PathVariable(value="id") Integer id) {
        return this.marketActivityService.getDetail(id);
    }

    @PostMapping(value={"newMemberByActivity"})
    public RestResult newMemberByActivity(@RequestBody AssembleNewMember assembleNewMember) {
        log.info("\u6d3b\u52a8\u53d1\u5c55\u4e86\u65b0\u4f1a\u5458\u3002\u3002\u6d3b\u52a8\u8ba2\u5355\u53f7\u4e3a:{}", (Object)assembleNewMember.getActivityOrdersNo());
        return this.marketActivityService.newMemberByActivity(assembleNewMember);
    }

    @GetMapping(value={"statistics"})
    public Map statistics(@RequestParam(value="id") Integer id) {
        log.info("\u62fc\u56e2\u6d3b\u52a8\u7edf\u8ba1");
        return this.marketActivityService.statistics(id);
    }

    @GetMapping(value={"getActivityGoods"})
    public List<Goods> getActivityGoods(@RequestParam(value="activityNo") String activityNo, @RequestParam(value="queryParams") String queryParams) {
        log.info("\u62fc\u56e2\u6d3b\u52a8\u7edf\u8ba1\u83b7\u53d6\u5546\u54c1\u5217\u8868");
        return this.marketActivityService.getActivityGoods(activityNo, queryParams);
    }
}

