/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.dto.seckill.BrandUserDTO;
import com.wmeimob.fastboot.bizvane.dto.seckill.MarketActivityGoodsSecKillAddDTO;
import com.wmeimob.fastboot.bizvane.dto.seckill.MarketActivityGoodsSecKillStatisticalAddDTO;
import com.wmeimob.fastboot.bizvane.dto.seckill.MarketActivitySecKillAddDTO;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsSecKillPOMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillStatisticalPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityStatisticalPO;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivityGoodsBuilderService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivityGoodsSecKillBuilderService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivityGoodsSecKillStatisticalBuilderService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityRepeatGoodsVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillAddRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodsModifyVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodsResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodsSkuResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodsSkuVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodsVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MarketActivityGoodsSecKillBuilderServiceImpl
implements MarketActivityGoodsSecKillBuilderService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityGoodsSecKillBuilderServiceImpl.class);
    @Autowired
    private MarketActivityGoodsBuilderService marketActivityGoodsBuilderService;
    @Resource
    private MarketActivityGoodsSecKillPOMapper marketActivityGoodsSecKillPOMapper;
    @Autowired
    private MarketActivityGoodsSecKillStatisticalBuilderService marketActivityGoodsSecKillStatisticalBuilderService;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Resource
    private MarketActivityGoodsPOMapper marketActivityGoodsPOMapper;
    @Resource
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;

    public List<MarketActivityGoodsSecKillPO> marketActivityGoodsSecKillPOBuilder(MarketActivitySecKillAddDTO marketActivitySecKillAddDTO, BrandUserDTO brandUserDTO) throws Exception {
        MarketActivityPO marketActivityPO = marketActivitySecKillAddDTO.getMarketActivityPO();
        MarketActivityStatisticalPO marketActivityStatisticalPO = marketActivitySecKillAddDTO.getMarketActivityStatisticalPO();
        CompanyBrandRelationPO companyBrandRelationPO = brandUserDTO.getCompanyBrandRelationPO();
        MarketActivitySecKillAddRequestVO requestVO = marketActivitySecKillAddDTO.getRequestVO();
        List goodsList = requestVO.getGoodsList();
        ArrayList<MarketActivityGoodsSecKillPO> marketActivityGoodsSecKillPOList = null;
        if (!CollectionUtils.isEmpty((Collection)goodsList)) {
            marketActivityGoodsSecKillPOList = new ArrayList<MarketActivityGoodsSecKillPO>();
            for (MarketActivitySecKillGoodsVO marketActivitySecKillGoodsVO : goodsList) {
                Integer goodsId = marketActivitySecKillGoodsVO.getGoodsId();
                String goodsNo = marketActivitySecKillGoodsVO.getGoodsNo();
                MarketActivityRepeatGoodsVO marketActivityRepeatGoodsVO = new MarketActivityRepeatGoodsVO();
                marketActivityRepeatGoodsVO.setGoodsId(marketActivitySecKillGoodsVO.getGoodsId());
                marketActivityRepeatGoodsVO.setMerchantId(companyBrandRelationPO.getMerchantId());
                marketActivityRepeatGoodsVO.setStartDate(requestVO.getMarketActivityStartTime());
                marketActivityRepeatGoodsVO.setEndDate(requestVO.getMarketActivityEndTime());
                List marketActivityPOS = this.marketActivityGoodsBuilderService.queryOnGoingInMarketActivity(marketActivityRepeatGoodsVO);
                if (!CollectionUtils.isEmpty((Collection)marketActivityPOS)) {
                    MarketActivityPO marketActivityPOOnGoing = (MarketActivityPO)marketActivityPOS.get(0);
                    String errorMsg = "goodsNo:" + goodsNo + "\u5df2\u5728\u6d3b\u52a8:" + marketActivityPOOnGoing.getActivityNo() + "\u4e2d\u4f7f\u7528\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0";
                    log.error("errorMsg:{}", (Object)errorMsg);
                    throw new Exception(errorMsg);
                }
                List skuList = marketActivitySecKillGoodsVO.getSkuList();
                if (CollectionUtils.isEmpty((Collection)skuList)) {
                    throw new Exception("\u8bf7\u9009\u62e9\u6b63\u786e\u5546\u54c1,\u4e14\u7ef4\u62a4\u6b63\u786esku\u4fe1\u606f!");
                }
                MarketActivitySecKillGoodsSkuVO marketActivitySecKillGoodsSkuVO = skuList.stream().min(Comparator.comparing(MarketActivitySecKillGoodsSkuVO::getMarketActivityPrice)).get();
                MarketActivityGoodsSecKillPO marketActivityGoodsSecKillPO = new MarketActivityGoodsSecKillPO();
                marketActivityGoodsSecKillPO.setMarketActivityId(marketActivityPO.getId());
                marketActivityGoodsSecKillPO.setMerchantId(companyBrandRelationPO.getMerchantId());
                marketActivityGoodsSecKillPO.setSysBrandId(companyBrandRelationPO.getBrandId());
                marketActivityGoodsSecKillPO.setGoodsId(goodsId);
                marketActivityGoodsSecKillPO.setMarketActivityGoodsMainName(marketActivitySecKillGoodsVO.getMarketActivitySecKillGoodsName());
                marketActivityGoodsSecKillPO.setMarketActivityGoodsMainTitle(marketActivitySecKillGoodsVO.getMarketActivitySecKillGoodsTitle());
                marketActivityGoodsSecKillPO.setMarketActivityGoodsMainImg(marketActivitySecKillGoodsVO.getMarketActivitySecKillGoodsImage());
                marketActivityGoodsSecKillPO.setMarketActivityGoodsMainStock(marketActivitySecKillGoodsVO.getMarketActivitySecKillGoodsStock());
                marketActivityGoodsSecKillPO.setMarketActivityGoodsStartSales(marketActivitySecKillGoodsVO.getMarketActivityGoodsStartSales());
                marketActivityGoodsSecKillPO.setMarketActivityGoodsStartPrice(marketActivitySecKillGoodsSkuVO.getMarketActivityPrice());
                marketActivityGoodsSecKillPO.setSort(marketActivitySecKillGoodsVO.getSort());
                marketActivityGoodsSecKillPO.setGmtCreate(new Date());
                int i = this.marketActivityGoodsSecKillPOMapper.insertSelective(marketActivityGoodsSecKillPO);
                log.info("\u79d2\u6740\u6d3b\u52a8\u65b0\u589e\u5546\u54c1:{}", (Object)JSON.toJSONString((Object)marketActivityGoodsSecKillPO));
                MarketActivityGoodsSecKillStatisticalAddDTO marketActivityGoodsSecKillStatisticalAddDTO = new MarketActivityGoodsSecKillStatisticalAddDTO();
                marketActivityGoodsSecKillStatisticalAddDTO.setMarketActivityGoodsSecKillPO(marketActivityGoodsSecKillPO);
                marketActivityGoodsSecKillStatisticalAddDTO.setMarketActivityStatisticalPO(marketActivityStatisticalPO);
                MarketActivityGoodsSecKillStatisticalPO marketActivityGoodsSecKillStatisticalPO = this.marketActivityGoodsSecKillStatisticalBuilderService.marketActivityGoodsSecKillStatisticalPOBuilder(marketActivityGoodsSecKillStatisticalAddDTO, brandUserDTO);
                log.info("\u79d2\u6740\u6d3b\u52a8\u65b0\u589e\u5546\u54c1\u7edf\u8ba1:{}", (Object)JSON.toJSONString((Object)marketActivityGoodsSecKillStatisticalPO));
                MarketActivityGoodsSecKillAddDTO marketActivityGoodsSecKillAddDTO = new MarketActivityGoodsSecKillAddDTO();
                marketActivityGoodsSecKillAddDTO.setMarketActivityGoodsSecKillPO(marketActivityGoodsSecKillPO);
                marketActivityGoodsSecKillAddDTO.setSkuList(skuList);
                marketActivityGoodsSecKillAddDTO.setMarketActivityPO(marketActivityPO);
                marketActivityGoodsSecKillAddDTO.setMarketActivitySecKillGoodsVO(marketActivitySecKillGoodsVO);
                List marketActivityGoodsPOList = this.marketActivityGoodsBuilderService.marketActivityGoodsPOBuilder(marketActivityGoodsSecKillAddDTO, brandUserDTO);
                List marketActivityGoodsPOIds = marketActivityGoodsPOList.stream().map(MarketActivityGoodsPO::getId).collect(Collectors.toList());
                log.info("\u79d2\u6740\u6d3b\u52a8\u65b0\u589e\u5546\u54c1skuIds:{}", (Object)JSON.toJSONString(marketActivityGoodsPOIds));
                marketActivityGoodsSecKillPOList.add(marketActivityGoodsSecKillPO);
            }
        }
        return marketActivityGoodsSecKillPOList;
    }

    public Integer modifyMarketActivityGoodsSecKillPO(MarketActivitySecKillGoodsModifyVO requestVO) {
        Integer marketActivityGoodsSeckillId = requestVO.getMarketActivityGoodsSeckillId();
        MarketActivityGoodsSecKillPO marketActivityGoodsSecKillPO = new MarketActivityGoodsSecKillPO();
        marketActivityGoodsSecKillPO.setMarketActivityGoodsSeckillId(marketActivityGoodsSeckillId);
        marketActivityGoodsSecKillPO.setMarketActivityGoodsMainName(requestVO.getMarketActivitySecKillGoodsName());
        marketActivityGoodsSecKillPO.setMarketActivityGoodsMainTitle(requestVO.getMarketActivitySecKillGoodsTitle());
        marketActivityGoodsSecKillPO.setMarketActivityGoodsMainImg(requestVO.getMarketActivitySecKillGoodsImage());
        marketActivityGoodsSecKillPO.setSort(requestVO.getSort());
        marketActivityGoodsSecKillPO.setGmtModified(new Date());
        int i = this.marketActivityGoodsSecKillPOMapper.updateByPrimaryKeySelective(marketActivityGoodsSecKillPO);
        return i;
    }

    public ResponseData<MarketActivitySecKillGoodsResponseVO> findMarketActivitySecKillGoodsOne(Integer marketActivityGoodsSecKillId, Integer merchantId) {
        MarketActivitySecKillGoodsResponseVO marketActivitySecKillGoodsResponseVO = new MarketActivitySecKillGoodsResponseVO();
        MarketActivityGoodsSecKillPO marketActivityGoodsSecKillPO = this.marketActivityGoodsSecKillPOMapper.selectByPrimaryKey(marketActivityGoodsSecKillId);
        if (marketActivityGoodsSecKillPO == null) {
            return ResponseUtil.getFailedMsg((String)"\u6b64\u6d3b\u52a8\u5546\u54c1\u4e0d\u5b58\u5728!");
        }
        Integer marketActivityMerchantId = marketActivityGoodsSecKillPO.getMerchantId();
        if (!merchantId.equals(marketActivityMerchantId)) {
            return ResponseUtil.getFailedMsg((String)"\u65e0\u6cd5\u67e5\u8be2\u975e\u672c\u5546\u6237\u8425\u9500\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f");
        }
        Integer goodsId = marketActivityGoodsSecKillPO.getGoodsId();
        GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(goodsId);
        MarketActivityGoodsPOExample marketActivityGoodsPOExample = new MarketActivityGoodsPOExample();
        marketActivityGoodsPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andMarketActivityGoodsSeckillIdEqualTo(marketActivityGoodsSecKillId).andValidEqualTo(Boolean.TRUE);
        List marketActivityGoodsPOList = this.marketActivityGoodsPOMapper.selectByExample(marketActivityGoodsPOExample);
        ArrayList<MarketActivitySecKillGoodsSkuResponseVO> marketActivitySecKillGoodsSkuResponseVOList = new ArrayList<MarketActivitySecKillGoodsSkuResponseVO>();
        if (!CollectionUtils.isEmpty((Collection)marketActivityGoodsPOList)) {
            for (MarketActivityGoodsPO marketActivityGoodsPO : marketActivityGoodsPOList) {
                MarketActivitySecKillGoodsSkuResponseVO marketActivitySecKillGoodsSkuResponseVO = new MarketActivitySecKillGoodsSkuResponseVO();
                Integer goodsSkuDetailId = marketActivityGoodsPO.getGoodsSkuDetailId();
                GoodsSkuDetailPO goodsSkuDetailPO = this.goodsSkuDetailPOMapper.selectByPrimaryKey(goodsSkuDetailId);
                marketActivitySecKillGoodsSkuResponseVO.setMarketActivityGoodsPO(marketActivityGoodsPO);
                marketActivitySecKillGoodsSkuResponseVO.setGoodsSkuDetailPO(goodsSkuDetailPO);
                marketActivitySecKillGoodsSkuResponseVOList.add(marketActivitySecKillGoodsSkuResponseVO);
            }
        }
        marketActivitySecKillGoodsResponseVO.setMarketActivityGoodsSecKillPO(marketActivityGoodsSecKillPO);
        marketActivitySecKillGoodsResponseVO.setMarketActivitySecKillGoodsSkuResponseVOList(marketActivitySecKillGoodsSkuResponseVOList);
        return ResponseUtil.getSuccessData((Object)marketActivitySecKillGoodsResponseVO);
    }
}

