/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.mapper.ConfigMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyMapper;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class ConfigServiceImpl
implements ConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfigServiceImpl.class);
    @Resource
    private ConfigMapper configMapper;
    @Resource
    private GoodsClassifyMapper goodsClassifyMapper;

    public Config add(Config config) {
        GoodsClassify classify;
        try {
            this.verify(config);
        }
        catch (Exception e) {
            log.error("config\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new CustomException(e.getMessage());
        }
        config.setGmtCreate(new Date());
        this.configMapper.insertSelective((Object)config);
        Example example = new Example(GoodsClassify.class);
        if (Boolean.TRUE.equals(config.getBargain())) {
            example.createCriteria().andEqualTo("merchantId", (Object)config.getMerchantId()).andEqualTo("coding", (Object)"bargain");
            classify = (GoodsClassify)this.goodsClassifyMapper.selectOneByExample((Object)example);
            if (classify != null) {
                classify.setPic(config.getBargainHeadUrl());
                this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)classify);
            }
        }
        if (Boolean.TRUE.equals(config.getAssemble())) {
            example.createCriteria().andEqualTo("merchantId", (Object)config.getMerchantId()).andEqualTo("coding", (Object)"assemble");
            classify = (GoodsClassify)this.goodsClassifyMapper.selectOneByExample((Object)example);
            if (classify != null) {
                classify.setPic(config.getAssembleHeadUrl());
                this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)classify);
            }
        }
        return config;
    }

    public int update(Config config) {
        GoodsClassify goodsClassify;
        List goodsClassifies;
        log.info("\u66f4\u65b0\u57fa\u7840\u914d\u7f6e:{}", (Object)JSONObject.toJSONString((Object)config));
        this.verify(config);
        config.setGmtModified(new Date());
        int i = this.configMapper.updateByPrimaryKeySelective((Object)config);
        Example example = new Example(GoodsClassify.class);
        if (Boolean.TRUE.equals(config.getAssemble())) {
            example.createCriteria().andEqualTo("merchantId", (Object)config.getMerchantId()).andEqualTo("coding", (Object)"assemble");
            goodsClassifies = this.goodsClassifyMapper.selectByExample((Object)example);
            if (!CollectionUtils.isEmpty((Collection)goodsClassifies) && goodsClassifies.stream().filter(e -> !e.getPid().equals(0)).findAny().isPresent()) {
                goodsClassify = goodsClassifies.stream().filter(e -> !e.getPid().equals(0)).findAny().get();
                goodsClassify.setPic(config.getAssembleHeadUrl());
                this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)goodsClassify);
            }
        }
        if (Boolean.TRUE.equals(config.getBargain())) {
            example.createCriteria().andEqualTo("merchantId", (Object)config.getMerchantId()).andEqualTo("coding", (Object)"bargain");
            goodsClassifies = this.goodsClassifyMapper.selectByExample((Object)example);
            if (!CollectionUtils.isEmpty((Collection)goodsClassifies) && goodsClassifies.stream().filter(e -> !e.getPid().equals(0)).findAny().isPresent()) {
                goodsClassify = goodsClassifies.stream().filter(e -> !e.getPid().equals(0)).findAny().get();
                goodsClassify.setPic(config.getAssembleHeadUrl());
                this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)goodsClassify);
            }
        }
        return i;
    }

    private void verify(Config config) {
        InputValidator.checkNumber((Integer)1, (Integer)30, (Integer)config.getAwaitOrderConfirm(), (String)"\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u65f6\u95f4");
        InputValidator.checkNumber((Integer)1, (Integer)30, (Integer)config.getAwaitOrderEvaluation(), (String)"\u81ea\u52a8\u597d\u8bc4\u65f6\u95f4");
        InputValidator.checkNaturalNumber((Integer)config.getAwaitOrderPayMinute(), (String)"\u5f85\u652f\u4ed8\u8ba2\u5355\u5173\u95ed\u65f6\u95f4");
        InputValidator.checkNumber((Integer)1, (Integer)30, (Integer)config.getAwaitOrderReturn(), (String)"\u81ea\u52a8\u5173\u95ed\u9000\u6b3e/\u9000\u8d27\u65f6\u95f4");
        if (config.getIsDistribution().booleanValue()) {
            InputValidator.checkNaturalNumber((Integer)config.getCommission(), (String)"\u9ed8\u8ba4\u8fd4\u4f63");
        }
        if (config.getIsFreeShipping().booleanValue()) {
            InputValidator.checkNaturalNumber((BigDecimal)config.getFreePrice(), (String)"\u5305\u90ae\u91d1\u989d");
        }
    }
}

