/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccountLogs;
import com.wmeimob.fastboot.bizvane.service.UserCommissionAccountLogsService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.excel.ExcelHelper;
import com.wmeimob.fastboot.util.web.IpAddressHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"commissionLog"})
public class UserCommissionAccountLogsController {
    private static final Logger log = LoggerFactory.getLogger(UserCommissionAccountLogsController.class);
    @Autowired
    private UserCommissionAccountLogsService userCommissionAccountLogsService;

    @GetMapping(value={"commission"})
    @Page
    public PageInfo commissionList(@RequestHeader(value="merchantId") Integer merchantId, UserCommissionAccountLogs userCommissionAccountLogs) {
        userCommissionAccountLogs.setMerchantId(merchantId);
        List list = this.userCommissionAccountLogsService.findByCondition((Serializable)userCommissionAccountLogs);
        return new PageInfo(list);
    }

    @GetMapping(value={"withdrawal"})
    @Page
    public PageInfo withdrawalList(@RequestHeader(value="merchantId") Integer merchantId, UserCommissionAccountLogs userCommissionAccountLogs) {
        userCommissionAccountLogs.setMerchantId(merchantId);
        List list = this.userCommissionAccountLogsService.withdrawalList(userCommissionAccountLogs);
        return new PageInfo(list);
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id, @RequestBody UserCommissionAccountLogs userCommissionAccountLogs, HttpServletRequest request) {
        String ip = IpAddressHelper.getRemoteHost((HttpServletRequest)request);
        userCommissionAccountLogs.setIp(ip);
        userCommissionAccountLogs.setId(id);
        userCommissionAccountLogs.setMerchantId(merchantId);
        return this.userCommissionAccountLogsService.update((Serializable)userCommissionAccountLogs) < 1 ? RestResult.fail() : RestResult.success();
    }

    @GetMapping(value={"commissionExport"})
    public void getCommissionExport(@RequestHeader(value="merchantId") Integer merchantId, UserCommissionAccountLogs userCommissionAccountLogs, HttpServletResponse res) {
        userCommissionAccountLogs.setMerchantId(merchantId);
        List list = this.userCommissionAccountLogsService.withdrawalList(userCommissionAccountLogs);
        String[] heads = new String[]{"\u8ba2\u5355\u7f16\u53f7", "\u8d2d\u4e70\u4eba", "\u8ba2\u5355\u91d1\u989d", "\u4f63\u91d1\u91d1\u989d", "\u4e0b\u5355\u65f6\u95f4"};
        String[] fields = new String[]{"orderNo", "nickname", "orderAmount", "changeAmount", "gmtCreate"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, UserCommissionAccountLogs.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u4f63\u91d1\u660e\u7ec6\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

