/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot;

import com.wmeimob.fastboot.autoconfigure.security.RestSecurity;
import javax.annotation.Resource;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.http.client.support.BasicAuthorizationInterceptor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.client.RestTemplate;
import tk.mybatis.spring.annotation.MapperScan;

@SpringBootApplication(scanBasePackages={"com.wmeimob"})
@EnableDiscoveryClient
@EnableFeignClients(basePackages={"com.bizvane.messagefacade.interfaces"})
@EnableAspectJAutoProxy(exposeProxy=true)
@EnableAsync
@MapperScan(value={"com.wmeimob.fastboot.bizvane.newmapper", "com.wmeimob.fastboot.bizvane.mapper", "com.wmeimob.fastboot.starter.common.mapper", "com.wmeimob.fastboot.starter.wechat.mapper", "com.wmeimob.fastboot.open.mapper"})
public class MallAdminApplication {
    @Resource
    private RestSecurity restSecurity;

    public static void main(String[] args) {
        SpringApplication.run(MallAdminApplication.class, (String[])args);
    }

    @Bean
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        if (this.restSecurity != null && this.restSecurity.getGlobal() != null) {
            restTemplate.getInterceptors().add(new BasicAuthorizationInterceptor(this.restSecurity.getGlobal().getUsername(), this.restSecurity.getGlobal().getPassword()));
            return restTemplate;
        }
        return restTemplate;
    }
}

