/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.api;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.api.vo.ApiGetOrdersRequestVO;
import com.wmeimob.fastboot.bizvane.api.vo.ApiOrderRefundRequestVO;
import com.wmeimob.fastboot.bizvane.api.vo.ApiOrderUpSendGoodsRequestVO;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.wmeimob.fastboot.bizvane.service.api.ApiOrdersService;
import com.wmeimob.fastboot.bizvane.service.impl.CommonConfigServiceImpl;
import com.wmeimob.fastboot.bizvane.service.impl.CommonOrdersServiceImpl;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class ApiOrdersServiceImpl
implements ApiOrdersService {
    private static final Logger log = LoggerFactory.getLogger(ApiOrdersServiceImpl.class);
    @Autowired
    private OrdersServiceImpl ordersServiceImpl;
    @Resource
    private RefundOrderMapper refundOrderMapper;
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private CommonConfigServiceImpl configService;
    @Resource(name="commonOrdersServiceImpl")
    private CommonOrdersServiceImpl commonOrdersService;
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    public PageInfo<Orders> getUnSendOrders(ApiGetOrdersRequestVO requestVO) {
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        Orders condition = new Orders();
        condition.setMerchantId(Integer.valueOf(requestVO.getMerchantId()));
        condition.setQueryStatus(Integer.valueOf(2));
        condition.setBeginDate(requestVO.getStartTime());
        condition.setEndDate(requestVO.getEndTime());
        List<Orders> list = this.ordersServiceImpl.findByConditionNew(condition);
        if (!CollectionUtils.isEmpty(list)) {
            list.stream().forEach(e -> e.getItems().forEach(f -> {
                f.setSkuCode(f.getGoodsSkuNo());
                f.setCode(f.getGoodsNo());
            }));
        }
        PageInfo goodsPageInfo = new PageInfo(list);
        return goodsPageInfo;
    }

    public PageInfo<RefundOrder> getRefundOrders(ApiGetOrdersRequestVO requestVO) {
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        RefundOrder refundOrder = new RefundOrder();
        refundOrder.setMerchantId(Integer.valueOf(requestVO.getMerchantId()));
        refundOrder.setBeginDate(requestVO.getStartTime());
        refundOrder.setEndDate(requestVO.getEndTime());
        List list = this.refundOrderMapper.selectRefundOrderListOffLineExport(refundOrder);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.stream().forEach(e -> e.getItems().forEach(f -> {
                f.setCode(f.getGoodsNo());
                f.setSkuCode(f.getGoodsSkuNo());
            }));
        }
        PageInfo goodsPageInfo = new PageInfo(list);
        return goodsPageInfo;
    }

    public ResponseData setUpSendGoods(ApiOrderUpSendGoodsRequestVO requestVO) {
        String orderNo = requestVO.getOrderNo();
        String shippingNo = requestVO.getShippingNo();
        String shippingVendor = requestVO.getShippingVendor();
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("orderNo", (Object)orderNo);
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)example);
        if (orders == null) {
            return ResponseUtil.getFailedMsg((String)"\u6b64\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728!");
        }
        if (orders.getLogisticsStatus() != null && orders.getLogisticsStatus().equals((Object)LogisticsStatusEnum.UN_SEND)) {
            orders.setShippingNo(shippingNo);
            orders.setShippingVendor(shippingVendor);
            orders.setGmtModified(new Date());
            orders.setShippingAt(new Date());
            orders.setLogisticsStatus(LogisticsStatusEnum.SEND);
            int result = this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
            if (result > 0) {
                Config sysConfig = this.configService.findSysConfig(orders.getMerchantId());
                orders.setUserId(orders.getUserId());
                orders.setId(orders.getId());
                this.scheduledThreadPoolExecutor.schedule(() -> this.commonOrdersService.confirm(orders), (long)sysConfig.getAwaitOrderConfirm().intValue(), TimeUnit.DAYS);
            }
            return ResponseUtil.getSuccessData(null, (String)"\u8ba2\u5355\u53d1\u8d27\u66f4\u65b0\u6210\u529f");
        }
        return ResponseUtil.getFailedMsg((String)"\u6b64\u5355\u4e0d\u662f\u5f85\u53d1\u8d27\u8ba2\u5355!");
    }

    public ResponseData setRefund(ApiOrderRefundRequestVO requestVO) {
        String refundNo = requestVO.getRefundNo();
        Example example = new Example(RefundOrder.class);
        example.createCriteria().andEqualTo("refundNo", (Object)refundNo);
        RefundOrder refundOrder = (RefundOrder)this.refundOrderMapper.selectOneByExample((Object)example);
        if (refundOrder == null) {
            return ResponseUtil.getFailedMsg((String)("\u9000\u5355" + refundNo + "\u4e0d\u5b58\u5728"));
        }
        refundOrder.setUnderStatus(Boolean.TRUE);
        refundOrder.setGmtModified(new Date());
        int i = this.refundOrderMapper.updateByPrimaryKeySelective((Object)refundOrder);
        if (i > 0) {
            log.info("\u66f4\u65b0\u9000\u5355\u72b6\u6001\u6210\u529f!");
        }
        return ResponseUtil.getSuccessData(null, (String)"\u66f4\u65b0\u9000\u5355\u72b6\u6001\u6210\u529f");
    }
}

