/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.admin.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.constants.admin.GoodsConstant;
import com.wmeimob.fastboot.bizvane.constants.admin.ImportConstant;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassifyCustom;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpec;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpecRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsTag;
import com.wmeimob.fastboot.bizvane.entity.GoodsTagCustom;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.enums.admin.ExportTempleHelp;
import com.wmeimob.fastboot.bizvane.enums.admin.GoodsExportTempleEnum;
import com.wmeimob.fastboot.bizvane.enums.admin.SkusExportTempleEnum;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsTagCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsTagMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ExcelImportPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.po.ExcelImportPOExample;
import com.wmeimob.fastboot.bizvane.po.ExcelImportPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPO;
import com.wmeimob.fastboot.bizvane.service.admin.ImportService;
import com.wmeimob.fastboot.bizvane.service.qdqm.GoodsSyncChildService;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.admin.ErrorExportMessageVO;
import com.wmeimob.fastboot.bizvane.vo.admin.ExportResponseVO;
import com.wmeimob.fastboot.bizvane.vo.admin.GoodsExportCheck;
import com.wmeimob.fastboot.bizvane.vo.admin.GoodsExportTempleVO;
import com.wmeimob.fastboot.bizvane.vo.admin.ImportSearchVO;
import com.wmeimob.fastboot.bizvane.vo.admin.ImportVO;
import com.wmeimob.fastboot.bizvane.vo.admin.SkusExportCheck;
import com.wmeimob.fastboot.bizvane.vo.admin.SkusExportTempleVO;
import com.wmeimob.fastboot.config.MallAdminException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class ImportServiceImpl
implements ImportService {
    private static final Logger log = LoggerFactory.getLogger(ImportServiceImpl.class);
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private GoodsClassifyMapper goodsClassifyMapper;
    @Resource
    private GoodsTagMapper goodsTagMapper;
    @Resource
    private GoodsTagCustomMapper goodsTagCustomMapper;
    @Resource
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Resource
    private GoodsSpecMapper goodsSpecMapper;
    @Resource
    private GoodsSpecRelationMapper goodsSpecRelationMapper;
    @Resource
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Resource
    private ExcelImportPOMapper excelImportPOMapper;
    @Resource
    private GoodsClassifyCustomMapper goodsClassifyCustomMapper;
    @Resource
    private LoginUtil loginUtil;
    @Autowired
    private GoodsSyncChildService goodsSyncChildService;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Resource
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseData goodsImport(Integer merchantId, ImportVO importVO, HttpServletRequest request) throws Exception {
        String accountCode = this.loginUtil.getLoginUser(request).getAccountCode();
        log.info("\u5f53\u524d\u7528\u6237:{}", (Object)accountCode);
        ExportResponseVO exportResponseVO = new ExportResponseVO();
        String qiNiuUrl = importVO.getQiNiuUrl();
        if (StringUtils.isEmpty((Object)qiNiuUrl)) {
            return ResponseUtil.getFailedMsg((String)"\u8bf7\u8f93\u5165\u6b63\u786eurl");
        }
        String fileUrl = qiNiuUrl.replace("https", "http").replace("http", "https");
        ExcelImportPOExample excelImportPOExample = new ExcelImportPOExample();
        excelImportPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andStatusEqualTo(ImportConstant.EXCEL_IMPORT_STATUS_EXECUTION).andImportTypeEqualTo("goodsImport").andAccountcodeEqualTo(accountCode);
        List excelImportPOS = this.excelImportPOMapper.selectByExample(excelImportPOExample);
        if (!CollectionUtils.isEmpty((Collection)excelImportPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u6237\u5f53\u524d\u3010\u5546\u54c1\u6b3e\u53f7\u3011\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        URL url = new URL(fileUrl);
        InputStream is = url.openConnection().getInputStream();
        if (is == null) {
            return ResponseUtil.getFailedMsg((String)"\u65e0\u5185\u5bb9,\u5bfc\u5165\u5904\u7406\u5931\u8d25!");
        }
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)is);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
            ResponseData responseData = ResponseUtil.getFailedMsg((String)"\u89e3\u6790\u6587\u4ef6\u5931\u8d25,\u8bf7\u786e\u5b9a\u4e0a\u4f20\u4e86\u6b63\u786e\u6587\u4ef6!");
            return responseData;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        Sheet firstSheet = wb.getSheetAt(0);
        int lastRowNum = firstSheet.getLastRowNum();
        log.info("\u6700\u540e\u4e00\u884c\u884c\u53f7:{}", (Object)lastRowNum);
        if (lastRowNum > 50001) {
            return ResponseUtil.getFailedMsg((String)"\u6587\u6863\u5185\u5bb9\u8d85\u8fc750000\u6761,\u8bf7\u624b\u52a8\u62c6\u5206\u6587\u6863\u540e\u518d\u4e0a\u4f20");
        }
        Integer brandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(merchantId);
        ExportTempleHelp exportTempleHelp = GoodsExportTempleEnum.getExportTempleHelp();
        List notesList = exportTempleHelp.getNotesList();
        List fieldsList = exportTempleHelp.getFieldsList();
        Row firstSheetRow = firstSheet.getRow(0);
        for (int i = 0; i < notesList.size(); ++i) {
            String header = firstSheetRow.getCell(i).getStringCellValue();
            if (StringUtils.isEmpty((Object)header)) {
                return ResponseUtil.getFailedMsg((String)"\u8868\u5934\u6709\u7a7a\u5217,\u8bf7\u91cd\u65b0\u67e5\u770b\u6587\u4ef6\u540e\u4e0a\u4f20");
            }
            if (header.trim().equalsIgnoreCase((String)notesList.get(i))) continue;
            return ResponseUtil.getFailedMsg((String)"\u8868\u5934\u4fe1\u606f\u6709\u8bef,\u8bf7\u4f7f\u7528\u6b63\u786e\u6a21\u677f\u6587\u4ef6");
        }
        ExcelImportPOWithBLOBs excelImportPOWithBLOBs = new ExcelImportPOWithBLOBs();
        excelImportPOWithBLOBs.setMerchantId(merchantId);
        excelImportPOWithBLOBs.setImportTime(new Date());
        excelImportPOWithBLOBs.setImportUrl(fileUrl);
        excelImportPOWithBLOBs.setImportType("goodsImport");
        excelImportPOWithBLOBs.setStatus(ImportConstant.EXCEL_IMPORT_STATUS_EXECUTION);
        excelImportPOWithBLOBs.setGmtCreate(new Date());
        excelImportPOWithBLOBs.setBeginTime(new Date());
        excelImportPOWithBLOBs.setAccountcode(accountCode);
        this.excelImportPOMapper.insertSelective(excelImportPOWithBLOBs);
        log.info("\u65b0\u589e\u5bfc\u5165\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)excelImportPOWithBLOBs));
        this.scheduledThreadPoolExecutor.execute(() -> {
            log.info("\u5546\u54c1\u5bfc\u5165\u5f00\u59cb\u4efb\u52a1");
            this.goodsImportAsync(merchantId, brandId, importVO, excelImportPOWithBLOBs, lastRowNum, firstSheet);
        });
        exportResponseVO.setTaskId(excelImportPOWithBLOBs.getExcelImportId());
        return ResponseUtil.getSuccessData((Object)exportResponseVO);
    }

    private void goodsImportAsync(Integer merchantId, Integer brandId, ImportVO importVO, ExcelImportPOWithBLOBs excelImportPOWithBLOBs, int lastRowNum, Sheet firstSheet) {
        ArrayList<GoodsExportTempleVO> successGoodsExportTempleVOList = new ArrayList<GoodsExportTempleVO>(50001);
        ArrayList<ErrorExportMessageVO> errorGoodsExportTempleVOList = new ArrayList<ErrorExportMessageVO>(50001);
        HashMap categoryData = new HashMap();
        for (int i = 1; i <= lastRowNum; ++i) {
            Row row = firstSheet.getRow(i);
            if (row == null) continue;
            String goodsNo = this.getValue(row.getCell(0)).trim();
            String goodsName = this.getValue(row.getCell(1)).trim();
            String firstCategory = this.getValue(row.getCell(2)).trim();
            String secondCategory = this.getValue(row.getCell(3)).trim();
            String goodsTag = this.getValue(row.getCell(4)).trim();
            String specType = this.getValue(row.getCell(5)).trim();
            String salePrice = this.getValue(row.getCell(6)).trim();
            String tagPrice = this.getValue(row.getCell(7)).trim();
            String isGift = this.getValue(row.getCell(8)).trim();
            String shoppingMode = this.getValue(row.getCell(9)).trim();
            String commissionRate = this.getValue(row.getCell(10)).trim();
            String priceType = this.getValue(row.getCell(11)).trim();
            String sort = this.getValue(row.getCell(12)).trim();
            String limitation = this.getValue(row.getCell(13)).trim();
            String isShelved = null;
            if (this.rowIsNull(goodsNo, goodsName, firstCategory, secondCategory, goodsTag, specType, salePrice, tagPrice, isGift, shoppingMode, commissionRate, priceType, sort, limitation, isShelved)) {
                log.info("poi\u8bc6\u522b\u5230\u6570\u636e\u4e3a\u7a7a,\u884c\u53f7:{}", (Object)i);
                continue;
            }
            GoodsExportTempleVO exportTempleVO = new GoodsExportTempleVO();
            exportTempleVO.setIndex(Integer.valueOf(i));
            exportTempleVO.setGoodsNo(goodsNo);
            exportTempleVO.setGoodsName(goodsName);
            exportTempleVO.setFirstCategory(firstCategory);
            exportTempleVO.setSecondCategory(secondCategory);
            exportTempleVO.setGoodsTag(goodsTag);
            exportTempleVO.setSpecType(specType);
            exportTempleVO.setSalePrice(salePrice);
            exportTempleVO.setTagPrice(tagPrice);
            exportTempleVO.setIsGift(isGift);
            exportTempleVO.setShoppingMode(shoppingMode);
            exportTempleVO.setCommissionRate(commissionRate);
            exportTempleVO.setPriceType(priceType);
            exportTempleVO.setSort(sort);
            exportTempleVO.setLimitation(limitation);
            exportTempleVO.setIsShelved(isShelved);
            boolean b = GoodsExportCheck.checkParam((GoodsExportTempleVO)exportTempleVO);
            log.info("checkParam\u5f53\u524d\u884c:{},\u6570\u636e:{}", (Object)exportTempleVO.getIndex(), (Object)JSON.toJSONString((Object)exportTempleVO));
            if (b) {
                ArrayList<GoodsExportTempleVO> secondCategoryDataList;
                HashMap<String, ArrayList<GoodsExportTempleVO>> secondCategoryMap = (HashMap<String, ArrayList<GoodsExportTempleVO>>)categoryData.get(firstCategory);
                if (CollectionUtils.isEmpty((Map)secondCategoryMap)) {
                    secondCategoryMap = new HashMap<String, ArrayList<GoodsExportTempleVO>>();
                }
                if (CollectionUtils.isEmpty((Collection)(secondCategoryDataList = (ArrayList<GoodsExportTempleVO>)secondCategoryMap.get(secondCategory)))) {
                    secondCategoryDataList = new ArrayList<GoodsExportTempleVO>();
                }
                secondCategoryDataList.add(exportTempleVO);
                secondCategoryMap.put(secondCategory, secondCategoryDataList);
                categoryData.put(firstCategory, secondCategoryMap);
                successGoodsExportTempleVOList.add(exportTempleVO);
                continue;
            }
            ErrorExportMessageVO errorExportMessageVO = new ErrorExportMessageVO();
            errorExportMessageVO.setIndex(exportTempleVO.getIndex());
            errorExportMessageVO.setGoodsNo(exportTempleVO.getGoodsNo());
            errorExportMessageVO.setErrorMsg(exportTempleVO.getErrorMsg());
            errorGoodsExportTempleVOList.add(errorExportMessageVO);
        }
        ExcelImportPOWithBLOBs param = new ExcelImportPOWithBLOBs();
        param.setFirstErrorInfo(JSON.toJSONString(errorGoodsExportTempleVOList));
        param.setGmtModified(new Date());
        param.setExcelImportId(excelImportPOWithBLOBs.getExcelImportId());
        this.excelImportPOMapper.updateByPrimaryKeySelective(param);
        log.info("\u66f4\u65b0\u4efb\u52a1:{}", (Object)JSON.toJSONString((Object)param));
        this.scheduledThreadPoolExecutor.execute(() -> {
            log.info("\u5546\u54c1\u5bfc\u5165\u4f7f\u7528\u5f00\u542f\u7ebf\u7a0b");
            this.disposeGoodsImport(merchantId, brandId, categoryData, excelImportPOWithBLOBs.getExcelImportId());
        });
    }

    private String getValue(Cell cell) {
        String value = "";
        if (cell == null) {
            return value;
        }
        int cellType = cell.getCellType();
        switch (cellType) {
            case 0: {
                value = cell.getNumericCellValue() + "";
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseData skusImport(Integer merchantId, ImportVO importVO, HttpServletRequest request) throws Exception {
        String accountCode = this.loginUtil.getLoginUser(request).getAccountCode();
        log.info("\u5f53\u524d\u7528\u6237:{}", (Object)accountCode);
        ExportResponseVO exportResponseVO = new ExportResponseVO();
        String qiNiuUrl = importVO.getQiNiuUrl();
        if (StringUtils.isEmpty((Object)qiNiuUrl)) {
            return ResponseUtil.getFailedMsg((String)"\u8bf7\u8f93\u5165\u6b63\u786eurl");
        }
        ExcelImportPOExample excelImportPOExample = new ExcelImportPOExample();
        excelImportPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andStatusEqualTo(ImportConstant.EXCEL_IMPORT_STATUS_EXECUTION).andImportTypeEqualTo("skusImport").andAccountcodeEqualTo(accountCode);
        List excelImportPOS = this.excelImportPOMapper.selectByExample(excelImportPOExample);
        if (!CollectionUtils.isEmpty((Collection)excelImportPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u6237\u5f53\u524d\u3010\u5546\u54c1SKU\u3011\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        String fileUrl = qiNiuUrl.replace("https", "http").replace("http", "https");
        URL url = new URL(fileUrl);
        InputStream is = url.openConnection().getInputStream();
        if (is == null) {
            return ResponseUtil.getFailedMsg((String)"\u65e0\u5185\u5bb9,\u5bfc\u5165\u5904\u7406\u5931\u8d25!");
        }
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)is);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
            ResponseData responseData = ResponseUtil.getFailedMsg((String)"\u89e3\u6790\u6587\u4ef6\u5931\u8d25,\u8bf7\u786e\u5b9a\u4e0a\u4f20\u4e86\u6b63\u786e\u6587\u4ef6!");
            return responseData;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        Sheet firstSheet = wb.getSheetAt(0);
        int lastRowNum = firstSheet.getLastRowNum();
        log.info("\u6700\u540e\u4e00\u884c\u884c\u53f7:{}", (Object)lastRowNum);
        if (lastRowNum > 50001) {
            return ResponseUtil.getFailedMsg((String)"\u6587\u6863\u5185\u5bb9\u8d85\u8fc750000\u6761,\u8bf7\u624b\u52a8\u62c6\u5206\u6587\u6863\u540e\u518d\u4e0a\u4f20");
        }
        ExportTempleHelp exportTempleHelp = SkusExportTempleEnum.getExportTempleHelp();
        List notesList = exportTempleHelp.getNotesList();
        List fieldsList = exportTempleHelp.getFieldsList();
        Row firstSheetRow = firstSheet.getRow(0);
        for (int i = 0; i < notesList.size(); ++i) {
            String header = firstSheetRow.getCell(i).getStringCellValue();
            if (StringUtils.isEmpty((Object)header)) {
                return ResponseUtil.getFailedMsg((String)"\u8868\u5934\u6709\u7a7a\u5217,\u8bf7\u91cd\u65b0\u67e5\u770b\u6587\u4ef6\u540e\u4e0a\u4f20");
            }
            if (header.trim().equalsIgnoreCase((String)notesList.get(i))) continue;
            return ResponseUtil.getFailedMsg((String)"\u8868\u5934\u4fe1\u606f\u6709\u8bef,\u8bf7\u4f7f\u7528\u6b63\u786e\u6a21\u677f\u6587\u4ef6");
        }
        ExcelImportPOWithBLOBs excelImportPOWithBLOBs = new ExcelImportPOWithBLOBs();
        excelImportPOWithBLOBs.setMerchantId(merchantId);
        excelImportPOWithBLOBs.setImportTime(new Date());
        excelImportPOWithBLOBs.setImportUrl(qiNiuUrl);
        excelImportPOWithBLOBs.setImportType("skusImport");
        excelImportPOWithBLOBs.setStatus(ImportConstant.EXCEL_IMPORT_STATUS_EXECUTION);
        excelImportPOWithBLOBs.setGmtCreate(new Date());
        excelImportPOWithBLOBs.setBeginTime(new Date());
        excelImportPOWithBLOBs.setAccountcode(accountCode);
        this.excelImportPOMapper.insertSelective(excelImportPOWithBLOBs);
        exportResponseVO.setTaskId(excelImportPOWithBLOBs.getExcelImportId());
        this.scheduledThreadPoolExecutor.execute(() -> {
            log.info("\u5546\u54c1sku\u5bfc\u5165\u5f00\u59cb\u4efb\u52a1");
            this.skusImportAsync(merchantId, importVO, excelImportPOWithBLOBs, lastRowNum, firstSheet);
        });
        return ResponseUtil.getSuccessData((Object)exportResponseVO);
    }

    @Override
    public ResponseData queryTaskInfo(HttpServletRequest request, ImportSearchVO importSearchVO) {
        String type = importSearchVO.getType();
        String accountCode = this.loginUtil.getLoginUser(request).getAccountCode();
        ExcelImportPOExample example = new ExcelImportPOExample();
        example.createCriteria().andImportTypeEqualTo(type).andStatusNotEqualTo(ImportConstant.EXCEL_IMPORT_STATUS_COMPLETED).andAccountcodeEqualTo(accountCode);
        List excelImportPOS = this.excelImportPOMapper.selectByExample(example);
        if (!CollectionUtils.isEmpty((Collection)excelImportPOS)) {
            return ResponseUtil.getFailedData(excelImportPOS.get(0), (String)"\u4efb\u52a1\u6267\u884c\u4e2d");
        }
        return ResponseUtil.getSuccessData((Object)"\u4efb\u52a1\u5df2\u6267\u884c\u5b8c\u6210");
    }

    private void skusImportAsync(Integer merchantId, ImportVO importVO, ExcelImportPOWithBLOBs excelImportPOWithBLOBs, int lastRowNum, Sheet firstSheet) {
        ArrayList<SkusExportTempleVO> successSkusExportTempleVOList = new ArrayList<SkusExportTempleVO>(50001);
        ArrayList<ErrorExportMessageVO> errorSkusExportTempleVOList = new ArrayList<ErrorExportMessageVO>(50001);
        for (int i = 1; i <= lastRowNum; ++i) {
            Row row = firstSheet.getRow(i);
            if (row == null) continue;
            String goodsNo = this.getValue(row.getCell(0)).trim();
            String skuNo = this.getValue(row.getCell(1)).trim();
            String skuName = this.getValue(row.getCell(2)).trim();
            String color = this.getValue(row.getCell(3)).trim();
            String size = this.getValue(row.getCell(4)).trim();
            String salePrice = this.getValue(row.getCell(5)).trim();
            String tagPrice = this.getValue(row.getCell(6)).trim();
            String stock = this.getValue(row.getCell(7)).trim();
            String volume = this.getValue(row.getCell(8)).trim();
            String weight = this.getValue(row.getCell(9)).trim();
            if (this.rowIsNull(goodsNo, skuNo, skuName, color, size, salePrice, tagPrice, stock, volume, weight)) {
                log.info("poi\u8bc6\u522b\u5230\u6570\u636e\u4e3a\u7a7a,\u884c\u53f7:{}", (Object)i);
                continue;
            }
            SkusExportTempleVO skusExportTempleVO = new SkusExportTempleVO();
            skusExportTempleVO.setIndex(Integer.valueOf(i));
            skusExportTempleVO.setGoodsNo(goodsNo);
            skusExportTempleVO.setSkuNo(skuNo);
            skusExportTempleVO.setSkuName(skuName);
            skusExportTempleVO.setColor(color);
            skusExportTempleVO.setSize(size);
            skusExportTempleVO.setSalePrice(salePrice);
            skusExportTempleVO.setTagPrice(tagPrice);
            skusExportTempleVO.setStock(stock);
            skusExportTempleVO.setVolume(volume);
            skusExportTempleVO.setWeight(weight);
            boolean b = SkusExportCheck.checkParam((SkusExportTempleVO)skusExportTempleVO);
            ErrorExportMessageVO errorExportMessageVO = new ErrorExportMessageVO();
            errorExportMessageVO.setIndex(skusExportTempleVO.getIndex());
            errorExportMessageVO.setErrorMsg(skusExportTempleVO.getErrorMsg());
            log.info("checkParam\u5f53\u524d\u884c:{},\u6570\u636e:{},bool:{}", new Object[]{skusExportTempleVO.getIndex(), JSON.toJSONString((Object)skusExportTempleVO), b});
            try {
                if (b) {
                    successSkusExportTempleVOList.add(skusExportTempleVO);
                    continue;
                }
                errorSkusExportTempleVOList.add(errorExportMessageVO);
                continue;
            }
            catch (Exception e) {
                log.error("error:{}", (Throwable)e);
                errorSkusExportTempleVOList.add(errorExportMessageVO);
            }
        }
        ExcelImportPOWithBLOBs param = new ExcelImportPOWithBLOBs();
        param.setFirstErrorInfo(JSON.toJSONString(errorSkusExportTempleVOList));
        param.setGmtModified(new Date());
        param.setExcelImportId(excelImportPOWithBLOBs.getExcelImportId());
        this.excelImportPOMapper.updateByPrimaryKeySelective(param);
        log.info("\u66f4\u65b0\u4efb\u52a1:{}", (Object)JSON.toJSONString((Object)param));
        log.info("\u65b0\u589e\u5bfc\u5165\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)excelImportPOWithBLOBs));
        this.scheduledThreadPoolExecutor.execute(() -> {
            log.info("\u8ba2\u5355\u5bfc\u5165\u4f7f\u7528\u5f00\u542f\u7ebf\u7a0b");
            this.disposeSkusImport(merchantId, successSkusExportTempleVOList, excelImportPOWithBLOBs.getExcelImportId());
        });
    }

    @Transactional
    protected void disposeGoodsImport(Integer merchantId, Integer brandId, HashMap<String, HashMap<String, List<GoodsExportTempleVO>>> categoryData, Integer excelImportId) {
        log.info("ImportServiceImpl_disposeGoodsImport_excelImportId:{}", (Object)excelImportId);
        ArrayList<ErrorExportMessageVO> errorList = new ArrayList<ErrorExportMessageVO>();
        ArrayList<ErrorExportMessageVO> successList = new ArrayList<ErrorExportMessageVO>();
        long startTime = System.currentTimeMillis();
        Set<String> firstCategorys = categoryData.keySet();
        log.info("\u67e5\u8be2\u5f53\u524d\u5546\u6237\u5df2\u6709tag");
        Example goodsTagExample = new Example(GoodsTag.class);
        goodsTagExample.createCriteria().andEqualTo((Object)"merchantId");
        List goodsTagList = this.goodsTagMapper.selectByExample((Object)goodsTagExample);
        log.info("\u65b0\u589e\u5546\u6237\u5df2\u6709tag Map");
        HashMap<String, GoodsTag> goodsTagHashMap = new HashMap<String, GoodsTag>();
        if (!CollectionUtils.isEmpty((Collection)goodsTagList)) {
            for (GoodsTag goodsTag : goodsTagList) {
                goodsTagHashMap.put(goodsTag.getName(), goodsTag);
            }
        }
        log.info("\u6570\u636e\u5e93\u4e2d\u5f53\u524d\u5b58\u5728tag:{}", (Object)JSON.toJSONString(goodsTagHashMap));
        log.info("\u5f00\u59cb\u5904\u7406\u4e00\u7ea7\u5206\u7c7b");
        for (String firstCategory : firstCategorys) {
            GoodsClassify firstGoodsClassify = null;
            log.info("\u4e00\u7ea7\u5206\u7c7b\u540d\u79f0:{}", (Object)firstCategory);
            if (!StringUtils.isEmpty((Object)firstCategory)) {
                Example firstGoodsClassifyExample = new Example(GoodsClassify.class);
                firstGoodsClassifyExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("name", (Object)firstCategory).andEqualTo("pid", (Object)0);
                List firstGoodsClassifiesList = this.goodsClassifyMapper.selectByExample((Object)firstGoodsClassifyExample);
                if (CollectionUtils.isEmpty((Collection)firstGoodsClassifiesList)) {
                    firstGoodsClassify = new GoodsClassify();
                    firstGoodsClassify.setMerchantId(merchantId);
                    firstGoodsClassify.setName(firstCategory);
                    firstGoodsClassify.setGmtCreate(new Date());
                    firstGoodsClassify.setPid(Integer.valueOf(0));
                    this.goodsClassifyMapper.insertSelective((Object)firstGoodsClassify);
                } else {
                    firstGoodsClassify = (GoodsClassify)firstGoodsClassifiesList.get(0);
                    Boolean isDel = firstGoodsClassify.getIsDel();
                    if (isDel.booleanValue()) {
                        log.info("\u4e00\u7ea7\u5206\u7c7b:{}\u88ab\u7981\u7528\uff0c\u5bfc\u5165\u6570\u636e\u5c06\u542f\u7528\u8be5\u5206\u7c7b", (Object)firstCategory);
                        firstGoodsClassify.setIsDel(Boolean.FALSE);
                        firstGoodsClassify.setGmtModified(new Date());
                        this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)firstGoodsClassify);
                    }
                }
                log.info("\u4e00\u7ea7\u5206\u7c7bjson:{}", (Object)JSON.toJSONString((Object)firstGoodsClassify));
            }
            HashMap<String, List<GoodsExportTempleVO>> secondCategoryMap = categoryData.get(firstCategory);
            Set<String> secondCategorys = secondCategoryMap.keySet();
            for (String secondCategory : secondCategorys) {
                log.info("\u5f00\u59cb\u5904\u7406\u4e00\u7ea7\u5206\u7c7b:{}\u4e0b\u4e8c\u7ea7\u5206\u7c7b:{}", (Object)firstCategory, (Object)secondCategory);
                GoodsClassify secondGoodsClassify = null;
                if (!StringUtils.isEmpty((Object)secondCategory)) {
                    Example secondGoodsClassifyExample = new Example(GoodsClassify.class);
                    secondGoodsClassifyExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("name", (Object)secondCategory).andEqualTo("pid", (Object)firstGoodsClassify.getId());
                    List secondGoodsClassifies = this.goodsClassifyMapper.selectByExample((Object)secondGoodsClassifyExample);
                    secondGoodsClassify = new GoodsClassify();
                    if (CollectionUtils.isEmpty((Collection)secondGoodsClassifies)) {
                        secondGoodsClassify.setMerchantId(merchantId);
                        secondGoodsClassify.setName(secondCategory);
                        secondGoodsClassify.setGmtCreate(new Date());
                        secondGoodsClassify.setPid(firstGoodsClassify.getId());
                        this.goodsClassifyMapper.insertSelective((Object)secondGoodsClassify);
                    } else {
                        secondGoodsClassify = (GoodsClassify)secondGoodsClassifies.get(0);
                        Boolean isDel = secondGoodsClassify.getIsDel();
                        if (isDel.booleanValue()) {
                            log.info("\u4e00\u7ea7\u5206\u7c7b:{}\u4e0b\u4e8c\u7ea7\u5206\u7c7b:{}\u88ab\u7981\u7528\uff0c\u5bfc\u5165\u6570\u636e\u5c06\u542f\u7528\u8be5\u5206\u7c7b", (Object)firstCategory, (Object)secondCategory);
                            secondGoodsClassify.setIsDel(Boolean.FALSE);
                            secondGoodsClassify.setGmtModified(new Date());
                            this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)secondGoodsClassify);
                        }
                    }
                    log.info("\u4e8c\u7ea7\u5206\u7c7b:{}", (Object)JSON.toJSONString((Object)secondGoodsClassify));
                }
                List<GoodsExportTempleVO> goodsExportTempleVOList = secondCategoryMap.get(secondCategory);
                log.info("\u5f00\u59cb\u5904\u7406\u6570\u636e");
                for (GoodsExportTempleVO goodsExportTempleVO : goodsExportTempleVOList) {
                    try {
                        this.disposeGoodsInfo(merchantId, brandId, goodsTagHashMap, firstGoodsClassify, secondGoodsClassify, goodsExportTempleVO);
                        ErrorExportMessageVO successExportMessageVO = new ErrorExportMessageVO();
                        successExportMessageVO.setIndex(goodsExportTempleVO.getIndex());
                        successList.add(successExportMessageVO);
                    }
                    catch (Exception e) {
                        ErrorExportMessageVO errorExportMessageVO = new ErrorExportMessageVO();
                        errorExportMessageVO.setIndex(goodsExportTempleVO.getIndex());
                        errorExportMessageVO.setErrorMsg(e.getMessage());
                        errorExportMessageVO.setGoodsNo(goodsExportTempleVO.getGoodsNo());
                        errorList.add(errorExportMessageVO);
                        log.info("error:{}", (Throwable)e);
                    }
                }
                log.info("\u7ed3\u675f\u5904\u7406\u6570\u636e");
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("\u7ed3\u675f\u5904\u7406\u4e00\u7ea7\u5206\u7c7b");
        ExcelImportPOWithBLOBs excelImportPOWithBLOBs = this.excelImportPOMapper.selectByPrimaryKey(excelImportId);
        excelImportPOWithBLOBs.setEndTime(new Date(endTime));
        excelImportPOWithBLOBs.setSuccessInfo(JSON.toJSONString(successList));
        excelImportPOWithBLOBs.setSecondErrorInfo(JSON.toJSONString(errorList));
        excelImportPOWithBLOBs.setStatus(ImportConstant.EXCEL_IMPORT_STATUS_COMPLETED);
        excelImportPOWithBLOBs.setGmtModified(new Date());
        this.excelImportPOMapper.updateByPrimaryKeyWithBLOBs(excelImportPOWithBLOBs);
        log.info("\u66f4\u65b0\u5bfc\u5165\u4efb\u52a1\u5b8c\u6210");
    }

    private void disposeGoodsInfo(Integer merchantId, Integer brandId, HashMap<String, GoodsTag> goodsTagHashMap, GoodsClassify firstGoodsClassify, GoodsClassify secondGoodsClassify, GoodsExportTempleVO goodsExportTempleVO) throws Exception {
        boolean isUniformParam;
        log.info("\u5f00\u59cb\u5904\u7406\u6570\u636e,\u884c\u53f7:{},\u6570\u636e:{}", (Object)goodsExportTempleVO.getIndex(), (Object)JSON.toJSONString((Object)goodsExportTempleVO));
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("goodsNo", (Object)goodsExportTempleVO.getGoodsNo()).andEqualTo("isDel", (Object)Boolean.FALSE);
        GoodsPOExample goodsPOExample = new GoodsPOExample();
        goodsPOExample.createCriteria().andSysBrandIdEqualTo(brandId).andGoodsNoEqualTo(goodsExportTempleVO.getGoodsNo()).andIsDelEqualTo(Boolean.FALSE).andValidEqualTo(Boolean.TRUE);
        List goodsList = this.goodsPOMapper.selectByExample(goodsPOExample);
        GoodsPO goods = new GoodsPO();
        boolean bl = isUniformParam = GoodsConstant.SINGLE_SPECIFICATION == this.parseInteger(goodsExportTempleVO.getSpecType());
        if (CollectionUtils.isEmpty((Collection)goodsList)) {
            goods.setMerchantId(merchantId);
            if (firstGoodsClassify != null) {
                goods.setCategoryFirstId(firstGoodsClassify.getId());
            }
            if (secondGoodsClassify != null) {
                goods.setCategorySecondId(secondGoodsClassify.getId());
            }
            goods.setGoodsNo(goodsExportTempleVO.getGoodsNo());
            goods.setGoodsName(goodsExportTempleVO.getGoodsName());
            goods.setIsGift(this.parseInteger(goodsExportTempleVO.getIsGift()));
            goods.setIsUniform(Boolean.valueOf(isUniformParam));
            goods.setSalePrice(new BigDecimal(goodsExportTempleVO.getSalePrice()));
            goods.setMarketPrice(new BigDecimal(goodsExportTempleVO.getTagPrice()));
            goods.setShippingMode(this.parseInteger(goodsExportTempleVO.getShoppingMode()));
            goods.setCommissionRate(new BigDecimal(goodsExportTempleVO.getCommissionRate()));
            goods.setPriceSystem(this.parseInteger(goodsExportTempleVO.getPriceType()));
            goods.setSort(this.parseInteger(goodsExportTempleVO.getSort()));
            goods.setLimitation(this.parseInteger(goodsExportTempleVO.getLimitation()));
            goods.setIsShelved(Boolean.FALSE);
            goods.setSysBrandId(brandId);
            this.goodsPOMapper.insertSelective(goods);
            log.info("\u65b0\u589e\u5546\u54c1:{}", JSON.toJSON((Object)goods));
            Goods goodsParam = new Goods();
            goodsParam.setId(goods.getId());
            goodsParam.setMerchantId(goods.getMerchantId());
            this.goodsSyncChildService.modifyChildMerchantStatus(goodsParam);
            Boolean isUniform = goods.getIsUniform();
            if (isUniform.booleanValue()) {
                log.info("\u5355\u89c4\u683c\u5546\u54c1\u65b0\u589e\u81ea\u52a8\u521b\u5efasku");
                GoodsSkuDetailPO goodsSkuDetail = new GoodsSkuDetailPO();
                goodsSkuDetail.setGoodsId(goods.getId());
                goodsSkuDetail.setSkuNo(goods.getGoodsNo());
                goodsSkuDetail.setMarketPrice(goods.getMarketPrice());
                goodsSkuDetail.setSalesPrice(goods.getSalePrice());
                goodsSkuDetail.setIsEnabled(Boolean.TRUE);
                goodsSkuDetail.setGmtCreate(new Date());
                goodsSkuDetail.setIsUniform(Boolean.TRUE);
                goodsSkuDetail.setVolume(new BigDecimal("1"));
                goodsSkuDetail.setWeight(new BigDecimal("1"));
                goodsSkuDetail.setMerchantId(merchantId);
                goodsSkuDetail.setSysBrandId(brandId);
                this.goodsSkuDetailPOMapper.insertSelective(goodsSkuDetail);
                log.info("\u5355\u89c4\u683c\u5546\u54c1\u65b0\u589e\u81ea\u52a8\u521b\u5efasku\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)goodsSkuDetail));
                log.info("\u65b0\u589e\u5546\u54c1\u4e0a\u67b6");
                Goods goodsShelved = new Goods();
                goodsShelved.setIsShelved(Boolean.TRUE);
                goodsShelved.setId(goods.getId());
                this.goodsMapper.updateByPrimaryKeySelective((Object)goodsShelved);
                log.info("\u5546\u54c1:{}\u81ea\u52a8\u4e0a\u67b6\u6210\u529f!", (Object)goods.getGoodsNo());
            }
        } else {
            goods = (GoodsPO)goodsList.get(0);
            log.info("\u66f4\u65b0\u5546\u54c1\u524d\u5546\u54c1:{}", JSON.toJSON((Object)goods));
            Boolean isUniform = goods.getIsUniform();
            if (isUniformParam != isUniform) {
                log.info("\u5f53\u524d\u5546\u54c1\u6570\u636e\u5e93\u4e2d\u89c4\u683c\u4e3a:{},\u6587\u4ef6\u89c4\u683c\u4e3a:{},\u76f4\u63a5return", (Object)isUniform, (Object)isUniformParam);
                throw new Exception("\u5f53\u524d\u5546\u54c1\u6570\u636e\u5e93\u4e2d\u89c4\u683c\u4e3a:" + isUniform + ",\u6587\u4ef6\u89c4\u683c\u4e3a:" + isUniformParam + ",\u76f4\u63a5return");
            }
            Example marketActivityGoodsExample = new Example(MarketActivityGoods.class);
            marketActivityGoodsExample.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("merchantId", (Object)merchantId);
            List marketActivityGoodsList = this.marketActivityGoodsMapper.selectByExample((Object)marketActivityGoodsExample);
            if (!CollectionUtils.isEmpty((Collection)marketActivityGoodsList)) {
                throw new MallAdminException("\u8be5\u5546\u54c1\u53c2\u4e0e\u6d3b\u52a8,\u4e0d\u5bfc\u5165\u5546\u54c1\u4fe1\u606f");
            }
            Boolean shelved = this.checkShelved(goodsExportTempleVO, goods);
            if (isUniform.booleanValue()) {
                List goodsSkuDetailList = this.goodsSkuDetailMapper.selectByGoodsId(goods.getId());
                if (CollectionUtils.isEmpty((Collection)goodsSkuDetailList)) {
                    log.warn("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728sku");
                    throw new MallAdminException("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728sku");
                }
                if (goodsSkuDetailList.size() > 1) {
                    log.warn("\u5f53\u524d\u5355\u89c4\u683c\u5546\u54c1sku\u6570\u5927\u4e8e1");
                    throw new MallAdminException("\u5f53\u524d\u5355\u89c4\u683c\u5546\u54c1sku\u6570\u5927\u4e8e1");
                }
                log.info("\u5355\u89c4\u683c\u5546\u54c1\u81ea\u52a8\u66f4\u65b0sku");
                GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
                goodsSkuDetail.setGoodsId(goods.getId());
                goodsSkuDetail.setSkuNo(goods.getGoodsNo());
                goodsSkuDetail.setMarketPrice(new BigDecimal(goodsExportTempleVO.getTagPrice()));
                goodsSkuDetail.setSalesPrice(new BigDecimal(goodsExportTempleVO.getSalePrice()));
                goodsSkuDetail.setIsEnabled(Boolean.TRUE);
                goodsSkuDetail.setGmtModified(new Date());
                goodsSkuDetail.setIsUniform(Boolean.TRUE);
                goodsSkuDetail.setId(((GoodsSkuDetail)goodsSkuDetailList.get(0)).getId());
                this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)goodsSkuDetail);
                log.info("\u5355\u89c4\u683c\u5546\u54c1\u66f4\u65b0\u81ea\u52a8\u66f4\u65b0sku\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)goodsSkuDetail));
            }
            goods.setMerchantId(merchantId);
            if (firstGoodsClassify != null) {
                goods.setCategoryFirstId(firstGoodsClassify.getId());
            }
            if (secondGoodsClassify != null) {
                goods.setCategorySecondId(secondGoodsClassify.getId());
            }
            goods.setGoodsNo(goodsExportTempleVO.getGoodsNo());
            goods.setGoodsName(goodsExportTempleVO.getGoodsName());
            goods.setIsGift(this.parseInteger(goodsExportTempleVO.getIsGift()));
            goods.setIsUniform(Boolean.valueOf(isUniformParam));
            goods.setSalePrice(new BigDecimal(goodsExportTempleVO.getSalePrice()));
            goods.setMarketPrice(new BigDecimal(goodsExportTempleVO.getTagPrice()));
            goods.setShippingMode(this.parseInteger(goodsExportTempleVO.getShoppingMode()));
            goods.setCommissionRate(new BigDecimal(goodsExportTempleVO.getCommissionRate()));
            goods.setPriceSystem(this.parseInteger(goodsExportTempleVO.getPriceType()));
            goods.setSort(this.parseInteger(goodsExportTempleVO.getSort()));
            goods.setLimitation(this.parseInteger(goodsExportTempleVO.getLimitation()));
            goods.setGmtModified(new Date());
            goods.setIsShelved(shelved);
            this.goodsPOMapper.updateByPrimaryKeySelective(goods);
            log.info("\u66f4\u65b0\u5546\u54c1\u540e\u5546\u54c1:{}", JSON.toJSON((Object)goods));
        }
        goodsExportTempleVO.setGoodsId(goods.getId());
        String goodsTagValue = goodsExportTempleVO.getGoodsTag();
        log.info("\u5f53\u524d\u5546\u54c1tag:{}", (Object)goodsTagValue);
        if (!StringUtils.isEmpty((Object)goodsTagValue)) {
            GoodsTag goodsTag = goodsTagHashMap.get(goodsTagValue);
            if (goodsTag == null) {
                goodsTag = new GoodsTag();
                goodsTag.setMerchantId(merchantId);
                goodsTag.setGmtCreate(new Date());
                goodsTag.setName(goodsTagValue);
                goodsTag.setSort(Integer.valueOf(0));
                this.goodsTagMapper.insertSelective((Object)goodsTag);
                log.info("\u65b0\u589e\u5546\u54c1tag\u5206\u7c7b:{}", (Object)goodsTag);
                goodsTagHashMap.put(goodsTagValue, goodsTag);
            }
            Example goodsTagCustomExample = new Example(GoodsTagCustom.class);
            goodsTagCustomExample.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("tagId", (Object)goodsTag.getId());
            List goodsTagCustomsList = this.goodsTagCustomMapper.selectByExample((Object)goodsTagCustomExample);
            if (CollectionUtils.isEmpty((Collection)goodsTagCustomsList)) {
                GoodsTagCustom goodsTagCustom = new GoodsTagCustom();
                goodsTagCustom.setTagId(goodsTag.getId());
                goodsTagCustom.setGoodsId(goods.getId());
                goodsTagCustom.setGmtCreate(new Date());
                this.goodsTagCustomMapper.insertSelective((Object)goodsTagCustom);
                log.info("\u65b0\u589e\u5546\u54c1tag\u5173\u8054\u5173\u7cfb:{}", (Object)JSON.toJSONString((Object)goodsTagCustom));
            }
        }
        log.info("\u65b0\u589e\u5546\u54c1\u5206\u7c7b\u5173\u7cfb");
        List goodsClassifyCustoms = this.goodsClassifyCustomMapper.selectByGoodsId(goods.getId());
        if (CollectionUtils.isEmpty((Collection)goodsClassifyCustoms)) {
            if (secondGoodsClassify != null) {
                GoodsClassifyCustom secondGoodsClassifyCustom = this.addGoodsClassifyCustom(secondGoodsClassify, goods);
                log.info("\u65b0\u589e\u5546\u54c1\u4e8c\u7ea7\u5206\u7c7b:{}", (Object)JSON.toJSONString((Object)secondGoodsClassifyCustom));
            }
            if (firstGoodsClassify != null) {
                GoodsClassifyCustom firstGoodsClassifyCustom = this.addGoodsClassifyCustom(firstGoodsClassify, goods);
                log.info("\u65b0\u589e\u5546\u54c1\u4e00\u7ea7\u5206\u7c7b:{}", (Object)JSON.toJSONString((Object)firstGoodsClassifyCustom));
            }
        } else {
            log.info("\u5f53\u524d\u5546\u54c1\u5206\u7c7blist:{}", (Object)JSON.toJSONString((Object)goodsClassifyCustoms));
            ArrayList<Integer> goodsClassifyIdList = new ArrayList<Integer>();
            for (GoodsClassifyCustom goodsClassifyCustom : goodsClassifyCustoms) {
                goodsClassifyIdList.add(goodsClassifyCustom.getClassifyId());
            }
            if (!goodsClassifyIdList.contains(secondGoodsClassify.getId())) {
                GoodsClassifyCustom secondGoodsClassifyCustom = this.addGoodsClassifyCustom(secondGoodsClassify, goods);
                log.info("\u4e0d\u5b58\u5728\u5546\u54c1\u4e8c\u7ea7\u5206\u7c7b\uff0c\u65b0\u589e\u5546\u54c1\u4e8c\u7ea7\u5206\u7c7b:{}", (Object)JSON.toJSONString((Object)secondGoodsClassifyCustom));
            }
            if (!goodsClassifyIdList.contains(firstGoodsClassify.getId())) {
                GoodsClassifyCustom firstGoodsClassifyCustom = this.addGoodsClassifyCustom(firstGoodsClassify, goods);
                log.info("\u4e0d\u5b58\u5728\u5546\u54c1\u4e00\u7ea7\u5206\u7c7b\uff0c\u65b0\u589e\u5546\u54c1\u4e00\u7ea7\u5206\u7c7b:{}", (Object)JSON.toJSONString((Object)firstGoodsClassifyCustom));
            }
        }
    }

    private GoodsClassifyCustom addGoodsClassifyCustom(GoodsClassify firstGoodsClassify, GoodsPO goods) {
        GoodsClassifyCustom firstGoodsClassifyCustom = new GoodsClassifyCustom();
        firstGoodsClassifyCustom.setGoodsId(goods.getId());
        firstGoodsClassifyCustom.setClassifyId(firstGoodsClassify.getId());
        firstGoodsClassifyCustom.setGmtCreate(new Date());
        this.goodsClassifyCustomMapper.insertSelective((Object)firstGoodsClassifyCustom);
        return firstGoodsClassifyCustom;
    }

    private Boolean checkShelved(GoodsExportTempleVO goodsExportTempleVO, GoodsPO goods) {
        boolean equals = GoodsConstant.IS_SHELVED.equals(goodsExportTempleVO.getIsShelved());
        return equals;
    }

    @Transactional
    protected void disposeSkusImport(Integer merchantId, List<SkusExportTempleVO> successSkusExportTempleVOList, Integer excelImportId) {
        log.info("ImportServiceImpl_disposeSkusImport_excelImportId:{}", (Object)excelImportId);
        HashMap<String, Goods> goodsHashMap = new HashMap<String, Goods>();
        ArrayList<ErrorExportMessageVO> errorList = new ArrayList<ErrorExportMessageVO>();
        ArrayList<ErrorExportMessageVO> successList = new ArrayList<ErrorExportMessageVO>();
        HashMap<String, GoodsSpec> colorGoodsSpecMap = new HashMap<String, GoodsSpec>();
        HashMap<String, GoodsSpec> sizeGoodsSpecMap = new HashMap<String, GoodsSpec>();
        log.info("\u67e5\u8be2\u989c\u8272\u7ec4");
        Example colorExample = new Example(GoodsSpec.class);
        colorExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("specName", (Object)"\u989c\u8272").andEqualTo("pid", (Object)0);
        List colorGoodsSpecs = this.goodsSpecMapper.selectByExample((Object)colorExample);
        boolean checkColor = !CollectionUtils.isEmpty((Collection)colorGoodsSpecs);
        log.info("\u67e5\u8be2\u5c3a\u5bf8\u7ec4");
        Example sizeExample = new Example(GoodsSpec.class);
        sizeExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("specName", (Object)"\u5c3a\u5bf8").andEqualTo("pid", (Object)0);
        List sizeGoodsSpecs = this.goodsSpecMapper.selectByExample((Object)sizeExample);
        boolean checkSize = !CollectionUtils.isEmpty((Collection)sizeGoodsSpecs);
        log.info("\u5f00\u59cb\u5904\u7406\u6570\u636e");
        for (SkusExportTempleVO skusExportTempleVO : successSkusExportTempleVOList) {
            try {
                this.disposeSkuInfo(merchantId, goodsHashMap, colorGoodsSpecMap, sizeGoodsSpecMap, colorGoodsSpecs, checkColor, sizeGoodsSpecs, checkSize, skusExportTempleVO);
                ErrorExportMessageVO successExportMessageVO = new ErrorExportMessageVO();
                successExportMessageVO.setIndex(skusExportTempleVO.getIndex());
                successList.add(successExportMessageVO);
            }
            catch (Exception e) {
                ErrorExportMessageVO errorExportMessageVO = new ErrorExportMessageVO();
                errorExportMessageVO.setIndex(skusExportTempleVO.getIndex());
                errorExportMessageVO.setErrorMsg(e.getMessage());
                errorExportMessageVO.setSkuNo(skusExportTempleVO.getSkuNo());
                errorExportMessageVO.setGoodsNo(skusExportTempleVO.getGoodsNo());
                errorList.add(errorExportMessageVO);
                log.warn("disposeSkusImport_error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("\u7ed3\u675f\u5904\u7406\u6570\u636e");
        ExcelImportPOWithBLOBs record = new ExcelImportPOWithBLOBs();
        record.setEndTime(new Date(endTime));
        record.setSuccessInfo(JSON.toJSONString(successList));
        record.setSecondErrorInfo(JSON.toJSONString(errorList));
        record.setStatus(ImportConstant.EXCEL_IMPORT_STATUS_COMPLETED);
        record.setGmtModified(new Date());
        record.setExcelImportId(excelImportId);
        this.excelImportPOMapper.updateByPrimaryKeySelective(record);
        log.info("\u66f4\u65b0\u5bfc\u5165\u4efb\u52a1\u5b8c\u6210");
    }

    private void disposeSkuInfo(Integer merchantId, HashMap<String, Goods> goodsHashMap, HashMap<String, GoodsSpec> colorGoodsSpecMap, HashMap<String, GoodsSpec> sizeGoodsSpecMap, List<GoodsSpec> colorGoodsSpecs, boolean checkColor, List<GoodsSpec> sizeGoodsSpecs, boolean checkSize, SkusExportTempleVO skusExportTempleVO) throws Exception {
        String goodsNo = skusExportTempleVO.getGoodsNo();
        Goods goods = goodsHashMap.get(goodsNo);
        if (goods == null) {
            Example goodsExample = new Example(Goods.class);
            goodsExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("goodsNo", (Object)goodsNo).andEqualTo("isDel", (Object)Boolean.FALSE);
            List goodsList = this.goodsMapper.selectByExample((Object)goodsExample);
            if (CollectionUtils.isEmpty((Collection)goodsList)) {
                throw new MallAdminException("\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            goods = (Goods)goodsList.get(0);
        }
        log.info("\u67e5\u8be2\u5f53\u524d\u5546\u54c1:{}", (Object)JSON.toJSONString((Object)goods));
        if (goods.getIsUniform().booleanValue()) {
            throw new MallAdminException("\u5546\u54c1\u4e3a\u5355\u89c4\u683c\u8bbe\u7f6e,\u4e0d\u5bfc\u5165sku\u4fe1\u606f");
        }
        Example marketActivityGoodsExample = new Example(MarketActivityGoods.class);
        marketActivityGoodsExample.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("merchantId", (Object)merchantId);
        List marketActivityGoodsList = this.marketActivityGoodsMapper.selectByExample((Object)marketActivityGoodsExample);
        if (!CollectionUtils.isEmpty((Collection)marketActivityGoodsList)) {
            throw new Exception("\u8be5\u5546\u54c1\u53c2\u4e0e\u6d3b\u52a8,\u4e0d\u5bfc\u5165sku\u4fe1\u606f");
        }
        StringBuilder specIds = new StringBuilder();
        StringBuilder specNames = new StringBuilder();
        String color = skusExportTempleVO.getColor();
        if (checkColor) {
            GoodsSpec colorGoodsSpec = colorGoodsSpecs.get(0);
            Example colorGoodsSpecRelationExample = new Example(GoodsSpecRelation.class);
            colorGoodsSpecRelationExample.createCriteria().andEqualTo("specId", (Object)colorGoodsSpec.getId()).andEqualTo("goodsId", (Object)goods.getId());
            List goodsSpecRelations = this.goodsSpecRelationMapper.selectByExample((Object)colorGoodsSpecRelationExample);
            if (CollectionUtils.isEmpty((Collection)goodsSpecRelations)) {
                GoodsSpecRelation goodsSpecRelation = new GoodsSpecRelation();
                goodsSpecRelation.setGoodsId(goods.getId());
                goodsSpecRelation.setSpecId(colorGoodsSpec.getId());
                this.goodsSpecRelationMapper.insertSelective((Object)goodsSpecRelation);
                log.info("\u65b0\u589e\u5546\u54c1\u989c\u8272\u89c4\u683c\u5bf9\u5e94\u5173\u7cfb:{}", (Object)JSON.toJSONString((Object)goodsSpecRelation));
            }
            if (!StringUtils.isEmpty((Object)color)) {
                log.info("\u5f00\u59cb\u67e5\u8be2\u989c\u8272:{}", (Object)color);
                GoodsSpec colorChildGoodsSpec = colorGoodsSpecMap.get(color);
                if (colorChildGoodsSpec == null) {
                    Example colorChildExample = new Example(GoodsSpec.class);
                    colorChildExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("specName", (Object)color).andEqualTo("pid", (Object)colorGoodsSpec.getId());
                    List colorChildGoodsSpecsList = this.goodsSpecMapper.selectByExample((Object)colorChildExample);
                    if (CollectionUtils.isEmpty((Collection)colorChildGoodsSpecsList)) {
                        log.info("\u65b0\u589e\u989c\u8272\u5b50\u5c5e\u6027");
                        colorChildGoodsSpec = new GoodsSpec();
                        colorChildGoodsSpec.setMerchantId(merchantId);
                        colorChildGoodsSpec.setSpecName(color);
                        colorChildGoodsSpec.setPid(colorGoodsSpec.getId());
                        colorChildGoodsSpec.setGmtCreate(new Date());
                        this.goodsSpecMapper.insertSelective((Object)colorChildGoodsSpec);
                    } else {
                        colorChildGoodsSpec = (GoodsSpec)colorChildGoodsSpecsList.get(0);
                    }
                }
                log.info("\u5f53\u524d\u989c\u8272\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)colorChildGoodsSpec));
                Example goodsSpecRelationExample = new Example(GoodsSpecRelation.class);
                goodsSpecRelationExample.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("specId", (Object)colorChildGoodsSpec.getId());
                List sizeGoodsSpecRelations = this.goodsSpecRelationMapper.selectByExample((Object)goodsSpecRelationExample);
                if (CollectionUtils.isEmpty((Collection)sizeGoodsSpecRelations)) {
                    GoodsSpecRelation goodsSpecRelation = new GoodsSpecRelation();
                    goodsSpecRelation.setGoodsId(goods.getId());
                    goodsSpecRelation.setSpecId(colorChildGoodsSpec.getId());
                    this.goodsSpecRelationMapper.insertSelective((Object)goodsSpecRelation);
                    log.info("\u65b0\u589e\u5546\u54c1\u989c\u8272\u5b50\u89c4\u683c\u5173\u8054\u5173\u7cfb:{}", (Object)JSON.toJSONString((Object)goodsSpecRelation));
                }
                log.info("\u989c\u8272:{}\u5c5e\u6027:{}", (Object)color, (Object)JSON.toJSONString((Object)colorChildGoodsSpec));
                colorGoodsSpecMap.put(color, colorChildGoodsSpec);
                specIds.append(colorChildGoodsSpec.getId()).append(",");
                specNames.append(color).append(",");
            }
        }
        String size = skusExportTempleVO.getSize();
        if (checkSize) {
            GoodsSpec sizeGoodsSpec = sizeGoodsSpecs.get(0);
            Example sizeGoodsSpecRelationExample = new Example(GoodsSpecRelation.class);
            sizeGoodsSpecRelationExample.createCriteria().andEqualTo("specId", (Object)sizeGoodsSpec.getId()).andEqualTo("goodsId", (Object)goods.getId());
            List goodsSpecRelations = this.goodsSpecRelationMapper.selectByExample((Object)sizeGoodsSpecRelationExample);
            if (CollectionUtils.isEmpty((Collection)goodsSpecRelations)) {
                GoodsSpecRelation goodsSpecRelation = new GoodsSpecRelation();
                goodsSpecRelation.setGoodsId(goods.getId());
                goodsSpecRelation.setSpecId(sizeGoodsSpec.getId());
                this.goodsSpecRelationMapper.insertSelective((Object)goodsSpecRelation);
                log.info("\u65b0\u589e\u5546\u54c1\u5c3a\u5bf8\u89c4\u683c\u5bf9\u5e94\u5173\u7cfb:{}", (Object)JSON.toJSONString((Object)goodsSpecRelation));
            }
            if (!StringUtils.isEmpty((Object)size)) {
                log.info("\u5f00\u59cb\u67e5\u8be2\u5c3a\u5bf8:{}", (Object)size);
                GoodsSpec sizeChildGoodsSpec = sizeGoodsSpecMap.get(size);
                if (sizeChildGoodsSpec == null) {
                    Example colorChildExample = new Example(GoodsSpec.class);
                    colorChildExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("specName", (Object)size).andEqualTo("pid", (Object)sizeGoodsSpec.getId());
                    List sizeChildGoodsSpecsList = this.goodsSpecMapper.selectByExample((Object)colorChildExample);
                    if (CollectionUtils.isEmpty((Collection)sizeChildGoodsSpecsList)) {
                        log.info("\u65b0\u589e\u5c3a\u5bf8\u5b50\u5c5e\u6027");
                        sizeChildGoodsSpec = new GoodsSpec();
                        sizeChildGoodsSpec.setMerchantId(merchantId);
                        sizeChildGoodsSpec.setSpecName(size);
                        sizeChildGoodsSpec.setPid(sizeGoodsSpec.getId());
                        sizeChildGoodsSpec.setGmtCreate(new Date());
                        this.goodsSpecMapper.insertSelective((Object)sizeChildGoodsSpec);
                    } else {
                        sizeChildGoodsSpec = (GoodsSpec)sizeChildGoodsSpecsList.get(0);
                    }
                }
                log.info("\u5f53\u524d\u5c3a\u5bf8\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)sizeChildGoodsSpec));
                Example goodsSpecRelationExample = new Example(GoodsSpecRelation.class);
                goodsSpecRelationExample.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("specId", (Object)sizeChildGoodsSpec.getId());
                List sizeGoodsSpecRelations = this.goodsSpecRelationMapper.selectByExample((Object)goodsSpecRelationExample);
                if (CollectionUtils.isEmpty((Collection)sizeGoodsSpecRelations)) {
                    GoodsSpecRelation goodsSpecRelation = new GoodsSpecRelation();
                    goodsSpecRelation.setGoodsId(goods.getId());
                    goodsSpecRelation.setSpecId(sizeChildGoodsSpec.getId());
                    this.goodsSpecRelationMapper.insertSelective((Object)goodsSpecRelation);
                    log.info("\u65b0\u589e\u5546\u54c1\u5c3a\u5bf8\u5b50\u89c4\u683c\u5173\u8054\u5173\u7cfb:{}", (Object)JSON.toJSONString((Object)goodsSpecRelation));
                }
                log.info("\u5c3a\u5bf8:{}\u5c5e\u6027:{}", (Object)size, (Object)JSON.toJSONString((Object)skusExportTempleVO));
                colorGoodsSpecMap.put(size, sizeChildGoodsSpec);
                specIds.append(sizeChildGoodsSpec.getId());
                specNames.append(size);
            }
        }
        Example goodsSkuDetailExample = new Example(GoodsSkuDetail.class);
        goodsSkuDetailExample.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("skuNo", (Object)skusExportTempleVO.getSkuNo()).andEqualTo("isDel", (Object)Boolean.FALSE);
        List goodsSkuDetails = this.goodsSkuDetailMapper.selectByExample((Object)goodsSkuDetailExample);
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        if (CollectionUtils.isEmpty((Collection)goodsSkuDetails)) {
            log.info("\u5f00\u59cb\u65b0\u589e\u5546\u54c1!");
            goodsSkuDetail.setGoodsId(goods.getId());
            goodsSkuDetail.setSpecNames(specNames.toString());
            goodsSkuDetail.setSpecIds(specIds.toString());
            goodsSkuDetail.setSkuNo(skusExportTempleVO.getSkuNo());
            goodsSkuDetail.setMarketPrice(new BigDecimal(skusExportTempleVO.getTagPrice()));
            goodsSkuDetail.setSalesPrice(new BigDecimal(skusExportTempleVO.getSalePrice()));
            goodsSkuDetail.setStock(this.parseInteger(skusExportTempleVO.getStock()));
            goodsSkuDetail.setVolume(new BigDecimal(skusExportTempleVO.getVolume()));
            goodsSkuDetail.setWeight(new BigDecimal(skusExportTempleVO.getWeight()));
            goodsSkuDetail.setIsEnabled(Boolean.TRUE);
            goodsSkuDetail.setGmtCreate(new Date());
            goodsSkuDetail.setIsDel(Boolean.FALSE);
            goodsSkuDetail.setIsUniform(Boolean.FALSE);
            this.goodsSkuDetailMapper.insertSelective((Object)goodsSkuDetail);
            log.info("\u591a\u89c4\u683c\u5546\u54c1\u65b0\u589e\u81ea\u52a8\u521b\u5efasku\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)goodsSkuDetail));
        } else {
            goodsSkuDetail = (GoodsSkuDetail)goodsSkuDetails.get(0);
            log.info("\u66f4\u65b0\u524d\u5546\u54c1sku:{}", (Object)JSON.toJSONString((Object)goodsSkuDetail));
            goodsSkuDetail.setGoodsId(goods.getId());
            goodsSkuDetail.setSpecNames(specNames.toString());
            goodsSkuDetail.setSpecIds(specIds.toString());
            goodsSkuDetail.setSkuNo(skusExportTempleVO.getSkuNo());
            goodsSkuDetail.setMarketPrice(new BigDecimal(skusExportTempleVO.getTagPrice()));
            goodsSkuDetail.setSalesPrice(new BigDecimal(skusExportTempleVO.getSalePrice()));
            goodsSkuDetail.setStock(this.parseInteger(skusExportTempleVO.getStock()));
            goodsSkuDetail.setVolume(new BigDecimal(skusExportTempleVO.getVolume()));
            goodsSkuDetail.setWeight(new BigDecimal(skusExportTempleVO.getWeight()));
            goodsSkuDetail.setIsEnabled(Boolean.TRUE);
            goodsSkuDetail.setGmtModified(new Date());
            goodsSkuDetail.setIsDel(Boolean.FALSE);
            goodsSkuDetail.setIsUniform(Boolean.FALSE);
            this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)goodsSkuDetail);
            log.info("\u66f4\u65b0\u540e\u5546\u54c1sku:{}", (Object)JSON.toJSONString((Object)goodsSkuDetail));
        }
    }

    private boolean rowIsNull(String ... param) {
        for (String s : param) {
            if (StringUtils.isEmpty((Object)s)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Integer parseInteger(String param) {
        return Double.valueOf(param).intValue();
    }
}

