/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.admin;

import com.wmeimob.fastboot.bizvane.api.vo.ApiPageVO;
import com.wmeimob.fastboot.bizvane.api.vo.ApiTokenVO;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.service.UnderLineService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tk.mybatis.mapper.entity.Example;

@Component
public class ApiService {
    @Autowired
    private UnderLineService underLineService;
    @Resource
    private CompanyBrandRelationMapper companyBrandRelationMapper;

    private ApiTokenVO decryptToken(String token) {
        InputValidator.checkEmpty((Object)token, (String)"token");
        String decrypt = this.underLineService.decrypt(token);
        if (StringUtils.isEmpty((Object)decrypt) || !decrypt.contains(",")) {
            throw new CustomException("\u52a0\u5bc6\u683c\u5f0f\u6709\u8bef");
        }
        String brandCode = decrypt.split(",")[0];
        String key = decrypt.split(",")[1];
        if (StringUtils.isEmpty((Object)brandCode)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        if (StringUtils.isEmpty((Object)key)) {
            throw new CustomException("\u53c2\u6570\u6709\u8bef\uff01");
        }
        Example comExample = new Example(CompanyBrandRelation.class);
        comExample.createCriteria().andEqualTo("merchantCode", (Object)brandCode).andEqualTo("authenticationKey", (Object)key);
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOneByExample((Object)comExample);
        if (companyBrandRelation == null) {
            throw new CustomException("\u6b64\u54c1\u724c\u672a\u5728\u5fae\u5546\u57ce\u8bbe\u7f6e");
        }
        if (!companyBrandRelation.getAuthenticationKey().equals(key)) {
            throw new CustomException("key\u65e0\u6743\u9650");
        }
        ApiTokenVO apiTokenVO = new ApiTokenVO();
        apiTokenVO.setToken(token);
        apiTokenVO.setCompanyBrandRelation(companyBrandRelation);
        return apiTokenVO;
    }

    public String checkStoreAuth(String token, String shopCode, Boolean checkShop) {
        ApiTokenVO apiTokenVO = this.decryptToken(token);
        CompanyBrandRelation companyBrandRelation = apiTokenVO.getCompanyBrandRelation();
        if (companyBrandRelation == null) {
            return shopCode;
        }
        Integer merchantId = companyBrandRelation.getMerchantId();
        if (!merchantId.toString().equalsIgnoreCase(shopCode) && checkShop.booleanValue()) {
            throw new CustomException("shopCode\u65e0\u6743\u9650");
        }
        return merchantId.toString();
    }

    public String checkStoreAuth(String token, String shopCode) {
        return this.checkStoreAuth(token, shopCode, Boolean.FALSE);
    }

    public void checkPage(ApiPageVO apiPageVO) {
        Integer pageSize;
        Integer pageNum = apiPageVO.getPageNum();
        if (pageNum == null) {
            apiPageVO.setPageNum(Integer.valueOf(0));
        }
        if ((pageSize = apiPageVO.getPageSize()) == null) {
            apiPageVO.setPageSize(Integer.valueOf(10));
        }
    }
}

