/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.Material;
import com.wmeimob.fastboot.bizvane.entity.PicGroup;
import com.wmeimob.fastboot.bizvane.mapper.MaterialMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.service.MaterialsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialsServiceImpl
implements MaterialsService {
    @Autowired
    private MaterialMapper materialMapper;
    @Autowired
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;

    public List<Material> selectMaterialList(Material materials) {
        List materialList = this.materialMapper.selectMaterialList(materials);
        return materialList;
    }

    public void mkGroup4Pics(PicGroup picGroup) {
        Integer brandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(picGroup.getMerchantId());
        picGroup.setBrandId(brandId);
        this.materialMapper.mkGroup4Pics(picGroup);
    }

    public void uploadPics(Material material) {
        List imgs = material.getImgs();
        Integer merchantId = material.getMerchantId();
        Integer brandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(material.getMerchantId());
        for (Material img : imgs) {
            img.setMerchantId(merchantId);
            img.setBrandId(brandId);
            this.materialMapper.uploadPic(img);
        }
    }

    public void updatePicGroup(Material material) {
        Integer merchantId = material.getMerchantId();
        Integer imgGroup = material.getImgGroup();
        List ids = material.getImgIds();
        if (imgGroup != 0) {
            for (Integer id : ids) {
                this.materialMapper.updatePicGroup(merchantId, imgGroup, id);
            }
        } else {
            for (Integer id : ids) {
                this.materialMapper.updatePicGroupToNull(merchantId, imgGroup, id);
            }
        }
    }

    public void deletePics(Material material) {
        Integer merchantId = material.getMerchantId();
        List ids = material.getImgIds();
        for (Integer id : ids) {
            this.materialMapper.deletePics(merchantId, id);
        }
    }

    public PicGroup selectAllGroup(Integer merchantId) {
        Integer brandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(merchantId);
        List picGroups = this.materialMapper.selectAllGroup(brandId);
        Integer unClassifyAmount = this.companyBrandRelationPOMapper.selectUnClassifyAmount(merchantId);
        picGroups.forEach(group -> {
            Integer imgAmount = this.companyBrandRelationPOMapper.selectImgAmount(group.getGroupId(), group.getMerchantId());
            group.setImgAmount(imgAmount);
            group.setUnClassifyAmount(unClassifyAmount);
        });
        PicGroup picGroup = new PicGroup();
        picGroup.setPicGroups(picGroups);
        picGroup.setUnClassifyAmount(unClassifyAmount);
        return picGroup;
    }

    public void deletePicGroups(Material material) {
        List materialList = this.materialMapper.selectMaterialList(material);
        if (materialList.size() > 0) {
            for (Material material1 : materialList) {
                this.updateToUnClassify(material1);
            }
        }
        this.materialMapper.deleteTheroup(material.getGroupId(), material.getMerchantId());
    }

    private void updateToUnClassify(Material material1) {
        this.materialMapper.unClassify(material1);
    }

    public void updateGroupName(Material material) {
        if (material != null) {
            this.materialMapper.updateGroupName(material);
        }
    }

    public void updatePicName(Material material) {
        if (material != null) {
            this.materialMapper.updatePicName(material);
        }
    }
}

