/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.GoodsQueryDTO;
import com.wmeimob.fastboot.bizvane.dto.GoodsStatisticalDTO;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleCombination;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassifyCustom;
import com.wmeimob.fastboot.bizvane.entity.GoodsCopyVO;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropValueCustom;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpecRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsTagCustom;
import com.wmeimob.fastboot.bizvane.entity.UpdateSalesEntity;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.enums.GoodsIsGift;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleCombinationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropHeadCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropValueCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsTagCustomMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuLogPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuLogPO;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.fix.Fix20200416;
import com.wmeimob.fastboot.bizvane.service.qdqm.GoodsSyncChildService;
import com.wmeimob.fastboot.bizvane.service.qdqm.ImportTaskService;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class GoodsServiceImpl
implements GoodsService {
    private static final Logger log = LoggerFactory.getLogger(GoodsServiceImpl.class);
    @Autowired
    private ActivityGoodsMapper activityGoodsMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsTagCustomMapper goodsTagCustomMapper;
    @Autowired
    private GoodsClassifyCustomMapper goodsClassifyCustomMapper;
    @Autowired
    private GoodsPropValueCustomMapper goodsPropValueCustomMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private GoodsSpecRelationMapper goodsSpecRelationMapper;
    @Autowired
    private GoodsPropHeadCustomMapper goodsPropHeadCustomMapper;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityRuleCombinationMapper activityRuleCombinationMapper;
    @Resource
    private GoodsClassifyMapper goodsClassifyMapper;
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private GoodsSkuLogPOMapper goodsSkuLogPOMapper;
    @Autowired
    private GoodsSyncChildService goodsSyncChildService;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;
    @Autowired
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Autowired
    private Fix20200416 fix20200416;
    @Autowired
    private ImportTaskService importTaskService;

    public Goods add(Goods goods) {
        Integer sysBrandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(goods.getMerchantId());
        goods.setSysBrandId(sysBrandId);
        log.info("\u65b0\u589e\u5546\u54c1\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)goods));
        InputValidator.checkEmpty((Object)goods.getExpressTemplateId(), (String)"\u8fd0\u8d39\u6a21\u677f");
        InputValidator.checkEmpty((Object)goods.getCoverImg(), (String)"\u5217\u8868\u9875\u5c55\u793a\u56fe");
        InputValidator.checkEmpty((Object)goods.getBannerImgPaths(), (String)"\u8be6\u60c5\u9875\u5546\u54c1\u56fe");
        log.info("\u65b0\u589e\u5546\u54c1\u4e1a\u52a1\u5c42\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)goods));
        if (goods.getLimitation() != null) {
            InputValidator.checkNaturalNumber((Integer)goods.getLimitation(), (String)"\u9650\u8d2d\u6570\u91cf");
        }
        if (!StringUtils.isEmpty((Object)goods.getVideoPaths())) {
            InputValidator.checkEmpty((Object)goods.getVideoImg(), (String)"\u89c6\u9891\u5c01\u9762\u56fe");
        }
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)goods.getGoodsNo()).andEqualTo("sysBrandId", (Object)goods.getSysBrandId()).andEqualTo("isDel", (Object)false);
        List goodsList = this.goodsMapper.selectByExample((Object)example);
        if (goodsList.size() > 0) {
            throw new MallAdminException("\u5546\u54c1\u7f16\u53f7\u91cd\u590d");
        }
        Date data = new Date();
        goods.setGmtCreate(data);
        goods.setIsShelved(Boolean.valueOf(false));
        this.goodsMapper.insertSelective((Object)goods);
        this.goodsSyncChildService.modifyChildMerchantStatus(goods);
        for (GoodsPropValueCustom gpvc : goods.getGoodsPropValueCustomList()) {
            gpvc.setGmtCreate(data);
            gpvc.setGoodsId(goods.getId());
        }
        for (GoodsClassifyCustom gcc : goods.getGoodsClassifyCustomList()) {
            gcc.setGmtCreate(data);
            gcc.setGoodsId(goods.getId());
        }
        for (GoodsTagCustom gtc : goods.getGoodsTagCustomList()) {
            gtc.setGmtCreate(data);
            gtc.setGoodsId(goods.getId());
        }
        if (goods.getGoodsPropValueCustomList().size() > 0) {
            this.goodsPropValueCustomMapper.insertList(goods.getGoodsPropValueCustomList());
        }
        if (goods.getGoodsClassifyCustomList().size() > 0) {
            this.goodsClassifyCustomMapper.insertList(goods.getGoodsClassifyCustomList());
        }
        if (goods.getGoodsTagCustomList().size() > 0) {
            this.goodsTagCustomMapper.insertList(goods.getGoodsTagCustomList());
        }
        return goods;
    }

    public int update(Goods goods) {
        int i;
        Example example;
        Integer sysBrandId = this.companyBrandRelationPOMapper.selectBrandIdByMerchantId(goods.getMerchantId());
        goods.setSysBrandId(sysBrandId);
        log.info("GoodsServiceImpl#update goods:{}", (Object)JSON.toJSONString((Object)goods));
        if (goods.getLimitation() != null) {
            InputValidator.checkNaturalNumber((Integer)goods.getLimitation(), (String)"\u9650\u8d2d\u6570\u91cf");
        }
        Date date = new Date();
        goods.setGmtModified(date);
        if (goods.getVideoDelete() != null && goods.getVideoDelete().booleanValue()) {
            goods.setVideoImg("");
            goods.setVideoPaths("");
        }
        if (goods.getGoodsPropValueCustomList() != null) {
            for (GoodsPropValueCustom gpvc : goods.getGoodsPropValueCustomList()) {
                if (gpvc.getId() == null) {
                    gpvc.setGmtCreate(date);
                    gpvc.setGoodsId(goods.getId());
                    this.goodsPropValueCustomMapper.insertSelective((Object)gpvc);
                }
                if (gpvc.getIsDelete() == null || !gpvc.getIsDelete().booleanValue()) continue;
                this.goodsPropValueCustomMapper.deleteByPrimaryKey((Object)gpvc);
            }
        }
        if (goods.getGoodsClassifyCustomList() != null) {
            for (GoodsClassifyCustom gcc : goods.getGoodsClassifyCustomList()) {
                if (gcc.getId() == null) {
                    gcc.setGmtCreate(date);
                    gcc.setGoodsId(goods.getId());
                    this.goodsClassifyCustomMapper.insertSelective((Object)gcc);
                }
                if (gcc.getIsDelete() == null || !gcc.getIsDelete().booleanValue()) continue;
                Integer count = this.goodsClassifyCustomMapper.countclassByid(goods.getId(), gcc.getId());
                if (count == 0) {
                    Integer pid = this.goodsClassifyCustomMapper.selectPidById(gcc.getId());
                    Example example2 = new Example(GoodsClassifyCustom.class);
                    example2.createCriteria().andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("classifyId", (Object)pid);
                    this.goodsClassifyCustomMapper.deleteByExample((Object)example2);
                }
                this.goodsClassifyCustomMapper.deleteByPrimaryKey((Object)gcc);
            }
        }
        if (goods.getGoodsTagCustomList() != null) {
            for (GoodsTagCustom gtc : goods.getGoodsTagCustomList()) {
                if (gtc.getId() == null) {
                    gtc.setGmtCreate(date);
                    gtc.setGoodsId(goods.getId());
                    this.goodsTagCustomMapper.insertSelective((Object)gtc);
                }
                if (gtc.getIsDelete() == null || !gtc.getIsDelete().booleanValue()) continue;
                this.goodsTagCustomMapper.deleteByPrimaryKey((Object)gtc);
            }
        }
        if (goods.getIsUniform() != null) {
            log.info("GoodsSkuDetail is:{}", (Object)JSONObject.toJSONString(goods.getGoodsSkuDetailList().get(0)));
            if (goods.getIsUniform().booleanValue()) {
                GoodsSkuDetail goodsSkuDetail = (GoodsSkuDetail)goods.getGoodsSkuDetailList().get(0);
                goodsSkuDetail.setSysBrandId(goods.getSysBrandId());
                goodsSkuDetail.setMerchantId(goods.getMerchantId());
                if (goods.getIsGift() == 0) {
                    if (goodsSkuDetail.getSalesPrice().compareTo(new BigDecimal("0")) < 1) {
                        throw new MallAdminException("\u552e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0");
                    }
                    if (goodsSkuDetail.getMarketPrice().compareTo(new BigDecimal("0")) < 1) {
                        throw new MallAdminException("\u540a\u724c\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0");
                    }
                    if (goodsSkuDetail.getMarketPrice().compareTo(goodsSkuDetail.getSalesPrice()) < 0) {
                        throw new MallAdminException("\u540a\u724c\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u9500\u552e\u4ef7");
                    }
                    if (!goods.getPriceSystem().equals(0) && goodsSkuDetail.getIntegralPoints().compareTo(0L) < 1) {
                        throw new MallAdminException("\u79ef\u5206\u4e0d\u80fd\u4e3a0");
                    }
                }
                if (goodsSkuDetail.getId() == null) {
                    List list = this.goodsSkuDetailMapper.selectSkuNoRepeat(goodsSkuDetail);
                    Integer countItself = this.goodsSkuDetailMapper.selectByItself(goodsSkuDetail);
                    if (list.size() - countItself > 0) {
                        throw new MallAdminException("sku\u7f16\u7801\u6709\u91cd\u590d");
                    }
                    goodsSkuDetail.setGoodsId(goods.getId());
                    goodsSkuDetail.setGmtCreate(date);
                    goodsSkuDetail.setIsUniform(Boolean.valueOf(true));
                    this.goodsSkuDetailMapper.insertSelective((Object)goodsSkuDetail);
                } else {
                    goodsSkuDetail.setNoId(goodsSkuDetail.getId());
                    Integer countItself = this.goodsSkuDetailMapper.selectByItself(goodsSkuDetail);
                    List list = this.goodsSkuDetailMapper.selectSkuNoRepeat(goodsSkuDetail);
                    if (list.size() - countItself > 0) {
                        throw new MallAdminException("sku\u7f16\u7801\u6709\u91cd\u590d");
                    }
                    goodsSkuDetail.setGmtModified(date);
                    log.info("\u66f4\u65b0\u5546\u54c1\u7684sku\u7b49\u4fe1\u606f\uff1a{},skuNO{}", (Object)JSONObject.toJSONString((Object)goodsSkuDetail), (Object)JSONObject.toJSONString((Object)goodsSkuDetail.getSkuNo()));
                    this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)goodsSkuDetail);
                    this.scheduledThreadPoolExecutor.execute(() -> {
                        Goods goods1 = this.goodsMapper.selectById(goods.getId());
                        log.info("GoodsServiceImpl#update goods1:{}", (Object)JSON.toJSONString((Object)goods1));
                        GoodsSkuLogPO goodsSkuLogPO = new GoodsSkuLogPO();
                        goodsSkuLogPO.setGmtCreate(new Date());
                        goodsSkuLogPO.setGoodsId(goods.getId());
                        goodsSkuLogPO.setGoodsSkuDetailId(goodsSkuDetail.getId());
                        goodsSkuLogPO.setGoodsNo(goods1.getGoodsNo());
                        goodsSkuLogPO.setSkuNo(goodsSkuDetail.getSkuNo());
                        goodsSkuLogPO.setNewMarketPrice(goodsSkuDetail.getMarketPrice());
                        goodsSkuLogPO.setNewSalesPrice(goodsSkuDetail.getSalesPrice());
                        goodsSkuLogPO.setNewStock(goodsSkuDetail.getStock());
                        goodsSkuLogPO.setUserCreate(goods.getNickName());
                        goodsSkuLogPO.setUserAccount(goods.getAccountCode());
                        goodsSkuLogPO.setMerchantId(goods.getMerchantId());
                        log.info("GoodsServiceImpl#update#scheduledThreadPoolExecutor goodsSkuLogPO:{}", (Object)JSON.toJSONString((Object)goodsSkuLogPO));
                        this.goodsSkuLogPOMapper.insertSelective(goodsSkuLogPO);
                    });
                }
                goods.setSalePrice(goodsSkuDetail.getSalesPrice());
                goods.setMarketPrice(goodsSkuDetail.getMarketPrice());
                goods.setIntegralPoints(((GoodsSkuDetail)goods.getGoodsSkuDetailList().get(0)).getIntegralPoints());
            } else {
                List goodsSkuDetailList = goods.getGoodsSkuDetailList();
                this.fix20200416.checkGoodsSkuDetailRepeat(goodsSkuDetailList, goods.getMerchantId());
                if (goodsSkuDetailList.size() > 0) {
                    example = new Example(GoodsSkuDetail.class);
                    example.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
                    List goodsSkuDetails = this.goodsSkuDetailMapper.selectByExample((Object)example);
                    ArrayList ids = new ArrayList();
                    goodsSkuDetailList.forEach(e -> ids.add(e.getId()));
                    for (GoodsSkuDetail g : goodsSkuDetails) {
                        if (ids.contains(g.getId())) continue;
                        g.setIsDel(Boolean.valueOf(true));
                        g.setSysBrandId(goods.getSysBrandId());
                        g.setMerchantId(goods.getMerchantId());
                        this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)g);
                    }
                    BigDecimal minSalePrice = ((GoodsSkuDetail)goodsSkuDetailList.get(0)).getSalesPrice();
                    BigDecimal minMarketPrice = ((GoodsSkuDetail)goodsSkuDetailList.get(0)).getMarketPrice();
                    Long minIntegralPoints = ((GoodsSkuDetail)goodsSkuDetailList.get(0)).getIntegralPoints();
                    for (GoodsSkuDetail g : goodsSkuDetailList) {
                        Integer countItself;
                        List list;
                        g.setSysBrandId(goods.getSysBrandId());
                        g.setMerchantId(goods.getMerchantId());
                        if (g.getSalesPrice().compareTo(new BigDecimal("0")) < 1) {
                            throw new MallAdminException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
                        }
                        if (g.getMarketPrice().compareTo(new BigDecimal("0")) < 1) {
                            throw new MallAdminException("\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
                        }
                        if (g.getMarketPrice().compareTo(g.getSalesPrice()) < 0) {
                            throw new MallAdminException("\u540a\u724c\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u9500\u552e\u4ef7");
                        }
                        if (!goods.getPriceSystem().equals(0) && g.getIntegralPoints().compareTo(0L) < 1) {
                            throw new MallAdminException("\u79ef\u5206\u4e0d\u80fd\u4e3a0");
                        }
                        if (g.getSalesPrice().compareTo(minSalePrice) < 0) {
                            minSalePrice = g.getSalesPrice();
                        }
                        if (g.getMarketPrice().compareTo(minMarketPrice) < 0) {
                            minMarketPrice = g.getMarketPrice();
                        }
                        if (!goods.getPriceSystem().equals(0) && g.getIntegralPoints().compareTo(minIntegralPoints) < 0) {
                            minIntegralPoints = g.getIntegralPoints();
                        }
                        if (g.getId() == null) {
                            g.setSysBrandId(goods.getSysBrandId());
                            list = this.goodsSkuDetailMapper.selectSkuNoRepeat(g);
                            countItself = this.goodsSkuDetailMapper.selectByItself(g);
                            if (list.size() - countItself > 0) {
                                throw new MallAdminException("sku\u7f16\u7801\u6709\u91cd\u590d");
                            }
                            g.setGoodsId(goods.getId());
                            g.setGmtCreate(date);
                            g.setIsUniform(Boolean.valueOf(false));
                            this.goodsSkuDetailMapper.insertSelective((Object)g);
                            continue;
                        }
                        g.setSysBrandId(goods.getSysBrandId());
                        g.setNoId(g.getId());
                        list = this.goodsSkuDetailMapper.selectSkuNoRepeat(g);
                        countItself = this.goodsSkuDetailMapper.selectByItself(g);
                        if (list.size() - countItself > 0) {
                            throw new MallAdminException("sku\u7f16\u7801\u6709\u91cd\u590d");
                        }
                        g.setGmtModified(date);
                        this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)g);
                        this.scheduledThreadPoolExecutor.execute(() -> {
                            Goods goods1 = this.goodsMapper.selectById(goods.getId());
                            log.info("GoodsServiceImpl#update goods1:{}", (Object)JSON.toJSONString((Object)goods1));
                            GoodsSkuLogPO goodsSkuLogPO = new GoodsSkuLogPO();
                            goodsSkuLogPO.setGmtCreate(new Date());
                            goodsSkuLogPO.setUserCreate(goods.getNickName());
                            goodsSkuLogPO.setUserAccount(goods.getAccountCode());
                            goodsSkuLogPO.setGoodsId(goods.getId());
                            goodsSkuLogPO.setGoodsSkuDetailId(g.getId());
                            goodsSkuLogPO.setGoodsNo(goods1.getGoodsNo());
                            goodsSkuLogPO.setSkuNo(g.getSkuNo());
                            goodsSkuLogPO.setNewMarketPrice(g.getMarketPrice());
                            goodsSkuLogPO.setNewSalesPrice(g.getSalesPrice());
                            goodsSkuLogPO.setNewStock(g.getStock());
                            goodsSkuLogPO.setMerchantId(goods.getMerchantId());
                            log.info("GoodsServiceImpl#update#scheduledThreadPoolExecutor goodsSkuLogPO:{}", (Object)JSON.toJSONString((Object)goodsSkuLogPO));
                            this.goodsSkuLogPOMapper.insertSelective(goodsSkuLogPO);
                        });
                    }
                    goods.setSalePrice(minSalePrice);
                    goods.setMarketPrice(minMarketPrice);
                    goods.setIntegralPoints(minIntegralPoints);
                    if (goods.getGoodsSpecRelationList().size() > 0) {
                        Example example4 = new Example(GoodsSpecRelation.class);
                        example4.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
                        this.goodsSpecRelationMapper.deleteByExample((Object)example4);
                        this.goodsSpecRelationMapper.insertList(goods.getGoodsSpecRelationList());
                    }
                }
            }
        }
        if ((i = this.goodsMapper.updateByPrimaryKeySelective((Object)goods)) > 0) {
            example = new Example(ActivityRuleCombination.class);
            example.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
            List combinations = this.activityRuleCombinationMapper.selectByExample((Object)example);
            combinations.forEach(c -> {
                c.setGoodsName(goods.getGoodsName());
                c.setGoodsNo(goods.getGoodsNo());
                this.activityRuleCombinationMapper.updateByPrimaryKeySelective(c);
            });
        }
        return i;
    }

    public Goods findById(Integer id) {
        Goods goods = this.goodsMapper.selectById(id);
        log.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)goods));
        ArrayList<GoodsSkuDetail> list2 = new ArrayList<GoodsSkuDetail>();
        for (GoodsSkuDetail skuDetail : goods.getGoodsSkuDetailList()) {
            if (StringUtils.isEmpty((Object)skuDetail.getSkuImg())) {
                skuDetail.setSkuImg(goods.getCoverImg());
            }
            list2.add(skuDetail);
            log.info("sku:{}", (Object)JSON.toJSONString(list2));
        }
        goods.setGoodsSkuDetailList(list2);
        log.info("\u6700\u540e\u8fd4\u56de\u7684\u5546\u54c1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)goods));
        return goods;
    }

    public List<Goods> findByConditionForActivity(Goods goods) {
        return this.goodsMapper.goodsListForActivity(goods);
    }

    public List<Goods> findByCondition(Goods goods) {
        return this.goodsMapper.goodsList(goods);
    }

    public int updateShelved(List<Goods> goodsList, Integer checked) {
        if (checked == 1) {
            for (Goods g : goodsList) {
                Example example = new Example(GoodsSkuDetail.class);
                example.createCriteria().andEqualTo("goodsId", (Object)g.getId()).andEqualTo("isDel", (Object)false);
                List list = this.goodsSkuDetailMapper.selectByExample((Object)example);
                if (list.size() >= 1) continue;
                throw new MallAdminException("\u7f16\u53f7" + g.getGoodsNo() + "\u5546\u54c1\u6ca1\u6709\u8bbe\u7f6e\u89c4\u683c");
            }
        }
        return this.goodsMapper.updateShelved(goodsList, checked);
    }

    public int delete(Integer id) {
        Goods goods1 = (Goods)this.goodsMapper.selectByPrimaryKey((Object)id);
        if (goods1.getIsShelved().booleanValue()) {
            throw new MallAdminException("\u5546\u54c1\u9700\u8981\u5148\u4e0b\u67b6\u624d\u80fd\u5220\u9664");
        }
        Goods goods = new Goods();
        goods.setId(id);
        goods.setIsDel(Boolean.valueOf(true));
        int result = this.goodsMapper.updateByPrimaryKeySelective((Object)goods);
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        goodsSkuDetail.setIsDel(Boolean.valueOf(true));
        Example example = new Example(GoodsSkuDetail.class);
        example.createCriteria().andEqualTo("goodsId", (Object)goods1.getId());
        int skuResult = this.goodsSkuDetailMapper.updateByExampleSelective((Object)goodsSkuDetail, (Object)example);
        log.info("\u66f4\u65b0\u4e86goodsId:[{}]\u4e0b\u7684sku:[{}]\u6761", (Object)id, (Object)skuResult);
        if (result > 0) {
            this.activityService.deleteActivityGoods(id);
        }
        return result;
    }

    public List<Goods> goodsStock(Goods goods) {
        return this.goodsMapper.goodsStock(goods);
    }

    public Goods findGiftByNo(Integer merchantId, String goodsNo) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)goodsNo).andEqualTo("merchantId", (Object)merchantId).andEqualTo("isGift", (Object)true).andEqualTo("isDel", (Object)false);
        List list = this.goodsMapper.selectByExample((Object)example);
        if (list.size() > 0) {
            return (Goods)list.get(0);
        }
        throw new MallAdminException("\u6ca1\u6709\u6b64\u7f16\u53f7\u7684\u8d60\u54c1");
    }

    public PageInfo<GoodsStatisticalDTO> goodsStatisticalList(Goods goods, Boolean pageJudge) {
        PageInfo pageInfo = new PageInfo();
        List statisticalDTOS = new ArrayList();
        if (Boolean.TRUE.equals(pageJudge)) {
            PageHelper.startPage((int)goods.getPageIndex(), (int)goods.getPageSize());
            statisticalDTOS = this.goodsMapper.goodsStatisticalList(goods);
            pageInfo = new PageInfo(statisticalDTOS);
        } else {
            statisticalDTOS = this.goodsMapper.goodsStatisticalList(goods);
            pageInfo.setList(statisticalDTOS);
        }
        if (pageInfo.getList().size() > 0) {
            GoodsStatisticalDTO goodsStatisticalDTO = new GoodsStatisticalDTO();
            goodsStatisticalDTO.setGoodsNo("\u603b\u8ba1");
            goodsStatisticalDTO.setAmount(new BigDecimal("0"));
            goodsStatisticalDTO.setAvgPrice(new BigDecimal("0"));
            goodsStatisticalDTO.setCountCar(Integer.valueOf(0));
            goodsStatisticalDTO.setCountCollect(Integer.valueOf(0));
            goodsStatisticalDTO.setQuantity(Integer.valueOf(0));
            for (GoodsStatisticalDTO g : pageInfo.getList()) {
                goodsStatisticalDTO.setAmount(goodsStatisticalDTO.getAmount().add(g.getAmount() == null ? new BigDecimal("0") : g.getAmount()));
                goodsStatisticalDTO.setAvgPrice(goodsStatisticalDTO.getAvgPrice().add(g.getAvgPrice() == null ? new BigDecimal("0") : g.getAvgPrice()));
                goodsStatisticalDTO.setCountCar(Integer.valueOf(goodsStatisticalDTO.getCountCar() + (g.getCountCar() == null ? 0 : g.getCountCar())));
                goodsStatisticalDTO.setCountCollect(Integer.valueOf(goodsStatisticalDTO.getCountCollect() + (g.getCountCollect() == null ? 0 : g.getCountCollect())));
                goodsStatisticalDTO.setQuantity(Integer.valueOf(goodsStatisticalDTO.getQuantity() + (g.getQuantity() == null ? 0 : g.getQuantity())));
                goodsStatisticalDTO.setAvgPrice(goodsStatisticalDTO.getAvgPrice().setScale(2, 4));
                g.setAvgPrice(g.getAvgPrice().setScale(2, 4));
            }
            pageInfo.getList().add(0, goodsStatisticalDTO);
        }
        return pageInfo;
    }

    public Goods selectByGoodsNo(Goods goods) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("goodsNo", (Object)goods.getGoodsNo()).andEqualTo("isGift", (Object)false).andEqualTo("merchantId", (Object)goods.getMerchantId()).andEqualTo("isDel", (Object)0);
        return (Goods)this.goodsMapper.selectOneByExample((Object)example);
    }

    public Integer selectCountGoodsByExpressId(Integer id) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("expressTemplateId", (Object)id).andEqualTo("isDel", (Object)false);
        List goods = this.goodsMapper.selectByExample((Object)example);
        return goods.size();
    }

    public PageInfo<Goods> selectGoodsList(Goods goods) {
        Integer merchantId = goods.getMerchantId();
        log.info("pageIndex:{} pageSize:{}", (Object)goods.getPageIndex(), (Object)goods.getPageSize());
        PageHelper.startPage((int)goods.getPageIndex(), (int)goods.getPageSize(), (boolean)true);
        List goods1 = this.goodsMapper.selectGoodsList(goods);
        PageInfo pageInfo = new PageInfo(goods1);
        List list = pageInfo.getList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List<Goods> goodsPackage = this.addCategoryName(list);
            pageInfo.setList(goodsPackage);
        }
        return pageInfo;
    }

    public PageInfo<Goods> getGoodListByClassifyName(Object condition) {
        GoodsQueryDTO goodsQueryDTO = (GoodsQueryDTO)condition;
        goodsQueryDTO.setActivityType(ActivitySanEnum.FULL_REDUCTION.getCode());
        log.info("\u67e5\u8be2\u6709\u6548\u6d3b\u52a8\u5546\u54c1\u6761\u4ef6:{}", (Object)goodsQueryDTO);
        List goodsIds = this.activityGoodsMapper.selectGoodIdsInActivity(goodsQueryDTO);
        log.info("\u67e5\u8be2\u51fa\u7684\u6709\u6548\u6d3b\u52a8\u5546\u54c1:{}", (Object)goodsIds);
        goodsQueryDTO.setGoodsInActivity(goodsIds);
        PageHelper.startPage((int)goodsQueryDTO.getPageIndex(), (int)goodsQueryDTO.getPageSize());
        List goods = this.activityGoodsMapper.selectGoodsNotInActivity(goodsQueryDTO);
        PageInfo result = new PageInfo(goods);
        log.info("\u7b26\u5408\u5546\u54c1\u7684\u7ed3\u679c\uff1a{}", (Object)goods);
        return result;
    }

    @Transactional
    public RestResult updateSalePrice(List<Goods> goods) {
        ArrayList<UpdateSalesEntity> failed = new ArrayList<UpdateSalesEntity>();
        for (Goods good : goods) {
            log.info("GoodsServiceImpl#updateSalePrice good:{}", (Object)JSON.toJSONString((Object)good));
            Goods good1 = this.goodsMapper.selectById(good.getId());
            if (good.getId() == null || good.getSalePrice() == null) {
                log.info("\u53c2\u6570\u4e3a\u7a7a");
                failed.add(this.transGood2Update(good1, "\u53c2\u6570\u4e3a\u7a7a"));
                continue;
            }
            if (good1 == null) {
                log.info("\u6ca1\u6709\u5546\u54c1\u6570\u636e");
                failed.add(this.transGood2Update(good1, "\u6ca1\u6709\u5546\u54c1\u6570\u636e"));
                continue;
            }
            if (GoodsIsGift.GIFT.getCode().equals(good1.getIsGift())) {
                log.info("\u8be5\u5546\u54c1\u662f\u793c\u54c1");
                failed.add(this.transGood2Update(good1, "\u8be5\u5546\u54c1\u662f\u793c\u54c1"));
                continue;
            }
            if (Boolean.TRUE.equals(good1.getIsDel())) {
                log.info("\u8be5\u5546\u54c1\u5df2\u7ecf\u88ab\u5220\u9664");
                failed.add(this.transGood2Update(good1, "\u8be5\u5546\u54c1\u5df2\u7ecf\u88ab\u5220\u9664"));
                continue;
            }
            GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
            goodsSkuDetail.setGoodsId(good1.getId());
            goodsSkuDetail.setSalesPrice(good.getSalePrice());
            goodsSkuDetail.setGmtModified(new Date());
            List goodsSkuDetails = this.goodsSkuDetailMapper.selectSkuSalesGTMarketPrice(goodsSkuDetail);
            log.info("GoodsServiceImpl#updateSalePrice goodsSkuDetails:{}", (Object)JSON.toJSONString((Object)goodsSkuDetails));
            if (goodsSkuDetails.size() > 0) {
                log.info("\u8be5\u5546\u54c1\u89c4\u683c\u552e\u4ef7\u5927\u4e8e\u540a\u724c\u4ef7");
                failed.add(this.transGood2Update(good1, "\u8be5\u5546\u54c1\u89c4\u683c\u552e\u4ef7\u5927\u4e8e\u540a\u724c\u4ef7"));
                continue;
            }
            Goods goodChange = new Goods();
            goodChange.setId(good1.getId());
            goodChange.setSalePrice(good.getSalePrice());
            int j = this.goodsMapper.updateSalesByGoodSelective(goodChange);
            if (j == 0 && !good1.getSalePrice().setScale(0, 4).equals(good.getSalePrice().setScale(0, 4))) {
                log.info("\u8be5\u5546\u54c1\u552e\u4ef7\u9ad8\u4e8e\u540a\u724c\u4ef7");
                failed.add(this.transGood2Update(good1, "\u8be5\u5546\u54c1\u552e\u4ef7\u9ad8\u4e8e\u540a\u724c\u4ef7"));
                continue;
            }
            int i = this.goodsSkuDetailMapper.updateByGoodsIdSelective(goodsSkuDetail);
            List goodsSkuDetailsUpdated = this.goodsSkuDetailMapper.selectByGoodsId(good.getId());
            log.info("GoodsServiceImpl#updateSalePrice#scheduledThreadPoolExecutor goodsSkuDetailsUpdated:{}", (Object)JSON.toJSONString((Object)goodsSkuDetailsUpdated));
            for (GoodsSkuDetail goodsSkuDetail1 : goodsSkuDetailsUpdated) {
                this.scheduledThreadPoolExecutor.execute(() -> {
                    log.info("GoodsServiceImpl#updateSalePrice#scheduledThreadPoolExecutor goodsSkuDetail1:{}", (Object)JSON.toJSONString((Object)goodsSkuDetail1));
                    Goods goods1 = this.goodsMapper.selectById(good.getId());
                    GoodsSkuLogPO goodsSkuLogPO = new GoodsSkuLogPO();
                    goodsSkuLogPO.setGmtCreate(new Date());
                    goodsSkuLogPO.setUserCreate(good.getNickName());
                    goodsSkuLogPO.setUserAccount(good.getAccountCode());
                    goodsSkuLogPO.setGoodsId(good.getId());
                    goodsSkuLogPO.setGoodsSkuDetailId(goodsSkuDetail1.getId());
                    goodsSkuLogPO.setGoodsNo(goods1.getGoodsNo());
                    goodsSkuLogPO.setSkuNo(goodsSkuDetail1.getSkuNo());
                    goodsSkuLogPO.setNewMarketPrice(good.getMarketPrice());
                    goodsSkuLogPO.setNewSalesPrice(good.getSalePrice());
                    goodsSkuLogPO.setMerchantId(good.getMerchantId());
                    this.goodsSkuLogPOMapper.insertSelective(goodsSkuLogPO);
                });
            }
        }
        HashMap<String, ArrayList<UpdateSalesEntity>> resultMap = new HashMap<String, ArrayList<UpdateSalesEntity>>();
        resultMap.put("failed", failed);
        return RestResult.success(resultMap);
    }

    public UpdateSalesEntity transGood2Update(Goods good, String msg) {
        UpdateSalesEntity faildMsg = new UpdateSalesEntity();
        if (good != null) {
            faildMsg.setId(good.getId());
            faildMsg.setGoodsName(good.getGoodsName());
        }
        faildMsg.setFailedMsg(msg);
        return faildMsg;
    }

    public List<Goods> addCategoryName(List<Goods> list) {
        for (Goods goods : list) {
            List goodsClassifies = this.goodsClassifyMapper.selectByGoodsId(goods.getId());
            for (GoodsClassify gc : goodsClassifies) {
                if (gc.getPid() != 0) {
                    goods.setSecondCategoryName(gc.getName());
                    continue;
                }
                goods.setFirstCategoryName(gc.getName());
            }
        }
        return list;
    }

    public PageInfo<GoodsCopyVO> selectGoodsListByChildSync(GoodsCopyVO goods) throws Exception {
        Integer merchantId = goods.getMerchantId();
        Integer mainMallMerchantIdByMerchantId = this.companyBrandRelationService.getMainMallMerchantIdByMerchantId(merchantId);
        if (mainMallMerchantIdByMerchantId == null) {
            throw new Exception("\u5f53\u524d\u5546\u6237\u6ca1\u6709\u4e3b\u5546\u57ce\u4fe1\u606f!");
        }
        goods.setChildMerchantId(merchantId);
        goods.setMerchantId(mainMallMerchantIdByMerchantId);
        PageHelper.startPage((int)goods.getPageIndex(), (int)goods.getPageSize());
        List goods1 = this.goodsMapper.selectGoodsListByChildSync(goods);
        PageInfo pageInfo = new PageInfo(goods1);
        List list = pageInfo.getList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List<GoodsCopyVO> goodsPackage = this.addCategoryNameNew(list);
            pageInfo.setList(goodsPackage);
        }
        return pageInfo;
    }

    private List<GoodsCopyVO> addCategoryNameNew(List<GoodsCopyVO> list) {
        for (Goods goods : list) {
            List goodsClassifies = this.goodsClassifyMapper.selectByGoodsId(goods.getId());
            for (GoodsClassify gc : goodsClassifies) {
                if (gc.getPid() != 0) {
                    goods.setSecondCategoryName(gc.getName());
                    continue;
                }
                goods.setFirstCategoryName(gc.getName());
            }
        }
        return list;
    }
}

