/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsClassifyService;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class GoodsClassifyServiceImpl
implements GoodsClassifyService {
    @Autowired
    private GoodsClassifyMapper goodsClassifyMapper;
    @Autowired
    private GoodsClassifyCustomMapper goodsClassifyCustomMapper;

    public GoodsClassify[] findByAll(Integer merchantId) {
        Example example = new Example(GoodsClassify.class);
        example.orderBy("sort").desc();
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        List goodsClassifies = this.goodsClassifyMapper.selectByExample((Object)example);
        return goodsClassifies.toArray(new GoodsClassify[0]);
    }

    public List<GoodsClassify> selectListByPid(Integer merchantId, Integer id) {
        Example example = new Example(GoodsClassify.class);
        example.createCriteria().andEqualTo("pid", (Object)id).andEqualTo("merchantId", (Object)merchantId);
        return this.goodsClassifyMapper.selectByExample((Object)example);
    }

    public GoodsClassify add(GoodsClassify goodsClassify) {
        InputValidator.checkLengthRange((Object)goodsClassify.getName(), (int)0, (int)20, (String)"\u5206\u7c7b\u540d\u79f0");
        InputValidator.checkLengthRange((Object)goodsClassify.getCoding(), (int)0, (int)20, (String)"\u7f16\u7801");
        InputValidator.checkNumber((Integer)1, (Integer)10000, (Integer)goodsClassify.getSort(), (String)"\u6392\u5e8f\u503c");
        if (InputValidator.countChinese((String)goodsClassify.getCoding()) > 0) {
            throw new MallAdminException("\u5206\u7c7b\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u4e2d\u6587");
        }
        if (goodsClassify.getPid() != 0) {
            try {
                InputValidator.checkEmpty((Object)goodsClassify.getPic(), (String)"\u5206\u7c7b\u56fe\u7247");
            }
            catch (Exception e) {
                throw new MallAdminException(e.getMessage());
            }
            GoodsClassify classify = (GoodsClassify)this.goodsClassifyMapper.selectByPrimaryKey((Object)goodsClassify.getPid());
            if (classify.getPid() != 0) {
                throw new MallAdminException("\u5206\u7c7b\u6700\u591a\u4e3a\u4e8c\u7ea7\u5206\u7c7b");
            }
        }
        Example example = new Example(GoodsClassify.class);
        example.createCriteria().andEqualTo("name", (Object)goodsClassify.getName()).andEqualTo("merchantId", (Object)goodsClassify.getMerchantId());
        List goodsClassifyList = this.goodsClassifyMapper.selectByExample((Object)example);
        if (goodsClassifyList.size() > 0) {
            throw new MallAdminException("\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        Example example2 = new Example(GoodsClassify.class);
        example2.createCriteria().andEqualTo("coding", (Object)goodsClassify.getCoding()).andEqualTo("merchantId", (Object)goodsClassify.getMerchantId());
        List goodsClassifyList2 = this.goodsClassifyMapper.selectByExample((Object)example2);
        if (goodsClassifyList2.size() > 0) {
            throw new MallAdminException("\u5206\u7c7b\u7f16\u7801\u91cd\u590d");
        }
        goodsClassify.setGmtCreate(new Date());
        int insert = this.goodsClassifyMapper.insertSelective((Object)goodsClassify);
        return goodsClassify;
    }

    public int update(GoodsClassify goodsClassify) {
        InputValidator.checkLengthRange((Object)goodsClassify.getName(), (int)0, (int)20, (String)"\u5206\u7c7b\u540d\u79f0");
        InputValidator.checkLengthRange((Object)goodsClassify.getCoding(), (int)0, (int)20, (String)"\u7f16\u7801");
        InputValidator.checkNumber((Integer)1, (Integer)10000, (Integer)goodsClassify.getSort(), (String)"\u6392\u5e8f\u503c");
        if (InputValidator.countChinese((String)goodsClassify.getCoding()) > 0) {
            throw new MallAdminException("\u5206\u7c7b\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u4e2d\u6587");
        }
        if (goodsClassify.getPid() != 0) {
            InputValidator.checkEmpty((Object)goodsClassify.getPic(), (String)"\u5206\u7c7b\u56fe\u7247");
        }
        Example example = new Example(GoodsClassify.class);
        example.createCriteria().andEqualTo("name", (Object)goodsClassify.getName()).andEqualTo("merchantId", (Object)goodsClassify.getMerchantId()).andNotEqualTo("id", (Object)goodsClassify.getId());
        List goodsClassifyList = this.goodsClassifyMapper.selectByExample((Object)example);
        if (goodsClassifyList.size() > 0) {
            throw new MallAdminException("\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        goodsClassify.setGmtModified(new Date());
        return this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)goodsClassify);
    }

    public int delete(Integer merchantId, GoodsClassify goodsClassify) {
        Integer integer;
        GoodsClassify classify = (GoodsClassify)this.goodsClassifyMapper.selectByPrimaryKey((Object)goodsClassify.getId());
        if (classify.getPid() == 0) {
            Example example = new Example(GoodsClassify.class);
            example.createCriteria().andEqualTo("pid", (Object)goodsClassify.getId());
            List classifyList = this.goodsClassifyMapper.selectByExample((Object)example);
            if (classifyList.size() > 0) {
                throw new MallAdminException("\u8bf7\u5148\u5220\u9664\u4e8c\u7ea7\u5206\u7c7b");
            }
        }
        if ((integer = this.goodsClassifyCustomMapper.selectCountGoodsByclassifyId(goodsClassify.getId(), merchantId)) > 0) {
            throw new MallAdminException("\u5206\u7c7b\u4e0b\u8fd8\u6709\u5546\u54c1\uff0c\u5220\u9664\u5931\u8d25");
        }
        return this.goodsClassifyMapper.deleteByPrimaryKey((Object)goodsClassify.getId());
    }
}

