/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.OrderRefundAuditStatusEnum;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.excel.ExcelHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"refund-orders"})
public class RefundOrderController {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderController.class);
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Page
    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, RefundOrder refundOrder) {
        refundOrder.setMerchantId(merchantId);
        List list = this.refundOrderService.findByCondition((Serializable)refundOrder);
        return new PageInfo(list);
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id, @RequestBody RefundOrder refundOrder) {
        refundOrder.setMerchantId(merchantId);
        int result = 0;
        try {
            log.info("\u66f4\u65b0\u552e\u540e\u4fe1\u606f\u5165\u53c2:{}", JSON.toJSON((Object)refundOrder));
            result = this.refundOrderService.update((Serializable)refundOrder);
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u552e\u540e\u4fe1\u606f\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        return result < 0 ? RestResult.fail() : RestResult.success();
    }

    @GetMapping(value={"{id}"})
    public RefundOrder findById(@PathVariable(value="id") Integer id) {
        return (RefundOrder)this.refundOrderService.findById(id);
    }

    @PutMapping(value={"refund/{id}"})
    public void updateRefundStatus(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        try {
            int n = this.refundOrderService.updateRefundStatus(merchantId, id);
        }
        catch (Exception e) {
            log.warn("\u786e\u8ba4\u9000\u6b3e\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
    }

    @GetMapping(value={"orderRefundExport"})
    public void refundOrderExport(String key, RefundOrder refundOrder, HttpServletResponse res) {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u552e\u540e\u8ba2\u5355orderStatisticalExport\u63a5\u53e3 key:{},order:{},res:{}", new Object[]{key, JSON.toJSON((Object)refundOrder), res});
        refundOrder.setMerchantId(refundOrder.getMerchantId());
        List list = this.refundOrderService.findByCondition((Serializable)refundOrder);
        block7: for (RefundOrder order : list) {
            switch (Objects.requireNonNull(OrderRefundAuditStatusEnum.getByType((Byte)order.getAuditStatus()))) {
                case STAND: {
                    order.setAuditStatusString(OrderRefundAuditStatusEnum.STAND.getMsg());
                    continue block7;
                }
                case SUCCESS: {
                    order.setAuditStatusString(OrderRefundAuditStatusEnum.SUCCESS.getMsg());
                    continue block7;
                }
                case FAILED: {
                    order.setAuditStatusString(OrderRefundAuditStatusEnum.FAILED.getMsg());
                    continue block7;
                }
            }
            order.setAuditStatusString("\u72b6\u6001\u4e3a\u7a7a");
        }
        String[] heads = new String[]{"\u8ba2\u5355\u7f16\u53f7", "\u8d2d\u4e70\u4eba", "\u624b\u673a\u53f7", "\u9000\u6b3e\u91d1\u989d", "\u9000\u6b3e\u539f\u56e0", "\u9000\u6b3e\u5355\u53f7", "\u7533\u8bf7\u65f6\u95f4", "\u5ba1\u6838\u4eba", "\u5ba1\u6838\u65f6\u95f4", "\u5ba1\u6838\u53cd\u9988", "\u5b9e\u9645\u9000\u6b3e\u91d1\u989d", "\u5b9e\u9645\u9000\u56de\u79ef\u5206", "\u72b6\u6001"};
        String[] fields = new String[]{"orderNo", "userName", "buyerPhone", "itemAmout", "refundReason", "refundNo", "refundAt", "auditor", "auditAt", "auditReback", "refundAmount", "refundIntegral", "auditStatusString"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, RefundOrder.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u552e\u540e\u8ba2\u5355\u7edf\u8ba1.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

