/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.Material;
import com.wmeimob.fastboot.bizvane.entity.PicGroup;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.MaterialsService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/materialCenter"})
public class MaterialCenterController {
    private static final Logger log = LoggerFactory.getLogger(MaterialCenterController.class);
    @Autowired
    private MaterialsService materialsService;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;

    @Page
    @PostMapping(value={"/showPic"})
    public ResponseData showPics(@RequestBody Material material) {
        ResponseData responseData = new ResponseData();
        log.info("\u7d20\u6750\u4e2d\u5fc3\u67e5\u8be2\u56fe\u7247,material:[{}]", (Object)JSONObject.toJSONString((Object)material));
        Integer pageIndex = material.getPageIndex();
        Integer pageSize = material.getPageSize();
        log.info("pageIndex:{},pageSize:{}", (Object)pageIndex, (Object)pageSize);
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List material1 = this.materialsService.selectMaterialList(material);
        PageInfo pageInfo = new PageInfo(material1);
        responseData.setCode(0);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    @RequestMapping(value={"/showGroups"})
    public ResponseData showGroups(@RequestBody Material material) {
        ResponseData responseData = new ResponseData();
        log.info("\u7d20\u6750\u4e2d\u5fc3\u67e5\u8be2\u5206\u7ec4,merchantId:[{}]", (Object)JSONObject.toJSONString((Object)material));
        PicGroup picGroups = this.materialsService.selectAllGroup(material.getMerchantId());
        responseData.setCode(0);
        responseData.setData((Object)picGroups);
        return responseData;
    }

    @RequestMapping(value={"/mkGroupForPics"})
    public RestResult mkGroup4Pics(@RequestBody PicGroup picGroup) {
        log.info("\u6dfb\u52a0\u7d20\u6750\u5206\u7ec4\uff1a{}", (Object)JSONObject.toJSONString((Object)picGroup));
        this.materialsService.mkGroup4Pics(picGroup);
        return RestResult.success();
    }

    @RequestMapping(value={"/uploadPics"})
    public RestResult uploadPics(@RequestBody Material material) {
        log.info("\u4e0a\u4f20\u56fe\u7247\uff1a{}", (Object)JSONObject.toJSONString((Object)material.getImgs()));
        this.materialsService.uploadPics(material);
        return RestResult.success();
    }

    @RequestMapping(value={"/updatePicGroup"})
    public RestResult updatePicGroup(@RequestBody Material material) {
        log.info("\u66f4\u6539ids\u56fe\u7247\u5206\u7ec4\uff1a{}", (Object)JSONObject.toJSONString((Object)material.getImgIds()));
        this.materialsService.updatePicGroup(material);
        return RestResult.success();
    }

    @RequestMapping(value={"/deletePics"})
    public RestResult deletePics(@RequestBody Material material) {
        log.info("\u5220\u9664ids\u56fe\u7247\uff1a{}", (Object)JSONObject.toJSONString((Object)material.getImgIds()));
        this.materialsService.deletePics(material);
        return RestResult.success();
    }

    @RequestMapping(value={"/deletePicGroups"})
    public RestResult deltePicGroups(@RequestBody Material material) {
        log.info("\u5220\u9664ids\u56fe\u7247\u5206\u7ec4\uff1a{}", (Object)JSONObject.toJSONString((Object)material.getImgGroup()));
        this.materialsService.deletePicGroups(material);
        return RestResult.success();
    }

    @RequestMapping(value={"/updateGroupName"})
    public RestResult updateGroupName(@RequestBody Material material) {
        log.info("\u66f4\u6539\u5206\u7ec4\u540d\u79f0\uff1a{}", (Object)JSONObject.toJSONString((Object)material));
        this.materialsService.updateGroupName(material);
        return RestResult.success();
    }

    @RequestMapping(value={"/updatePicName"})
    public RestResult updatePicName(@RequestBody Material material) {
        log.info("\u66f4\u6539\u56fe\u7247\u540d\u79f0\uff1a{}", (Object)JSONObject.toJSONString((Object)material));
        this.materialsService.updatePicName(material);
        return RestResult.success();
    }
}

