/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.MallLogs;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.MallLogsService;
import com.wmeimob.fastboot.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"logs"})
public class MallAdminController {
    private static final Logger log = LoggerFactory.getLogger(MallAdminController.class);
    @Autowired
    private MallLogsService mallLogsService;
    @Autowired
    private BizvaneInterface bizvaneInterface;

    @GetMapping(value={"offline/{logsId}"})
    public void pushOffline(@PathVariable(value="logsId") String logsId) {
        MallLogs mallLogs;
        log.info("\u5165\u53c2logsId:[{}]", (Object)logsId);
        if (!StringUtils.isEmpty((Object)logsId) && (mallLogs = this.mallLogsService.findById(Integer.parseInt(logsId))) != null) {
            String logType = mallLogs.getLogType();
            String logContent = mallLogs.getLogContent();
            switch (logType) {
                case "0": {
                    Orders orders = (Orders)JSON.parseObject((String)logContent, Orders.class);
                    this.bizvaneInterface.notifyPaidOrderInfoOffLine(orders);
                    break;
                }
                case "1": {
                    Orders orders = (Orders)JSON.parseObject((String)logContent, Orders.class);
                    this.bizvaneInterface.notifySendOrderInfo(orders);
                    break;
                }
                case "2": {
                    RefundOrder refundOrder = (RefundOrder)JSON.parseObject((String)logContent, RefundOrder.class);
                    this.bizvaneInterface.notifyRefundOrderInfo(refundOrder);
                    break;
                }
                default: {
                    RefundOrder refundOrder = (RefundOrder)JSON.parseObject((String)logContent, RefundOrder.class);
                    this.bizvaneInterface.notifyRefundGoodsInfo(refundOrder);
                }
            }
        }
    }
}

