/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.IntegralClassify;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.mapper.IntegralClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsMapper;
import com.wmeimob.fastboot.bizvane.service.IntegralClassifyService;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralClassifyServiceImpl
implements IntegralClassifyService {
    @Autowired
    private IntegralClassifyMapper integralClassifyMapper;
    @Autowired
    private IntegralGoodsMapper integralGoodsMapper;

    public int add(IntegralClassify integralClassify) {
        Example nameExample = new Example(IntegralClassify.class);
        nameExample.createCriteria().andEqualTo("merchantId", (Object)integralClassify.getMerchantId()).andEqualTo("name", (Object)integralClassify.getName());
        List nameList = this.integralClassifyMapper.selectByExample((Object)nameExample);
        if (nameList.size() > 0) {
            throw new CustomException("\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Example noExample = new Example(IntegralClassify.class);
        noExample.createCriteria().andEqualTo("merchantId", (Object)integralClassify.getMerchantId()).andEqualTo("classifyNo", (Object)integralClassify.getClassifyNo());
        List noList = this.integralClassifyMapper.selectByExample((Object)noExample);
        if (noList.size() > 0) {
            throw new CustomException("\u5206\u7c7b\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        integralClassify.setGmtCreate(new Date());
        int num = this.integralClassifyMapper.insert((Object)integralClassify);
        return num;
    }

    public int update(IntegralClassify integralClassify) {
        Example example = new Example(IntegralClassify.class);
        example.createCriteria().andEqualTo("merchantId", (Object)integralClassify.getMerchantId()).andEqualTo("name", (Object)integralClassify.getName()).andNotEqualTo("id", (Object)integralClassify.getId());
        List list = this.integralClassifyMapper.selectByExample((Object)example);
        if (list.size() > 0) {
            throw new CustomException("\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Example noExample = new Example(IntegralClassify.class);
        noExample.createCriteria().andEqualTo("merchantId", (Object)integralClassify.getMerchantId()).andEqualTo("classifyNo", (Object)integralClassify.getClassifyNo()).andNotEqualTo("id", (Object)integralClassify.getId());
        List noList = this.integralClassifyMapper.selectByExample((Object)noExample);
        if (noList.size() > 0) {
            throw new CustomException("\u5206\u7c7b\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        integralClassify.setGmtModified(new Date());
        int num = this.integralClassifyMapper.updateByPrimaryKey((Object)integralClassify);
        return num;
    }

    public int delete(Integer id) {
        IntegralClassify classify = (IntegralClassify)this.integralClassifyMapper.selectByPrimaryKey((Object)id);
        Example example = new Example(IntegralGoods.class);
        example.createCriteria().andEqualTo("merchantId", (Object)classify.getMerchantId()).andEqualTo("valid", (Object)true).andLike("classifyId", "%" + id + "%");
        List list = this.integralGoodsMapper.selectByExample((Object)example);
        if (list.size() > 0) {
            throw new CustomException("\u6b64\u5206\u7c7b\u5df2\u88ab\u5546\u54c1\u4f7f\u7528!");
        }
        int num = this.integralClassifyMapper.deleteByPrimaryKey((Object)id);
        return num;
    }

    public List<IntegralClassify> getList(Integer merchantId) {
        Example example = new Example(IntegralClassify.class);
        example.orderBy("sort").asc();
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        return this.integralClassifyMapper.selectByExample((Object)example);
    }
}

