/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.controller.OrderController;
import com.wmeimob.fastboot.bizvane.dto.StatisticalDTO;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.enums.ShippingModeEnum;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.wmeimob.fastboot.bizvane.utils.ConvertDateUtils;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.vo.OrdersExcelRes;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.excel.ExcelHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"orders"})
public class OrderController {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @Resource
    private OrdersService ordersService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersService;
    @Resource
    private OrdersServiceImpl ordersServiceImpl;
    @Autowired
    private MarketActivityService marketActivityService;

    @Page
    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, Orders orders) {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u8ba2\u5355list\u63a5\u53e3 param:{}", JSON.toJSON((Object)orders));
        orders.setMerchantId(merchantId);
        List list = this.ordersService.findByCondition((Serializable)orders);
        return new PageInfo(list);
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Orders orders, @PathVariable Integer id) {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u8ba2\u5355update\u63a5\u53e3 merchantID:{},order:{},id:{}", new Object[]{merchantId, JSON.toJSON((Object)orders), id});
        orders.setMerchantId(merchantId);
        int i = 0;
        try {
            i = this.ordersService.update((Serializable)orders);
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        return i < 1 ? RestResult.fail() : RestResult.success();
    }

    @GetMapping(value={"/judgeSend"})
    public Map judgeSend(@RequestParam(value="id") Integer id) {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u8ba2\u5355judgeSend\u63a5\u53e3 id:{}", (Object)id);
        return this.ordersServiceImpl.judgeSend(id);
    }

    @GetMapping(value={"{id}"})
    public Orders getOrderById(@PathVariable(value="id") Integer id) {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u8ba2\u5355getOrderById\u63a5\u53e3 id:{}", (Object)id);
        return (Orders)this.commonOrdersService.findById(id);
    }

    @GetMapping(value={"commissionStatisticalList"})
    public PageInfo commissionStatisticalList(@RequestHeader(value="merchantId") Integer merchantId, Orders orders) {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u8ba2\u5355commissionStatisticalList\u63a5\u53e3 mechantID:{},order:{}", (Object)merchantId, JSON.toJSON((Object)orders));
        orders.setMerchantId(merchantId);
        DateUtil dateUtil = new DateUtil();
        String currentTime = dateUtil.getCurrentTime();
        String strDateByDay = DateUtil.getStrDateByDay((String)"30");
        if (orders.getBeginDate() == null) {
            orders.setBeginDate(DateUtil.stringToDate((String)strDateByDay, (String)"yyyy-MM-dd"));
        }
        if (orders.getEndDate() == null) {
            orders.setEndDate(DateUtil.stringToDate((String)currentTime, (String)"yyyy-MM-dd"));
        }
        Date begin = ConvertDateUtils.getConvertDate((Date)orders.getBeginDate(), (String)" 00:00:00");
        Date end = ConvertDateUtils.getConvertDate((Date)orders.getEndDate(), (String)" 23:59:59");
        orders.setBeginDate(begin);
        orders.setEndDate(end);
        return this.ordersService.commissionStatisticalList(orders, Boolean.TRUE);
    }

    @GetMapping(value={"orderStatisticalList"})
    public PageInfo orderStatisticalList(@RequestHeader(value="merchantId") Integer merchantId, Orders orders) {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u8ba2\u5355orderStatisticalList\u63a5\u53e3 merchantID:{},order:{}", (Object)merchantId, JSON.toJSON((Object)orders));
        orders.setMerchantId(merchantId);
        return this.ordersService.orderStatisticalList(orders, Boolean.TRUE);
    }

    @GetMapping(value={"export-key"})
    public String export() {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u8ba2\u5355export\u63a5\u53e3 ");
        String key = UUID.randomUUID().toString();
        this.stringRedisTemplate.opsForValue().set((Object)("download_key:" + key), (Object)"all", 30L, TimeUnit.SECONDS);
        return key;
    }

    @GetMapping(value={"orderStatisticalExport"})
    public void orderStatisticalExport(String key, Orders orders, HttpServletResponse res) {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u8ba2\u5355orderStatisticalExport\u63a5\u53e3 key:{},order:{},res:{}", new Object[]{JSON.toJSON((Object)key), JSON.toJSON((Object)orders), res});
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)("download_key:" + key));
        if (value == null) {
            return;
        }
        orders.setMerchantId(orders.getMerchantId());
        List list = this.ordersService.orderStatisticalList(orders, Boolean.FALSE).getList();
        String[] heads = new String[]{"\u65e5\u671f", "\u4e0b\u5355\u4ef6\u6570", "\u4e0b\u5355\u8ba2\u5355\u6570", "\u4e0b\u5355\u91d1\u989d", "\u652f\u4ed8\u4ef6\u6570", "\u652f\u4ed8\u8ba2\u5355\u6570", "\u652f\u4ed8\u91d1\u989d", "\u9000\u6b3e\u4ef6\u6570", "\u9000\u6b3e\u5355\u6570", "\u9000\u6b3e\u91d1\u989d", "\u6536\u85cf\u91cf", "\u5ba2\u5355\u91cf", "\u5e73\u5747\u6210\u4ea4\u4ef6\u6570"};
        String[] fields = new String[]{"createTime", "quantity", "countOrder", "price", "payQuantity", "countPayOrder", "payAmount", "refundQuantity", "countRefundOrder", "refundPrice", "countCollect", "avgPrice", "avgQuantity"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, StatisticalDTO.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u8ba2\u5355\u7edf\u8ba1.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping(value={"commissionStatisticalExport"})
    public void commissionStatisticalExport(String key, Orders orders, HttpServletResponse res) {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u8ba2\u5355commissionStatisticalExport\u63a5\u53e3 key:{},orders:{},res:{}", new Object[]{JSON.toJSON((Object)key), JSON.toJSON((Object)orders), res});
        orders.setMerchantId(orders.getMerchantId());
        List list = this.ordersService.commissionStatisticalList(orders, Boolean.FALSE).getList();
        String[] heads = new String[]{"\u65e5\u671f", "\u6210\u4ea4\u4ef6\u6570", "\u6210\u4ea4\u8ba2\u5355\u6570", "\u6210\u4ea4\u91d1\u989d", "\u9000\u6b3e\u4ef6\u6570", "\u9000\u6b3e\u5355\u6570", "\u9000\u6b3e\u91d1\u989d", "\u4f63\u91d1\u91d1\u989d"};
        String[] fields = new String[]{"createTime", "quantity", "countOrder", "price", "refundQuantity", "countRefundOrder", "refundPrice", "commission"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)list, (String[])heads, (String[])fields, StatisticalDTO.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5206\u9500\u7edf\u8ba1.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping(value={"orderListExport"})
    public void orderListExport(String key, Orders orders, HttpServletResponse res) {
        log.info("\u5fae\u5546\u57cepc\u4e2d\u53f0\u8ba2\u5355orderListExport\u63a5\u53e3 orders:{},res:{}", JSON.toJSON((Object)orders), (Object)res);
        orders.setMerchantId(orders.getMerchantId());
        List list = this.ordersService.findByCondition((Serializable)orders);
        List result = this.flatExcelData(list);
        String[] heads = new String[]{"\u5e8f\u53f7", "\u4f1a\u5458\u5361\u53f7", "\u4f1a\u5458\u59d3\u540d", "\u4f1a\u5458\u7b49\u7ea7", "\u4f1a\u5458\u624b\u673a\u53f7", "\u8ba2\u5355\u65f6\u95f4", "\u8ba2\u5355\u7f16\u53f7", "\u8ba2\u5355\u7c7b\u578b", "\u5546\u54c1\u7f16\u53f7", "\u5546\u54c1\u6761\u7801", "\u5546\u54c1\u540d\u79f0", "\u89c4\u683c", "\u552e\u4ef7", "\u540a\u724c\u4ef7", "\u5546\u54c1\u6570\u91cf", "\u5546\u54c1\u603b\u989d", "\u8ba2\u5355\u603b\u4ef7", "\u8ba2\u5355\u72b6\u6001", "\u652f\u4ed8\u65b9\u5f0f", "\u6536\u8d27\u4eba\u59d3\u540d", "\u6536\u8d27\u4eba\u624b\u673a\u53f7", "\u6536\u8d27\u4eba\u7701\u4efd", "\u6536\u8d27\u4eba\u57ce\u5e02", "\u6536\u8d27\u4eba\u533a\u57df", "\u6536\u8d27\u4eba\u8be6\u7ec6\u5730\u5740", "\u914d\u9001\u65b9\u5f0f", "\u5feb\u9012\u516c\u53f8", "\u5feb\u9012\u5355\u53f7", "\u5907\u6ce8"};
        String[] fields = new String[]{"serialNo", "offlineCardNo", "vipName", "memberLevel", "mobile", "gmtCreate", "orderNo", "ordersActivityType", "goodsNo", "skuNo", "goodsName", "goodsSkuName", "salePrice", "marketPrice", "saleQuantity", "goosAmount", "orderAmount", "outStatus", "payType", "shippingName", "shippingMobile", "shippingProvince", "shippingCity", "shippingDistrict", "shippingAddress", "shippingMode", "shippingVendor", "shippingNo", "userComments"};
        try {
            HSSFWorkbook hssfWorkbook = ExcelHelper.exportFromList((List)result, (String[])heads, (String[])fields, OrdersExcelRes.class);
            res.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u8ba2\u5355\u62a5\u8868.xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)res.getOutputStream());
            res.getOutputStream().close();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void findOrderStatus(Orders o) {
        if (o.getOrderStatus().equals((Object)OrdersStatusEnum.FAIL)) {
            o.setOutStatus("\u5df2\u5173\u95ed");
        }
        if (o.getPayStatus().equals((Object)PayStatusEnum.UN_PAY) && o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE)) {
            o.setOutStatus("\u5f85\u652f\u4ed8");
        }
        if (o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && o.getPayStatus().equals((Object)PayStatusEnum.SUCCESS) && o.getLogisticsStatus().equals((Object)LogisticsStatusEnum.UN_SEND)) {
            o.setOutStatus("\u5f85\u53d1\u8d27");
        }
        if (o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && o.getPayStatus().equals((Object)PayStatusEnum.SUCCESS) && o.getLogisticsStatus().equals((Object)LogisticsStatusEnum.SEND)) {
            o.setOutStatus("\u5df2\u53d1\u8d27");
        }
        if (o.getOrderStatus().equals((Object)OrdersStatusEnum.TRADE) && o.getPayStatus().equals((Object)PayStatusEnum.SUCCESS) && o.getLogisticsStatus().equals((Object)LogisticsStatusEnum.RECEIVED)) {
            o.setOutStatus("\u5df2\u6536\u8d27");
        }
        if (o.getOrderStatus().equals((Object)OrdersStatusEnum.SUCCESS)) {
            o.setOutStatus("\u4ea4\u6613\u6210\u529f" + (o.getIsComment() == false ? "(\u5f85\u8bc4\u4ef7)" : ""));
        }
    }

    private void findOrderActivityType(Orders o) {
        if (o.getOrdersActivityType().equals(OrderActivityTypeEnum.KJ.getCode().toString())) {
            o.setOrdersActivityType(OrderActivityTypeEnum.KJ.getDesc());
        } else if (o.getOrdersActivityType().equals(OrderActivityTypeEnum.PIT.getCode().toString())) {
            o.setOrdersActivityType(OrderActivityTypeEnum.PIT.getDesc());
        } else if (o.getOrdersActivityType().equals(OrderActivityTypeEnum.ZB.getCode().toString())) {
            o.setOrdersActivityType(OrderActivityTypeEnum.ZB.getDesc());
        } else {
            o.setOrdersActivityType(OrderActivityTypeEnum.PT.getDesc());
        }
    }

    private List<OrdersExcelRes> flatExcelData(List<Orders> list) {
        log.info("\u5e73\u94fa\u6570\u636e\u5904\u7406\u5165\u53c2:[{}]", JSON.toJSON(list));
        ArrayList<OrdersExcelRes> res = new ArrayList<OrdersExcelRes>();
        int flag = 1;
        for (Orders orders : list) {
            this.findOrderStatus(orders);
            this.findOrderActivityType(orders);
            String date = DateFormatUtils.format((Date)orders.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss");
            for (OrderItems item : orders.getItems()) {
                OrdersExcelRes oer = new OrdersExcelRes();
                oer.setSerialNo(Integer.valueOf(flag));
                RefundStatus refundStatus = item.getRefundStatus();
                BeanUtils.copyProperties((Object)orders, (Object)oer);
                switch (1.$SwitchMap$com$wmeimob$fastboot$bizvane$enums$RefundStatus[refundStatus.ordinal()]) {
                    case 1: {
                        oer.setOutStatus("\u9000\u6b3e\u6210\u529f");
                        break;
                    }
                    case 2: {
                        oer.setOutStatus("\u9000\u6b3e\u5931\u8d25");
                        break;
                    }
                    case 3: {
                        oer.setOutStatus("\u9000\u6b3e\u4e2d");
                        break;
                    }
                    default: {
                        oer.setOutStatus(orders.getOutStatus());
                    }
                }
                oer.setGoodsNo(item.getGoodsNo());
                oer.setGoodsSkuName(item.getGoodsSkuName());
                oer.setSkuNo(item.getGoodsSkuNo());
                oer.setGoodsName(item.getGoodsName());
                oer.setMarketPrice(item.getMarketPrice());
                oer.setSalePrice(item.getSalePrice());
                oer.setMemberLevel(orders.getMemberLevelName());
                if (!Integer.valueOf(ShippingModeEnum.LOGISTICS.getCode()).equals(orders.getShippingMode())) {
                    oer.setShippingAddress(orders.getPickStoreName());
                    oer.setShippingName(orders.getUserName());
                    oer.setShippingMobile(orders.getMobile());
                }
                oer.setShippingMode(orders.getShippingMode().equals(0) ? "\u9001\u8d27\u4e0a\u95e8" : "\u95e8\u5e97\u81ea\u63d0");
                oer.setGoosAmount(this.goodsAmountHandler(orders, item));
                oer.setGmtCreate(date);
                oer.setPayType("\u5fae\u4fe1\u652f\u4ed8");
                oer.setMobile(orders.getMobile());
                oer.setSaleQuantity(item.getSaleQuantity());
                ++flag;
                res.add(oer);
            }
        }
        log.info("\u5e73\u94fa\u6570\u636e\u5904\u7406\u5b8c\u6210:[{}]", JSON.toJSON(res));
        return res;
    }

    private String goodsAmountHandler(Orders orders, OrderItems item) {
        log.info("\u5904\u7406\u5546\u54c1\u603b\u989d\u8fdb\u5165");
        switch (orders.getPriceSystem()) {
            case 0: {
                return item.getWepayAmount() + "";
            }
            case 1: {
                return item.getPoints() + "+ " + item.getWepayAmount();
            }
            case 2: {
                return item.getPoints() + "";
            }
        }
        throw new MallAdminException("\u53c2\u6570\u9519\u8bef\uff0c\u4ef7\u683c\u4f53\u7cfb\u4e0d\u5b58\u5728\u5176\u4ed6\u60c5\u51b5");
    }
}

