/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.entity.IndexSubjectImg;
import com.wmeimob.fastboot.bizvane.enums.ModuleType;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.IndexSubjectService;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/index"})
public class IndexSubjectController {
    private static final Logger log = LoggerFactory.getLogger(IndexSubjectController.class);
    @Autowired
    private IndexSubjectService indexSubjectService;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;

    @RequestMapping(value={"/{moduleType}"}, method={RequestMethod.POST, RequestMethod.PUT})
    public RestResult saveIndexSubject(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="moduleType") Integer moduleType, @RequestBody JSONObject jsonObject) {
        try {
            this.indexSubjectService.add(merchantId, moduleType, jsonObject);
        }
        catch (Exception e) {
            log.warn("\u4fdd\u5b58\u5e97\u94fa\u88c5\u4fee\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallAdminException(e.getMessage());
        }
        return RestResult.success();
    }

    @GetMapping(value={"/{moduleType}"})
    public PageInfo getIndexSubjectList(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="moduleType") Integer moduleType) {
        InputValidator.checkEmpty((Object)moduleType, (String)"\u53c2\u6570");
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        IndexSubjectImg indexSubjectImg = new IndexSubjectImg();
        indexSubjectImg.setMerchantId(merchantId);
        indexSubjectImg.setModuleType(moduleType);
        List list = null;
        if (ModuleType.SUBJECT_SETTINGS.getValue().equals(moduleType)) {
            PageContext.startPage();
            list = this.indexSubjectService.findByCondition(indexSubjectImg);
            new PageInfo(list);
        }
        PageContext.startPage();
        list = this.indexSubjectService.findByCondition(indexSubjectImg);
        if (null != list && !list.isEmpty()) {
            return new PageInfo(list);
        }
        return new PageInfo();
    }

    @GetMapping(value={"onSubject"})
    public List onSubjectList(@RequestHeader(value="merchantId") Integer merchantId) {
        return this.indexSubjectService.findSubListByOn(merchantId);
    }

    @DeleteMapping(value={"/{id}"})
    public RestResult delIndexSubject(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        this.indexSubjectService.delete(merchantId, id);
        return RestResult.success();
    }

    @RequestMapping(value={"/couponList4Mall"})
    public List<CouponDTO> couponDTOList4Mall(CouponDTO dto) {
        Integer brandIdByMerchantId = this.companyBrandRelationService.getBrandIdByMerchantId(dto.getMerchantId());
        dto.setBrandId(brandIdByMerchantId);
        return this.indexSubjectService.couponList4Mall(dto);
    }
}

