/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.GoodsGroup;
import com.wmeimob.fastboot.bizvane.service.GoodsGroupService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goodsGroup"})
public class GoodsGroupController {
    private static final Logger log = LoggerFactory.getLogger(GoodsGroupController.class);
    @Autowired
    private GoodsGroupService goodsGroupService;

    @RequestMapping(value={"/mkGroupForGoods"})
    public RestResult mkGroup4Goods(@RequestBody GoodsGroup goodsGroup) {
        log.info("\u6dfb\u52a0\u5546\u54c1\u5206\u7ec4\uff1a{}", (Object)JSONObject.toJSONString((Object)goodsGroup));
        this.goodsGroupService.mkGroup4Goods(goodsGroup);
        return RestResult.success();
    }

    @RequestMapping(value={"/showGoodsGroups"})
    public ResponseData showGroups(@RequestBody GoodsGroup goodsGroup) {
        ResponseData responseData = new ResponseData();
        Integer pageIndex = goodsGroup.getPageIndex();
        Integer pageSize = goodsGroup.getPageSize();
        log.info("pageIndex:{},pageSize:{}", (Object)pageIndex, (Object)pageSize);
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List goodsGroups = this.goodsGroupService.selectGoodsGroups(goodsGroup);
        PageInfo pageInfo = new PageInfo(goodsGroups);
        responseData.setCode(0);
        responseData.setData((Object)pageInfo);
        log.info("\u67e5\u8be2\u5546\u54c1\u5206\u7ec4\uff1a{}", (Object)JSONObject.toJSONString((Object)pageInfo));
        return responseData;
    }

    @RequestMapping(value={"/updateGoodsGroup"})
    public RestResult updateGoodsGroup(@RequestBody GoodsGroup goodsGroup) {
        log.info("\u66f4\u65b0\u5546\u54c1\u5206\u7ec4\uff1a{}", (Object)JSONObject.toJSONString((Object)goodsGroup.getId()));
        this.goodsGroupService.updateGoodsGroup(goodsGroup);
        return RestResult.success();
    }

    @RequestMapping(value={"/deleteGoodsGroup"})
    public RestResult delteGoodsGroup(@RequestBody GoodsGroup goodsGroup) {
        log.info("\u5220\u9664\u5546\u54c1\u5206\u7ec4\uff1a{}", (Object)JSONObject.toJSONString((Object)goodsGroup.getId()));
        this.goodsGroupService.deleteGoodsGroup(goodsGroup);
        return RestResult.success();
    }
}

