package com.bizvane.basic.feign.model.req.approve;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

@Getter
@Setter
@ApiModel
public class QueryApproveTaskListReqVO {

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("审批流程code")
    private String approveConfigCode;

    @ApiModelProperty("审批任务code")
    private String taskCode;

    @ApiModelProperty("审批业务")
    private String approveBusiness;

    @ApiModelProperty("审批业务名称")
    private String approveBusinessName;

    @ApiModelProperty("审批内容")
    private String approveContent;

    @ApiModelProperty("关联业务ID")
    private String refBusinessId;

    @ApiModelProperty("关联业务值")
    private String refBusinessValue;

    @ApiModelProperty("审批状态（1审核中 2审核通过 3审核拒绝 4审核超时 5审核撤销）")
    private Integer status;

    @ApiModelProperty("申请人id")
    private String applyUserCode;

    @ApiModelProperty("申请人")
    private String applyUserName;

    @ApiModelProperty("申请时间")
    private Date applyTime;

    @ApiModelProperty("过期时间")
    private Date expireTime;
}
