package com.bizvane.basic.feign.feign;

import com.bizvane.basic.feign.model.req.GoodsReq;
import com.bizvane.basic.feign.model.req.TBaseGoodsPageReq;
import com.bizvane.basic.feign.model.vo.TbaseGoodsSkuVo;
import com.bizvane.basic.feign.model.vo.TbaseGoodsVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBaseGoods")
@Api(value = "商品RPC")
public interface TBaseGoodsFeign {

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询商品列表")
    ResponseData<PageInfo<TbaseGoodsVo>> pageList(@RequestBody TBaseGoodsPageReq req);


    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "查询商品列表")
    ResponseData<List<TbaseGoodsVo>> list(@RequestBody TbaseGoodsVo req);

    @RequestMapping(value = "/batchSave", method = RequestMethod.POST)
    @ApiModelProperty("批量添加商品")
    ResponseData<Boolean> batchSave(@RequestBody List<GoodsReq> req);











}
