package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.req.TSysOperationLogPageReq;
import com.bizvane.basic.feign.model.vo.TSysOperationLogVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tSysOperationLog")
@Api(value = "操作日志RPC")
public interface SysOperationLogRpcFeign {

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询列表")
    ResponseData<PageInfo<TSysOperationLogVo>> pageList(@RequestBody TSysOperationLogPageReq req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "保存日志")
    ResponseData<Boolean> save(@RequestBody TSysOperationLogVo req);

}
