package com.bizvane.basic.feign.feign;


import com.bizvane.basic.feign.model.vo.TSysAuthVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tSysAuth")
@Api(value = "权限RPC")
public interface SysAuthRpcFeign {

    @RequestMapping(value = "/getAuthList", method = RequestMethod.POST)
    @ApiOperation(value = "权限列表")
    ResponseData<List<TSysAuthVo>> getAuthList(@RequestBody TSysAuthVo req);

}
