package com.bizvane.basic.feign.feign;

import com.bizvane.basic.feign.model.req.TBaseMenuAuthReq;
import com.bizvane.basic.feign.model.vo.MenuAuthVO;
import com.bizvane.basic.feign.model.vo.TSysMenuVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/tBasicMenu")
@Api(value = "菜单RPC")
public interface BasicMenuRpcFeign {

    @RequestMapping(value = "/getAllMenuAndBtnList", method = RequestMethod.POST)
    @ApiOperation(value = "获取所有菜单列表")
    ResponseData<List<TSysMenuVO>> getAllMenuAndBtnList();


    @RequestMapping(value = "/getMenuAuthByMenuCode", method = RequestMethod.POST)
    @ApiOperation(value = "获取菜单权限列表")
    ResponseData<MenuAuthVO> getMenuAuthByMenuCode(@RequestParam("menuCode") String menuCode);


    @RequestMapping(value = "/getMenuAuthByMenuCodeBatch", method = RequestMethod.POST)
    @ApiOperation(value = "批量获取菜单权限列表")
    ResponseData<MenuAuthVO> getMenuAuthByMenuCodeBatch(@RequestBody TBaseMenuAuthReq tBaseMenuAuthReq);

}
