/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.base.store.client.web;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.common.bean.StaffReqBean;
import com.bizvane.base.store.bean.dto.StaffDTO;
import com.bizvane.base.store.service.inter.IStaffService;
import com.bizvane.base.store.valid.StaffSaveGroup;
import com.bizvane.base.store.valid.StaffUpdateGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/staff"})
@Validated
public class StaffController {
    private static final Logger log = LoggerFactory.getLogger(StaffController.class);
    @Autowired
    private IStaffService iStaffService;

    @RequestMapping(value={"/save"}, method={RequestMethod.POST}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<StaffDTO> save(@RequestBody @Validated(value={StaffSaveGroup.class}) StaffReqBean staffReqBean) {
        log.info("\u4fdd\u5b58\u5bfc\u8d2d\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)staffReqBean));
        ResultBean result = new ResultBean();
        StaffDTO dto = this.iStaffService.save(staffReqBean.getSysCompanyId(), staffReqBean.getStaffCode(), staffReqBean.getStaffName(), staffReqBean.getStaffId(), staffReqBean.getStatus(), staffReqBean.getImgs(), staffReqBean.getPhone(), staffReqBean.getEmail(), staffReqBean.getSex(), staffReqBean.getPosition(), staffReqBean.getCountryCode(), staffReqBean.getCreateUserId(), staffReqBean.getCreateUserName(), staffReqBean.getModifiedUserId(), staffReqBean.getModifiedUserName(), staffReqBean.getWmGuideCode());
        result.setResult((Serializable)dto);
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<StaffDTO> update(@RequestBody @Validated(value={StaffUpdateGroup.class}) StaffReqBean staffReqBean) {
        log.info("\u66f4\u65b0\u5bfc\u8d2d\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)staffReqBean));
        ResultBean result = new ResultBean();
        StaffDTO dto = this.iStaffService.update(staffReqBean.getSysStaffId(), staffReqBean.getStaffName(), staffReqBean.getStaffId(), staffReqBean.getImgs(), staffReqBean.getPhone(), staffReqBean.getEmail(), staffReqBean.getSex(), staffReqBean.getPosition(), staffReqBean.getCountryCode(), staffReqBean.getModifiedUserId(), staffReqBean.getModifiedUserName(), staffReqBean.getWmGuideCode());
        result.setResult((Serializable)dto);
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<Integer> delete(@RequestParam(value="sysStaffId") @NotBlank(message="\u7cfb\u7edf\u5bfc\u8d2did\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7cfb\u7edf\u5bfc\u8d2did\u4e0d\u80fd\u4e3a\u7a7a") String sysStaffId) {
        log.info("\u6839\u636eid\u67e5\u8be2\u5bfc\u8d2d\u5165\u53c2:sysStaffId:{}", (Object)sysStaffId);
        ResultBean result = new ResultBean();
        Integer i = this.iStaffService.delete(sysStaffId);
        result.setResult((Serializable)i);
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }

    @RequestMapping(value={"/batchSaveStaff/{batchid}"}, method={RequestMethod.POST}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<Integer> batchSaveStaff(@RequestBody List<StaffReqBean> staffList, @PathVariable(value="batchid") String batchid) {
        Assert.checkBetween((int)staffList.size(), (int)1, (int)100);
        log.info("\u4f01\u4e1a:{}\u4e0b\u6279\u91cf\u4fdd\u5b58\u5458\u5de5\u63a5\u53e3:{}\u6761,batchid:{}", new Object[]{staffList.get(0).getSysCompanyId(), staffList.size(), batchid});
        ResultBean result = new ResultBean();
        Integer i = this.iStaffService.batchSave(staffList);
        result.setResult((Serializable)i);
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }

    @RequestMapping(value={"/getStaffByCondition"}, method={RequestMethod.GET}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<ArrayList<StaffDTO>> getStaffByCondition(@RequestParam(value="sysCompanyId") @NotBlank(message="\u7cfb\u7edf\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7cfb\u7edf\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a") String sysCompanyId, @RequestParam(value="staffCode", required=false) String staffCode, @RequestParam(value="staffId", required=false) String staffId, @RequestParam(value="phone", required=false) String phone) {
        log.info("\u6761\u4ef6\u67e5\u8be2\u5bfc\u8d2d\u5165\u53c2:sysCompanyId:{}  staffCode:{}  staffId:{}  phone:{}", new Object[]{sysCompanyId, staffCode, staffId, phone});
        ResultBean result = new ResultBean();
        ArrayList dtos = this.iStaffService.getStaff(sysCompanyId, staffCode, staffId, phone);
        result.setResult((Serializable)dtos);
        result.setSuccess(Boolean.valueOf(true));
        return result;
    }
}

