/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.basecontroller.config;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    @Autowired
    private RedisTemplate redisTemplate;

    public void remove(String ... keys) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.remove(key);
            ++n2;
        }
    }

    public void removePattern(String pattern) {
        Set keys = this.redisTemplate.keys((Object)pattern);
        if (keys.size() > 0) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public void remove(String key) {
        if (this.exists(key)) {
            this.redisTemplate.delete((Object)key);
        }
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Object get(String key) {
        Object result = null;
        ValueOperations operations = this.redisTemplate.opsForValue();
        result = operations.get((Object)key);
        return result;
    }

    public <T> Object get(T t, String key) {
        ValueOperations operations = this.redisTemplate.opsForValue();
        return operations.get((Object)key);
    }

    public boolean increment(String key, int value) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.increment((Object)key, (long)value);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, Object value) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, Object value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

