/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.basecontroller.config;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.MessageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class AdviceConfig {
    private static final Logger logger = LoggerFactory.getLogger(AdviceConfig.class);

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), true));
    }

    @ExceptionHandler(value={BizException.class})
    @ResponseBody
    public ResponseData<MessageInfo> bizException(BizException e) {
        logger.info("{}:{},\u7ea7\u522b{}", new Object[]{e.getMessage(), e.getData(), e.getLevel().getName()});
        return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u3010\u63d0\u9192\u6d88\u606f\u3011", (Object)new MessageInfo("\u670d\u52a1\u5668\u51fa\u73b0\u9519\u8bef\uff0c\u5c0f\u4f19\u4f34\u6b63\u5728\u7d27\u6025\u5904\u7406\u4e2d......", "sys_alarm"));
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseData<MessageInfo> processUnauthenticatedException(Exception e) {
        logger.info("{}:", (Object)"\u7cfb\u7edf\u5f02\u5e38", (Object)e);
        return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u3010\u63d0\u9192\u6d88\u606f\u3011", (Object)new MessageInfo("\u670d\u52a1\u5668\u51fa\u73b0\u9519\u8bef\uff0c\u5c0f\u4f19\u4f34\u6b63\u5728\u7d27\u6025\u5904\u7406\u4e2d......", "sys_alarm"));
    }
}

