package com.bizvane.baisonBase.facade.models.e3.param;

import com.alibaba.fastjson.annotation.JSONField;
import com.bizvane.baisonBase.facade.models.e3.IBaisonE3ReqDataContent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@ApiModel("梦洁百胜E3分页查询导购参数")
@Data
public class BaisonE3PageQueryStaffDataContent implements IBaisonE3ReqDataContent {
    @ApiModelProperty("查询页码")
    @JSONField(name = "page_index")
    private Integer pageIndex;

    @ApiModelProperty("每页记录数")
    @JSONField(name = "page_size")
    private Integer pageSize;

    @ApiModelProperty("查询参数组合")
    @JSONField(name = "filter_fields")
    private List<FilterField> filterFields;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class FilterField {

        @ApiModelProperty("字段名称")
        @JSONField(name = "field_code")
        private String fieldCode;

        @ApiModelProperty("查询参数组合")
        @JSONField(name = "filter_fields")
        private List<FilterField> filterFields;

        @ApiModelProperty("连接符号")
        @JSONField(name = "operator")
        private String operator;

        @ApiModelProperty("字段值")
        @JSONField(name = "value")
        private String value;

        @ApiModelProperty("操作符号")
        @JSONField(name = "condition_operator")
        private String conditionOperator;

    }
}
