package com.bizvane.baisonBase.facade.rpc;


import com.bizvane.baisonBase.facade.models.yw.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 伊文储值卡接口
 * */
@FeignClient(value = "${feign.client.baison.name}", path = "${feign.client.baison.path}/rechargeCard")
public interface YwRechargeCardServiceRpc {

    /**
     * 储值卡充值
     * */
    @RequestMapping(value ="rechargeStoredCard",method = RequestMethod.POST)
    ResponseData<YwRechargeRecordInfoResponseVo> rechargeStoredCard(YwRechargeRecordInfoRequestVo requestVo);

    /**
     * 储值卡购买
     * */
    @RequestMapping(value ="bayStoredCard",method = RequestMethod.POST)
    ResponseData<YwRechargeRecordInfoResponseVo> bayStoredCard(YwRechargeRecordInfoRequestVo requestVo);

    /**
     * 储值卡资料更新
     * */
    @RequestMapping(value ="updateStoredCard",method = RequestMethod.POST)
    ResponseData updateStoredCard(YwRechargeCardInfoRequestVo requestVo);

    /**
     * 储值卡列表查询
     * */
    @RequestMapping(value ="getStoredCardList",method = RequestMethod.POST)
    ResponseData<PageInfo<YwRechargeCardInfoResponseVo>> getStoredCardList(YwRechargeCardInfoRequestVo requestVo);

}
