package com.bizvane.baisonBase.facade.rpc;


import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bizvane.baisonBase.facade.models.mj.MjCouponSendRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjCouponTransferRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjCouponUseRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjLabelDefRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjMbrLabelRequestVo;
import com.bizvane.baisonBase.facade.models.mj.MjQueryMemberInfoRequestVo;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.IntegralAdjustRequestVO;
import com.bizvane.connectorservice.entity.common.IntegralAdjustResponseVO;
import com.bizvane.connectorservice.entity.common.MemberLoginResponseVO;
import com.bizvane.connectorservice.entity.common.MemberOpenCardRequestVO;
import com.bizvane.connectorservice.entity.common.MemberOpenCardResponseVO;

import io.swagger.annotations.ApiOperation;

/**
 * 梦洁会员新接口，梦洁自研
 * */
@FeignClient(value = "${feign.client.baison.name}", path = "${feign.client.baison.path}/icrmMemberMJ")
public interface MjMemberServiceNewRpc {

    /**
     * 查询会员
     * */
    @RequestMapping(value ="queryMemberInfo",method = RequestMethod.POST)
    Result<MemberLoginResponseVO> queryMemberInfo(@RequestParam("phone")String phone, @RequestParam("cardNo") String cardNo);

    /**
     * 会员注册修改
     * */
    @RequestMapping(value ="addAndUpdateMember",method = RequestMethod.POST)
    Result<MemberOpenCardResponseVO> addAndUpdateMember(@RequestBody MemberOpenCardRequestVO requestVo);

    /**
     * 会员积分调整
     * */
    @RequestMapping(value ="adjustIntegral",method = RequestMethod.POST)
    Result<IntegralAdjustResponseVO> adjustIntegral(@RequestBody IntegralAdjustRequestVO requestVo);

    @ApiOperation( value = "查询会员即将过期积分",notes = "查询会员即将过期积分",tags = {"mj"},httpMethod = "POST")
    @RequestMapping(value = "queryExpireIntegral", method = RequestMethod.POST)
    Result<Long> queryExpireIntegral(@RequestBody MjQueryMemberInfoRequestVo requestVo);
    
    /**
     * 
     * @param 标签定义新增或修改同步
     * @return
     */
    @RequestMapping(value ="addAndUpdateLabelDef",method = RequestMethod.POST)
    Result<Boolean> addAndUpdateLabelDef(@RequestBody MjLabelDefRequestVo requestVo);
    
    /**
     * 
     * @param 会员标签新增或者修改
     * @return
     */
    @RequestMapping(value ="addAndUpdateMbrLabel",method = RequestMethod.POST)
    Result<Boolean> addAndUpdateMbrLabel(@RequestBody MjMbrLabelRequestVo requestVo);
    
    /**
     * 优惠券发放
     * @param requestVo
     * @return
     */
    @RequestMapping(value ="couponSend",method = RequestMethod.POST)
    Result<Boolean> couponSend(@RequestBody MjCouponSendRequestVo requestVo);
    
    /**
     * 优惠券核销
     * @param requestVo
     * @return
     */
    @RequestMapping(value ="couponUse",method = RequestMethod.POST)
    Result<Boolean> couponUse(@RequestBody MjCouponUseRequestVo requestVo);
    
    /**
     * 优惠券转赠
     * @param requestVo
     * @return
     */
    @RequestMapping(value ="couponTransfer",method = RequestMethod.POST)
    Result<Boolean> couponTransfer(@RequestBody MjCouponTransferRequestVo requestVo);



}
