/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.quickbi.authx.signature;

import com.alibaba.quickbi.authx.signature.SignatureUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RequestSignatureUtil {
    private static final String SIGNATURE_PARAM_NAME = "signature";
    private static final int NONCE_SIZE = 16;

    public static boolean validRequestSignature(HttpServletRequest request, String sk) {
        if (null == request || null == sk) {
            return false;
        }
        String uri = request.getRequestURI();
        String method = request.getMethod();
        Map<String, String> parameters = RequestSignatureUtil.extractQueryParameters(request);
        String requestSign = "";
        if (!parameters.containsKey(SIGNATURE_PARAM_NAME)) {
            return false;
        }
        requestSign = parameters.get(SIGNATURE_PARAM_NAME);
        parameters.remove(SIGNATURE_PARAM_NAME);
        String stringToSign = SignatureUtil.buildStringToSign(uri, method, parameters);
        String sign = SignatureUtil.sign(stringToSign, sk);
        return sign.equalsIgnoreCase(requestSign);
    }

    private static Map<String, String> extractQueryParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        HashMap<String, String> result = new HashMap<String, String>();
        if (null == parameterMap || parameterMap.size() == 0) {
            return result;
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (null == values || values.length == 0) continue;
            if (values.length == 1) {
                result.put(key, values[0]);
                continue;
            }
            String value = RequestSignatureUtil.sortArraysToString(values, ",");
            result.put(key, value);
        }
        return result;
    }

    private static String sortArraysToString(String[] arrays, String sep) {
        List<String> list = Arrays.asList(arrays);
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i == list.size() - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }
}

