/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class DefaultCommentGenerator
implements CommentGenerator {
    private Properties properties;
    private boolean suppressDate = false;
    private boolean suppressAllComments = false;
    private boolean addRemarkComments = false;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public DefaultCommentGenerator() {
        this.properties = new Properties();
    }

    public void addJavaFileComment(CompilationUnit compilationUnit) {
    }

    public void addComment(XmlElement xmlElement) {
        if (this.suppressAllComments) {
            return;
        }
        xmlElement.addElement((Element)new TextElement("<!--"));
        StringBuilder sb = new StringBuilder();
        sb.append("  WARNING - \u53ea\u8bfb - ");
        sb.append("@mbg.generated");
        xmlElement.addElement((Element)new TextElement(sb.toString()));
        String s = this.getDateString();
        if (s != null) {
            sb.setLength(0);
            sb.append("  This element was generated on ");
            sb.append(s);
            sb.append('.');
            xmlElement.addElement((Element)new TextElement(sb.toString()));
        }
        xmlElement.addElement((Element)new TextElement("-->"));
    }

    public void addRootComment(XmlElement rootElement) {
    }

    public void addConfigurationProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        this.suppressDate = StringUtility.isTrue((String)properties.getProperty("suppressDate"));
        this.suppressAllComments = StringUtility.isTrue((String)properties.getProperty("suppressAllComments"));
        this.addRemarkComments = StringUtility.isTrue((String)properties.getProperty("addRemarkComments"));
        String dateFormatString = properties.getProperty("dateFormat");
        if (StringUtility.stringHasValue((String)dateFormatString)) {
            this.dateFormat = new SimpleDateFormat(dateFormatString);
        }
    }

    protected void addJavadocTag(JavaElement javaElement, boolean markAsDoNotDelete) {
        String s;
        javaElement.addJavaDocLine(" *");
        StringBuilder sb = new StringBuilder();
        sb.append(" * ");
        sb.append("@mbg.generated");
        if (markAsDoNotDelete) {
            sb.append(" do_not_delete_during_merge");
        }
        if ((s = this.getDateString()) != null) {
            sb.append(' ');
            sb.append(s);
        }
        javaElement.addJavaDocLine(sb.toString());
    }

    protected String getDateString() {
        if (this.suppressDate) {
            return null;
        }
        if (this.dateFormat != null) {
            return this.dateFormat.format(new Date());
        }
        return new Date().toString();
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        innerClass.addJavaDocLine("/**");
        sb.append(" * \u53ea\u8bfb. ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        innerClass.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)innerClass, false);
        innerClass.addJavaDocLine(" */");
    }

    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments || !this.addRemarkComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        topLevelClass.addJavaDocLine("/**");
        String remarks = introspectedTable.getRemarks();
        if (this.addRemarkComments && StringUtility.stringHasValue((String)remarks)) {
            String[] remarkLines;
            topLevelClass.addJavaDocLine(" * Database Table Remarks:");
            for (String remarkLine : remarkLines = remarks.split(System.getProperty("line.separator"))) {
                topLevelClass.addJavaDocLine(" *   " + remarkLine);
            }
        }
        topLevelClass.addJavaDocLine(" *");
        topLevelClass.addJavaDocLine(" * This class was generated by MyBatis Generator.");
        sb.append(" * This class corresponds to the database table ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        topLevelClass.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)topLevelClass, true);
        topLevelClass.addJavaDocLine(" */");
    }

    public void addEnumComment(InnerEnum innerEnum, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        innerEnum.addJavaDocLine("/**");
        innerEnum.addJavaDocLine(" * This enum was generated by MyBatis Generator.");
        sb.append(" * This enum corresponds to the database table ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        innerEnum.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)innerEnum, false);
        innerEnum.addJavaDocLine(" */");
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        field.addJavaDocLine("/**");
        String remarks = introspectedColumn.getRemarks();
        if (this.addRemarkComments && StringUtility.stringHasValue((String)remarks)) {
            String[] remarkLines;
            field.addJavaDocLine(" * Database Column Remarks:");
            for (String remarkLine : remarkLines = remarks.split(System.getProperty("line.separator"))) {
                field.addJavaDocLine(" *   " + remarkLine);
            }
        }
        field.addJavaDocLine(" * \u53ea\u8bfb.");
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getRemarks());
        sb.append(". ");
        sb.append(introspectedColumn.getActualColumnName());
        field.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)field, false);
        field.addJavaDocLine(" */");
        String swaggerName = field.getName();
        String[] remarksList = remarks.split("\u793a\u4f8b");
        String swaggerValue = remarks;
        String swaggerexample = "";
        if (remarksList.length == 2) {
            swaggerValue = remarksList[0];
            swaggerexample = remarksList[1];
        }
        String swagger = "@io.swagger.annotations.ApiModelProperty(value = \"" + swaggerValue + "\"," + "name = \"" + swaggerName + "\", required = false," + "example = \"" + swaggerexample + "\")";
        field.addJavaDocLine(swagger);
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        field.addJavaDocLine("/**");
        sb.append(" * \u53ea\u8bfb. ");
        field.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)field, false);
        field.addJavaDocLine(" */");
    }

    public void addGeneralMethodComment(Method method, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments) {
            return;
        }
        method.addJavaDocLine("/**");
        method.addJavaDocLine(" * \u53ea\u8bfb. ");
        this.addJavadocTag((JavaElement)method, false);
        method.addJavaDocLine(" */");
    }

    public void addGetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.append(" * \u53ea\u8bfb. ");
        method.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)method, false);
        method.addJavaDocLine(" */");
    }

    public void addSetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.append(" * \u53ea\u8bfb. ");
        method.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)method, false);
        method.addJavaDocLine(" */");
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable, boolean markAsDoNotDelete) {
        if (this.suppressAllComments) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        innerClass.addJavaDocLine("/**9");
        innerClass.addJavaDocLine(" * This class was generated by MyBatis Generator.");
        sb.append(" * This class corresponds to the database table ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        innerClass.addJavaDocLine(sb.toString());
        this.addJavadocTag((JavaElement)innerClass, markAsDoNotDelete);
        innerClass.addJavaDocLine(" */");
    }
}

