/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import cn.bizvane.rocketmq.spring.core.MessageDelayLevel;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.appletservice.interfaces.vg.VGLoginService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.po.SysYearEndActRecordPO;
import com.bizvane.appletservice.models.vo.vg.NewYearMemberGuideUpdateRequestVo;
import com.bizvane.appletservice.models.vo.vg.OpenCard23NewYearActVo;
import com.bizvane.appletservice.models.vo.vg.VGChildBrandRedisVo;
import com.bizvane.appletservice.models.vo.vg.VGMbrRegisterRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGMbrRegisterRequestVoFor23ActVo;
import com.bizvane.appletservice.models.vo.vg.VGRequestHeaderVo;
import com.bizvane.appletservice.utils.TimeUtils;
import com.bizvane.appletserviceimpl.common.ChannelMemberCodeEnum;
import com.bizvane.appletserviceimpl.impl.vg.VGGetAllMemberInfoServiceImpl;
import com.bizvane.appletserviceimpl.impl.vg.VGInitServiceImpl;
import com.bizvane.appletserviceimpl.mappers.SysYearEndActRecordPOMapper;
import com.bizvane.appletserviceimpl.utils.MD5Util;
import com.bizvane.appletserviceimpl.utils.OptionUtils;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SysStaffBrandInfoVo;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.core.facade.interfaces.CoreTraceFeign;
import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.core.facade.models.po.TraceRecordPO;
import com.bizvane.core.facade.models.vo.TraceRecordVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberSysApiService;
import com.bizvane.members.facade.service.api.vg.VGMemberInfoRpcService;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.vg.VGContentVo;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.mktcenterservice.rpc.ContentServiceRpc;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterMemberVo;
import com.bizvane.unifiedreg.model.vo.UnifiedRegisterVo;
import com.bizvane.unifiedreg.rpc.MemberChannelRegistrationFeign;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class VGLoginServiceImpl
implements VGLoginService {
    private static final Logger log = LoggerFactory.getLogger(VGLoginServiceImpl.class);
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MemberChannelRegistrationFeign memberChannelRegistrationFeign;
    @Autowired
    private CoreTraceFeign coreTraceFeign;
    @Autowired
    private ActivityEGServiceRpc activityEGServiceRpc;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private VGInitServiceImpl vgInitService;
    @Autowired
    private OptionUtils optionUtils;
    @Autowired
    private VGGetAllMemberInfoServiceImpl vgGetAllMemberInfoService;
    @Autowired
    private VGMemberInfoRpcService vgMemberInfoRpcService;
    @Autowired
    private ContentServiceRpc contentServiceRpc;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private SysYearEndActRecordPOMapper sysYearEndActRecordMapper;
    @Value(value="${activityUrl.newYear23Act}")
    private String newYear23ActUrl;
    @Autowired
    private MemberSysApiService memberSysApiService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    public ResponseData getMbrAndOpenCard(HttpServletRequest request, VGMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        this.redisTemplateService.deleteFromRedis((Object)(memberCode + "_allCardByGroupMemberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(-100);
            return responseData;
        }
        String clubBrandId = request.getHeader("clubBrandId");
        if (clubBrandId == null) {
            responseData.setMessage("clubBrandId\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String phone = (String)this.redisTemplateService.stringGetStringByKey((Object)("Phone:" + memberCode));
        String childBizvaneSessionId = MD5Util.md5((String)(bizvaneSessionId + clubBrandId));
        String masterChildInfo = bizvaneSessionId + "masterCard";
        String vgChildBrandRedisVoJSON = (String)this.redisTemplateService.hashGet((Object)masterChildInfo, (Object)childBizvaneSessionId);
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long sysBrandId = Long.valueOf(clubBrandId);
        Long sysCompanyId = ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId();
        String wxUnionId = ((MemberInfoModel)singleMemberModel.getData()).getWxUnionId();
        String channelCode = null;
        String source = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "source"));
        AppletBrandMenberBo menberBoRes = new AppletBrandMenberBo();
        log.info("\u5f53\u524d\u54c1\u724c\u4ff1\u4e50\u90e8\u6e20\u9053\u4e3a\u5fae\u4fe1\u6e20\u9053");
        channelCode = ChannelMemberCodeEnum.WX_MINI_MEMBER.getCode();
        String redisChildMemberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(childBizvaneSessionId + "memberCode"));
        menberBoRes.setSysBrandId(Long.valueOf(sysBrandId));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{redisChildMemberCode})) {
            menberBoRes.setMemberCode(redisChildMemberCode);
            return this.getMbrInfoByWx(childBizvaneSessionId, menberBoRes, redisChildMemberCode);
        }
        String mktTaskId = wxMbrRegisteRequestVo.getMktTaskId();
        UnifiedRegisterVo unifiedRegisterVo = new UnifiedRegisterVo();
        String uuid = request.getHeader("UUID");
        log.info("UUID\u5f00\u5361={}", (Object)uuid);
        String uuidJONString = null;
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            uuidJONString = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
            log.info("uuidJONString={}", (Object)uuidJONString);
        }
        if (StringUtils.isNotBlank(uuidJONString)) {
            JSONObject JSONobjectUUID = JSONObject.parseObject(uuidJONString);
            String mktActivityId = JSONobjectUUID.getString("mktActivityId");
            ProbabilityVO vo = new ProbabilityVO();
            vo.setMktActivityId(Long.valueOf(mktActivityId));
            ResponseData mktActivityPOWithBLOBs = this.activityEGServiceRpc.getMktActivityPOWithBLOBs(vo);
            Integer activityType = ((MktActivityDetailAndPicture)mktActivityPOWithBLOBs.getData()).getActivityType();
            log.info("activityType={}, mktActivityId={}", (Object)activityType, (Object)mktActivityId);
            unifiedRegisterVo.setActivityId(Long.valueOf(mktActivityId));
            unifiedRegisterVo.setActivityType(activityType);
        }
        String channelUniqueMemberCode = MD5Util.md5((String)(memberCode + sysBrandId));
        String traceId = this.convertTraceId(wxMbrRegisteRequestVo, sysBrandId, sysCompanyId, wxUnionId);
        this.fillTraceInfo(wxMbrRegisteRequestVo, sysBrandId, unifiedRegisterVo, traceId, (MemberInfoModel)singleMemberModel.getData());
        unifiedRegisterVo.setPhone(phone);
        unifiedRegisterVo.setSysBrandId(sysBrandId);
        unifiedRegisterVo.setSysCompanyId(sysCompanyId);
        unifiedRegisterVo.setChannelUniqueMemberCode(channelUniqueMemberCode);
        unifiedRegisterVo.setChannelCode(channelCode);
        unifiedRegisterVo.setMasterMemberCode(memberCode);
        ResponseData unifiedRegisterMemberVoResponseData = null;
        try {
            unifiedRegisterMemberVoResponseData = this.memberChannelRegistrationFeign.unifiedRegister(unifiedRegisterVo);
        }
        catch (Exception e) {
            log.info("\u5f00\u5361\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:{}", (Throwable)e);
            ResponseData responseDataError = (ResponseData)JSON.parseObject((String)e.getMessage().split("content:")[1], ResponseData.class);
            return new ResponseData(100, responseDataError.getMessage());
        }
        log.info("\u5f00\u5361\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)unifiedRegisterMemberVoResponseData));
        if (unifiedRegisterMemberVoResponseData == null || unifiedRegisterMemberVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(100, "\u5fae\u4fe1\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u518d\u8bd5");
        }
        UnifiedRegisterMemberVo unifiedRegisterMemberVoResponseDataData = (UnifiedRegisterMemberVo)unifiedRegisterMemberVoResponseData.getData();
        String childMemberCode = unifiedRegisterMemberVoResponseDataData.getMemberCode();
        menberBoRes.setMemberCode(childMemberCode);
        Integer operateType = null;
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(childBizvaneSessionId + "memberCode"), (Object)childMemberCode, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(childMemberCode + "bizvaneSessionId"), (Object)childBizvaneSessionId, 7776000000L);
        VGChildBrandRedisVo vgChildBrandRedisVoAdd = VGChildBrandRedisVo.builder().sysBrandId(sysBrandId).sysCompanyId(sysCompanyId).memberCode(childMemberCode).build();
        this.redisTemplateService.hashPushHashMap((Object)masterChildInfo, (Object)childBizvaneSessionId, (Object)JSON.toJSONString((Object)vgChildBrandRedisVoAdd));
        this.activityService.executeActivity(Long.valueOf(sysBrandId), childMemberCode, operateType);
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getOderMemberCode())) {
            this.activityService.inviteOpenCoder(childMemberCode, wxMbrRegisteRequestVo.getOderMemberCode(), mktTaskId);
        }
        if (StringUtils.isNotBlank((CharSequence)mktTaskId) && !"null".equals(mktTaskId)) {
            this.activityService.executeTaskCallBack(request, sysCompanyId, sysBrandId, childMemberCode, Long.valueOf(mktTaskId));
        }
        this.insertTraceRecord(wxMbrRegisteRequestVo, menberBoRes);
        VGRequestHeaderVo requestHeader = this.optionUtils.getRequestHeader(memberCode);
        VGContentVo vgContentVo = new VGContentVo();
        vgContentVo.setMemberCode(((UnifiedRegisterMemberVo)unifiedRegisterMemberVoResponseData.getData()).getMemberCode());
        vgContentVo.setPage(requestHeader.getPage());
        vgContentVo.setSourceid(requestHeader.getSourceid());
        this.contentServiceRpc.joinClub(vgContentVo);
        return this.getMbrInfoByWx(bizvaneSessionId, menberBoRes, childMemberCode);
    }

    @Async
    public ResponseData autoJoinClub(VGRequestHeaderVo requestHeader, VGMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        log.info("autoJoinClub#wxMbrRegisteRequestVo:{}", (Object)JSON.toJSONString((Object)wxMbrRegisteRequestVo));
        String autoJoinClubUUID = wxMbrRegisteRequestVo.getAutoJoinClubUUID();
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = wxMbrRegisteRequestVo.getBizvaneSessionId();
        log.info("header\u4e2d\u65e0\u6cd5\u83b7\u53d6bizvaneSessionId,\u4ecebody\u4e2d\u518d\u83b7\u53d6\u4e00\u6b21:{}", (Object)bizvaneSessionId);
        if (bizvaneSessionId == null) {
            log.info("bizvaneSessionId\u53c2\u6570\u4e0d\u5b58\u5728,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)autoJoinClubUUID);
            return responseData;
        }
        String traceId = wxMbrRegisteRequestVo.getTraceId();
        if (StringUtils.isEmpty((CharSequence)traceId)) {
            log.info("traceId\u53c2\u6570\u4e0d\u5b58\u5728,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        this.redisTemplateService.deleteFromRedis((Object)(memberCode + "_allCardByGroupMemberCode"));
        if (memberCode == null) {
            log.info("\u96c6\u56e2\u4f1a\u5458\u4e0d\u5b58\u5728,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)autoJoinClubUUID);
            return responseData;
        }
        ResponseData tracePOResponseData = this.coreTraceFeign.selectByTraceId(Long.valueOf(traceId));
        log.info("selectByTraceId\u65b9\u6cd5\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)tracePOResponseData));
        TracePO tracePOResponseDataData = (TracePO)tracePOResponseData.getData();
        if (tracePOResponseDataData == null) {
            log.info("selectByTraceId\u67e5\u8be2\u4e0d\u5b58\u5728,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)autoJoinClubUUID);
            return responseData;
        }
        MemberInfoModel masterMemberInfoModelSearch = new MemberInfoModel();
        masterMemberInfoModelSearch.setMemberCode(memberCode);
        ResponseData masteSingleMemberModel = this.memberInfoApiService.getSingleMemberModel(masterMemberInfoModelSearch);
        MemberInfoModel masterMemberModelData = (MemberInfoModel)masteSingleMemberModel.getData();
        if (masterMemberModelData == null) {
            log.info("\u5c0f\u7a0b\u5e8fmemberCode:{}\u4f1a\u5458\u4e0d\u5b58\u5728!,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)memberCode, (Object)autoJoinClubUUID);
            return responseData;
        }
        Long clubSysCompanyId = tracePOResponseDataData.getSysCompanyId();
        if (masterMemberModelData.getSysCompanyId().compareTo(clubSysCompanyId) != 0) {
            log.info("\u5c0f\u7a0b\u5e8fmemberCode:{}\u4f1a\u5458\u548ctraceId:{}\u4f01\u4e1a\u4e0d\u4e00\u81f4!,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", new Object[]{memberCode, traceId, autoJoinClubUUID});
            return responseData;
        }
        Long clubBrandId = tracePOResponseDataData.getBrandId();
        if (masterMemberModelData.getBrandId().compareTo(clubBrandId) == 0) {
            log.info("\u5c0f\u7a0b\u5e8fmemberCode:{}\u4f1a\u5458\u548ctraceId:{}\u54c1\u724c\u4e00\u81f4!,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", new Object[]{memberCode, traceId, autoJoinClubUUID});
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)masterMemberModelData.getGroupMemberCode())) {
            log.info("\u5c0f\u7a0b\u5e8fmemberCode:{}\u4f1a\u5458groupMemberCode\u4e3a\u7a7a!,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", new Object[]{memberCode, traceId, autoJoinClubUUID});
            return responseData;
        }
        MemberInfoModel clubMemberInfoModelSearch = new MemberInfoModel();
        clubMemberInfoModelSearch.setGroupMemberCode(masterMemberModelData.getGroupMemberCode());
        clubMemberInfoModelSearch.setBrandId(clubBrandId);
        ResponseData clubSingleMemberModel = this.memberInfoApiService.getSingleMemberModel(clubMemberInfoModelSearch);
        MemberInfoModel clubMemberModelData = (MemberInfoModel)clubSingleMemberModel.getData();
        if (clubMemberModelData == null) {
            log.info("\u4f1a\u5458\u672a\u5165\u4f1a,\u8fdb\u884c\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)autoJoinClubUUID);
        }
        UnifiedRegisterVo unifiedRegisterVo = new UnifiedRegisterVo();
        String channelUniqueMemberCode = MD5Util.md5((String)(memberCode + clubBrandId));
        String channelCode = ChannelMemberCodeEnum.WX_MINI_MEMBER.getCode();
        this.fillTraceInfo(wxMbrRegisteRequestVo, clubBrandId, unifiedRegisterVo, traceId, masterMemberModelData);
        unifiedRegisterVo.setPhone(masterMemberModelData.getPhone());
        unifiedRegisterVo.setSysBrandId(clubBrandId);
        unifiedRegisterVo.setSysCompanyId(clubSysCompanyId);
        unifiedRegisterVo.setChannelUniqueMemberCode(channelUniqueMemberCode);
        unifiedRegisterVo.setChannelCode(channelCode);
        unifiedRegisterVo.setMasterMemberCode(memberCode);
        ResponseData unifiedRegisterMemberVoResponseData = null;
        try {
            unifiedRegisterMemberVoResponseData = this.memberChannelRegistrationFeign.unifiedRegister(unifiedRegisterVo);
        }
        catch (Exception e) {
            log.info("\u5f00\u5361\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:{}", (Throwable)e);
            return responseData;
        }
        log.info("\u5f00\u5361\u63a5\u53e3\u8fd4\u56de\u7ed3\u679cautoJoinClub:{}", (Object)JSONObject.toJSONString((Object)unifiedRegisterMemberVoResponseData));
        if (unifiedRegisterMemberVoResponseData == null || unifiedRegisterMemberVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.info("\u5f00\u5361\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u7a7a,\u7ed3\u675f\u81ea\u52a8\u5165\u4f1a,uuid:{}", (Object)autoJoinClubUUID);
            return responseData;
        }
        VGContentVo vgContentVo = new VGContentVo();
        vgContentVo.setMemberCode(((UnifiedRegisterMemberVo)unifiedRegisterMemberVoResponseData.getData()).getMemberCode());
        vgContentVo.setPage(requestHeader.getPage());
        vgContentVo.setSourceid(requestHeader.getSourceid());
        log.info("VGLoginServiceImpl#autoJoinClub#vgContentVo:{}", (Object)JSON.toJSONString((Object)vgContentVo));
        this.contentServiceRpc.joinClub(vgContentVo);
        return responseData;
    }

    public MemberInfoModel simpleJoinClub(HttpServletRequest request, MemberInfoModel memberInfoModelMaster, Long clubBrandId) {
        String masterMemberCode = memberInfoModelMaster.getMemberCode();
        Long sysCompanyId = memberInfoModelMaster.getSysCompanyId();
        String phone = memberInfoModelMaster.getPhone();
        MemberInfoModel memberInfoModelSearchClub = new MemberInfoModel();
        memberInfoModelSearchClub.setGroupMemberCode(masterMemberCode);
        memberInfoModelSearchClub.setBrandId(clubBrandId);
        MemberInfoModel memberInfoModelClub = (MemberInfoModel)this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearchClub).getData();
        if (memberInfoModelClub != null) {
            return memberInfoModelClub;
        }
        String traceId = this.convertTraceId(new VGMbrRegisterRequestVo(), clubBrandId, sysCompanyId, memberInfoModelMaster.getWxUnionId());
        log.info("\u5f53\u524d\u54c1\u724c\u4ff1\u4e50\u90e8\u6e20\u9053\u4e3a\u5fae\u4fe1\u6e20\u9053");
        String channelCode = ChannelMemberCodeEnum.WX_MINI_MEMBER.getCode();
        String channelUniqueMemberCode = MD5Util.md5((String)(masterMemberCode + clubBrandId));
        UnifiedRegisterVo unifiedRegisterVo = new UnifiedRegisterVo();
        this.fillTraceInfo(null, clubBrandId, unifiedRegisterVo, traceId, memberInfoModelMaster);
        unifiedRegisterVo.setPhone(phone);
        unifiedRegisterVo.setSysBrandId(clubBrandId);
        unifiedRegisterVo.setSysCompanyId(sysCompanyId);
        unifiedRegisterVo.setChannelUniqueMemberCode(channelUniqueMemberCode);
        unifiedRegisterVo.setChannelCode(channelCode);
        unifiedRegisterVo.setMasterMemberCode(masterMemberCode);
        ResponseData unifiedRegisterMemberVoResponseData = null;
        try {
            unifiedRegisterMemberVoResponseData = this.memberChannelRegistrationFeign.unifiedRegister(unifiedRegisterVo);
        }
        catch (Exception e) {
            log.info("\u5f00\u5361\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:{}", (Throwable)e);
            return null;
        }
        UnifiedRegisterMemberVo unifiedRegisterMemberVo = (UnifiedRegisterMemberVo)unifiedRegisterMemberVoResponseData.getData();
        if (SysResponseEnum.SUCCESS.getCode() != unifiedRegisterMemberVoResponseData.getCode() || unifiedRegisterMemberVo == null) {
            return null;
        }
        String memberCode = unifiedRegisterMemberVo.getMemberCode();
        MemberInfoModel memberInfoModelSearch = new MemberInfoModel();
        memberInfoModelSearch.setMemberCode(memberCode);
        MemberInfoModel memberInfoModel = (MemberInfoModel)this.memberInfoApiService.getSingleMemberModel(memberInfoModelSearch).getData();
        VGRequestHeaderVo requestHeader = this.optionUtils.getRequestHeader(memberCode);
        VGContentVo vgContentVo = new VGContentVo();
        vgContentVo.setMemberCode(memberCode);
        vgContentVo.setPage(requestHeader.getPage());
        vgContentVo.setSourceid(requestHeader.getSourceid());
        this.contentServiceRpc.joinClub(vgContentVo);
        this.redisTemplateService.deleteFromRedis((Object)(masterMemberCode + "_allCardByGroupMemberCode"));
        return memberInfoModel;
    }

    public ResponseData<OpenCard23NewYearActVo> openCard23NewYearAct(HttpServletRequest request, VGMbrRegisterRequestVoFor23ActVo wxMbrRegisteRequestVo) {
        log.info("openCard23NewYearAct#wxMbrRegisteRequestVo:{}", (Object)JSON.toJSONString((Object)wxMbrRegisteRequestVo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        if (wxMbrRegisteRequestVo == null || StringUtils.isEmpty((CharSequence)wxMbrRegisteRequestVo.getCardNo()) || StringUtils.isEmpty((CharSequence)wxMbrRegisteRequestVo.getMemberCode()) || null == wxMbrRegisteRequestVo.getIsNewUser()) {
            responseData.setMessage("CardNo\u5165\u53c2\u4fe1\u606f\u4e0d\u5b8c\u6574");
            return responseData;
        }
        String memberCode = wxMbrRegisteRequestVo.getMemberCode();
        long currentTime = System.currentTimeMillis();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (singleMemberModel == null || singleMemberModel.getData() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(-100);
            return responseData;
        }
        Date registerDate = ((MemberInfoModel)singleMemberModel.getData()).getCreateDate();
        long registerTime = registerDate.getTime();
        log.info("\u7528\u6237\u6ce8\u518c\u65f6\u95f4registerTime:{}", (Object)registerTime);
        log.info("\u67e5\u8be2\u767b\u5f55\u7528\u6237\u4fe1\u606f#openCard23NewYearAct#memberInfoModel:{}", (Object)JSON.toJSONString((Object)singleMemberModel));
        ResponseData memberInfoModelData = this.memberInfoApiService.queryMemberBrandAndStaffInfo(wxMbrRegisteRequestVo.getCardNo());
        log.info("\u67e5\u8be2\u9080\u8bf7\u4eba\u4fe1\u606f#openCard23NewYearAct#memberInfoModelData:{}", (Object)JSON.toJSONString((Object)memberInfoModelData));
        if (memberInfoModelData == null || CollectionUtils.isEmpty((Collection)((Collection)memberInfoModelData.getData()))) {
            responseData.setMessage("\u9080\u8bf7\u4eba\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
            return responseData;
        }
        String unionId = "";
        List memberInfoModels = ((List)memberInfoModelData.getData()).stream().filter(memberObj -> StringUtils.isNotEmpty((CharSequence)memberObj.getWxUnionId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(memberInfoModels)) {
            unionId = ((MemberInfoModel)memberInfoModels.get(0)).getWxUnionId();
            log.info("\u9080\u8bf7\u4ebaunionId:{}", (Object)unionId);
        }
        if (CollectionUtils.isEmpty((Collection)((List)memberInfoModelData.getData()).stream().filter(memberInfo -> memberInfo.getBrandId() != 154L).collect(Collectors.toList()))) {
            OpenCard23NewYearActVo openCard23NewYearActVo = new OpenCard23NewYearActVo();
            openCard23NewYearActVo.setUnionId(unionId);
            openCard23NewYearActVo.setUrl(this.newYear23ActUrl);
            responseData.setData((Object)openCard23NewYearActVo);
            responseData.setMessage("\u53ef\u81ea\u52a8\u5f00\u5361\u65f6\u95f4\u8d85\u65f6\uff0c\u65e0\u6cd5\u5f00\u5361");
            return responseData;
        }
        if (currentTime - registerTime > 300000L) {
            OpenCard23NewYearActVo openCard23NewYearActVo = new OpenCard23NewYearActVo();
            openCard23NewYearActVo.setUnionId(unionId);
            openCard23NewYearActVo.setUrl(this.newYear23ActUrl);
            responseData.setData((Object)openCard23NewYearActVo);
            responseData.setMessage("\u53ef\u81ea\u52a8\u5f00\u5361\u65f6\u95f4\u8d85\u65f6\uff0c\u65e0\u6cd5\u5f00\u5361");
            return responseData;
        }
        if (Boolean.FALSE.equals(wxMbrRegisteRequestVo.getIsNewUser())) {
            OpenCard23NewYearActVo openCard23NewYearActVo = new OpenCard23NewYearActVo();
            openCard23NewYearActVo.setUnionId(unionId);
            openCard23NewYearActVo.setUrl(this.newYear23ActUrl);
            responseData.setData((Object)openCard23NewYearActVo);
            responseData.setMessage("\u8be5\u7528\u6237\u5df2\u7ecf\u6ce8\u518c\u8fc7\u4e86");
            return responseData;
        }
        ResponseData invitedMemberInfoModelData = this.memberInfoApiService.queryMemberBrandAndStaffInfo(((MemberInfoModel)singleMemberModel.getData()).getCardNo());
        List newMemberBrandList = ((List)invitedMemberInfoModelData.getData()).stream().map(memberObj -> memberObj.getBrandId()).collect(Collectors.toList());
        log.info("\u67e5\u8be2\u88ab\u9080\u8bf7\u4eba\u662f\u5426\u6709\u5f00\u5361\u4ff1\u4e50\u90e8#openCard23NewYearAct#newMemberBrandList:{}", (Object)JSON.toJSONString(newMemberBrandList));
        if (memberInfoModelData == null || CollectionUtils.isEmpty((Collection)((Collection)memberInfoModelData.getData())) || StringUtils.isEmpty((CharSequence)((MemberInfoModel)((List)memberInfoModelData.getData()).get(0)).getPhone())) {
            responseData.setMessage("\u9080\u8bf7\u4eba\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
            return responseData;
        }
        if (this.redisTemplateService.hasKey((Object)(memberCode + "newYearActivityFor23")).booleanValue()) {
            log.info("\u8be5\u7528\u6237\u5df2\u7ecf\u53c2\u4e0e\u8fc7\u81ea\u52a8\u5f00\u5361:{}", (Object)memberCode);
            OpenCard23NewYearActVo openCard23NewYearActVo = new OpenCard23NewYearActVo();
            openCard23NewYearActVo.setUnionId(unionId);
            openCard23NewYearActVo.setUrl(this.newYear23ActUrl);
            responseData.setData((Object)openCard23NewYearActVo);
            responseData.setMessage("\u8be5\u7528\u6237\u5df2\u7ecf\u53c2\u4e0e\u8fc7\u81ea\u52a8\u5f00\u5361");
            return responseData;
        }
        List<Object> brandMember = new ArrayList<MemberInfoModel>();
        String memberPhone = ((MemberInfoModel)((List)memberInfoModelData.getData()).get(0)).getPhone();
        ResponseData staffInfoByPhone = this.staffServiceRpc.getStaffInfoByPhone(memberPhone);
        log.info("\u67e5\u8be2\u7528\u6237\u662f\u5426\u4e3a\u5bfc\u8d2d\u8fd4\u56de\u7ed3\u679c phone:{},\u5bfc\u8d2d:{}", (Object)memberPhone, (Object)JSON.toJSONString((Object)staffInfoByPhone));
        Boolean isStaff = staffInfoByPhone != null && staffInfoByPhone.getData() != null && StringUtils.isNotEmpty((CharSequence)((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getServiceGuideCode());
        log.info("\u5224\u65ad\u7528\u6237 phone:{}\u662f\u5426\u4e3a\u5bfc\u8d2d:{}", (Object)memberPhone, (Object)isStaff);
        String firstBrandCode = "";
        if (Boolean.FALSE.equals(isStaff)) {
            List infoModelDataData = (List)memberInfoModelData.getData();
            for (MemberInfoModel memberObj2 : infoModelDataData) {
                if (154L == memberObj2.getBrandId()) {
                    firstBrandCode = memberObj2.getFirstOpenBrandCode();
                }
                if (154L == memberObj2.getBrandId()) continue;
                brandMember.add(memberObj2);
            }
        } else {
            SysStaffBrandInfoVo sysStaffBrandInfo = (SysStaffBrandInfoVo)staffInfoByPhone.getData();
            log.info("\u67e5\u8be2\u7528\u6237 phone:{},\u5bfc\u8d2d\u4fe1\u606f:{}", (Object)memberPhone, (Object)JSON.toJSONString((Object)sysStaffBrandInfo));
            MemberInfoModel memberInfoModelGuide = new MemberInfoModel();
            memberInfoModelGuide.setBrandId(sysStaffBrandInfo.getSysBrandId());
            memberInfoModelGuide.setServiceGuideId(sysStaffBrandInfo.getServiceGuideId());
            memberInfoModelGuide.setServiceStoreId(sysStaffBrandInfo.getServiceStoreId());
            memberInfoModelGuide.setServiceStoreCode(sysStaffBrandInfo.getServiceStoreCode());
            memberInfoModelGuide.setServiceGuideCode(sysStaffBrandInfo.getServiceGuideCode());
            memberInfoModelGuide.setOpenCardGuideId(sysStaffBrandInfo.getServiceGuideId());
            memberInfoModelGuide.setOpenCardGuideCode(sysStaffBrandInfo.getServiceGuideCode());
            memberInfoModelGuide.setOpenCardStoreId(sysStaffBrandInfo.getServiceStoreId());
            memberInfoModelGuide.setOpenCardStoreCode(sysStaffBrandInfo.getServiceStoreCode());
            memberInfoModelGuide.setBrandId(sysStaffBrandInfo.getSysBrandId());
            brandMember.add(memberInfoModelGuide);
            firstBrandCode = sysStaffBrandInfo.getSysBrandCode();
        }
        if (CollectionUtils.isEmpty(brandMember)) {
            log.info("\u54c1\u724c\u4fe1\u606f\u4e3a\u7a7a:{}", (Object)JSON.toJSONString((Object)staffInfoByPhone.getData()));
            OpenCard23NewYearActVo openCard23NewYearActVo = new OpenCard23NewYearActVo();
            openCard23NewYearActVo.setUnionId(unionId);
            openCard23NewYearActVo.setUrl(this.newYear23ActUrl);
            responseData.setData((Object)openCard23NewYearActVo);
            return responseData;
        }
        ResponseData memberSysResponseVoResponseData = this.memberSysApiService.getMemberSysModel(Long.valueOf(154L), Long.valueOf(247L));
        MembersSysModel membersSysModel = memberSysResponseVoResponseData != null && memberSysResponseVoResponseData.getData() != null ? (MembersSysModel)memberSysResponseVoResponseData.getData() : null;
        String channelCode = ChannelMemberCodeEnum.WX_MINI_MEMBER.getCode();
        ResponseData staffById = this.staffServiceRpc.getStaffById(membersSysModel.getOpenCardGuideId());
        ResponseData staffStore = this.storeServiceRpc.getStaffStore(((SysStaffPo)staffById.getData()).getStaffCode(), Long.valueOf(247L));
        brandMember = brandMember.stream().sorted(Comparator.comparing(MemberInfoModel::getBrandId)).collect(Collectors.toList());
        log.info("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f#openCard23NewYearAct#brandMember:{}", (Object)JSON.toJSONString(brandMember));
        for (MemberInfoModel memberInfoModel2 : brandMember) {
            try {
                if (Boolean.FALSE.equals(isStaff) && (memberInfoModel2.getBrandId() == 160L || memberInfoModel2.getBrandId() == 162L || memberInfoModel2.getBrandId() == 161L)) {
                    log.info("\u4e0d\u8d70\u6ce8\u518c : {} ", (Object)JSON.toJSONString((Object)memberInfoModel2));
                } else {
                    MemberInfoModel memberReg = new MemberInfoModel();
                    memberReg.setBrandId(memberInfoModel2.getBrandId());
                    memberReg.setCardNo(((MemberInfoModel)singleMemberModel.getData()).getCardNo());
                    log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f#openCard23NewYearAct#memberInfo:{}", (Object)JSON.toJSONString((Object)memberReg));
                    ResponseData memberCheckModel = this.memberInfoApiService.getSingleMemberModel(memberReg);
                    log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f#openCard23NewYearAct#memberModel:{}", (Object)JSON.toJSONString((Object)memberCheckModel));
                    if (memberCheckModel == null || memberCheckModel.getData() == null || StringUtils.isEmpty((CharSequence)((MemberInfoModel)memberCheckModel.getData()).getMemberCode())) {
                        String channelUniqueMemberCode = MD5Util.md5((String)(memberCode + memberInfoModel2.getBrandId()));
                        UnifiedRegisterVo unifiedRegisterVo = new UnifiedRegisterVo();
                        unifiedRegisterVo.setPhone(((MemberInfoModel)singleMemberModel.getData()).getPhone());
                        unifiedRegisterVo.setSysBrandId(memberInfoModel2.getBrandId());
                        unifiedRegisterVo.setSysCompanyId(Long.valueOf(247L));
                        unifiedRegisterVo.setMasterMemberCode(memberCode);
                        unifiedRegisterVo.setChannelCode(channelCode);
                        unifiedRegisterVo.setChannelUniqueMemberCode(channelUniqueMemberCode);
                        if (Boolean.TRUE.equals(isStaff) && (((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getSysBrandId() == memberInfoModel2.getBrandId() || memberInfoModel2.getBrandId() == 156L && (((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getSysBrandId() == 160L || ((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getSysBrandId() == 161L || ((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getSysBrandId() == 162L))) {
                            unifiedRegisterVo.setSysGuideId(((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getServiceGuideId());
                            unifiedRegisterVo.setSysStoreId(((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getServiceStoreId());
                        }
                        ResponseData unifiedRegisterMemberVoResponseData = this.memberChannelRegistrationFeign.unifiedRegister(unifiedRegisterVo);
                        log.info("\u5f00\u5361 unifiedRegisterMemberVoResponseData :{}", (Object)JSON.toJSONString((Object)unifiedRegisterMemberVoResponseData));
                    }
                }
                log.info("\u5f00\u5361\u7ed3\u679c#\u5f53\u524d\u767b\u5f55\u7528\u6237memberCode:{},openCard23NewYearAct#", (Object)memberCode);
                try {
                    NewYearMemberGuideUpdateRequestVo newYearMemberGuideUpdateRequestVo = new NewYearMemberGuideUpdateRequestVo();
                    newYearMemberGuideUpdateRequestVo.setCardNo(((MemberInfoModel)singleMemberModel.getData()).getCardNo());
                    newYearMemberGuideUpdateRequestVo.setBrandId(memberInfoModel2.getBrandId());
                    newYearMemberGuideUpdateRequestVo.setServiceStoreId(memberInfoModel2.getServiceStoreId());
                    newYearMemberGuideUpdateRequestVo.setServiceStoreCode(memberInfoModel2.getServiceStoreCode());
                    newYearMemberGuideUpdateRequestVo.setServiceGuideId(memberInfoModel2.getServiceGuideId());
                    newYearMemberGuideUpdateRequestVo.setServiceGuideCode(memberInfoModel2.getServiceGuideCode());
                    log.info("\u53d8\u66f4\u5bfc\u8d2d VO:{}", (Object)JSON.toJSONString((Object)newYearMemberGuideUpdateRequestVo));
                    SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("long_new_year_keng").delayLevel(MessageDelayLevel._10s).build(), (Object)JSON.toJSONString((Object)newYearMemberGuideUpdateRequestVo));
                    log.info("\u53d8\u66f4\u5bfc\u8d2d\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sendResult));
                    SysYearEndActRecordPO sysYearEndActRecordPo = new SysYearEndActRecordPO();
                    sysYearEndActRecordPo.setBrandId(memberInfoModel2.getBrandId());
                    sysYearEndActRecordPo.setInviterName(((MemberInfoModel)((List)memberInfoModelData.getData()).get(0)).getName());
                    sysYearEndActRecordPo.setInviterCardNo(((MemberInfoModel)((List)memberInfoModelData.getData()).get(0)).getCardNo());
                    sysYearEndActRecordPo.setInviteeName(((MemberInfoModel)singleMemberModel.getData()).getName());
                    sysYearEndActRecordPo.setInviteeCardNo(((MemberInfoModel)singleMemberModel.getData()).getCardNo());
                    if (Boolean.TRUE.equals(isStaff)) {
                        sysYearEndActRecordPo.setInviteeOpenCardStoreId(memberInfoModel2.getOpenCardStoreId());
                        sysYearEndActRecordPo.setInviteeOpenCardGuideId(memberInfoModel2.getOpenCardGuideId());
                    } else {
                        sysYearEndActRecordPo.setInviteeOpenCardStoreId(membersSysModel.getOpenCardStoreId());
                        sysYearEndActRecordPo.setInviteeOpenCardGuideId(membersSysModel.getOpenCardGuideId());
                    }
                    sysYearEndActRecordPo.setInviteeServiceGuideId(memberInfoModel2.getServiceGuideId());
                    sysYearEndActRecordPo.setInviteeServiceStoreId(memberInfoModel2.getServiceStoreId());
                    sysYearEndActRecordPo.setCreateTime(TimeUtils.getNowTime());
                    this.sysYearEndActRecordMapper.insertSelective(sysYearEndActRecordPo);
                }
                catch (Exception e) {
                    log.info("\u4fee\u6539\u4f1a\u5458\u5f00\u5361\u95e8\u5e97\u548c\u5f00\u5361\u5bfc\u8d2d\u5f02\u5e38:{}", (Throwable)e);
                }
                log.info("2023\u65b0\u5e74\u6d3b\u52a8\u5f00\u5361\u6210\u529f  \u9080\u8bf7\u4eba\u5361\u53f7:{},\u88ab\u9080\u8bf7\u4eba\u5361\u53f7:{} ", (Object)wxMbrRegisteRequestVo.getCardNo(), (Object)((MemberInfoModel)singleMemberModel.getData()).getCardNo());
            }
            catch (Exception e) {
                log.error("2023\u65b0\u5e74\u6d3b\u52a8\u5f00\u5361\u5931\u8d25  \u9080\u8bf7\u4eba\u5361\u53f7:{},\u88ab\u9080\u8bf7\u4eba\u5361\u53f7:{} ", new Object[]{wxMbrRegisteRequestVo.getCardNo(), ((MemberInfoModel)singleMemberModel.getData()).getCardNo(), e});
            }
        }
        try {
            MemberInfoModel model = new MemberInfoModel();
            model.setMemberCode(memberCode);
            if (Boolean.TRUE.equals(isStaff)) {
                model.setOpenCardStoreId(((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getServiceStoreId());
                model.setOpenCardGuideId(((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getServiceGuideId());
                model.setOpenCardStoreCode(((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getServiceStoreCode());
                model.setOpenCardGuideCode(((SysStaffBrandInfoVo)staffInfoByPhone.getData()).getServiceGuideCode());
            } else {
                if (membersSysModel != null && null != staffById && staffById.getData() != null && null != staffStore && staffStore.getData() != null) {
                    model.setOpenCardStoreCode(((SysStorePo)staffStore.getData()).getSysStoreOfflineCode());
                    model.setOpenCardGuideCode(((SysStaffPo)staffById.getData()).getStaffCode());
                }
                model.setOpenCardStoreId(membersSysModel.getOpenCardStoreId());
                model.setOpenCardGuideId(membersSysModel.getOpenCardGuideId());
            }
            if (StringUtils.isNotEmpty((CharSequence)firstBrandCode)) {
                model.setFirstOrderTime(TimeUtils.getNowTime());
                model.setFirstOpenBrandCode(firstBrandCode);
            }
            log.info("\u4fee\u6539\u4f1a\u5458\u9996\u6b21\u5f00\u5361\u4ff1\u4e50\u90e8\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)model));
            this.memberInfoApiService.updateMemberInfoByMemberCode(model);
        }
        catch (Exception e) {
            log.info("\u4fee\u6539\u4f1a\u5458memberCode:{},\u9996\u6b21\u5f00\u5361\u4ff1\u4e50\u90e8:{} \u5931\u8d25", (Object)firstBrandCode);
        }
        log.info("updateMemberInfo()#end");
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(memberCode + "newYearActivityFor23"), (Object)memberCode, 7776000000L);
        log.info("\u4f1a\u5458\u6ce8\u518c\u5b8c\u6210");
        OpenCard23NewYearActVo openCard23NewYearActVo = new OpenCard23NewYearActVo();
        openCard23NewYearActVo.setCardNo(wxMbrRegisteRequestVo.getCardNo());
        openCard23NewYearActVo.setUnionId(unionId);
        openCard23NewYearActVo.setUrl(this.newYear23ActUrl);
        responseData.setData((Object)openCard23NewYearActVo);
        return responseData;
    }

    private void fillTraceInfo(VGMbrRegisterRequestVo wxMbrRegisteRequestVo, Long sysBrandId, UnifiedRegisterVo unifiedRegisterVo, String traceId, MemberInfoModel masterMemberModelData) {
        block10: {
            if (StringUtils.isNotBlank((CharSequence)traceId)) {
                try {
                    ResponseData tracePOResponseData = this.coreTraceFeign.selectByTraceId(Long.valueOf(traceId));
                    int code = tracePOResponseData.getCode();
                    TracePO data = (TracePO)tracePOResponseData.getData();
                    if (SysResponseEnum.SUCCESS.getCode() != code || data == null) break block10;
                    try {
                        data = this.convertTracePo(data, sysBrandId, masterMemberModelData);
                    }
                    catch (Exception e) {
                        log.warn("\u901a\u8fc7tracePo\u83b7\u53d6\u65b0\u7684TracePo\u5931\u8d25:{}", (Throwable)e);
                    }
                    if (data.getBrandId().compareTo(sysBrandId) == 0) {
                        String traceValue = data.getTraceValue();
                        JSONObject obj = JSON.parseObject((String)traceValue);
                        String storeId = obj.getString("storeId");
                        String guideId = obj.getString("guideId");
                        String source_way = obj.getString("source_way");
                        if (StringUtils.isNotEmpty((CharSequence)storeId)) {
                            unifiedRegisterVo.setSysStoreId(Long.valueOf(storeId));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)guideId)) {
                            unifiedRegisterVo.setSysGuideId(Long.valueOf(guideId));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)source_way)) {
                            unifiedRegisterVo.setSourceWay(source_way);
                        }
                        unifiedRegisterVo.setTraceValue(traceValue);
                    } else {
                        log.warn("\u5f53\u524d\u4f20\u5165traceId\u5bf9\u5e94\u54c1\u724c\u548c\u4ff1\u4e50\u90e8\u4e0d\u4e00\u81f4");
                    }
                }
                catch (NumberFormatException e) {
                    log.error("\u5165\u4f1a\u65f6\u8f6c\u6362traceId\u5931\u8d25:{}", (Throwable)e);
                }
            }
        }
    }

    private String convertTraceId(VGMbrRegisterRequestVo wxMbrRegisteRequestVo, Long sysBrandId, Long sysCompanyId, String wxUnionId) {
        String traceId = null;
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getTraceId()) && !"null".equals(wxMbrRegisteRequestVo.getTraceId())) {
            traceId = wxMbrRegisteRequestVo.getTraceId();
        } else {
            TraceRecordVo traceRecordVo = new TraceRecordVo();
            traceRecordVo.setUnionId(wxUnionId);
            traceRecordVo.setSysCompanyId(sysCompanyId);
            traceRecordVo.setBrandId(sysBrandId);
            try {
                ResponseData traceRecordPOResponseData = this.coreTraceFeign.selectTraceRecord(traceRecordVo);
                log.info("selectTraceRecord\u65b9\u6cd5\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)traceRecordPOResponseData));
                if (traceRecordPOResponseData.getData() != null) {
                    traceId = ((TraceRecordPO)traceRecordPOResponseData.getData()).getTraceId().toString();
                }
            }
            catch (Exception e) {
                log.warn("coreTraceFeign.selectTraceRecord error:{}", (Throwable)e);
            }
        }
        return traceId;
    }

    private TracePO convertTracePo(TracePO data, Long sysBrandId, MemberInfoModel masterMemberModelData) {
        TraceRecordPO traceRecordPO = new TraceRecordPO();
        traceRecordPO.setBrandId(sysBrandId);
        traceRecordPO.setSysCompanyId(masterMemberModelData.getSysCompanyId());
        traceRecordPO.setUnionid(masterMemberModelData.getWxUnionId());
        traceRecordPO.setTraceId(data.getTraceId());
        traceRecordPO.setTraceValue(data.getTraceValue());
        TraceRecordPO traceIsOfficialAccountsDefault = this.vgMemberInfoRpcService.traceIsOfficialAccountsDefault(traceRecordPO);
        if (traceIsOfficialAccountsDefault == null) {
            log.info("traceIsOfficialAccountsDefault is null");
            return data;
        }
        Long traceIdNew = traceIsOfficialAccountsDefault.getTraceId();
        ResponseData tracePOResponseData = this.coreTraceFeign.selectByTraceId(traceIdNew);
        if (SysResponseEnum.SUCCESS.getCode() != tracePOResponseData.getCode() || tracePOResponseData.getData() == null) {
            log.info("traceIsOfficialAccountsDefault selectByTraceId is null");
            return data;
        }
        log.info("traceIsOfficialAccountsDefault data:{}", (Object)JSON.toJSONString((Object)tracePOResponseData.getData()));
        return (TracePO)tracePOResponseData.getData();
    }

    private ResponseData<AppletBrandMenberBo> getMbrInfoByWx(String childBizvaneSessionId, AppletBrandMenberBo menberBoRes, String clubMemberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(clubMemberCode);
        ResponseData model = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (model.getData() != null) {
            String phone = ((MemberInfoModel)model.getData()).getPhone();
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + clubMemberCode), (Object)phone, 7776000000L);
        }
        log.info("getUserInfo childMemberCode={}  childBizvaneSessionId={}", (Object)clubMemberCode, (Object)childBizvaneSessionId);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(childBizvaneSessionId + "MemberCode"), (Object)clubMemberCode, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(clubMemberCode + "BizvaneSessionId"), (Object)childBizvaneSessionId, 7776000000L);
        log.info("memberCode\u6388\u6743\u5df2\u5f00\u5361={}", this.redisTemplateService.stringGetStringByKey((Object)(childBizvaneSessionId + "MemberCode")));
        menberBoRes.setMemberCode(clubMemberCode);
        menberBoRes.setOpenCard(true);
        menberBoRes.setBrandName(((MemberInfoModel)model.getData()).getOfflineBrandCode());
        log.info("openCard={}", (Object)JSON.toJSONString((Object)menberBoRes));
        return new ResponseData((Object)menberBoRes);
    }

    private void insertTraceRecord(VGMbrRegisterRequestVo wxMbrRegisteRequestVo, AppletBrandMenberBo menberBoRes) {
        TraceRecordVo traceRecordVo = new TraceRecordVo();
        traceRecordVo.setOpenId(menberBoRes.getOpenId());
        traceRecordVo.setSysCompanyId(menberBoRes.getSysCompanyId());
        traceRecordVo.setBrandId(menberBoRes.getSysBrandId());
        traceRecordVo.setUnionId(menberBoRes.getUnionId());
        if (StringUtils.isNotBlank((CharSequence)wxMbrRegisteRequestVo.getTraceId()) && !"null".equals(wxMbrRegisteRequestVo.getTraceId())) {
            traceRecordVo.setTraceId(Long.valueOf(wxMbrRegisteRequestVo.getTraceId()));
            this.coreTraceFeign.saveTraceRecord(traceRecordVo);
        }
        log.info("\u54c1\u724c\u4ff1\u4e50\u90e8\u4f1a\u5458\u5f00\u5361,traceRecord,\u5185\u5bb9:{},appid={}", (Object)JSONObject.toJSONString((Object)traceRecordVo), (Object)menberBoRes.getAppid());
    }
}

