/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.vg;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.vg.VGInitService;
import com.bizvane.appletservice.models.vo.vg.VGChildBrandRedisVo;
import com.bizvane.appletserviceimpl.impl.vg.VGGetAllMemberInfoServiceImpl;
import com.bizvane.appletserviceimpl.utils.MD5Util;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class VGInitServiceImpl
implements VGInitService {
    private static final Logger log = LoggerFactory.getLogger(VGInitServiceImpl.class);
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private VGGetAllMemberInfoServiceImpl vgGetAllMemberInfoService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    @Async
    public void initChildBrandBizvaneSessionId(Long sysCompanyId, Long sysBrandId, String bizvaneSessionId) {
        if (!ObjectUtils.allNotNull((Object[])new Object[]{sysCompanyId, sysBrandId, bizvaneSessionId})) {
            log.warn("VGInitServiceImpl#initChildBrandBizvaneSessionId param\u4f20\u5165\u6709\u5b57\u6bb5\u4e3anull!");
            return;
        }
        List brandList = this.vgGetAllMemberInfoService.getBrandListByCompanyId(sysCompanyId);
        long masterBrandCount = brandList.stream().filter(e -> e.getMasterCard()).count();
        if (masterBrandCount == 0L) {
            log.warn("\u5f53\u524d\u4f01\u4e1a\u4e0b\u65e0\u96c6\u56e2\u5361,return");
            return;
        }
        List childBrandList = brandList.stream().filter(e -> e.getSysBrandId().compareTo(sysBrandId) != 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(childBrandList)) {
            log.warn("\u5f53\u524d\u4f01\u4e1a\u4e0b\u65e0\u54c1\u724c\u4ff1\u4e50\u90e8,return");
            return;
        }
        log.info("\u5f53\u524d\u4f01\u4e1a\u4e0b\u54c1\u724c\u4ff1\u4e50\u90e8:{}", (Object)JSON.toJSONString(childBrandList));
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            log.warn("\u5f53\u524dbizvaneSessionId\u5bf9\u5e94memberCode\u4e3a\u7a7a,return");
            return;
        }
        String phone = (String)this.redisTemplateService.stringGetStringByKey((Object)("Phone:" + memberCode));
        if (StringUtils.isBlank((CharSequence)phone)) {
            log.warn("\u5f53\u524dmemberCode:{}\u5bf9\u5e94phone\u4e3a\u7a7a,return", (Object)memberCode);
            return;
        }
        String masterChildInfo = bizvaneSessionId + "masterCard";
        for (SysBrandPo sysBrandPo : childBrandList) {
            Long childBrandId = sysBrandPo.getSysBrandId();
            String childBizvaneSessionId = MD5Util.md5((String)(bizvaneSessionId + childBrandId));
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setBrandId(Long.valueOf(childBrandId));
            memberInfoModel.setPhone(phone);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            log.info("VGInitServiceImpl#initChildBrandBizvaneSessionId#singleMemberModel:{}", JSON.toJSON((Object)singleMemberModel));
            String childMemberCode = null;
            if (singleMemberModel.getData() != null) {
                log.warn("\u7528\u6237\u6570\u636e\u4e0d\u5b58\u5728");
                childMemberCode = ((MemberInfoModel)singleMemberModel.getData()).getMemberCode();
            }
            VGChildBrandRedisVo vgChildBrandRedisVo = VGChildBrandRedisVo.builder().sysBrandId(childBrandId).sysCompanyId(sysCompanyId).memberCode(childMemberCode).build();
            this.redisTemplateService.hashPushHashMap((Object)masterChildInfo, (Object)childBizvaneSessionId, (Object)JSON.toJSONString((Object)vgChildBrandRedisVo));
        }
        Map map = this.redisTemplateService.hashGetAll((Object)masterChildInfo);
        log.info("\u5f53\u524d\u624b\u673a\u53f7:{}\u521d\u59cb\u5316\u54c1\u724c\u4ff1\u4e50\u90e8\u53c2\u6570:{}", (Object)phone, (Object)JSON.toJSONString((Object)map));
    }
}

