/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl.seckill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.BrandService;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.interfaces.vg.VGLoginService;
import com.bizvane.appletservice.models.vo.ChildsVo;
import com.bizvane.appletservice.models.vo.ConfirmGoodsVo;
import com.bizvane.appletservice.models.vo.GoodSkuSpecDetailsVo;
import com.bizvane.appletservice.models.vo.MainSpecVo;
import com.bizvane.appletservice.models.vo.ShopClassifyMapVo;
import com.bizvane.appletservice.models.vo.ShopStoreSkuVo;
import com.bizvane.appletservice.models.vo.ShopStoreVo;
import com.bizvane.appletservice.models.vo.ShopVo;
import com.bizvane.appletservice.models.vo.SysStoreInfoVO;
import com.bizvane.appletservice.models.vo.seckill.SeckillActivityBaseRequestVO;
import com.bizvane.appletserviceimpl.channel.action.ChannelActionMessage;
import com.bizvane.appletserviceimpl.enums.SysBusinessResponseEnum;
import com.bizvane.appletserviceimpl.handler.AppletBizvaneException;
import com.bizvane.appletserviceimpl.impl.seckill.SecKillActivityAppletCouponDTO;
import com.bizvane.appletserviceimpl.impl.seckill.SeckillActivityCouponResponseVO;
import com.bizvane.appletserviceimpl.impl.seckill.SeckillActivityResponseVO;
import com.bizvane.appletserviceimpl.mappers.LocalHandwrittenMapper;
import com.bizvane.appletserviceimpl.utils.CouponUtils;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.models.bo.CouponIntegralExchangeBO;
import com.bizvane.mktcenterservice.models.po.MktCouponIntegralExchangePO;
import com.bizvane.mktcenterservice.models.vo.CouponIntegralExchangeVO;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.models.vo.MktCouponIntegralExchangeVO;
import com.bizvane.mktcenterservice.models.vo.MktGiftBagVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatenterprise.service.entity.vo.StoreOrderInformVO;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.integral.GoodSkuSpecDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralClassify;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoodsSku;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralSpec;
import com.wmeimob.fastboot.bizvane.enums.skyworth.IntegralGoodsPriceTypeEnum;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.po.IntegralActivityPOWithBLOBs;
import com.wmeimob.fastboot.bizvane.service.rpc.vg.IntegralActivityRpcService;
import com.wmeimob.fastboot.bizvane.service.rpc.vg.IntegralGoodsRpcService;
import com.wmeimob.fastboot.bizvane.service.seckill.SeckillActivityRpcService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityBaseSearchVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityCouponDTO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityResponseRpcVO;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SeckillActivityService {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityService.class);
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private BrandService brandService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private VGLoginService vgLoginService;
    @Autowired
    private IntegrationShopService integrationShopService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private IntegralGoodsRpcService integralGoodsRpcService;
    @Autowired
    private IntegralActivityRpcService integralActivityRpcService;
    @Resource
    private LocalHandwrittenMapper localHandwrittenMapper;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    SeckillActivityRpcService seckillActivityRpcService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;
    @Autowired
    private ChannelActionMessage channelActionMessage;
    private static final String GENERATEORDEER = "api/wx/orders/confirmGoods";
    @Value(value="${wxStore.baseUrl}")
    private String DOMAINNAME;

    public Result<SeckillActivityResponseVO> getActivityGoodsList(SeckillActivityBaseRequestVO requestVO) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(requestVO.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("SeckillActivityServiceImpl|getActivityGoodsList|singleMemberModel:{}", JSON.toJSON((Object)singleMemberModel));
        MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
        if (memberModelData == null) {
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        try {
            SeckillActivityBaseSearchVO search = new SeckillActivityBaseSearchVO();
            search.setActivityCode(requestVO.getActivityCode());
            search.setPageSize(requestVO.getPageSize());
            search.setPageIndex(requestVO.getPageIndex());
            Result result = this.seckillActivityRpcService.getSeckillActivityGoodsList(search);
            log.info("SeckillActivityServiceImpl|goodsList={}", (Object)JSONObject.toJSONString((Object)result));
            SeckillActivityResponseVO response = new SeckillActivityResponseVO();
            if (!result.isSuccess() || result.getData() == null) {
                return Result.failure((Integer)result.getCode(), (String)result.getMessage());
            }
            response.setGoodsRpcVOList(((SeckillActivityResponseRpcVO)result.getData()).getGoodsRpcVOList());
            response.setActivityVO(((SeckillActivityResponseRpcVO)result.getData()).getActivityVO());
            return Result.success((Object)response, (Long)result.getTotal());
        }
        catch (Exception e) {
            log.error("SeckillActivityServiceImpl|getActivityGoodsList|msg:{},exception:{}", (Object)e.getMessage(), (Object)e);
            throw new AppletBizvaneException("\u83b7\u53d6\u79d2\u6740\u6d3b\u52a8\u5546\u54c1\u5217\u8868\u5931\u8d25");
        }
    }

    public Result<SeckillActivityResponseVO> getGoodsDetail(SeckillActivityBaseRequestVO requestVO) {
        try {
            SeckillActivityBaseSearchVO search = new SeckillActivityBaseSearchVO();
            search.setActivityCode(requestVO.getActivityCode());
            search.setGoodsId(Integer.valueOf(Integer.parseInt(requestVO.getGoodsId())));
            Result result = this.seckillActivityRpcService.getGoodsDetail(search);
            if (result.getData() == null) {
                return Result.success();
            }
            if (((SeckillActivityResponseRpcVO)result.getData()).getIntegralGoods() == null) {
                return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u4e0d\u5b58\u5728~");
            }
            log.info("SeckillActivityServiceImpl|goodsDetail:{}", (Object)JSON.toJSONString((Object)result.getData()));
            ShopStoreVo shopStoreVo = this.buildShopStoreVo(((SeckillActivityResponseRpcVO)result.getData()).getIntegralGoods());
            log.info("SeckillActivityServiceImpl|shopStoreVo:{}", (Object)JSONObject.toJSONString((Object)shopStoreVo));
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("seckillActivity_integrationShopGoodId:" + requestVO.getGoodsId()), (Object)JSON.toJSONString((Object)shopStoreVo), 300000L);
            SeckillActivityResponseVO response = new SeckillActivityResponseVO();
            response.setShopStoreVo(shopStoreVo);
            response.setActivityVO(((SeckillActivityResponseRpcVO)result.getData()).getActivityVO());
            return Result.success((Object)response);
        }
        catch (Exception e) {
            log.error("SeckillActivityServiceImpl|goodsDetail|msg:{},exception:{}", (Object)e.getMessage(), (Object)e);
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)SysResponseEnum.FAILED.getMessage());
        }
    }

    public Result<SeckillActivityCouponResponseVO> getActivityExchangeCouponList(SeckillActivityBaseRequestVO requestVO, HttpServletRequest request) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(requestVO.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("SeckillActivityServiceImpl|getActivityGoodsList|singleMemberModel:{}", JSON.toJSON((Object)singleMemberModel));
        MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
        if (memberModelData == null) {
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        try {
            SeckillActivityBaseSearchVO search = new SeckillActivityBaseSearchVO();
            search.setActivityCode(requestVO.getActivityCode());
            search.setPageSize(requestVO.getPageSize());
            search.setPageIndex(requestVO.getPageIndex());
            Result result = this.seckillActivityRpcService.getExchangeCouponsList(search);
            log.info("SeckillActivityServiceImpl|couponList={}", (Object)JSONObject.toJSONString((Object)result));
            if (!result.isSuccess() || result.getData() == null) {
                return Result.failure((Integer)result.getCode(), (String)result.getMessage());
            }
            SeckillActivityCouponResponseVO vo = new SeckillActivityCouponResponseVO();
            List response = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)((SeckillActivityResponseRpcVO)result.getData()).getCoupons())) {
                ResponseData exchangeCoupon = this.getExchangeCoupon(requestVO.getSysBrandId(), requestVO.getSysCompanyId(), Integer.valueOf(1), Integer.valueOf(200), Boolean.valueOf(false), Boolean.valueOf(false), null, null, request);
                log.info("SeckillActivityService.getActivityExchangeCouponList exchangeCoupon:{}", (Object)JSON.toJSONString((Object)exchangeCoupon));
                List list = new ArrayList();
                if (exchangeCoupon.getCode() != 0) {
                    return Result.failure((String)exchangeCoupon.getMessage());
                }
                CouponIntegralExchangeBO data = (CouponIntegralExchangeBO)exchangeCoupon.getData();
                PageInfo pageInfo = data.getPageInfo();
                list = pageInfo.getList();
                Map<Long, MktCouponIntegralExchangeVO> idMapExchange = list.stream().collect(Collectors.toMap(MktCouponIntegralExchangePO::getExchangeId, e -> e));
                List coupons = ((SeckillActivityResponseRpcVO)result.getData()).getCoupons();
                response = coupons.stream().filter(coupon -> {
                    MktCouponIntegralExchangeVO exchangeVO = (MktCouponIntegralExchangeVO)idMapExchange.get(coupon.getExchangeId());
                    return exchangeVO != null && exchangeVO.getSalesStatus() == 1;
                }).map(coupon -> {
                    SecKillActivityAppletCouponDTO dto = new SecKillActivityAppletCouponDTO();
                    dto.setExchangeId(coupon.getExchangeId());
                    dto.setSeckilllActivityCouponDTO(coupon);
                    dto.setQuantityRedeemed(coupon.getQuantityRedeemed());
                    dto.setMktCouponIntegralExchangeVO((MktCouponIntegralExchangeVO)idMapExchange.get(coupon.getExchangeId()));
                    return dto;
                }).collect(Collectors.toList());
                if (requestVO.getExchangeId() != null) {
                    response = response.stream().filter(dto -> dto.getExchangeId().equals(requestVO.getExchangeId())).collect(Collectors.toList());
                }
            }
            vo.setCouponDTOList(response);
            vo.setActivityVO(((SeckillActivityResponseRpcVO)result.getData()).getActivityVO());
            return Result.success((Object)vo, (Long)result.getTotal());
        }
        catch (Exception e2) {
            log.error("SeckillActivityServiceImpl|getActivitycouponList|msg:{},exception:{}", (Object)e2.getMessage(), (Object)e2);
            throw new AppletBizvaneException("\u83b7\u53d6\u79d2\u6740\u6d3b\u52a8\u5151\u6362\u5238\u5217\u8868\u5931\u8d25");
        }
    }

    public Result<SeckillActivityCouponResponseVO> getExchangeCouponDetail(SeckillActivityBaseRequestVO requestVO, HttpServletRequest request) {
        try {
            SeckillActivityBaseSearchVO search = new SeckillActivityBaseSearchVO();
            search.setActivityCode(requestVO.getActivityCode());
            search.setExchangeId(requestVO.getExchangeId());
            search.setPageSize(requestVO.getPageSize());
            search.setPageIndex(requestVO.getPageIndex());
            Result rpcResult = this.seckillActivityRpcService.getExchangeCouponsDetail(search);
            log.info("SeckillActivityServiceImpl|coupondetail={}", (Object)JSONObject.toJSONString((Object)rpcResult));
            if (!rpcResult.isSuccess() || rpcResult.getData() == null) {
                return Result.failure((Integer)rpcResult.getCode(), (String)rpcResult.getMessage());
            }
            CouponRecordVO couponRecordVO = new CouponRecordVO();
            couponRecordVO.setExchangeId(requestVO.getExchangeId());
            couponRecordVO.setSysCompanyId(requestVO.getSysCompanyId());
            couponRecordVO.setBrandId(requestVO.getSysBrandId());
            ResponseData couponAndPrice = this.getCouponAndPrice(request, couponRecordVO);
            if (couponAndPrice.getCode() != 0) {
                return Result.failure((String)couponAndPrice.getMessage());
            }
            SeckillActivityCouponResponseVO vo = new SeckillActivityCouponResponseVO();
            SeckillActivityResponseRpcVO result = (SeckillActivityResponseRpcVO)rpcResult.getData();
            vo.setPriceData((CouponIntegralExchangeVO)couponAndPrice.getData());
            vo.setActivityVO(((SeckillActivityResponseRpcVO)rpcResult.getData()).getActivityVO());
            if (!CollectionUtils.isEmpty((Collection)result.getCoupons())) {
                vo.setCouponDTO((SeckillActivityCouponDTO)result.getCoupons().get(0));
            }
            return Result.success((Object)vo);
        }
        catch (Exception e) {
            log.error("SeckillActivityServiceImpl|couponsDetail|msg:{},exception:{}", (Object)e.getMessage(), (Object)e);
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)SysResponseEnum.FAILED.getMessage());
        }
    }

    private ResponseData<CouponIntegralExchangeBO> getExchangeCoupon(Long brandId, Long companyId, Integer pageNumber, Integer pageSize, Boolean canConvertCoupon, Boolean hotGoods, Integer getTarget, Integer exchangePriceType, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        try {
            Object data;
            CouponRecordVO couponRecordVO = new CouponRecordVO();
            couponRecordVO.setPageNumber(pageNumber);
            couponRecordVO.setPageSize(pageSize);
            couponRecordVO.setBrandId(brandId);
            couponRecordVO.setCanConvertCoupon(canConvertCoupon);
            couponRecordVO.setHotGoods(hotGoods);
            couponRecordVO.setExchangePriceType(exchangePriceType);
            couponRecordVO.setSysCompanyId(companyId);
            log.info("IntegrationShopController#getExchangeCoupon#couponRecordVO:{}", (Object)JSON.toJSONString((Object)couponRecordVO));
            String bizvaneSessionId = request.getHeader("bizvaneSessionId");
            if (bizvaneSessionId == null) {
                responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
                return responseData;
            }
            String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
            log.info("integrationShopGetall memberCode:{}", (Object)memberCode);
            if (memberCode == null) {
                responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                responseData.setCode(-100);
                return responseData;
            }
            if (couponRecordVO.getCanConvertCoupon() == null) {
                responseData.setMessage("\u67e5\u8be2\u52fe\u9009\u6846\u4e3anull");
                responseData.setCode(100);
                return responseData;
            }
            couponRecordVO.setMemberCode(memberCode);
            Long serviceStoreId = this.wxAppletApiService.getOpenCardStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
            try {
                ResponseData config = this.integrationShopService.getConfig(Integer.valueOf(couponRecordVO.getBrandId().intValue()));
                data = config.getData();
                JSONObject json = (JSONObject)JSON.toJSON((Object)data);
                log.info("IntegrationShopController#integrationShopGetall#169# configMap:{}", (Object)json);
                if (!couponRecordVO.getCanConvertCoupon().booleanValue()) {
                    log.info("hiddenGoods:{}", (Object)json.getBoolean("hiddenGoods"));
                    couponRecordVO.setHiddenGoods(json.getBoolean("hiddenGoods"));
                }
            }
            catch (Exception e) {
                log.info("IntegrationShopController#integrationShopGetall#157 Exception :{},:{}", (Object)e.getMessage(), (Object)e);
            }
            couponRecordVO.setOpenCardStoreId(serviceStoreId);
            ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
            data = (MemberCardLevelModel)modelResponseData.getData();
            Integer integral = data.getCountIntegral();
            log.info("integrationShopGetall memberCode:{},memberResp:{}", (Object)memberCode, (Object)JSONObject.toJSONString((Object)modelResponseData));
            if (integral != null) {
                couponRecordVO.setCountIntegral(integral);
            }
            couponRecordVO.setMbrLevelId(data.getLevelId());
            log.info("\u5165\u53c2222222222====" + JSON.toJSON((Object)couponRecordVO));
            ResponseData convernCouponLists = this.taskServiceForWXRpc.getConvernCouponListsForActivity(couponRecordVO);
            log.info("integrationShopGetall convernCouponLists:{}", (Object)JSON.toJSONString((Object)convernCouponLists));
            try {
                CouponUtils.mergeCouponListsApplicableBrandCodes((ResponseData)convernCouponLists);
                log.info("\u683c\u5f0f\u5316\u540e\u6570\u636e:{}", (Object)JSON.toJSONString((Object)convernCouponLists));
            }
            catch (Exception e) {
                log.warn("IntegrationShopController#getExchangeCoupon\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            }
            return convernCouponLists;
        }
        catch (Exception e) {
            log.warn("IntegrationShopController#getExchangeCoupon\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    public ResponseData getCouponAndPrice(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        SysBrandPo sysBrandPo;
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        couponRecordVO.setMemberCode(memberCode);
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setOpenId(openId);
        log.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        ResponseData couponAndPrice = this.taskServiceForWXRpc.getCouponAndPriceForActivity(couponRecordVO);
        CouponIntegralExchangeVO priceData = (CouponIntegralExchangeVO)couponAndPrice.getData();
        if (org.springframework.util.StringUtils.isEmpty((Object)priceData)) {
            log.info("priceData=======null");
            return couponAndPrice;
        }
        Long twCLubBrandId = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)priceData.getExchangeClubId()) && (sysBrandPo = this.brandService.getBrandById(Long.valueOf(priceData.getExchangeClubId()))) != null) {
            twCLubBrandId = sysBrandPo.getParentId();
            priceData.setExchangeClubName(sysBrandPo.getBrandName());
        }
        if (twCLubBrandId != null) {
            SysBrandPo twSysBrandPo = this.brandService.getBrandById(twCLubBrandId);
            priceData.setExchangeClubId(twCLubBrandId.toString());
            priceData.setExchangeClubName(twSysBrandPo.getBrandName());
            List mbrLevelModelList = priceData.getMbrLevelModelList();
            if (!CollectionUtils.isEmpty((Collection)mbrLevelModelList)) {
                List transformTwLevel = this.integrationShopService.transformTwLevel(twCLubBrandId, mbrLevelModelList);
                priceData.setMbrLevelModelList(transformTwLevel);
            }
        }
        priceData.setMktCouponIntegralExchangePOWithBLOBs(null);
        MktGiftBagVO giftBagVO = priceData.getGiftBagVO();
        if (!org.springframework.util.StringUtils.isEmpty((Object)giftBagVO)) {
            log.info("\u52b5\u5305\u8f6c\u5316\u663e\u793a");
            List couponDefinitionPOList = giftBagVO.getCouponDefinitionPOList();
            CouponDefinitionPO couponDefinition2 = new CouponDefinitionPO();
            StringBuilder listCodeBuilder = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)couponDefinitionPOList)) {
                for (CouponDefinitionPOWithBLOBs coupon : couponDefinitionPOList) {
                    CouponUtils.convertApplicableBrandCodes((CouponDefinitionPO)coupon, (int)2);
                    listCodeBuilder.append(coupon.getApplicableBrandCodes());
                    listCodeBuilder.append(",");
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)listCodeBuilder)) {
                    couponDefinition2.setApplicableBrandCodes(listCodeBuilder.toString());
                    CouponUtils.convertApplicableBrandCodes((CouponDefinitionPO)couponDefinition2, (int)2);
                    priceData.setCouponDefinitionPO(couponDefinition2);
                }
            }
        } else {
            log.info("\u52b5\u8f6c\u5316\u663e\u793a");
            CouponDefinitionPO couponDefinitionPo = priceData.getCouponDefinitionPO();
            if (!org.springframework.util.StringUtils.isEmpty((Object)couponDefinitionPo)) {
                CouponUtils.convertApplicableBrandCodes((CouponDefinitionPO)couponDefinitionPo, (int)2);
            }
        }
        return couponAndPrice;
    }

    public ShopStoreVo buildShopStoreVo(IntegralGoods goods) {
        ShopStoreVo shopStoreVo = new ShopStoreVo();
        shopStoreVo.setShopId(String.valueOf(goods.getId()));
        shopStoreVo.setGoodsNo(goods.getGoodsNo());
        shopStoreVo.setGoodsName(goods.getGoodsName());
        shopStoreVo.setShelf(String.valueOf(goods.getShelf()));
        shopStoreVo.setClassifyId(goods.getClassifyId());
        shopStoreVo.setCoverImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)goods.getCoverImg()));
        String[] splits = goods.getBannerImgPaths().split(",");
        ArrayList<String> stringList = new ArrayList<String>();
        for (String split : splits) {
            String splitsDome = QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)split);
            stringList.add(splitsDome);
        }
        shopStoreVo.setBannerImgPaths(stringList);
        shopStoreVo.setHot(String.valueOf(goods.getHot()));
        shopStoreVo.setPrice(String.valueOf(goods.getPrice()));
        shopStoreVo.setUpperShelfTime(String.valueOf(goods.getUpperShelfTime()));
        shopStoreVo.setRestrictedNum(String.valueOf(goods.getRestrictedNum()));
        shopStoreVo.setActualSales(String.valueOf(goods.getActualSales()));
        shopStoreVo.setDistributionMode(goods.getDistributionMode());
        shopStoreVo.setExchangeInstructions(goods.getExchangeInstructions());
        shopStoreVo.setGoodsDetails(goods.getGoodsDetails());
        shopStoreVo.setExchangeStatus(goods.getExchangeStatus());
        shopStoreVo.setExchangeCount(goods.getExchangeCount());
        shopStoreVo.setIsWholeStore(goods.getIsWholeStore());
        shopStoreVo.setGoodsType(goods.getGoodsType());
        shopStoreVo.setTotalStock(goods.getTotalStock());
        shopStoreVo.setPriceType(goods.getPriceType());
        shopStoreVo.setCashPrice(String.valueOf(goods.getCashPrice()));
        shopStoreVo.setTemplateId(goods.getIntegralExpressTemplateId());
        shopStoreVo.setFreightType(goods.getFreightType());
        shopStoreVo.setDefaultFreight(goods.getDefaultFreight());
        shopStoreVo.setVideoUrl(goods.getVideoUrl());
        shopStoreVo.setVideoPictureUrl(goods.getVideoPictureUrl());
        List storeInfoList = goods.getStoreInfoList();
        ArrayList storeList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)storeInfoList)) {
            storeInfoList.forEach(store -> {
                SysStoreInfoVO dto = new SysStoreInfoVO();
                BeanUtils.copyProperties((Object)store, (Object)dto);
                storeList.add(dto);
            });
        }
        shopStoreVo.setSecondPrice(goods.getSecondPrice() == null ? "0" : String.valueOf(goods.getSecondPrice()));
        shopStoreVo.setSecondCashPrice(goods.getSecondCashPrice() == null ? "0.00" : String.valueOf(goods.getSecondCashPrice()));
        shopStoreVo.setStoreInfoList(storeList);
        this.buildCLubMerInfo(shopStoreVo, goods);
        this.buildGoodsSkus(shopStoreVo, goods);
        this.buildGoodsClassify(shopStoreVo, goods);
        return shopStoreVo;
    }

    private void buildCLubMerInfo(ShopStoreVo shopStoreVo, IntegralGoods goods) {
        SysBrandPo sysBrandPo;
        String clubId = goods.getClubId();
        Boolean mbrLevelStatus = goods.getMbrLevelStatus();
        Long parentClubId = null;
        shopStoreVo.setExchangeClubId(clubId);
        if (StringUtils.isNotBlank((CharSequence)clubId) && (sysBrandPo = this.brandService.getBrandById(Long.valueOf(clubId))) != null) {
            parentClubId = sysBrandPo.getParentId();
            shopStoreVo.setExchangeClubName(sysBrandPo.getBrandName());
        }
        if (StringUtils.isNotBlank((CharSequence)clubId) && mbrLevelStatus != null && mbrLevelStatus.booleanValue()) {
            ResponseData levelListResponseData = this.memberLevelApiService.queryAllLevelList(Long.valueOf(clubId));
            List levelList = (List)levelListResponseData.getData();
            if (SysResponseEnum.SUCCESS.getCode() != levelListResponseData.getCode() || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)levelList)) {
                throw new MallCommonException("\u7b49\u7ea7\u5217\u8868\u67e5\u8be2\u5931\u8d25");
            }
            List<String> mbrLevelIdList = Arrays.asList(goods.getMbrLevelIds().split(","));
            List mbrLevelModelList = levelList.stream().filter(mbrLevelModel -> mbrLevelIdList.contains(mbrLevelModel.getMbrLevelId().toString())).collect(Collectors.toList());
            shopStoreVo.setMbrLevelModelList(mbrLevelModelList);
            shopStoreVo.setMbrLevelStatus(mbrLevelStatus);
        } else {
            shopStoreVo.setMbrLevelStatus(Boolean.valueOf(false));
        }
        if (parentClubId != null) {
            SysBrandPo twSysBrandPo = this.brandService.getBrandById(parentClubId);
            shopStoreVo.setExchangeClubId(parentClubId.toString());
            shopStoreVo.setExchangeClubName(twSysBrandPo.getBrandName());
            List mbrLevelModelList = shopStoreVo.getMbrLevelModelList();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)mbrLevelModelList)) {
                List transformTwLevel = this.transformTwLevel(parentClubId, mbrLevelModelList);
                shopStoreVo.setMbrLevelModelList(transformTwLevel);
            }
        }
    }

    private void buildGoodsSkus(ShopStoreVo shopStoreVo, IntegralGoods goods) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)goods.getSkus())) {
            ShopVo shopVo = new ShopVo();
            ArrayList<ShopStoreSkuVo> shopStoreSkuVos = new ArrayList<ShopStoreSkuVo>();
            ArrayList<ShopStoreSkuVo> shopSkuVo = new ArrayList<ShopStoreSkuVo>();
            ArrayList<MainSpecVo> shopMainSpecVo = new ArrayList<MainSpecVo>();
            ArrayList<ChildsVo> shopChildsVoList = new ArrayList<ChildsVo>();
            for (IntegralGoodsSku sku : goods.getSkus()) {
                ShopStoreSkuVo shopStoreSkuVo = new ShopStoreSkuVo();
                ShopStoreSkuVo storeSkuVo = new ShopStoreSkuVo();
                String skuId = String.valueOf(sku.getId());
                shopStoreSkuVo.setSkuId(String.valueOf(sku.getId()));
                shopStoreSkuVo.setGoodsId(String.valueOf(sku.getGoodsId()));
                shopStoreSkuVo.setSpecNames(sku.getSpecNames());
                shopStoreSkuVo.setSpecIds(sku.getSpecIds());
                shopStoreSkuVo.setSkuNo(sku.getSkuNo());
                shopStoreSkuVo.setSkuImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)sku.getSkuImg()));
                shopStoreSkuVo.setSkuPrice(String.valueOf(sku.getPrice()));
                shopStoreSkuVo.setStock(String.valueOf(sku.getStock()));
                shopStoreSkuVo.setEnabled(String.valueOf(sku.getEnabled()));
                shopStoreSkuVo.setCashPrice(String.valueOf(sku.getCashPrice()));
                shopStoreSkuVo.setSecondPrice(String.valueOf(sku.getSecondPrice()));
                shopStoreSkuVo.setSecondCashPrice(String.valueOf(sku.getSecondCashPrice()));
                shopStoreSkuVo.setPriceStock(sku.getPriceStock().toString());
                shopStoreSkuVo.setCashPriceStock(sku.getCashPriceStock().toString());
                shopStoreSkuVo.setCashBonusStock(sku.getCashBonusStock().toString());
                storeSkuVo.setSkuId(String.valueOf(sku.getId()));
                storeSkuVo.setSpecNames(sku.getSpecNames());
                storeSkuVo.setSkuImg(sku.getSkuImg());
                shopSkuVo.add(storeSkuVo);
                List goodSkuSpecDetails = sku.getGoodSkuSpecDetails();
                ArrayList<GoodSkuSpecDetailsVo> detailsVoList = new ArrayList<GoodSkuSpecDetailsVo>();
                for (GoodSkuSpecDTO skuSpec : goodSkuSpecDetails) {
                    String uuid = UUIDUtils.getUUID();
                    GoodSkuSpecDetailsVo goodSkuSpecDetailsVo = new GoodSkuSpecDetailsVo();
                    MainSpecVo mainSpecVo = new MainSpecVo();
                    mainSpecVo.setMainSpecName(skuSpec.getMainSpec().getSpecName());
                    mainSpecVo.setMainSpecPid(String.valueOf(skuSpec.getMainSpec().getPid()));
                    mainSpecVo.setMainSpecId(String.valueOf(skuSpec.getMainSpec().getId()));
                    mainSpecVo.setGoodSkuSpecDetailsID(uuid);
                    mainSpecVo.setSkuId(skuId);
                    shopMainSpecVo.add(mainSpecVo);
                    goodSkuSpecDetailsVo.setSkuId(skuId);
                    goodSkuSpecDetailsVo.setMainSpecVo(mainSpecVo);
                    goodSkuSpecDetailsVo.setGoodSkuSpecDetailsID(uuid);
                    List childs = skuSpec.getChilds();
                    ArrayList<ChildsVo> childsVoList = new ArrayList<ChildsVo>();
                    for (IntegralSpec child : childs) {
                        ChildsVo childsVo = new ChildsVo();
                        childsVo.setChildsId(String.valueOf(child.getId()));
                        childsVo.setChildsSpecPid(String.valueOf(child.getPid()));
                        childsVo.setChildsSpecName(child.getSpecName());
                        childsVo.setGoodSkuSpecDetailsID(uuid);
                        childsVo.setSkuId(skuId);
                        childsVoList.add(childsVo);
                        shopChildsVoList.add(childsVo);
                    }
                    goodSkuSpecDetailsVo.setChildsVoList(childsVoList);
                    detailsVoList.add(goodSkuSpecDetailsVo);
                }
                shopStoreSkuVo.setGoodSkuSpecDetails(detailsVoList);
                shopStoreSkuVos.add(shopStoreSkuVo);
            }
            shopStoreVo.setShopStoreSkuVos(shopStoreSkuVos);
            shopVo.setShopSkuVo(shopSkuVo);
            shopVo.setShopMainSpecVo(shopMainSpecVo);
            shopVo.setShopChildsVoList(shopChildsVoList);
            shopStoreVo.setShopVo(shopVo);
        } else {
            shopStoreVo.setShopStoreSkuVos(null);
        }
    }

    private void buildGoodsClassify(ShopStoreVo shopStoreVo, IntegralGoods goods) {
        List classifyList = goods.getClassifyList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)classifyList)) {
            ArrayList<ShopClassifyMapVo> shopClassifyMapVos = new ArrayList<ShopClassifyMapVo>();
            for (IntegralClassify classify : classifyList) {
                ShopClassifyMapVo shopClassifyMapVo = new ShopClassifyMapVo();
                shopClassifyMapVo.setClassID(String.valueOf(classify.getId()));
                shopClassifyMapVo.setClassifyName(classify.getName());
                shopClassifyMapVo.setClassifyNo(classify.getClassifyNo());
                shopClassifyMapVo.setClassifyDescribe(classify.getClassifyDescribe());
                shopClassifyMapVo.setSort(String.valueOf(classify.getSort()));
                shopClassifyMapVo.setClassifyImg(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classify.getClassifyImg()));
                shopClassifyMapVo.setClassifyHome(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classify.getClassifyHome()));
                shopClassifyMapVo.setClassifyIcon(QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)classify.getClassifyIcon()));
                shopClassifyMapVos.add(shopClassifyMapVo);
            }
            shopStoreVo.setClassifyMapVos(shopClassifyMapVos);
        } else {
            shopStoreVo.setClassifyMapVos(null);
        }
    }

    public Result<IntegralOrders> createOrder(SeckillActivityBaseRequestVO requestVO, HttpServletRequest request) {
        ShopStoreVo shopStoreVo;
        String clubId;
        ConfirmGoodsVo confirmGoodsVo = requestVO.getConfirmGoodsVo();
        String redisJsonString = (String)this.redisTemplateService.stringGetStringByKey((Object)("seckillActivity_integrationShopGoodId:" + confirmGoodsVo.getGoodId()));
        if (StringUtils.isEmpty((CharSequence)redisJsonString)) {
            log.error("SeckillActivityServiceImpl|redisJsonString is null");
            return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u7f51\u7edc\u5f02\u5e38,\u5237\u65b0\u5f53\u524d\u9875\u9762\u91cd\u8bd5");
        }
        MemberInfoModel memberInfo = this.getMemberInfo(confirmGoodsVo.getMemberCode());
        if (!IntegralGoodsPriceTypeEnum.CASH.getType().equals(confirmGoodsVo.getPriceType())) {
            if (IntegralGoodsPriceTypeEnum.INTEGRAL_AND_CASH.getType().equals(confirmGoodsVo.getPriceType()) && StringUtils.isNotEmpty((CharSequence)confirmGoodsVo.getSecondPrice()) && Integer.valueOf(confirmGoodsVo.getSecondPrice()) > memberInfo.getCountIntegral()) {
                return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
            }
            if (IntegralGoodsPriceTypeEnum.INTEGRAL.getType().equals(confirmGoodsVo.getPriceType()) && Integer.valueOf(confirmGoodsVo.getSaleIntegral()) > memberInfo.getCountIntegral()) {
                return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)"\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(clubId = (shopStoreVo = (ShopStoreVo)JSON.parseObject((String)redisJsonString, ShopStoreVo.class)).getExchangeClubId()))) {
            List mbrLevelIds;
            MemberInfoModel memberInfoModelClub = this.vgLoginService.simpleJoinClub(request, memberInfo, Long.valueOf(clubId));
            if (memberInfoModelClub == null) {
                return Result.failure((Integer)SysResponseEnum.FAILED.getCode(), (String)SysResponseEnum.FAILED.getMessage());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopStoreVo.getMbrLevelModelList()) && !(mbrLevelIds = shopStoreVo.getMbrLevelModelList().stream().map(MbrLevelModel::getMbrLevelId).collect(Collectors.toList())).contains(memberInfoModelClub.getLevelId())) {
                return Result.failure((Integer)SysBusinessResponseEnum.BUSINESS_DEFINED_CODE_NOT_EXCHANGE_ALLOWED.getCode(), (String)SysBusinessResponseEnum.BUSINESS_DEFINED_CODE_NOT_EXCHANGE_ALLOWED.getMessage());
            }
        }
        IntegralOrders integralOrders = this.buildIntegralOrder(confirmGoodsVo, memberInfo);
        integralOrders.setOrderRemark(requestVO.getOrderRemark());
        log.info("SeckillActivityService|integralOrders:{}", (Object)JSON.toJSONString((Object)integralOrders));
        SeckillActivityBaseSearchVO createOrder = new SeckillActivityBaseSearchVO();
        createOrder.setActivityCode(requestVO.getActivityCode());
        createOrder.setIntegralOrders(integralOrders);
        Result result = this.seckillActivityRpcService.createOrder(createOrder);
        this.toSendChannelActionMessage(requestVO.getSourceId(), result);
        return result;
    }

    private void toSendChannelActionMessage(Long sourceId, Result<IntegralOrders> result) {
        log.info("toSendChannelActionMessage, sourceId:{}, result:{}", (Object)sourceId, result);
        if (sourceId == null || result.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.info("toSendChannelActionMessage, \u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u4e0d\u89e6\u53d1\u6e20\u9053\u4e8b\u4ef6");
            return;
        }
        this.channelActionMessage.sendChannelActionPartakenMessageByIntegralOrders(sourceId, (IntegralOrders)result.getData());
    }

    private Integer caseMemberGender(String memberGender) {
        Integer result = null;
        try {
            result = StringUtils.isNotBlank((CharSequence)memberGender) ? Integer.valueOf(memberGender) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private ResponseData generateOrderWithLable(ConfirmGoodsVo confirmGoodsVo) {
        ResponseData responseData = new ResponseData();
        String memberCode = confirmGoodsVo.getMemberCode();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("\u79ef\u5206\u751f\u6210\u8ba2\u5355generateOrder\u7684memberCode:{},\u83b7\u53d6crm\u7528\u6237\u4fe1\u606f\u4e3a:{}", (Object)memberCode, JSON.toJSON((Object)singleMemberModel));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2SingleMemberModel\u8fd4\u56de:[{}]", JSON.toJSON((Object)singleMemberModel));
        MemberInfoModel memberInfo = (MemberInfoModel)singleMemberModel.getData();
        confirmGoodsVo.setMemberCode(memberCode);
        confirmGoodsVo.setMemberPhone(memberInfo.getPhone());
        confirmGoodsVo.setMemberName(memberInfo.getName());
        confirmGoodsVo.setMemberCardNo(memberInfo.getCardNo());
        confirmGoodsVo.setSysBrandId(String.valueOf(memberInfo.getBrandId()));
        confirmGoodsVo.setSysCompanyId(memberInfo.getSysCompanyId());
        String redisJsonString = (String)this.redisTemplateService.stringGetStringByKey((Object)("seckillActivity_integrationShopGoodId:" + confirmGoodsVo.getGoodId()));
        if (StringUtils.isEmpty((CharSequence)redisJsonString)) {
            responseData.setMessage("\u7f51\u7edc\u5f02\u5e38,\u5237\u65b0\u5f53\u524d\u9875\u9762\u91cd\u8bd5");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/json");
            HashMap<String, String> stringMap = new HashMap<String, String>();
            stringMap.put("merchantId", confirmGoodsVo.getSysBrandId());
            stringMap.put("sysCompanyId", confirmGoodsVo.getSysCompanyId() + "");
            stringMap.put("memberCode", confirmGoodsVo.getMemberCode());
            stringMap.put("memberCardNo", confirmGoodsVo.getMemberCardNo());
            stringMap.put("memberName", confirmGoodsVo.getMemberName());
            stringMap.put("memberPhone", confirmGoodsVo.getMemberPhone());
            stringMap.put("goodId", confirmGoodsVo.getGoodId());
            stringMap.put("goodNo", confirmGoodsVo.getGoodNo());
            stringMap.put("shippingName", confirmGoodsVo.getShippingName());
            stringMap.put("shippingMobile", confirmGoodsVo.getShippingMobile());
            stringMap.put("shippingProvince", confirmGoodsVo.getShippingProvince());
            stringMap.put("shippingCity", confirmGoodsVo.getShippingCity());
            stringMap.put("shippingDistrict", confirmGoodsVo.getShippingDistrict());
            stringMap.put("shippingAddress", confirmGoodsVo.getShippingAddress());
            stringMap.put("userComments", confirmGoodsVo.getUserComments());
            stringMap.put("goodSkuNo", confirmGoodsVo.getGoodSkuNo());
            stringMap.put("goodSkuSpecNames", confirmGoodsVo.getGoodSkuSpecNames());
            stringMap.put("saleQuantity", confirmGoodsVo.getSaleQuantity());
            stringMap.put("orderType", confirmGoodsVo.getOrderType());
            stringMap.put("openId", confirmGoodsVo.getOpenId());
            stringMap.put("templateId", confirmGoodsVo.getTemplateId());
            stringMap.put("exchangeStatus", StringUtils.isEmpty((CharSequence)confirmGoodsVo.getExchangeStatus()) ? "0" : confirmGoodsVo.getExchangeStatus());
            stringMap.put("exchangeCount", StringUtils.isEmpty((CharSequence)confirmGoodsVo.getExchangeCount()) ? "0" : confirmGoodsVo.getExchangeCount());
            if (StringUtils.isNotBlank((CharSequence)confirmGoodsVo.getSelfPickTime())) {
                stringMap.put("selfPickTimeStr", confirmGoodsVo.getSelfPickTime());
            }
            ResponseData configData = this.integrationShopService.getConfig(Integer.valueOf(Integer.parseInt(confirmGoodsVo.getSysBrandId())));
            log.info("\u6240\u83b7\u53d6\u7684\u914d\u7f6e:{}", (Object)JSONObject.toJSONString((Object)configData));
            Object data = configData.getData();
            JSONObject json = (JSONObject)JSON.toJSON((Object)data);
            String isDeliverCheck = json.getString("isDeliverCheck");
            String deliverAuditorMark = json.getString("deliverAuditorMark");
            if (StringUtils.isNotBlank((CharSequence)isDeliverCheck) && 1 == Integer.parseInt(isDeliverCheck)) {
                log.info("\u6267\u884c\u4e86\u9700\u8981\u53d1\u8d27\u903b\u8f91=======:{}", (Object)JSONObject.toJSONString((Object)isDeliverCheck));
                stringMap.put("isDeliverCheck", "1");
                stringMap.put("deliverAuditorMark", deliverAuditorMark);
            } else {
                log.info("\u6267\u884c\u4e86\u4e0d\u9700\u8981\u53d1\u8d27\u903b\u8f91====:{}", (Object)JSONObject.toJSONString((Object)isDeliverCheck));
                stringMap.put("isDeliverCheck", "0");
            }
            if (memberInfo.getLevelId() != null) {
                ResponseData mbrLevelModelResponseData = this.memberLevelApiService.queryLevelModel(memberInfo.getLevelId());
                String levelName = ((MbrLevelModel)mbrLevelModelResponseData.getData()).getLevelName();
                stringMap.put("levelName", levelName);
            }
            String storeCode = "";
            if (StringUtils.isNotEmpty((CharSequence)confirmGoodsVo.getStoreId())) {
                ResponseData codeById = this.storeServiceRpc.getStoreCodeById(Long.valueOf(confirmGoodsVo.getStoreId()));
                storeCode = (String)codeById.getData();
                ResponseData distributorNameResponseData = this.storeServiceRpc.getDistributorName(Long.valueOf(confirmGoodsVo.getStoreId()));
                log.info("generateOrder#distributorNameResponseData#814:{}", (Object)JSON.toJSONString((Object)distributorNameResponseData));
                if (distributorNameResponseData.getData() != null) {
                    String distributorName = distributorNameResponseData.getData().toString();
                    stringMap.put("distributorName", distributorName);
                }
            }
            stringMap.put("storeCode", storeCode);
            stringMap.put("storeName", confirmGoodsVo.getStoreName());
            stringMap.put("storeId", confirmGoodsVo.getStoreId());
            log.info("generateOrder={}", (Object)JSON.toJSONString(stringMap));
            String generateOrder = HttpUtil.post((String)(this.DOMAINNAME + GENERATEORDEER), (String)JSON.toJSONString(stringMap), map);
            JSONObject jsonObject = JSON.parseObject((String)generateOrder);
            String code = jsonObject.getString("code");
            String msg = jsonObject.getString("msg");
            String orderNo = jsonObject.getString("data");
            log.info("generateOrderResult={}", (Object)generateOrder);
            if ("0".equals(code)) {
                if (StringUtils.isNotEmpty((CharSequence)confirmGoodsVo.getStoreId())) {
                    StoreOrderInformVO soiVO = new StoreOrderInformVO();
                    soiVO.setMemberName(confirmGoodsVo.getMemberName());
                    soiVO.setMemberPhone(confirmGoodsVo.getMemberPhone());
                    soiVO.setOrderDate(sdf.format(new Date()));
                    soiVO.setOrderNo(orderNo);
                    soiVO.setStoreName(confirmGoodsVo.getStoreName());
                    soiVO.setSysBrandId(((MemberInfoModel)singleMemberModel.getData()).getBrandId());
                    soiVO.setSysCompanyId(((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId());
                    soiVO.setSysStoreId(Long.valueOf(confirmGoodsVo.getStoreId()));
                    soiVO.setSysStoreOfflineCode(storeCode);
                    log.info("memberInfoModel={}", (Object)((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId());
                    log.info("\u901a\u77e5\u4f01\u5fae\u63a5\u53e3\u5165\u53c2{}", (Object)JSON.toJSONString((Object)soiVO));
                }
                JSONObject dataJson = jsonObject.getJSONObject("data");
                responseData.setData((Object)dataJson);
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                return responseData;
            }
            responseData.setMessage(msg);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        catch (Exception e) {
            log.info("\u8fdb\u5165Exception20191230");
            log.error(e.getMessage(), (Throwable)e);
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
    }

    public IntegralOrders buildIntegralOrder(ConfirmGoodsVo confirmGoodsVo, MemberInfoModel memberInfo) {
        ResponseData mbrLevelModelResponseData;
        IntegralOrders order = new IntegralOrders();
        order.setMerchantId(Integer.valueOf(memberInfo.getBrandId().intValue()));
        order.setSysCompanyId(memberInfo.getSysCompanyId());
        order.setMemberCode(memberInfo.getMemberCode());
        order.setMemberCardNo(memberInfo.getCardNo());
        order.setMemberName(memberInfo.getName());
        order.setMemberPhone(memberInfo.getPhone());
        order.setMemberGender(this.caseMemberGender(memberInfo.getGender()));
        order.setGoodId(Integer.valueOf(Integer.parseInt(confirmGoodsVo.getGoodId())));
        order.setGoodNo(confirmGoodsVo.getGoodNo());
        order.setShippingName(confirmGoodsVo.getShippingName());
        order.setShippingMobile(confirmGoodsVo.getShippingMobile());
        order.setShippingProvince(confirmGoodsVo.getShippingProvince());
        order.setShippingCity(confirmGoodsVo.getShippingCity());
        order.setShippingDistrict(confirmGoodsVo.getShippingDistrict());
        order.setShippingAddress(confirmGoodsVo.getShippingAddress());
        order.setUserComments(confirmGoodsVo.getUserComments());
        order.setGoodSkuNo(confirmGoodsVo.getGoodSkuNo());
        order.setGoodSkuSpecNames(confirmGoodsVo.getGoodSkuSpecNames());
        order.setSaleQuantity(Integer.valueOf(Integer.parseInt(confirmGoodsVo.getSaleQuantity())));
        order.setOrderType(confirmGoodsVo.getOrderType());
        order.setOpenId(confirmGoodsVo.getOpenId());
        order.setTemplateId(confirmGoodsVo.getTemplateId());
        order.setExchangeStatus(StringUtils.isEmpty((CharSequence)confirmGoodsVo.getExchangeStatus()) ? "0" : confirmGoodsVo.getExchangeStatus());
        order.setExchangeCount(StringUtils.isEmpty((CharSequence)confirmGoodsVo.getExchangeCount()) ? "0" : confirmGoodsVo.getExchangeCount());
        order.setOrderRemark(confirmGoodsVo.getOrderRemark());
        order.setGoodsType(confirmGoodsVo.getGoodsType());
        if (StringUtils.isNotBlank((CharSequence)confirmGoodsVo.getSelfPickTime())) {
            order.setSelfPickTimeStr(confirmGoodsVo.getSelfPickTime());
        }
        ResponseData configData = new ResponseData();
        try {
            configData = this.integrationShopService.getConfig(Integer.valueOf(memberInfo.getBrandId().intValue()));
        }
        catch (IOException e) {
            log.error("buildIntegralOrder|configData:{},{}", (Object)e.getMessage(), (Object)e);
        }
        log.info("\u6240\u83b7\u53d6\u7684\u914d\u7f6e:{}", (Object)JSONObject.toJSONString((Object)configData));
        Object data = configData.getData();
        JSONObject json = (JSONObject)JSON.toJSON((Object)data);
        String isDeliverCheck = json.getString("isDeliverCheck");
        String deliverAuditorMark = json.getString("deliverAuditorMark");
        if (StringUtils.isNotBlank((CharSequence)isDeliverCheck) && 1 == Integer.parseInt(isDeliverCheck)) {
            log.info("\u6267\u884c\u4e86\u9700\u8981\u53d1\u8d27\u903b\u8f91=======:{}", (Object)JSONObject.toJSONString((Object)isDeliverCheck));
            order.setIsDeliverCheck("1");
            order.setDeliverAuditorMark(deliverAuditorMark);
        } else {
            log.info("\u6267\u884c\u4e86\u4e0d\u9700\u8981\u53d1\u8d27\u903b\u8f91====:{}", (Object)JSONObject.toJSONString((Object)isDeliverCheck));
            order.setIsDeliverCheck("0");
        }
        if (memberInfo.getLevelId() != null && (mbrLevelModelResponseData = this.memberLevelApiService.queryLevelModel(memberInfo.getLevelId())).getData() != null) {
            order.setLevelName(((MbrLevelModel)mbrLevelModelResponseData.getData()).getLevelName());
        }
        String storeCode = "";
        if (StringUtils.isNotEmpty((CharSequence)String.valueOf(memberInfo.getOpenCardStoreId()))) {
            ResponseData codeById = this.storeServiceRpc.getStoreCodeById(memberInfo.getOpenCardStoreId());
            storeCode = (String)codeById.getData();
            ResponseData distributorNameResponseData = this.storeServiceRpc.getDistributorName(memberInfo.getOpenCardStoreId());
            log.info("generateOrder#distributorNameResponseData#814:{}", (Object)JSON.toJSONString((Object)distributorNameResponseData));
            if (distributorNameResponseData.getData() != null) {
                order.setDistributorName(distributorNameResponseData.getData().toString());
            }
        }
        order.setStoreCode(storeCode);
        order.setStoreName(confirmGoodsVo.getStoreName());
        order.setStoreId(Integer.valueOf(Objects.isNull(confirmGoodsVo.getStoreId()) ? memberInfo.getOpenCardStoreId().intValue() : Integer.parseInt(confirmGoodsVo.getStoreId())));
        order.setGmtCreate(new Date());
        order.setPriceType(confirmGoodsVo.getPriceType());
        return order;
    }

    private MemberInfoModel getMemberInfo(String memberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        if (singleMemberModel == null || singleMemberModel.getData() == null) {
            log.error("SeckillActivityService|\u79d2\u6740\u8ba2\u5355\u7684memberCode:{}", (Object)memberCode);
            throw new MallCommonException("\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        log.info("SeckillActivityService|\u79d2\u6740\u8ba2\u5355\u7684memberCode:{},\u83b7\u53d6crm\u7528\u6237\u4fe1\u606f\u4e3a:{}", (Object)memberCode, JSON.toJSON((Object)singleMemberModel.getData()));
        return (MemberInfoModel)singleMemberModel.getData();
    }

    private Boolean checkMemberLabelMatch(ConfirmGoodsVo confirmGoodsVo, String memberCode) {
        try {
            com.wmeimob.fastboot.bizvane.utils.response.ResponseData goodsInfo = this.integralGoodsRpcService.getGoodsInfo(Integer.valueOf(confirmGoodsVo.getGoodId()));
            IntegralGoods integralGoods = (IntegralGoods)goodsInfo.getData();
            if (goodsInfo.getCode() != SysResponseEnum.SUCCESS.getCode() || integralGoods == null) {
                log.info("checkMemberLabelMatch integralGoods is null");
                return Boolean.FALSE;
            }
            Boolean activityJudge = integralGoods.getActivityJudge();
            if (!activityJudge.booleanValue()) {
                log.info("checkMemberLabelMatch activityJudge is false,return");
                return Boolean.TRUE;
            }
            com.wmeimob.fastboot.bizvane.utils.response.ResponseData activeActivityMatchResponse = this.integralActivityRpcService.checkActiveActivityMatchAnyGoodsId(Long.valueOf(confirmGoodsVo.getGoodId()));
            Boolean matchActivity = (Boolean)activeActivityMatchResponse.getData();
            if (activeActivityMatchResponse.getCode() != SysResponseEnum.SUCCESS.getCode() || matchActivity == null) {
                log.info("checkMemberLabelMatch checkActiveActivityMatchAnyGoodsId is null");
                return Boolean.FALSE;
            }
            log.info("checkMemberLabelMatch matchActivity is :{}", (Object)matchActivity);
            if (!matchActivity.booleanValue()) {
                log.info("checkMemberLabelMatch matchActivity is not match");
                return Boolean.FALSE;
            }
            Long sysBrandId = Long.valueOf(confirmGoodsVo.getSysBrandId());
            com.wmeimob.fastboot.bizvane.utils.response.ResponseData activeActivityOne = this.integralActivityRpcService.getActiveActivityOne(sysBrandId);
            IntegralActivityPOWithBLOBs enableIntegralActivity = (IntegralActivityPOWithBLOBs)activeActivityOne.getData();
            if (activeActivityOne.getCode() != SysResponseEnum.SUCCESS.getCode() || enableIntegralActivity == null) {
                log.info("checkMemberLabelMatch enableIntegralActivity is null");
                return Boolean.FALSE;
            }
            com.wmeimob.fastboot.bizvane.utils.response.ResponseData enableActivityMatchResponse = this.integralActivityRpcService.checkActiveActivityMatchGoodsId(enableIntegralActivity.getIntegralActivityId(), Long.valueOf(confirmGoodsVo.getGoodId()));
            Boolean enableMatchActivity = (Boolean)enableActivityMatchResponse.getData();
            if (enableActivityMatchResponse.getCode() != SysResponseEnum.SUCCESS.getCode() || enableMatchActivity == null) {
                log.info("checkMemberLabelMatch checkActiveActivityMatchGoodsId is null");
                return Boolean.FALSE;
            }
            if (!enableMatchActivity.booleanValue()) {
                log.info("checkMemberLabelMatch enableMatchActivity is false");
                return Boolean.FALSE;
            }
            if (enableIntegralActivity.getBeginTime() == null || enableIntegralActivity.getEndTime() == null) {
                log.info("checkMemberLabelMatch activity beginTime and endTime is any null");
                return Boolean.FALSE;
            }
            int matchDate = this.localHandwrittenMapper.queryBetweenTwoDate(enableIntegralActivity.getBeginTime(), enableIntegralActivity.getEndTime());
            if (matchDate == 0) {
                log.info("checkMemberLabelMatch matchDate is 0 , not need check autolabel");
                return Boolean.FALSE;
            }
            MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
            membersInfoSearchVo.setMemberCode(memberCode);
            Byte activityRange = enableIntegralActivity.getActivityRange();
            if (activityRange == null) {
                log.info("checkMemberLabelMatch activityRange is null");
                return Boolean.FALSE;
            }
            if (activityRange == 0) {
                log.info("checkMemberLabelMatch activityRange is 0");
                return Boolean.TRUE;
            }
            membersInfoSearchVo.setAutoLabel(Boolean.TRUE);
            membersInfoSearchVo.setAutoLabelIdList(Arrays.asList(enableIntegralActivity.getAutoLabelId()));
            membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
            membersInfoSearchVo.setPageSize(Integer.valueOf(1));
            membersInfoSearchVo.setBrandId(Long.valueOf(confirmGoodsVo.getSysBrandId()));
            membersInfoSearchVo.setSysCompanyId(confirmGoodsVo.getSysCompanyId());
            ResponseData pageInfoResponseData = this.memberInfoApiService.vgSearch(membersInfoSearchVo);
            log.info("checkMemberLabelMatch vgSearch:{}", (Object)JSON.toJSONString((Object)pageInfoResponseData));
            com.bizvane.utils.responseinfo.PageInfo memberInfoVoPageInfo = (com.bizvane.utils.responseinfo.PageInfo)pageInfoResponseData.getData();
            if (activeActivityOne.getCode() != SysResponseEnum.SUCCESS.getCode() || memberInfoVoPageInfo == null) {
                log.info("checkMemberLabelMatch pageInfoResponseData is null");
                return Boolean.FALSE;
            }
            List memberInfoVoList = memberInfoVoPageInfo.getList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)memberInfoVoList)) {
                log.info("checkMemberLabelMatch memberInfoVoList is null");
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.info("checkMemberLabelMatch_error:{}", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    private List<MbrLevelModel> transformTwLevel(Long parentClubId, List<MbrLevelModel> mbrLevelModelList) {
        ArrayList<MbrLevelModel> twMbrLevelModels = new ArrayList<MbrLevelModel>();
        ResponseData twLevelListResponseData = this.memberLevelApiService.queryAllLevelList(Long.valueOf(parentClubId));
        List twLevelList = (List)twLevelListResponseData.getData();
        for (int i = 0; i < mbrLevelModelList.size(); ++i) {
            MbrLevelModel mbrLevelModelClub = mbrLevelModelList.get(i);
            MbrLevelModel mbrLevelModelTw = twLevelList.stream().filter(mbrLevelModel -> mbrLevelModel.getOfflineLevelCode().equals(mbrLevelModelClub.getOfflineLevelCode())).findFirst().orElse(null);
            if (mbrLevelModelTw == null) continue;
            twMbrLevelModels.add(mbrLevelModelTw);
        }
        log.info("transformTwLevel:{}", (Object)JSON.toJSONString(twMbrLevelModels));
        return twMbrLevelModels;
    }

    public Result<SeckillActivityResponseVO> checkOrder(SeckillActivityBaseRequestVO requestVO) {
        log.info("SeckillActivityServiceImpl|checkOrder|request={}", (Object)JSONObject.toJSONString((Object)requestVO));
        if (requestVO.getConfirmGoodsVo().getGoodSkuNo() == null || requestVO.getConfirmGoodsVo().getGoodId() == null || requestVO.getConfirmGoodsVo().getSaleQuantity() == null || requestVO.getPriceType() == null) {
            return Result.failure((String)"sku\u7f16\u7801\u3001\u5546\u54c1id\u3001\u5546\u54c1\u6570\u91cf\u3001\u5546\u54c1\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SeckillActivityBaseSearchVO search = new SeckillActivityBaseSearchVO();
        search.setActivityCode(requestVO.getActivityCode());
        search.setPriceType(requestVO.getPriceType());
        IntegralOrders orders = new IntegralOrders();
        orders.setGoodId(Integer.valueOf(Integer.parseInt(requestVO.getConfirmGoodsVo().getGoodId())));
        orders.setGoodSkuNo(requestVO.getConfirmGoodsVo().getGoodSkuNo());
        orders.setSaleQuantity(Integer.valueOf(Integer.parseInt(requestVO.getConfirmGoodsVo().getSaleQuantity())));
        orders.setMemberCode(requestVO.getConfirmGoodsVo().getMemberCode());
        orders.setGmtCreate(new Date());
        search.setIntegralOrders(orders);
        Result result = this.seckillActivityRpcService.checkOrder(search);
        log.info("SeckillActivityServiceImpl|checkOrder|result={}", (Object)JSONObject.toJSONString((Object)result));
        if (result.isSuccess()) {
            return Result.success();
        }
        return Result.failure((Integer)result.getCode(), (String)result.getMessage());
    }
}

