/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.wechatmall;

import com.alibaba.fastjson.JSON;
import com.beust.jcommander.internal.Lists;
import com.bizvane.appletserviceimpl.controllers.wechatmall.MemberCodesReqDto;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.query.MemberSearchEsRequestPo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.google.common.base.Throwables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/IntegralOrder"})
public class IntegralOrderDistributorNameService {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrderDistributorNameService.class);
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    @GetMapping(value={"/getDistributorNameByStoreId"})
    public ResponseData getDistributorNameByStoreCode(@RequestParam String memberCode) {
        log.info("IntegralOrderDistributorNameService#getDistributorNameByStoreCode storeId:{}", (Object)JSON.toJSONString((Object)memberCode));
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getMemberModel(memberInfoModel);
        log.info("singleMemberModel:{}", (Object)JSON.toJSONString((Object)singleMemberModel.getData()));
        MemberInfoModel data = (MemberInfoModel)singleMemberModel.getData();
        return this.storeServiceRpc.getDistributorName(data.getOpenCardStoreId());
    }

    @PostMapping(value={"/getDistributorNameByMemberCodes"})
    public ResponseData<Map<String, String>> getDistributorNameByMemberCodes(@RequestBody MemberCodesReqDto reqDto) {
        log.info("IntegralOrderDistributorNameService#getDistributorNameByMemberCodes memberCodes:{}", (Object)JSON.toJSONString((Object)reqDto.getMemberCodes()));
        try {
            MemberSearchEsRequestPo memberInfoModel = new MemberSearchEsRequestPo();
            memberInfoModel.setMemberCodes(reqDto.getMemberCodes());
            memberInfoModel.setSysBrandId(Long.valueOf(1L));
            ResponseData listResponseData = this.memberInfoApiService.getMemberInfoPojoByEs(memberInfoModel);
            log.info("listResponseData:{}", (Object)JSON.toJSONString((Object)listResponseData.getData()));
            List list = (List)listResponseData.getData();
            Map<String, Long> collect = list.stream().filter(e -> e.getOpenCardStoreId() != null).collect(Collectors.toMap(MembersInfoSearchPojo::getMemberCode, MembersInfoSearchPojo::getOpenCardStoreId, (v1, v2) -> v2));
            List storeIds = Lists.newArrayList(collect.values());
            ResponseData idStoreLists = this.storeServiceRpc.getIdStoreLists(storeIds);
            Map<Long, String> collect1 = ((List)idStoreLists.getData()).stream().filter(e -> e.getDistributorName() != null).collect(Collectors.toMap(SysStorePo::getSysStoreId, SysStorePo::getDistributorName));
            HashMap resultMap = new HashMap();
            collect.keySet().forEach(key -> resultMap.put(key, collect1.get(collect.get(key))));
            return new ResponseData(resultMap);
        }
        catch (Exception e2) {
            log.info("IntegralOrderDistributorNameService#getDistributorNameByMemberCodes fails:{}", (Object)Throwables.getStackTraceAsString((Throwable)e2));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "getDistributorNameByMemberCodes fail");
        }
    }
}

