/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.ur;

import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.vo.SendStorageCardTargetMemberVO;
import com.bizvane.appletserviceimpl.utils.Assert;
import com.bizvane.customized.facade.interfaces.StorageCardServiceFeign;
import com.bizvane.customized.facade.models.vo.CusUrStorageCardReceivedVO;
import com.bizvane.customized.facade.models.vo.CusUrStorageCardSendVO;
import com.bizvane.members.facade.service.ur.UrMemberApiService;
import com.bizvane.members.facade.ur.vo.MembersEsRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u50a8\u503c\u5361\u5fae\u4fe1\u6e20\u9053"})
@RequestMapping(value={"/ur/storageCard"})
@RestController
public class StorageCardController {
    private static final Logger log = LoggerFactory.getLogger(StorageCardController.class);
    @Autowired
    private StorageCardServiceFeign storageCardServiceFeign;
    @Autowired
    private UrMemberApiService urMemberApiService;
    @Autowired
    private LoginService loginService;

    @ApiOperation(value="\u50a8\u503c\u5361\u8f6c\u589e", notes="\u5fae\u4fe1\u516c\u4f17\u53f7\u5c0f\u7a0b\u5e8f\u8c03\u7528\u6b64\u63a5\u53e3\u8f6c\u8d60\u50a8\u503c\u5361")
    @PostMapping(value={"/sendStorageCard"})
    public ResponseData sendStorageCard(@RequestBody CusUrStorageCardSendVO vo) {
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        vo.setMemberCode(memberResourceBO.getMemberCode());
        vo.setSysCompanyId(memberResourceBO.getSysCompanyId());
        vo.setBrandId(memberResourceBO.getBrandId());
        return this.storageCardServiceFeign.sendStorageCard(vo);
    }

    @ApiOperation(value="\u50a8\u503c\u5361\u53d7\u8d60", notes="\u5fae\u4fe1\u516c\u4f17\u53f7\u5c0f\u7a0b\u5e8f\u8c03\u7528\u6b64\u63a5\u53e3\u83b7\u53d6\u53d7\u8d60\u7684\u50a8\u503c\u5361")
    @PostMapping(value={"/receivedStorageCard"})
    public ResponseData receivedSendStorageCard(@RequestBody CusUrStorageCardReceivedVO vo) {
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        vo.setMemberCode(memberResourceBO.getMemberCode());
        vo.setSysCompanyId(memberResourceBO.getSysCompanyId());
        vo.setBrandId(memberResourceBO.getBrandId());
        return this.storageCardServiceFeign.receivedSendStorageCard(vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u6807\u4eba", notes="\u5fae\u4fe1\u516c\u4f17\u53f7\u5c0f\u7a0b\u5e8f\u8c03\u7528\u6b64\u63a5\u53e3\u9009\u62e9\u8d60\u9001\u7684\u4f1a\u5458")
    @PostMapping(value={"/getTargetMember"})
    public ResponseData getTargetMember(@RequestBody SendStorageCardTargetMemberVO vo) {
        MemberResoucreBO memberResourceBO = this.loginService.getMemberResourceBO();
        MembersEsRequestVo membersEsRequestVo = new MembersEsRequestVo();
        membersEsRequestVo.setBrandId(memberResourceBO.getBrandId());
        membersEsRequestVo.setSysCompanyId(memberResourceBO.getSysCompanyId());
        membersEsRequestVo.setWxMembers(Boolean.valueOf(true));
        Assert.notAllNull((String)"\u8bf7\u8f93\u5165\u4f1a\u5458\u5361\u53f7\u6216\u624b\u673a\u53f7\uff01", (Object[])new Object[]{vo.getMemberCode(), vo.getPhone()});
        if (StringUtils.isNotBlank((CharSequence)vo.getMemberCode())) {
            membersEsRequestVo.setCardNo(vo.getMemberCode());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getPhone())) {
            membersEsRequestVo.setPhone(vo.getPhone());
        }
        return this.urMemberApiService.getMembersListPageable(membersEsRequestVo);
    }
}

