/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.alipay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.alipayfacade.interfaces.AlipayPublicServiceFeign;
import com.bizvane.alipayfacade.models.po.AlipayPublicPo;
import com.bizvane.appletservice.interfaces.MenberCenterPersonalService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletserviceimpl.utils.HttpClient;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.members.facade.vo.ExtendPropertyFormVO;
import com.bizvane.members.facade.vo.ExtendPropertySingleVO;
import com.bizvane.members.facade.vo.ExtendPropertyValueVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alipayMenberCenterPersonal"})
public class AlipayMenberCenterPersonalController {
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private MenberCenterPersonalService menberCenterPersonalService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private AlipayPublicServiceFeign alipayPublicServiceFeign;
    @Autowired
    HttpClient httpClient;
    @Value(value="${admin.mall.userAddress.domain}")
    private String domain;
    private final String methodName = "/getDefault?mbrMemberId=";
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/updateBaseAndExtendPropertyValue"}, method={RequestMethod.POST})
    public ResponseData<MemberInfoModel> updateBaseAndExtendPropertyValue(ExtendPropertyValueVO extendPropertyValueVO, String code, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        logger.info("\u66f4\u6539\u4e2a\u4eba\u8d44\u6599\u5165\u53c2={}", (Object)JSON.toJSONString((Object)extendPropertyValueVO));
        logger.info("\u5165\u53c2code={}", (Object)code);
        String appid = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        ResponseData alipayPublicByAppid = this.alipayPublicServiceFeign.getAlipayPublicByAppid(appid);
        Long sysBrandId = ((AlipayPublicPo)alipayPublicByAppid.getData()).getSysBrandId();
        Long sysCompanyId = ((AlipayPublicPo)alipayPublicByAppid.getData()).getSysCompanyId();
        String pName = extendPropertyValueVO.getPropertyName();
        logger.info("extendPropertyValueVO.getPropertyValue()={}", (Object)extendPropertyValueVO.getPropertyValue());
        String redisCode = (String)this.redisTemplateService.stringGetStringByKey((Object)extendPropertyValueVO.getPropertyValue());
        if ("\u624b\u673a".equals(pName) && !code.equals(redisCode)) {
            responseData.setMessage("\u9a8c\u8bc1\u7801\u8d85\u65f6\u6216\u8005\u8f93\u5165\u9519\u8bef");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        extendPropertyValueVO.setMemberCode(memberCode);
        extendPropertyValueVO.setBrandId(sysBrandId);
        extendPropertyValueVO.setSysCompanyId(sysCompanyId);
        ResponseData extendPropertyValue = this.wxAppletApiService.updateBaseAndExtendPropertyValue(extendPropertyValueVO);
        if (extendPropertyValue.getCode() == 0) {
            AppletBrandMenberBo appletBrandMenberBo = new AppletBrandMenberBo();
            appletBrandMenberBo.setMemberCode(memberCode);
            appletBrandMenberBo.setSysBrandId(sysBrandId);
            appletBrandMenberBo.setPropertyCode(extendPropertyValueVO.getPropertyCode());
            if (sysCompanyId != null) {
                appletBrandMenberBo.setSysCompanyId(sysCompanyId);
            }
            this.menberCenterPersonalService.designatedPerfectData(appletBrandMenberBo, bizvaneSessionId);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    @RequestMapping(value={"/updatePropertyValueForm"}, method={RequestMethod.POST})
    public ResponseData<MemberInfoModel> updatePropertyValueForm(String extendPropertySingleVOList, HttpServletRequest request) {
        ExtendPropertyFormVO extendPropertyFormVO = new ExtendPropertyFormVO();
        List eList = JSONObject.parseArray((String)extendPropertySingleVOList, ExtendPropertySingleVO.class);
        logger.info("\u89e3\u6790\u540e\u7684list = {}", (Object)JSON.toJSONString((Object)eList));
        extendPropertyFormVO.setExtendPropertySingleVOList(eList);
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        logger.info("\u66f4\u6539\u4e2a\u4eba\u8d44\u6599\u5165\u53c2\uff08\u591a\u9879\uff09={}", (Object)JSON.toJSONString((Object)extendPropertyFormVO));
        String appid = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        ResponseData alipayPublicByAppid = this.alipayPublicServiceFeign.getAlipayPublicByAppid(appid);
        Long sysBrandId = ((AlipayPublicPo)alipayPublicByAppid.getData()).getSysBrandId();
        Long sysCompanyId = ((AlipayPublicPo)alipayPublicByAppid.getData()).getSysCompanyId();
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        logger.info("\u66f4\u6539\u4e2a\u4eba\u8d44\u6599\u5165\u53c2\uff08\u591a\u9879\uff09#memberCode:{}", (Object)memberCode);
        extendPropertyFormVO.setBrandId(sysBrandId);
        extendPropertyFormVO.setSysCompanyId(sysCompanyId);
        extendPropertyFormVO.setMemberCode(memberCode);
        StringBuilder code = new StringBuilder();
        for (ExtendPropertySingleVO e : eList) {
            if (!StringUtils.isNotEmpty((CharSequence)e.getPropertyValue())) continue;
            code.append(",").append(e.getPropertyCode());
        }
        String propertyCode = code.substring(1, code.length());
        ResponseData updatePropertyValueForm = this.wxAppletApiService.updatePropertyValueForm(extendPropertyFormVO);
        logger.info("wxAppletApiService#updatePropertyValueForm() result:{}", (Object)JSONObject.toJSONString((Object)updatePropertyValueForm));
        if (updatePropertyValueForm.getCode() == 0) {
            AppletBrandMenberBo appletBrandMenberBo = new AppletBrandMenberBo();
            appletBrandMenberBo.setMemberCode(memberCode);
            appletBrandMenberBo.setSysBrandId(sysBrandId);
            if (sysCompanyId != null) {
                appletBrandMenberBo.setSysCompanyId(sysCompanyId);
            }
            appletBrandMenberBo.setPropertyCode(propertyCode);
            this.menberCenterPersonalService.designatedPerfectData(appletBrandMenberBo, bizvaneSessionId);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }
}

