/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.appletservice.models.bo.OpenCardeModels;
import com.bizvane.appletservice.models.po.MemberInfoModelPO;
import com.bizvane.appletservice.models.po.MemberSysAccountPO;
import com.bizvane.appletservice.models.vo.vg.VGMbrRegisterRequestVo;
import com.bizvane.appletserviceimpl.impl.vg.TestVGLoginServiceImpl;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCompanyPo;
import com.bizvane.centerstageservice.models.po.SysMerchantStoreRelPo;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.MerchantInfoRequestVO;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.CompanyServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysMerchantServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.out.huairen.HuaiRenGetStocksRequestVO;
import com.bizvane.connectorservice.entity.out.huairen.HuaiRenGetStocksResponseVO;
import com.bizvane.connectorservice.entity.yzw.IntegralOrderRequestVo;
import com.bizvane.connectorservice.interfaces.rpc.ConnectorServiceFeign;
import com.bizvane.connectorservice.interfaces.rpc.OutOfConnectServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponServiceFeign;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponOnlineUseRequestVO;
import com.bizvane.customized.facade.interfaces.IntegralMallServiceFeign;
import com.bizvane.customized.facade.models.vo.shininghouse.IntegerOrderPushRequestVO;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.bo.GetMemberDeductionInfo;
import com.bizvane.members.facade.service.api.IntegralChangeApiService;
import com.bizvane.members.facade.service.api.MallOpenCardService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.MiniProgramFocusOnService;
import com.bizvane.members.facade.service.api.MiniProgramOpenCardService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.members.facade.service.card.request.FocusOnRequestModel;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.request.MallOpenCardRequestVo;
import com.bizvane.members.facade.service.card.request.RequestOpenCardModel;
import com.bizvane.members.facade.service.card.response.FocusOnResponseModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.members.facade.service.card.response.MallOpenCardResponseVo;
import com.bizvane.members.facade.service.card.response.ResponseOpenCardModel;
import com.bizvane.members.facade.service.electcard.ElectCardConfigApiService;
import com.bizvane.members.facade.service.electcard.MbrElectCardOpenErrorRpcService;
import com.bizvane.members.facade.service.electcard.MemberElectCardOpenCardApiService;
import com.bizvane.members.facade.service.qywxapi.CompanyMemberApiService;
import com.bizvane.members.facade.vo.MbrElectCardOpenErrorVo;
import com.bizvane.members.facade.vo.MbrElectCardVO;
import com.bizvane.members.facade.vo.MemberAuthorizeInsertTaskItemRequestVo;
import com.bizvane.members.facade.vo.MemberElectCardRequestVo;
import com.bizvane.members.facade.vo.MemberElectCardResponseVo;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.vo.ActivityManualVO;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityManualServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.JWTUtil;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberWxStoreInterfce"})
public class MemberWxStoreInterfceController {
    private static final Logger log = LoggerFactory.getLogger(MemberWxStoreInterfceController.class);
    @Autowired
    private ActivityManualServiceRpc activityManualServiceRpc;
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private CouponServiceFeign couponServiceFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private MiniProgramOpenCardService miniProgramOpenCardService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private MiniProgramFocusOnService focusByMiniProgram;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private MemberElectCardOpenCardApiService memberElectCardOpenCardApiService;
    @Autowired
    private ActivityEGServiceRpc activityEGServiceRpc;
    @Autowired
    private IntegralChangeApiService integralChangeApiService;
    @Autowired
    private CompanyServiceRpc companyServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private MemberInfoApiService MemberInfoApiService;
    @Autowired
    private CompanyMemberApiService companyMemberApiService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private MallOpenCardService mallOpenCardService;
    @Autowired
    private IntegralMallServiceFeign integralMallServiceFeign;
    @Autowired
    private OutOfConnectServiceFeign huaiRenService;
    @Autowired
    private SysMerchantServiceRpc sysMerchantServiceRpc;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private MbrElectCardOpenErrorRpcService mbrElectCardOpenErrorRpcService;
    @Autowired
    private ElectCardConfigApiService electCardConfigApiService;
    @Autowired
    private TestVGLoginServiceImpl testVGLoginService;
    @Autowired
    private ConnectorServiceFeign connectorServiceFeign;

    @RequestMapping(value={"/getToken"})
    public ResponseData getToken(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String stageToken = request.getHeader("stageToken");
        if (stageToken == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6 token");
            responseData.setData(null);
            return responseData;
        }
        SysAccountPO sysAccountPO = (SysAccountPO)JWTUtil.unsign((String)stageToken, SysAccountPO.class);
        log.info("MemberWxStoreInterfceController#getToken sysAccountPO:{}", (Object)JSON.toJSONString((Object)sysAccountPO));
        String token = JWTUtil.sign((Object)sysAccountPO, (long)JWTUtil.TTLMILLIS.intValue());
        ResponseData companyById = this.companyServiceRpc.getCompanyById(sysAccountPO.getSysCompanyId());
        ResponseData brandByID = this.brandServiceRpc.getBrandByID(sysAccountPO.getBrandId());
        String brandName = ((SysBrandPo)brandByID.getData()).getBrandName();
        String brandCode = ((SysBrandPo)brandByID.getData()).getBrandCode();
        SysCompanyPo companyByIdData = (SysCompanyPo)companyById.getData();
        String companyName = companyByIdData.getCompanyName();
        MemberSysAccountPO memberSysAccountPO = new MemberSysAccountPO();
        memberSysAccountPO.setToken(token);
        memberSysAccountPO.setCompanyName(companyName);
        memberSysAccountPO.setSysCompanyId(sysAccountPO.getSysCompanyId());
        memberSysAccountPO.setBrandId(sysAccountPO.getBrandId());
        memberSysAccountPO.setName(sysAccountPO.getName());
        memberSysAccountPO.setCompanyCode(companyByIdData.getCompanyCode());
        memberSysAccountPO.setBrandName(brandName);
        memberSysAccountPO.setBrandCode(brandCode);
        memberSysAccountPO.setAccountCode(sysAccountPO.getAccountCode());
        if (sysAccountPO != null) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u7528\u6237\u5df2\u6709\u6743\u9650");
            responseData.setData((Object)memberSysAccountPO);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("\u7528\u6237\u6ca1\u6709\u6743\u9650");
        responseData.setData(null);
        return responseData;
    }

    @RequestMapping(value={"/queryLevelModel"}, method={RequestMethod.POST})
    public ResponseData<MbrLevelModel> queryLevelModel(Long mbrLevelId) {
        ResponseData responseData = new ResponseData();
        if (mbrLevelId == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u7b49\u7ea7id");
            return responseData;
        }
        log.info("\u5fae\u5546\u57ce\u4f1a\u5458\u4f53\u7cfb\u5b9a\u4e49={}", (Object)mbrLevelId);
        return this.memberLevelApiService.queryLevelModel(mbrLevelId);
    }

    @RequestMapping(value={"/getMemberModelInfo"}, method={RequestMethod.POST})
    public ResponseData<MemberInfoModel> getMemberModelInfo(MemberInfoModel memberInfoModel) {
        return this.memberInfoApiService.getMemberModel(memberInfoModel);
    }

    @RequestMapping(value={"/getSingleMemberModelInfo"}, method={RequestMethod.POST})
    public ResponseData<MemberInfoModelPO> findMemberModelInfo(MemberInfoModel memberInfoModel) {
        log.info("MemberWxStoreInterfceController#getSingleMemberModelInfo:{}", (Object)JSON.toJSONString((Object)memberInfoModel));
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("MemberWxStoreInterfceController#getSingleMemberModelInfo singleMemberModel:{}", (Object)JSON.toJSONString((Object)singleMemberModel));
        MemberInfoModelPO result = new MemberInfoModelPO();
        result.setMerchantId(memberInfoModel.getBrandId());
        if (singleMemberModel.getData() == null) {
            return new ResponseData((Object)result);
        }
        BeanUtils.copyProperties((Object)singleMemberModel.getData(), (Object)result);
        log.info("MemberWxStoreInterfceController#getSingleMemberModelInfo result:{}", (Object)JSON.toJSONString((Object)result));
        if (singleMemberModel != null) {
            Long serviceStoreId = ((MemberInfoModel)singleMemberModel.getData()).getServiceStoreId();
            Long openCardStoreId = ((MemberInfoModel)singleMemberModel.getData()).getOpenCardStoreId();
            Long storeIdParam = null;
            storeIdParam = serviceStoreId == null ? openCardStoreId : serviceStoreId;
            log.info("storeServiceRpc # getStoreById:{}", (Object)storeIdParam);
            ResponseData storeById = this.storeServiceRpc.getStoreById(storeIdParam);
            if (storeById != null && storeById.getData() != null) {
                result.setStoreId(((SysStorePo)storeById.getData()).getStoreId());
            }
            MerchantInfoRequestVO merchantInfoRequestVO = new MerchantInfoRequestVO();
            merchantInfoRequestVO.setBrandId(result.getBrandId());
            merchantInfoRequestVO.setSysStoreId(storeIdParam);
            ResponseData merchantByMemberStoreId = this.sysMerchantServiceRpc.getMerchantByMemberStoreId(merchantInfoRequestVO);
            if (SysResponseEnum.SUCCESS.getCode() == merchantByMemberStoreId.getCode()) {
                log.info("MemberWxStoreInterfceController#getSingleMemberModelInfo merchantByMemberStoreId:{}", (Object)JSON.toJSONString((Object)merchantByMemberStoreId));
                result.setMerchantId(((SysMerchantStoreRelPo)merchantByMemberStoreId.getData()).getSysMerchantId());
            }
        }
        return new ResponseData((Object)result);
    }

    @RequestMapping(value={"/getActivityByMemberInfo"}, method={RequestMethod.POST})
    public ResponseData<List<ActivityVO>> getActivityByMemberInfo(ActivityManualVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getMemberInfoModel().getBrandId() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return responseData;
        }
        if (vo.getMemberInfoModel().getMemberCode() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        if (vo.getActivityType() == null) {
            responseData.setMessage("\u6d3b\u52a8\u7c7b\u522b\u672a\u8f93\u5165");
            return responseData;
        }
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(vo.getMemberInfoModel().getMemberCode()).getData();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(vo.getMemberInfoModel().getMemberCode()).getData();
        log.info("\u9886\u52b5openCardStoreId={} , \u9886\u52b5serviceStoreId={}", (Object)openCardStoreId, (Object)serviceStoreId);
        vo.getMemberInfoModel().setServiceStoreId(serviceStoreId);
        vo.getMemberInfoModel().setOpenCardStoreId(openCardStoreId);
        return this.activityManualServiceRpc.getActivityByMemberInfo(vo);
    }

    @RequestMapping(value={"/onlyexecuteActivity"}, method={RequestMethod.POST})
    public ResponseData onlyexecuteActivity(ActivityManualVO vo) {
        log.info("\u9886\u5238\u4e2d\u5fc3\u9886\u53d6={}", (Object)JSON.toJSONString((Object)vo));
        return this.activityManualServiceRpc.executeActivity(vo);
    }

    @RequestMapping(value={"/getCouponListByCondition"}, method={RequestMethod.POST})
    public ResponseData getCouponListByCondition(CouponListByMemberCodeRequestVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getMemberCode() == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        if (vo.getPageNumber() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u9875\u6570");
            return responseData;
        }
        if (vo.getPageSize() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u4e00\u9875\u6570");
            return responseData;
        }
        if (vo.getCouponStatus() == null) {
            responseData.setMessage("\u52b5\u7c7b\u578b\u672a\u8f93\u5165");
            return responseData;
        }
        vo.setQuerySource(Integer.valueOf(1));
        log.info("\u6211\u7684\u4f18\u60e0\u5238\u67e5\u8be2={}", (Object)JSON.toJSONString((Object)vo));
        return this.couponQueryServiceFeign.getCouponListByMemeberCode(vo);
    }

    @RequestMapping(value={"/findCouponDetailByCouponId"}, method={RequestMethod.POST})
    public ResponseData<CouponDetailResponseVO> findCouponDetailByCouponId(Long couponEntityId) {
        ResponseData responseData = new ResponseData();
        if (couponEntityId == null) {
            responseData.setMessage(" \u52b5id");
            return responseData;
        }
        log.info("\u4f18\u60e0\u5238\u8be6\u60c5={}", (Object)couponEntityId);
        return this.couponQueryServiceFeign.getCouponDetail(couponEntityId);
    }

    @RequestMapping(value={"/onlineUse"}, method={RequestMethod.POST})
    public ResponseData<Object> findCouponDetailByCouponId(CouponOnlineUseRequestVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        log.info("\u7ebf\u4e0a\u52b5\u6838\u9500={}", (Object)JSON.toJSONString((Object)vo));
        return this.couponServiceFeign.onlineUse(vo);
    }

    @RequestMapping(value={"/lock"}, method={RequestMethod.POST})
    public ResponseData<Object> lock(CouponEntityVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.lock(vo);
    }

    @RequestMapping(value={"/unlock"}, method={RequestMethod.POST})
    public ResponseData<Object> unlock(CouponEntityVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.unlock(vo);
    }

    @RequestMapping(value={"/refreshtoInterface"})
    public ResponseData<AppletRefreshtoInterfaceBo> refreshtoInterface(String appId) {
        return this.loginService.refreshtoInterface(appId);
    }

    @RequestMapping(value={"/openCardMenbr"})
    public ResponseData openCardMenbr(@RequestBody OpenCardeModels openCardeModels) {
        log.info("\u8fdb\u5165\u65b9\u6cd5openCardMenbr={}", (Object)System.currentTimeMillis());
        ResponseData responseData = new ResponseData();
        log.info("phone={} , appId={} , name={} , openId={} , unionId={},birthday={}", new Object[]{openCardeModels.getPhone(), openCardeModels.getAppId(), openCardeModels.getName(), openCardeModels.getOpenId(), openCardeModels.getUnionId(), openCardeModels.getBirthday()});
        RequestOpenCardModel requestOpenCardModel = new RequestOpenCardModel();
        requestOpenCardModel.setPhone(openCardeModels.getPhone());
        requestOpenCardModel.setOpenId(openCardeModels.getOpenId());
        requestOpenCardModel.setUnionId(openCardeModels.getUnionId());
        requestOpenCardModel.setAppId(openCardeModels.getAppId());
        requestOpenCardModel.setName(openCardeModels.getName());
        requestOpenCardModel.setBirthday(openCardeModels.getBirthday());
        FocusOnRequestModel focusOnRequestModel = new FocusOnRequestModel();
        focusOnRequestModel.setAppId(openCardeModels.getAppId());
        focusOnRequestModel.setOpenId(openCardeModels.getOpenId());
        focusOnRequestModel.setUnionId(openCardeModels.getUnionId());
        focusOnRequestModel.setWxNick(openCardeModels.getName());
        focusOnRequestModel.setMiniProgram(Integer.valueOf(2));
        log.info("\u5173\u6ce8\u5165\u53c2={}", (Object)focusOnRequestModel.toString());
        FocusOnResponseModel focus = this.focusByMiniProgram.focusByMiniProgram(focusOnRequestModel);
        if (focus == null) {
            responseData.setMessage("\u5173\u6ce8\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        log.info("\u8c03\u7528\u5f00\u5361={}", (Object)System.currentTimeMillis());
        ResponseOpenCardModel responseOpenCardModel = this.miniProgramOpenCardService.openCard(requestOpenCardModel);
        log.info("\u8c03\u7528miniProgramOpenCardService\u8fd4\u56de\u65f6\u95f4={}", (Object)System.currentTimeMillis());
        log.info("\u5f00\u5361\u8fd4\u56de={}", (Object)responseOpenCardModel.toString());
        if (responseOpenCardModel != null) {
            Integer operateType = responseOpenCardModel.getOperateType();
            ResponseData wxPublicPOByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(openCardeModels.getAppId());
            Long sysBrandId = ((WxPublicPO)wxPublicPOByAppId.getData()).getSysBrandId();
            log.info("sysBrandId=======" + sysBrandId);
            this.activityService.executeActivity(sysBrandId, responseOpenCardModel.getMemberCode(), operateType);
            log.info("\u8c03\u7528\u6d3b\u52a8\u5f00\u5361\u7ed3\u675f={}", (Object)System.currentTimeMillis());
            responseData.setMessage("\u5f00\u5361\u6210\u529f");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)responseOpenCardModel.getPhone());
            log.info("\u5f00\u5361\u6210\u529f\u8fd4\u56de={}", (Object)System.currentTimeMillis());
            return responseData;
        }
        responseData.setMessage("\u5f00\u5361\u5931\u8d25");
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    @PostMapping(value={"/openCardMenbrClub"})
    public ResponseData<AppletBrandMenberBo> getMbrAndOpenCard(HttpServletRequest request, VGMbrRegisterRequestVo wxMbrRegisteRequestVo) {
        try {
            return this.testVGLoginService.getMbrAndOpenCard(request, wxMbrRegisteRequestVo);
        }
        catch (Exception exception) {
            return new ResponseData(100, exception.getMessage());
        }
    }

    @RequestMapping(value={"/electronicMembershipCardOpenCard"})
    public ResponseData<MemberElectCardResponseVo> electronicMembershipCardOpenCard(MemberElectCardRequestVo memberElectCardRequestVo) {
        MbrElectCardOpenErrorVo mbrElectCardOpenErrorVo;
        Long electCardOpenErrorId;
        log.info("memberElectCardRequestVo={}", (Object)JSON.toJSONString((Object)memberElectCardRequestVo));
        if (StringUtils.isBlank((CharSequence)memberElectCardRequestVo.getWxUnionId())) {
            ResponseData memberElectCardResponseVoResponseData = new ResponseData();
            memberElectCardResponseVoResponseData.setCode(SysResponseEnum.FAILED.getCode());
            memberElectCardResponseVoResponseData.setMessage("\u4e3a\u4e86\u7ed9\u60a8\u63d0\u4f9b\u66f4\u597d\u7684\u4ea7\u54c1\u670d\u52a1\uff0c\u8bf7\u8fd4\u56de\u4e0a\u4e00\u9875\u9762\u5173\u6ce8\u516c\u4f17\u53f7\u540e\u518d\u8fdb\u884c\u63d0\u4ea4\uff0c\u611f\u8c22\u60a8\u7684\u652f\u6301~");
            return memberElectCardResponseVoResponseData;
        }
        MbrElectCardOpenErrorVo mbrElectCardOpenErrorVoSearch = new MbrElectCardOpenErrorVo();
        mbrElectCardOpenErrorVoSearch.setUnionId(memberElectCardRequestVo.getWxUnionId());
        mbrElectCardOpenErrorVoSearch.setOpenId(memberElectCardRequestVo.getWxOpenId());
        mbrElectCardOpenErrorVoSearch.setCardId(memberElectCardRequestVo.getCardId());
        ResponseData mbrElectCardOpenErrorVoResponseData = this.mbrElectCardOpenErrorRpcService.getByVo(mbrElectCardOpenErrorVoSearch);
        log.info("mbrElectCardOpenErrorRpcService#getByVo(),mbrElectCardOpenErrorVoResponseData={}", (Object)JSONObject.toJSONString((Object)mbrElectCardOpenErrorVoResponseData));
        if (mbrElectCardOpenErrorVoResponseData == null || mbrElectCardOpenErrorVoResponseData.getData() == null || ((MbrElectCardOpenErrorVo)mbrElectCardOpenErrorVoResponseData.getData()).getElectCardOpenErrorId() == null) {
            MbrElectCardOpenErrorVo mbrElectCardOpenErrorVo2 = new MbrElectCardOpenErrorVo();
            ResponseData mbrElectCardVOResponseData = this.electCardConfigApiService.queryElectCardConfigByCardId(mbrElectCardOpenErrorVoSearch.getCardId());
            if (mbrElectCardVOResponseData != null && mbrElectCardVOResponseData.getData() != null && StringUtils.isNotBlank((CharSequence)((MbrElectCardVO)mbrElectCardVOResponseData.getData()).getCardId())) {
                MbrElectCardVO mbrElectCardVO = (MbrElectCardVO)mbrElectCardVOResponseData.getData();
                mbrElectCardOpenErrorVo2.setSysCompanyId(mbrElectCardVO.getSysCompanyId());
                mbrElectCardOpenErrorVo2.setSysBrandId(mbrElectCardVO.getSysBrandId());
            } else {
                log.info("\u67e5\u8be2\u4e0d\u5230\u5361\u5957\u4fe1\u606f,electCardConfigApiService#queryElectCardConfigByCardId,mbrElectCardVOResponseData={}", (Object)JSONObject.toJSONString((Object)mbrElectCardVOResponseData));
            }
            mbrElectCardOpenErrorVo2.setOpenId(memberElectCardRequestVo.getWxOpenId());
            mbrElectCardOpenErrorVo2.setUnionId(memberElectCardRequestVo.getWxUnionId());
            mbrElectCardOpenErrorVo2.setCardId(memberElectCardRequestVo.getCardId());
            mbrElectCardOpenErrorVo2.setElectCode(memberElectCardRequestVo.getCode());
            mbrElectCardOpenErrorVo2.setElectCardInfo(JSONObject.toJSONString((Object)memberElectCardRequestVo));
            mbrElectCardOpenErrorVo2.setValid(Boolean.TRUE);
            ResponseData responseData = this.mbrElectCardOpenErrorRpcService.saveByVo(mbrElectCardOpenErrorVo2);
            electCardOpenErrorId = (Long)responseData.getData();
        } else {
            electCardOpenErrorId = ((MbrElectCardOpenErrorVo)mbrElectCardOpenErrorVoResponseData.getData()).getElectCardOpenErrorId();
        }
        ResponseData memberElectCardResponseVoResponseData = this.memberElectCardOpenCardApiService.openCard(memberElectCardRequestVo);
        if (memberElectCardResponseVoResponseData != null && SysResponseEnum.SUCCESS.getCode() == memberElectCardResponseVoResponseData.getCode()) {
            mbrElectCardOpenErrorVo = new MbrElectCardOpenErrorVo();
            mbrElectCardOpenErrorVo.setElectCardOpenErrorId(electCardOpenErrorId);
            this.mbrElectCardOpenErrorRpcService.deleteByVo(mbrElectCardOpenErrorVo);
        } else {
            mbrElectCardOpenErrorVo = new MbrElectCardOpenErrorVo();
            mbrElectCardOpenErrorVo.setElectCardOpenErrorId(electCardOpenErrorId);
            mbrElectCardOpenErrorVo.setErroInfo(memberElectCardResponseVoResponseData.getMessage());
            log.info("mbrElectCardOpenErrorRpcService#updateByVo,request:{}", (Object)JSONObject.toJSONString((Object)mbrElectCardOpenErrorVo));
            this.mbrElectCardOpenErrorRpcService.updateByVo(mbrElectCardOpenErrorVo);
        }
        return memberElectCardResponseVoResponseData;
    }

    @RequestMapping(value={"/searchActivityId"})
    public ResponseData<MktActivityPOWithBLOBs> searchActivityId(ProbabilityVO probabilityVO) {
        log.info("searchActivityId={}", (Object)JSON.toJSONString((Object)probabilityVO));
        return this.activityEGServiceRpc.getActivityId(probabilityVO);
    }

    @RequestMapping(value={"/integralChangeOperate"})
    public ResponseData<IntegralChangeRequestModel> integralChangeOperate(IntegralChangeRequestModel integralChangeRequestModel) {
        ResponseData responseData = new ResponseData();
        log.info("integralChangeOperate={}", (Object)JSON.toJSONString((Object)integralChangeRequestModel));
        String memberCode = integralChangeRequestModel.getMemberCode();
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u6ca1\u6709\u4f1a\u5458 Code");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        log.info("============singleMemberModel=======:{}", (Object)JSON.toJSONString((Object)singleMemberModel));
        if (singleMemberModel.getData() == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        Long brandId = ((MemberInfoModel)singleMemberModel.getData()).getBrandId();
        Long sysCompanyId = ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId();
        Integer countIntegral = ((MemberInfoModel)singleMemberModel.getData()).getCountIntegral();
        if (countIntegral == null || brandId == null || sysCompanyId == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        log.info("\u53d8\u66f4\u79ef\u5206:{}", (Object)integralChangeRequestModel.getChangeIntegral());
        log.info("\u4f1a\u5458\u603b\u79ef\u5206:{}", (Object)countIntegral);
        if ("1".equals(integralChangeRequestModel.getChangeType()) && integralChangeRequestModel.getChangeIntegral() != null && integralChangeRequestModel.getChangeIntegral().compareTo(countIntegral) == 1) {
            responseData.setMessage("\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
            responseData.setCode(101);
            return responseData;
        }
        log.info("brand={} ,sysCompanyId={}", (Object)brandId, (Object)sysCompanyId);
        integralChangeRequestModel.setBrandId(brandId);
        integralChangeRequestModel.setSysCompanyId(sysCompanyId);
        if ("1".equals(integralChangeRequestModel.getChangeType())) {
            integralChangeRequestModel.setBusinessType("30");
        } else if ("2".equals(integralChangeRequestModel.getChangeType())) {
            integralChangeRequestModel.setBusinessType("31");
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        IntegralChangeResponseModel integralChangeResponseModel = this.integralChangeApiService.integralChangeOperate(integralChangeRequestModel);
        Integer code = integralChangeResponseModel.getCode();
        String message = integralChangeResponseModel.getMessage();
        responseData.setCode(code.intValue());
        responseData.setMessage(message);
        log.info("integralChangeResponseModel={}", (Object)code, (Object)message);
        return responseData;
    }

    @GetMapping(value={"/getMallBySysBrandId"})
    public ResponseData<String> getMallBySysBrandId(@RequestParam(value="sysBrandId") Long sysBrandId) {
        ResponseData result = new ResponseData();
        ResponseData data = this.wxPublicServiceFeign.getMallBySysBrandId(sysBrandId);
        WxPublicPO po = (WxPublicPO)data.getData();
        if (po != null) {
            result.setCode(SysResponseEnum.SUCCESS.getCode());
            result.setData((Object)po.getAppid());
            result.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return result;
        }
        result.setCode(SysResponseEnum.FAILED.getCode());
        result.setMessage("\u6ca1\u6709\u67e5\u5230\u8be5\u54c1\u724c\u7684\u5fae\u5546\u57ce\u6570\u636e");
        return result;
    }

    @GetMapping(value={"/getMemberDeductionInfo"})
    public ResponseData getMemberDeductionInfo(String memberCode) {
        ResponseData data = new ResponseData();
        HashMap<String, Number> map = new HashMap<String, Number>();
        ResponseData dataInfo = this.MemberInfoApiService.getMemberDeductionInfo(memberCode);
        GetMemberDeductionInfo info = (GetMemberDeductionInfo)dataInfo.getData();
        log.info("\u4f1a\u5458\u4f59\u989d{},\u53ef\u7528\u79ef\u5206{},\u79ef\u5206\u62b5\u6263\u6bd4\u4f8b{}", new Object[]{info.getBalance(), info.getCountIntegral(), info.getDiscountRatio()});
        if (info != null) {
            map.put("balance", info.getBalance());
            map.put("countIntegral", info.getCountIntegral());
            map.put("discountRatio", info.getDiscountRatio());
            data.setData(map);
            data.setCode(SysResponseEnum.SUCCESS.getCode());
            data.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return data;
        }
        data.setCode(SysResponseEnum.FAILED.getCode());
        data.setMessage(SysResponseEnum.FAILED.getMessage());
        return data;
    }

    @PostMapping(value={"/updateMemberBalanceAndIntegral"})
    public ResponseData updateMemberBalanceAndIntegral(GetMemberDeductionInfo memberDeductionInfo) {
        log.info("\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206\u7684\u5165\u53c2:[{}]", JSON.toJSON((Object)memberDeductionInfo));
        ResponseData data = new ResponseData();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyymmddHHmmssSSS");
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberDeductionInfo.getMemberCode());
        MemberInfoModel singleMemberModel = (MemberInfoModel)this.memberInfoApiService.getSingleMemberModel(memberInfoModel).getData();
        if (singleMemberModel == null) {
            data.setCode(SysResponseEnum.FAILED.getCode());
            data.setMessage("\u4f1a\u5458\u4e0d\u5b58\u5728");
            return data;
        }
        BigDecimal balance = (BigDecimal)this.companyMemberApiService.queryMemberBalanceByMemberCode(memberDeductionInfo.getMemberCode()).getData();
        log.info("\u53d8\u66f4\u79ef\u5206{},\u4f1a\u5458\u53ef\u7528\u79ef\u5206{}", (Object)memberDeductionInfo.getChangeIntegral(), (Object)singleMemberModel.getCountIntegral());
        log.info("\u53d8\u66f4\u4f59\u989d{},\u4f1a\u5458\u53ef\u7528\u4f59\u989d{}", (Object)memberDeductionInfo.getBalance(), (Object)balance);
        if ("1".equals(memberDeductionInfo.getChangeType())) {
            if (memberDeductionInfo.getChangeIntegral() != null && memberDeductionInfo.getChangeIntegral().compareTo(singleMemberModel.getCountIntegral()) == 1) {
                data.setMessage("\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
                data.setCode(101);
                return data;
            }
            if (memberDeductionInfo.getBalance() != null && memberDeductionInfo.getBalance().compareTo(balance) == 1) {
                data.setMessage("\u60a8\u7684\u4f59\u989d\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
                data.setCode(101);
                return data;
            }
            memberDeductionInfo.setBusinessType("35");
        } else {
            memberDeductionInfo.setBusinessType("36");
        }
        memberDeductionInfo.setBrandId(singleMemberModel.getBrandId());
        memberDeductionInfo.setSysCompanyId(singleMemberModel.getSysCompanyId());
        memberDeductionInfo.setCardNo(singleMemberModel.getCardNo());
        memberDeductionInfo.setChangeBills(sdf.format(new Date()) + (int)((Math.random() * 9.0 + 1.0) * 1000.0));
        memberDeductionInfo.setWxPayVoucherNo(UUID.randomUUID().toString());
        memberDeductionInfo.setBrandCode(singleMemberModel.getOfflineBrandCode());
        log.info("\u8bf7\u6c42\u53c2\u6570{}", (Object)memberDeductionInfo.toString());
        ResponseData result = this.MemberInfoApiService.updateMemberBalanceAndIntegral(memberDeductionInfo);
        data.setCode(result.getCode());
        data.setMessage(result.getMessage());
        return data;
    }

    @RequestMapping(value={"/openCard"}, method={RequestMethod.POST})
    ResponseData<MallOpenCardResponseVo> openCard(MallOpenCardRequestVo mallOpenCardRequestVo) {
        log.info("MemberMallController#openCard mallOpenCardRequestVo:{}", (Object)JSON.toJSONString((Object)mallOpenCardRequestVo));
        ResponseData responseData = new ResponseData();
        MallOpenCardResponseVo mallOpenCardResponseVo = new MallOpenCardResponseVo();
        ResponseData mallOpenCardResponseVoResponseData = this.mallOpenCardService.openCard(mallOpenCardRequestVo);
        log.info("MemberMallController#openCard mallOpenCardResponseVoResponseData:{}", (Object)JSON.toJSONString((Object)mallOpenCardResponseVoResponseData));
        if (SysResponseEnum.FAILED.getCode() == mallOpenCardResponseVoResponseData.getCode()) {
            return mallOpenCardResponseVoResponseData;
        }
        mallOpenCardResponseVo = (MallOpenCardResponseVo)mallOpenCardResponseVoResponseData.getData();
        mallOpenCardResponseVo.setMerchantId(mallOpenCardRequestVo.getBrandId());
        Long sysStoreId = ((MallOpenCardResponseVo)mallOpenCardResponseVoResponseData.getData()).getServiceStoreId();
        if (sysStoreId == null) {
            sysStoreId = ((MallOpenCardResponseVo)mallOpenCardResponseVoResponseData.getData()).getOpenCardStoreId();
        }
        MerchantInfoRequestVO merchantInfoRequestVO = new MerchantInfoRequestVO();
        merchantInfoRequestVO.setBrandId(mallOpenCardRequestVo.getBrandId());
        merchantInfoRequestVO.setSysStoreId(sysStoreId);
        ResponseData merchantByMemberStoreId = this.sysMerchantServiceRpc.getMerchantByMemberStoreId(merchantInfoRequestVO);
        if (SysResponseEnum.SUCCESS.getCode() == merchantByMemberStoreId.getCode()) {
            log.info("MemberWxStoreInterfceController#findMemberModelInfo merchantByMemberStoreId:{}", (Object)JSON.toJSONString((Object)merchantByMemberStoreId));
            mallOpenCardResponseVo.setMerchantId(((SysMerchantStoreRelPo)merchantByMemberStoreId.getData()).getSysMerchantId());
        }
        responseData.setData((Object)mallOpenCardResponseVo);
        return responseData;
    }

    @PostMapping(value={"/pushIntegralOrder"})
    public ResponseData pushOrder(@RequestBody IntegerOrderPushRequestVO requestVO) throws Exception {
        log.info("MemberMallController#pushIntegralOrder:{}", (Object)JSON.toJSONString((Object)requestVO));
        return this.integralMallServiceFeign.pushOrder(requestVO);
    }

    @PostMapping(value={"/getStocks"})
    Result<List<HuaiRenGetStocksResponseVO.HuaiRenStockChildVO>> getStocks(HuaiRenGetStocksRequestVO requestVO) {
        log.info("MemberMallController#getStoreStock:{}", (Object)JSON.toJSONString((Object)requestVO));
        return this.huaiRenService.getStocks(requestVO);
    }

    @PostMapping(value={"/getMemberInfoByCardNo"})
    public ResponseData<MemberInfoModel> getMemberInfoByCardNo(MemberInfoModel memberInfoModel) {
        log.info("MemberMallController#getMemberInfoByCardNo:{}", (Object)JSON.toJSONString((Object)memberInfoModel));
        ResponseData singleMemberModelInfo = this.memberInfoApiService.getSingleMemberModelInfo(memberInfoModel);
        return singleMemberModelInfo;
    }

    @PostMapping(value={"/pushOrderToConnector"})
    public Result<String> pushOrderToConnector(@RequestBody IntegralOrderRequestVo integralOrderRequestVo) {
        log.info("MemberMallController#pushOrderToConnector:{}", (Object)JSON.toJSONString((Object)integralOrderRequestVo));
        Result stringResult = this.connectorServiceFeign.addIntegralOrder(integralOrderRequestVo);
        log.info("result:{}", (Object)JSON.toJSONString((Object)stringResult));
        return stringResult;
    }

    @PostMapping(value={"/getCompanyStoreCategory"})
    public ResponseData<Long> getCompanyStoreCategory(Long brandId) {
        log.info("MemberMallController_getCompanyStoreCategory_request:{}", (Object)JSON.toJSONString((Object)brandId));
        ResponseData companyStoreCategory = this.sysMerchantServiceRpc.getCompanyStoreCategory(brandId);
        log.info("MemberMallController_getCompanyStoreCategory_result:{}", (Object)JSON.toJSONString((Object)companyStoreCategory));
        return companyStoreCategory;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5c0f\u7a0b\u5e8ftoken")
    @PostMapping(value={"obtainToken"})
    public ResponseData<String> getTokenByAppId(@RequestParam String appId) {
        return this.wxPublicServiceFeign.getAccessTokenByAppId(appId);
    }

    @RequestMapping(value={"/getStoreById"}, method={RequestMethod.POST})
    public ResponseData<SysStorePo> getOfflineStoreById(Long sysStoreId) {
        return this.storeServiceRpc.getStoreById(sysStoreId);
    }

    @RequestMapping(value={"/getStaffById"}, method={RequestMethod.POST})
    public ResponseData<SysStaffPo> getStaffById(Long sysStaffId) {
        return this.staffServiceRpc.getStaffById(sysStaffId);
    }

    @RequestMapping(value={"/insertAuthorizeTaskItem"}, method={RequestMethod.POST})
    public ResponseData insertAuthorizeTaskItem(@RequestBody MemberAuthorizeInsertTaskItemRequestVo memberAuthorizeInsertTaskItemRequestVo) {
        return this.MemberInfoApiService.insertAuthorizeTaskItem(memberAuthorizeInsertTaskItemRequestVo);
    }

    @RequestMapping(value={"/pushMemberAuthorizeTaskByCondition"}, method={RequestMethod.POST})
    ResponseData pushMemberAuthorizeTaskByCondition(@RequestParam(value="memberCode") String memberCode) {
        log.info("enter function applet pushMemberAuthorizeTaskByCondition with param memberCode :{}", (Object)memberCode);
        return this.MemberInfoApiService.pushMemberAuthorizeTaskByCondition(memberCode);
    }
}

