/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.IncreaseByTransferringService;
import com.bizvane.appletservice.models.bo.CouponDetailResponseBo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponServiceFeign;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MembersAdvancedSearchApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.thymeleaf.util.StringUtils;

@RestController
@RequestMapping(value={"/increaseByTransferring"}, method={RequestMethod.POST})
public class IncreaseByTransferringController {
    @Autowired
    private IncreaseByTransferringService increaseByTransferringService;
    @Autowired
    private CouponServiceFeign couponServiceFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MembersAdvancedSearchApiService membersAdvancedSearchApiService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/increaseInSecurities"}, method={RequestMethod.POST})
    public ResponseData increaseInSecurities(String couponCode, String transferDate, Long couponSysCompanyId, Long couponSysBrandId, HttpServletRequest request) {
        logger.info("IncreaseByTransferringController increaseInSecurities couponCode:{},transferDate:{},couponSysCompanyId:{},couponSysBrandId:{}", new Object[]{couponCode, transferDate, couponSysCompanyId, couponSysBrandId});
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((String)couponCode)) {
            logger.info("increaseInSecurities couponCode is null");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (StringUtils.isEmpty((String)bizvaneSessionId) || StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)brandId)) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(-100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((String)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MembersInfoSearchPojo memberInfo = this.getMemberInfo(couponSysCompanyId, couponSysBrandId, memberCode);
        if (memberInfo == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.couponServiceFeign.couponGiving(couponCode, memberInfo.getMemberCode(), couponSysCompanyId, couponSysBrandId, transferDate);
    }

    @RequestMapping(value={"/transferCouponBack"}, method={RequestMethod.POST})
    public ResponseData transferCouponBack(String couponCode, Long couponSysCompanyId, Long couponSysBrandId, HttpServletRequest request) {
        logger.info("IncreaseByTransferringController transferCouponBack couponCode:{},couponSysCompanyId:{},couponSysBrandId:{}", new Object[]{couponCode, couponSysCompanyId, couponSysBrandId});
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((String)couponCode)) {
            logger.info("increaseInSecurities couponCode is null");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (StringUtils.isEmpty((String)bizvaneSessionId) || StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)brandId)) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            responseData.setCode(-100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isEmpty((String)memberCode)) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MembersInfoSearchPojo memberInfo = this.getMemberInfo(couponSysCompanyId, couponSysBrandId, memberCode);
        if (memberInfo == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.couponServiceFeign.transferCouponBack(couponCode, memberInfo.getMemberCode(), couponSysCompanyId, couponSysBrandId);
    }

    @RequestMapping(value={"/getIncreaseByTransferring"}, method={RequestMethod.POST})
    public ResponseData<CouponDetailResponseBo> increaseByTransferring(String couponCode, String transferMemberCode, String transferDate, Long couponSysCompanyId, Long couponSysBrandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        logger.info("IncreaseByTransferringController increaseByTransferring couponCode:{},transferMemberCode:{},transferDat:{},bizvaneSessionId:{},companyId:{},brandId:{}", new Object[]{couponCode, transferMemberCode, transferDate, bizvaneSessionId, couponSysCompanyId, couponSysBrandId});
        MembersInfoSearchPojo memberInfo = this.getMemberInfo(couponSysCompanyId, couponSysBrandId, transferMemberCode);
        if (memberInfo == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        return this.increaseByTransferringService.increaseByTransferring(couponCode, memberInfo.getMemberCode(), transferDate, bizvaneSessionId, couponSysCompanyId, couponSysBrandId);
    }

    @RequestMapping(value={"/transfer"}, method={RequestMethod.POST})
    public ResponseData transfer(CouponEntityVO vo, Long couponSysCompanyId, Long couponSysBrandId, HttpServletRequest request) {
        ResponseData coupon;
        int couponCode;
        ResponseData responseData = new ResponseData();
        logger.info("transfer\u5165\u53c2=====" + vo.getOldMemberCode());
        if (vo.getCouponCode() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u52b5\u7f16\u53f7");
            return responseData;
        }
        String key = "transfer_coupon" + vo.getCouponCode();
        Boolean isTransfer = this.redisTemplateService.hasKey((Object)key);
        if (isTransfer.booleanValue()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u975e\u5e38\u62b1\u6b49\u6b64\u5238\u5df2\u88ab\u4eba\u9886\u53d6");
            return responseData;
        }
        this.redisTemplateService.stringSetValueAndExpireTime((Object)key, (Object)vo.getCouponCode(), 3000L);
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String companyId = request.getHeader("sysCompanyId");
        String brandId = request.getHeader("sysBrandId");
        if (StringUtils.isEmpty((String)bizvaneSessionId) || StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)brandId)) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setNewMemberCode(memberCode);
        if (vo.getOldMemberCode() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8f6c\u8d60\u65b9\u4f1a\u5458\u4fe1\u606f\u6709\u8bef");
            return responseData;
        }
        MembersInfoSearchPojo oldMemberInfo = this.getMemberInfo(couponSysCompanyId, couponSysBrandId, vo.getOldMemberCode());
        if (oldMemberInfo == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setSysCompanyId(couponSysCompanyId);
        memberInfoModel.setBrandId(couponSysBrandId);
        memberInfoModel.setGroupMemberCode(memberCode);
        MemberInfoModel newMemberInfo = (MemberInfoModel)this.memberInfoApiService.getSingleMemberModel(memberInfoModel).getData();
        if (newMemberInfo == null) {
            ResponseData brandPoResponseData = this.brandServiceRpc.getBrandByID(couponSysBrandId);
            responseData.setMessage("\u60a8\u5c1a\u672a\u5728" + ((SysBrandPo)brandPoResponseData.getData()).getBrandName() + "\u4ff1\u4e50\u90e8\u4e0b\u5165\u4f1a\uff0c\u4e0d\u5141\u8bb8\u9886\u53d6");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        vo.setOldMemberCode(oldMemberInfo.getMemberCode());
        vo.setNewMemberCode(newMemberInfo.getMemberCode());
        vo.setSysCompanyId(couponSysCompanyId);
        vo.setSysBrandId(couponSysBrandId);
        if (StringUtil.isNotEmpty((String)vo.getCreateDtStart())) {
            try {
                vo.setDtStart(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(vo.getCreateDtStart()));
            }
            catch (Exception e) {
                logger.info("\u8f6c\u8d60\u65f6\u95f4\u7c7b\u578b\u9519\u8bef\u3002dtStart:{}", (Object)vo.getCreateDtStart());
            }
        }
        if ((couponCode = (coupon = this.couponServiceFeign.givenCoupon(vo)).getCode()) == SysResponseEnum.SUCCESS.getCode()) {
            Date newTimes = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            this.redisTemplateService.stringSetString((Object)(newMemberInfo.getMemberCode() + vo.getCouponCode()), (Object)df.format(newTimes));
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u9886\u53d6\u6210\u529f");
            responseData.setData((Object)newMemberInfo.getMemberCode());
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("\u975e\u5e38\u62b1\u6b49\u6b64\u5238\u5df2\u88ab\u4eba\u9886\u53d6");
        return responseData;
    }

    public MembersInfoSearchPojo getMemberInfo(Long sysCompanyId, Long sysBrandId, String groupMemberCode) {
        MembersInfoSearchPojo membersInfoSearchPojo = null;
        MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
        membersInfoSearchVo.setSysCompanyId(sysCompanyId);
        membersInfoSearchVo.setBrandId(sysBrandId);
        membersInfoSearchVo.setGroupMemberCode(groupMemberCode);
        membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
        membersInfoSearchVo.setPageSize(Integer.valueOf(1));
        ResponseData result = this.membersAdvancedSearchApiService.vgAdvancedSearch(membersInfoSearchVo);
        if (result != null && result.getCode() == SysResponseEnum.SUCCESS.getCode() && result.getData() != null && !CollectionUtils.isEmpty((Collection)((PageInfo)result.getData()).getList())) {
            membersInfoSearchPojo = (MembersInfoSearchPojo)((PageInfo)result.getData()).getList().get(0);
        }
        return membersInfoSearchPojo;
    }
}

