/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.channel.action;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.appletserviceimpl.channel.action.dto.ChannelActionMessageDto;
import com.bizvane.mktcenterservice.common.ContentChannelSourceActionTypeEnum;
import com.bizvane.mktcenterservice.common.ContentChannelTriggerTypeEnum;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ChannelActionMessage {
    private static final Logger log = LoggerFactory.getLogger(ChannelActionMessage.class);
    public static final String LINK = "-";
    public static final String CHANNEL_ACTION_REDIS_PREFIX = "channel_action:";
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public void redPacketExpandPartakenChannelAction(Long sourceId, String memberCode, Long couponDefinitionId) {
        log.info("redPacketExpandPartakenChannelAction, sourceId:{}, memberCode:{}, couponDefinitionId:{}", new Object[]{sourceId, memberCode, couponDefinitionId});
        if (sourceId == null || StringUtils.isBlank((CharSequence)memberCode)) {
            log.info("redPacketExpandPartakenChannelAction,\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u4e0d\u89e6\u53d1\u4e8b\u4ef6");
            return;
        }
        ChannelActionMessageDto messageDto = ChannelActionMessageDto.builder().actionType(ContentChannelSourceActionTypeEnum.PARTAKEN.getCode()).triggerType(ContentChannelTriggerTypeEnum.ACTIVITY.getCode()).sourceId(sourceId).memberCode(memberCode).extend_2(couponDefinitionId == null ? "" : couponDefinitionId + "").build();
        this.doSendChannelActionMessage(messageDto);
    }

    public void sendChannelActionPartakenMessageByIntegralOrders(Long sourceId, IntegralOrders orders) {
        log.info("ChannelActionMessage,sendChannelActionMessageByIntegralOrders,orders:{}", (Object)JSON.toJSONString((Object)orders));
        if (orders == null) {
            log.info("ChannelActionMessage,sendChannelActionMessageByIntegralOrders,orders is null");
            return;
        }
        ChannelActionMessageDto messageDto = ChannelActionMessageDto.builder().actionType(ContentChannelSourceActionTypeEnum.PARTAKEN.getCode()).triggerType(ContentChannelTriggerTypeEnum.ACTIVITY.getCode()).sourceId(sourceId).memberCode(orders.getMemberCode()).extend_2("1").extend_3(orders.getOrderNo()).build();
        if (!this.checkChannelActionMessageDto(messageDto)) {
            log.info("checkChannelActionMessageDto,messageDto is error");
            return;
        }
        this.doSendChannelActionMessage(messageDto);
        this.sendChannelActionExchangeMessageByIntegralOrders(orders, sourceId);
    }

    public void toSendChannelActionExchangeMessageByIntegralOrders(IntegralOrders orders) {
        log.info("toSendChannelActionExchangeMessageByIntegralOrders,orders:{}", (Object)JSON.toJSONString((Object)orders));
        if (orders == null || StringUtils.isBlank((CharSequence)orders.getMemberCode()) || StringUtils.isBlank((CharSequence)orders.getOrderNo())) {
            log.info("toSendChannelActionExchangeMessageByIntegralOrders,check is null:{}");
            return;
        }
        if (!IntegralOrdersStatusEnum.SHIPPED.getCode().equals(orders.getOrderStatus()) && !IntegralOrdersStatusEnum.SIGN.getCode().equals(orders.getOrderStatus())) {
            log.info("toSendChannelActionExchangeMessageByIntegralOrders,\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u89e6\u53d1\u5151\u6362\u4e8b\u4ef6");
            return;
        }
        String sourceId = this.findSourceIdByMemberCodeAndBusinessCode(orders.getMemberCode(), orders.getOrderNo());
        if (StringUtils.isBlank((CharSequence)sourceId)) {
            log.info("toSendChannelActionExchangeMessageByIntegralOrders, \u8be5\u8ba2\u5355\u4e0d\u5c5e\u4e8e\u6e20\u9053\u6295\u653e\u5185\u5bb9\uff0c\u4e0d\u89e6\u53d1\u5151\u6362\u4e8b\u4ef6");
            return;
        }
        this.sendChannelActionExchangeMessageByIntegralOrders(orders, Long.valueOf(sourceId));
    }

    public void sendChannelActionExchangeMessageByIntegralOrders(IntegralOrders orders, Long sourceId) {
        log.info("ChannelActionMessage,sendChannelActionMessageByIntegralOrders\uff0c sourceId:{},orders:{}", (Object)sourceId, (Object)JSON.toJSONString((Object)orders));
        if (orders == null || sourceId == null) {
            log.info("ChannelActionMessage,sendChannelActionMessageByIntegralOrders,orders is null  OR sourceId is null");
            return;
        }
        if (IntegralOrdersStatusEnum.SHIPPED.getCode().equals(orders.getOrderStatus()) || IntegralOrdersStatusEnum.SIGN.getCode().equals(orders.getOrderStatus())) {
            ChannelActionMessageDto messageDto = ChannelActionMessageDto.builder().actionType(ContentChannelSourceActionTypeEnum.EXCHANGE.getCode()).triggerType(ContentChannelTriggerTypeEnum.ACTIVITY.getCode()).sourceId(sourceId).memberCode(orders.getMemberCode()).extend_2("1").extend_3(orders.getOrderNo()).build();
            if (!this.checkChannelActionMessageDto(messageDto)) {
                log.info("checkChannelActionMessageDto,messageDto is error");
                return;
            }
            this.doSendChannelActionMessage(messageDto);
        } else {
            log.info("sendChannelActionExchangeMessageByIntegralOrders,\u8be5\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u53d1\u8d27\u6216\u8005\u5df2\u7b7e\u6536");
            String redisKey = this.buildChannelActionKey(orders.getMemberCode(), orders.getOrderNo());
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)(sourceId + ""), 30L, TimeUnit.DAYS);
        }
    }

    private void doSendChannelActionMessage(ChannelActionMessageDto messageDto) {
        try {
            log.info("doSendChannelActionMessage, messageDto:{}", (Object)JSON.toJSONString((Object)messageDto));
            SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("content_channel_source_action").build(), (Object)JSON.toJSONString((Object)messageDto));
            log.info("doSendChannelActionMessage sendResult:{}", (Object)JSONObject.toJSONString((Object)sendResult));
        }
        catch (Exception e) {
            log.info("doSendChannelActionMessage error:{}", (Object)e.getMessage());
        }
    }

    private String buildChannelActionKey(String memberCode, String businessCode) {
        return "channel_action:-" + memberCode + LINK + businessCode;
    }

    public String findSourceIdByMemberCodeAndBusinessCode(String memberCode, String businessCode) {
        String sourceId = "";
        log.info("findSourceIdByMemberCodeAndBusinessCode,memberCode:{}, businessCode:{}", (Object)memberCode, (Object)businessCode);
        if (StringUtils.isBlank((CharSequence)memberCode) || StringUtils.isBlank((CharSequence)businessCode)) {
            log.info("findSourceIdByMemberCodeAndBusinessCode \u53c2\u6570\u4e0d\u5b8c\u6574");
            return sourceId;
        }
        String redisKey = this.buildChannelActionKey(memberCode, businessCode);
        try {
            sourceId = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        }
        catch (Exception e) {
            log.info("findSourceIdByMemberCodeAndBusinessCode, \u67e5\u8be2\u7f13\u5b58\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        log.info("findSourceIdByMemberCodeAndBusinessCode,result:{}", (Object)sourceId);
        return sourceId;
    }

    private boolean checkChannelActionMessageDto(ChannelActionMessageDto messageDto) {
        log.info("checkChannelActionMessageDto,messageDto\uff1a{}", (Object)JSON.toJSONString((Object)messageDto));
        return messageDto != null && messageDto.getActionType() != null && messageDto.getTriggerType() != null && messageDto.getSourceId() != null && !StringUtils.isBlank((CharSequence)messageDto.getMemberCode());
    }
}

