/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.MQ;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.MessageDelayLevel;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.WxPayService;
import com.bizvane.appletservice.models.po.SysRechargeOrderPoExample;
import com.bizvane.appletservice.models.po.SysRechargeOrderPoWithBLOBs;
import com.bizvane.appletservice.models.vo.UnionPay2MQVo;
import com.bizvane.appletserviceimpl.common.RechargeTypeEnum;
import com.bizvane.appletserviceimpl.mappers.SysRechargeOrderPoMapper;
import com.bizvane.centerstageservice.models.po.MbrRechargeRecordPo;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.mktcenterservice.models.vo.MemberInfoModelVOActivity;
import com.bizvane.mktcenterservice.rpc.ActivityPayServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="public_union_pay_recharge_record")
public class UnionPayCallBackConsumer
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(UnionPayCallBackConsumer.class);
    @Autowired
    MbrRechargeServiceRpc mbrRechargeServiceRpc;
    private List<MessageDelayLevel> messageDelayLevelList;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    @Autowired
    ActivityPayServiceRpc activityPayServiceRpc;
    @Autowired
    private SysRechargeOrderPoMapper sysRechargeOrderPoMapper;
    @Autowired
    private WxPayService wxPayService;
    private final String UNION_PAY_RECORD = "UNION_PAY_RECORD";
    private final String CALL_BUSINESS_SUCCESS = "SUCCESS";
    private final String CALL_BUSINESS_FAIL = "FAIL";

    public void onMessage(ConsumerMessage<String> message) {
        String messageContent = (String)message.getMessage();
        log.info("UnionPayCallBackConsumer consume one record:{}", (Object)messageContent);
        UnionPay2MQVo unionPay2MQVo = (UnionPay2MQVo)JSONObject.parseObject((String)messageContent, UnionPay2MQVo.class);
        try {
            MbrRechargeRecordPo mbrRechargeRecordPo = new MbrRechargeRecordPo();
            BeanUtils.copyProperties((Object)unionPay2MQVo, (Object)mbrRechargeRecordPo);
            mbrRechargeRecordPo.setRechargeType(RechargeTypeEnum.UNION_PAY.getCode());
            String memberCode = unionPay2MQVo.getMemberCode();
            if (StringUtils.isNotEmpty((CharSequence)memberCode)) {
                Long sysStoreId = this.wxPayService.getSysStoreId(memberCode);
                mbrRechargeRecordPo.setSysStoreId(sysStoreId);
            }
            ResponseData responseData = this.mbrRechargeServiceRpc.addMbrRechargeRecord(mbrRechargeRecordPo);
            if (SysResponseEnum.FAILED.getCode() == responseData.getCode()) {
                log.info("UnionPayCallBackConsumer \u8c03\u7528 addMbrRechargeRecord error");
                this.reConsumeMessage(unionPay2MQVo);
                return;
            }
            SysRechargeOrderPoExample example = new SysRechargeOrderPoExample();
            example.createCriteria().andSysBrandIdEqualTo(unionPay2MQVo.getSysBrandId()).andMemberCodeEqualTo(unionPay2MQVo.getMemberCode()).andPlatSerialNumEqualTo(unionPay2MQVo.getPayVoucherNo());
            SysRechargeOrderPoWithBLOBs retryBlobs = new SysRechargeOrderPoWithBLOBs();
            retryBlobs.setCallBusinessStatus("SUCCESS");
            this.sysRechargeOrderPoMapper.updateByExampleSelective(retryBlobs, example);
            if (unionPay2MQVo.getPayId() != null) {
                MemberInfoModelVOActivity voActivity = new MemberInfoModelVOActivity();
                BeanUtils.copyProperties((Object)unionPay2MQVo, (Object)voActivity);
                ResponseData activityResp = this.activityPayServiceRpc.excuseActivityPay(voActivity);
                log.info("UnionPayCallBackConsumer \u8c03\u7528 excuseActivityPay resp:{}", (Object)JSONObject.toJSONString((Object)activityResp));
            }
            log.info("UnionPayCallBackConsumer consume one record  end :{}", (Object)unionPay2MQVo.getPayVoucherNo());
        }
        catch (Exception e) {
            log.error("UnionPayCallBackConsumer errorInfo:{}", (Throwable)e);
            this.reConsumeMessage(unionPay2MQVo);
            return;
        }
    }

    public void reConsumeMessage(UnionPay2MQVo vo) {
        String cardNo = vo.getCardNo();
        String wxPayVoucherNo = vo.getPayVoucherNo();
        String key = "UNION_PAY_RECORD" + cardNo + wxPayVoucherNo;
        String s = (String)this.redisTemplateService.stringGetStringByKey((Object)key);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            int retry = Integer.valueOf(s);
            if (retry >= this.messageDelayLevelList.size()) {
                log.info("UnionPayCallBackConsumer \u652f\u4ed8\u51ed\u8bc1\u4e3a:{},\u91cd\u8bd5:{},\u4ecd\u7136\u5931\u8d25,\u653e\u5f03\u91cd\u8bd5", (Object)vo.getPayVoucherNo(), (Object)this.messageDelayLevelList.size());
                SysRechargeOrderPoExample example = new SysRechargeOrderPoExample();
                example.createCriteria().andSysBrandIdEqualTo(vo.getSysBrandId()).andMemberCodeEqualTo(vo.getMemberCode()).andPlatSerialNumEqualTo(vo.getPayVoucherNo());
                SysRechargeOrderPoWithBLOBs retryBlobs = new SysRechargeOrderPoWithBLOBs();
                retryBlobs.setCallBusinessStatus("FAIL");
                this.sysRechargeOrderPoMapper.updateByExampleSelective(retryBlobs, example);
                return;
            }
        } else {
            s = "0";
        }
        int retryTime = Integer.valueOf(s);
        MessageDelayLevel messageDelayLevel = (MessageDelayLevel)this.messageDelayLevelList.get(retryTime);
        vo.setRetryTime(Integer.valueOf(++retryTime));
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("public_union_pay_recharge_record").delayLevel(messageDelayLevel).build(), (Object)JSON.toJSONString((Object)vo));
        this.redisTemplateService.stringSetValueAndExpireTime((Object)key, (Object)String.valueOf(retryTime), 10800000L);
        String messageId = sendResult.getMsgId();
        log.info("UnionPayCallBackConsumer \u652f\u4ed8\u51ed\u8bc1:{},reSendMessage\t\u6d88\u606f\u91cd\u65b0\u53d1\u9001\u5b8c\u6210mq\u8fd4\u56de\u7684msgId:{},\u5ef6\u8fdf\u7684\u7b49\u7ea7\u662f:{},\u5f53\u524d\u91cd\u8bd5\u6b21\u6570:{}", new Object[]{vo.getPayVoucherNo(), messageId, messageDelayLevel.getLevel(), retryTime});
    }

    @PostConstruct
    public void init() {
        this.messageDelayLevelList = Arrays.asList(MessageDelayLevel._1m, MessageDelayLevel._2m, MessageDelayLevel._5m, MessageDelayLevel._10m, MessageDelayLevel._30m, MessageDelayLevel._1h, MessageDelayLevel._2h);
    }
}

