/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.MQ;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.MessageDelayLevel;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.models.vo.vg.NewYearMemberGuideUpdateRequestVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.vo.MemberGuideUpdateRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

@RocketMQMessageListener(topic="long_new_year_keng")
public class NewYearConsumer
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(NewYearConsumer.class);
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    public static final String YEAR_CONST = "2024_year_";

    public void onMessage(ConsumerMessage<String> message) {
        String messageContent = (String)message.getMessage();
        log.info("NewYearConsumer consume  record:{}", (Object)messageContent);
        NewYearMemberGuideUpdateRequestVo newYearMemberGuideUpdateRequestVo = (NewYearMemberGuideUpdateRequestVo)JSONObject.parseObject((String)messageContent, NewYearMemberGuideUpdateRequestVo.class);
        if (newYearMemberGuideUpdateRequestVo == null) {
            return;
        }
        Integer time = 1;
        String redisTime = (String)this.redisTemplate.opsForValue().get((Object)(YEAR_CONST + newYearMemberGuideUpdateRequestVo.getCardNo()));
        if (StringUtils.isNotEmpty((CharSequence)redisTime)) {
            time = Integer.valueOf(redisTime);
        }
        log.info("NewYearConsumer consume  time:{}", (Object)time);
        if (time > 3) {
            log.info("NewYearConsumer consume  time over :{}", (Object)time);
            return;
        }
        Integer n = time;
        Integer n2 = time = Integer.valueOf(time + 1);
        try {
            MemberInfoModel memberInfo = new MemberInfoModel();
            memberInfo.setBrandId(newYearMemberGuideUpdateRequestVo.getBrandId());
            memberInfo.setCardNo(newYearMemberGuideUpdateRequestVo.getCardNo());
            log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f#openCard23NewYearAct#memberInfo:{}", (Object)JSON.toJSONString((Object)memberInfo));
            ResponseData memberModel = this.memberInfoApiService.getSingleMemberModel(memberInfo);
            if (memberModel == null || memberModel.getData() == null || StringUtils.isEmpty((CharSequence)((MemberInfoModel)memberModel.getData()).getMemberCode())) {
                this.redisTemplate.opsForValue().set((Object)(YEAR_CONST + newYearMemberGuideUpdateRequestVo.getCardNo()), (Object)time.toString(), 1L, TimeUnit.DAYS);
                log.info("\u53d8\u66f4\u5bfc\u8d2d MQ :{}", (Object)JSON.toJSONString((Object)newYearMemberGuideUpdateRequestVo));
                SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("long_new_year_keng").delayLevel(MessageDelayLevel._10s).build(), (Object)JSON.toJSONString((Object)newYearMemberGuideUpdateRequestVo));
                log.info("\u53d8\u66f4\u5bfc\u8d2d MQ  \u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sendResult));
            }
            String currentMemberCode = ((MemberInfoModel)memberModel.getData()).getMemberCode();
            MemberGuideUpdateRequestVo memberGuideUpdateRequestVo = new MemberGuideUpdateRequestVo();
            memberGuideUpdateRequestVo.setMemberCode(currentMemberCode);
            memberGuideUpdateRequestVo.setBrandId(newYearMemberGuideUpdateRequestVo.getBrandId());
            memberGuideUpdateRequestVo.setServiceStoreId(newYearMemberGuideUpdateRequestVo.getServiceStoreId());
            memberGuideUpdateRequestVo.setServiceStoreCode(newYearMemberGuideUpdateRequestVo.getServiceStoreCode());
            memberGuideUpdateRequestVo.setServiceGuideId(newYearMemberGuideUpdateRequestVo.getServiceGuideId());
            memberGuideUpdateRequestVo.setServiceGuideCode(newYearMemberGuideUpdateRequestVo.getServiceGuideCode());
            log.info("\u53d8\u66f4\u5bfc\u8d2d VO:{}", (Object)JSON.toJSONString((Object)memberGuideUpdateRequestVo));
            ResponseData updateServiceStoreAndGuide = this.memberInfoApiService.updateServiceStoreAndGuide(memberGuideUpdateRequestVo);
            log.info("\u53d8\u66f4\u5bfc\u8d2d\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)memberGuideUpdateRequestVo));
            if (updateServiceStoreAndGuide == null || updateServiceStoreAndGuide.getCode() == -1) {
                this.redisTemplate.opsForValue().set((Object)(YEAR_CONST + newYearMemberGuideUpdateRequestVo.getCardNo()), (Object)time.toString(), 1L, TimeUnit.DAYS);
                log.info("\u53d8\u66f4\u5bfc\u8d2d MQ :{}", (Object)JSON.toJSONString((Object)memberGuideUpdateRequestVo));
                SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("long_new_year_keng").delayLevel(MessageDelayLevel._10s).build(), (Object)JSON.toJSONString((Object)memberGuideUpdateRequestVo));
                log.info("\u53d8\u66f4\u5bfc\u8d2d MQ  \u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sendResult));
            }
        }
        catch (Exception e) {
            this.redisTemplate.opsForValue().set((Object)(YEAR_CONST + newYearMemberGuideUpdateRequestVo.getCardNo()), (Object)time.toString(), 1L, TimeUnit.DAYS);
            log.info("\u53d8\u66f4\u5bfc\u8d2d MQ :{}", (Object)JSON.toJSONString((Object)newYearMemberGuideUpdateRequestVo));
            SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("long_new_year_keng").delayLevel(MessageDelayLevel._10s).build(), (Object)JSON.toJSONString((Object)newYearMemberGuideUpdateRequestVo));
            log.info("\u53d8\u66f4\u5bfc\u8d2d MQ  \u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sendResult));
        }
    }
}

